/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic.feature;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.models.ModelHeuristicRules;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicEditorHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodeEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.feature.DynamicFeatureEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.feature.FeaturePredictionLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DynamicFeatureNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.help.HelpSystem;

public class DynamicFeatureEditorDlg
extends DataConsumerAttributesDialog<DynamicFeatureNode> {
    private DynamicFeatureEditorPanel content;
    private DynamicNodeEditorState state;
    private Map<String, ModelHeuristicRules> modelRules;

    @Override
    protected JEWTDialog buildDialog(Context context, DynamicFeatureNode dynamicFeatureNode, AbstractDataNode abstractDataNode) {
        this.initRes();
        this.modelRules = new DynamicEditorHelper().getHeuristicRules(context, dynamicFeatureNode);
        this.content = new DynamicFeatureEditorPanel(context, dynamicFeatureNode, this.modelRules);
        this.state = this.content.getState();
        JEWTDialog jEWTDialog = this.buildDialog(context, this.content);
        jEWTDialog.setMinimumSize(new Dimension(400, 380));
        jEWTDialog.setPreferredSize(new Dimension(800, 700));
        return jEWTDialog;
    }

    @Override
    protected JEWTDialog buildDialog(Context context, JPanel jPanel) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        CustomJEWTDialog customJEWTDialog = new CustomJEWTDialog((Frame)ideMainWindow, this.wizName, n);
        customJEWTDialog.setContent(jPanel);
        customJEWTDialog.setTitle(this.getDialogTitle());
        this.registerHelp(customJEWTDialog);
        return customJEWTDialog;
    }

    @Override
    protected String getDialogTitle() {
        return FeaturePredictionLrb.get("FEATURE_NODE_EDITOR_TITLE");
    }

    public void initRes() {
    }

    @Override
    protected void registerHelp(JEWTDialog jEWTDialog) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "dynamic_feature_node_edit");
    }

    class CustomJEWTDialog
    extends JEWTDialog {
        CustomJEWTDialog(Frame frame, String string, int n) {
            super(frame, string, n);
        }

        public void dispose() {
            super.dispose();
            DynamicFeatureEditorDlg.this.content.cleanUp();
        }
    }
}

