/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableColumnType;
import oracle.ide.Context;

public class UpdateTableWizardModel
extends DataSourceWizardModel {
    private static final Logger theLogger = Logger.getLogger(UpdateTableWizardModel.class.getName());

    public UpdateTableWizardModel(Component component, Context context, AbstractDataNode abstractDataNode, boolean bl) {
        super(component, context, abstractDataNode);
        this.tableExists = bl;
    }

    @Override
    public void loadDefaultSelectedColumns() {
        this._selectedColumns.clear();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        List<String> list = DatabaseMetadataUtils.getRequiredColumns(connectionFolder, StringUtils.escapeSingleQuotesForSQL(this._selectedTable.getSchema()), StringUtils.escapeSingleQuotesForSQL(this._selectedTable.getName()));
        for (String string : list) {
            hashMap.put(string, string);
        }
        for (String string : this._availableColumns) {
            UpdateTableColumnType updateTableColumnType = new UpdateTableColumnType();
            if (DatabaseMetadataUtils.isDataTypeSupported(string.getDataType())) {
                updateTableColumnType.setRequiredColumn(null != hashMap.get(string.getName()));
                updateTableColumnType.setName(string.getName());
                updateTableColumnType.setAlias(string.getAlias());
                updateTableColumnType.setDataType(string.getDataType());
                updateTableColumnType.setDataTypeQualifier(string.getDataTypeQualifier());
                updateTableColumnType.setStatus(string.getStatus());
                updateTableColumnType.setAnnotation(string.getAnnotation());
                this._selectedColumns.add(updateTableColumnType);
                continue;
            }
            string.setStatus(AttributeStatus.INVALID);
        }
        this.removeSelectedAttrs(this._availableColumns, this._selectedColumns);
    }
}

