/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.JSONHelper;
import oracle.dmt.dataminer.generated.server.OdmrNodeReference;
import oracle.dmt.dataminer.generated.server.OdmrNodeReferenceSet;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.ImportDataGuideTableModel;
import oracle.dmt.dataminer.workflow.dialog.data.ImportDataGuideTableModelEx;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class ImportDataGuidePanel
extends DialogDisplayer<AbstractDataNode> {
    private static final Logger theLogger = Logger.getLogger(ImportDataGuidePanel.class.getName());
    private static final String CREATE_TABLE_NODE = "CreateTable";
    private static final String DATA_SOURCE_NODE = "DataSource";
    private static final String CURRENT_WORKFLOW = DataDialogsLrb.get("IMPORT_DATAGUIDE_TABLE_COMBO_CURRENT_WORKFLOW");
    private static final String ALL_WORKFLOWS = DataDialogsLrb.get("IMPORT_DATAGUIDE_TABLE_COMBO_ALL_WORKFLOWS");
    private Exception _ex = null;
    private boolean _success = false;
    private boolean loading = false;
    private List<Workflow> allWorkflows = new ArrayList<Workflow>();
    private Map<ImportDataGuideTableModel.ImportDataHelper, List<JSONColumnsType.Attribute>> allAvailableDataGuides;
    private Map<ImportDataGuideTableModel.ImportDataHelper, List<JSONColumnsType.Attribute>> workFlowAvailableGuides;
    private String dataGuideTableName;
    private String dataGuideColumnName;
    private DataMinerTablePanel dataMinerTablePanel1;
    private JLabel jLblShow;
    private JComboBox<String> jcmbSelectWorkflow;

    public ImportDataGuidePanel(Context context, AbstractDataNode abstractDataNode) {
        super(context, abstractDataNode);
        this.initComponents();
        this.initUI();
        this.initRes();
    }

    private void initComponents() {
        this.jLblShow = new JLabel();
        this.jcmbSelectWorkflow = new JComboBox();
        this.dataMinerTablePanel1 = new DataMinerTablePanel();
        this.jLblShow.setText("Show:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel1, -1, 653, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblShow, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcmbSelectWorkflow, -2, 221, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblShow).addComponent(this.jcmbSelectWorkflow, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dataMinerTablePanel1, -1, 261, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.jLblShow.setText(DataDialogsLrb.get("IMPORT_DATAGUIDE_SHOW_WORKFLOWS"));
        this.jLblShow.setLabelFor(this.jcmbSelectWorkflow);
    }

    @Override
    public void initUI() {
        this.loading = true;
        this.jcmbSelectWorkflow.setModel(new DefaultComboBoxModel<String>(new String[]{CURRENT_WORKFLOW, ALL_WORKFLOWS}));
        this.jcmbSelectWorkflow.setSelectedIndex(0);
        this.setupMessagTable(ImportDataGuideTableModel.LOADING_WORKFLOW);
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
        this.jcmbSelectWorkflow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ImportDataGuidePanel.this.loading) {
                    return;
                }
                if (ImportDataGuidePanel.this.jcmbSelectWorkflow.getSelectedItem().equals(CURRENT_WORKFLOW)) {
                    ImportDataGuidePanel.this.setupTable(new ImportDataGuideTableModel(ImportDataGuidePanel.this.workFlowAvailableGuides));
                } else if (ImportDataGuidePanel.this.allAvailableDataGuides == null) {
                    ImportDataGuidePanel.this.setupMessagTable(ImportDataGuideTableModel.LOADING_WORKFLOWS);
                    LoadComboUI loadComboUI = new LoadComboUI();
                    loadComboUI.execute();
                } else {
                    ImportDataGuidePanel.this.setupTable(new ImportDataGuideTableModelEx(ImportDataGuidePanel.this.allAvailableDataGuides));
                }
            }
        });
    }

    private void setupTable(ImportDataGuideTableModel importDataGuideTableModel) {
        this.dataMinerTablePanel1.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel1.getTable().setSelectionMode(0);
        this.dataMinerTablePanel1.getTable().setShowGrid(true);
        this.dataMinerTablePanel1.getTable().setShowHorizontalLines(true);
        this.dataMinerTablePanel1.getTable().setShowVerticalLines(true);
        this.dataMinerTablePanel1.getTable().setFixedColumns(0, new int[0]);
        this.dataMinerTablePanel1.getTable().setModel((TableModel)((Object)importDataGuideTableModel));
        this.dataMinerTablePanel1.getTable().setSorted(true);
        this.dataMinerTablePanel1.getTable().setColumnSelectorAvailable(true);
        this.dataMinerTablePanel1.getTable().setAutoResizeMode(4);
    }

    private void setupMessagTable(String string) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.dataMinerTablePanel1.getTable().getModel();
        defaultTableModel.setRowCount(1);
        this.dataMinerTablePanel1.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel1.getTable().setAutoResizeMode(4);
        this.dataMinerTablePanel1.getTable().setShowHorizontalLines(false);
        this.dataMinerTablePanel1.getTable().setShowGrid(false);
        this.dataMinerTablePanel1.getTable().setModel((TableModel)((Object)new ImportDataGuideTableModel(string)));
    }

    @Override
    public boolean doWork() {
        int n = this.dataMinerTablePanel1.getTable().getSelectedRowInModel();
        if (n == -1) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("IMPORT_DATAGUIDE_TABLE_NO_SELECTION_ERROR"), (String)DataDialogsLrb.get("IMPORT_DATAGUIDE_LOADING_FAILURE_TITLE"), null);
            return false;
        }
        ImportDataGuideTableModel importDataGuideTableModel = (ImportDataGuideTableModel)((Object)this.dataMinerTablePanel1.getTable().getModel());
        ImportDataGuideTableModel.RowData rowData = importDataGuideTableModel.getDataGuideInfo(n);
        DataNodeType dataNodeType = rowData.getNodeData();
        if (dataNodeType != null) {
            String string = rowData.getJsonColumnName();
            JSONColumnsType jSONColumnsType = JSONHelper.getJSONColumnsType(dataNodeType);
            List list = jSONColumnsType.getAttribute();
            for (JSONColumnsType.Attribute attribute : list) {
                if (!attribute.getName().equals(string)) continue;
                this.dataGuideTableName = attribute.getDataGuideInfo().getSystem().getDataGuideTable();
                this.dataGuideColumnName = string;
                break;
            }
        }
        return true;
    }

    public String getDataGuideTableName() {
        return this.dataGuideTableName;
    }

    public String getDataGuideColumnName() {
        return this.dataGuideColumnName;
    }

    private Map<ImportDataGuideTableModel.ImportDataHelper, List<JSONColumnsType.Attribute>> getWorkflowAvailableDataGuides(Workflow workflow) {
        WorkflowProcess.Nodes nodes = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<ImportDataGuideTableModel.ImportDataHelper> arrayList2 = new ArrayList<ImportDataGuideTableModel.ImportDataHelper>();
        WorkflowProcess workflowProcess = workflow.getWorkflowProcess();
        nodes = workflowProcess.getNodes();
        List list = nodes.getCreateTable();
        List list2 = nodes.getDataSource();
        if (list2 != null && !list2.isEmpty()) {
            arrayList.addAll(list2);
        }
        if (list != null && !list.isEmpty()) {
            arrayList.addAll(list);
        }
        for (DataNodeType dataNodeType : arrayList) {
            ImportDataGuideTableModel.ImportDataHelper importDataHelper = new ImportDataGuideTableModel.ImportDataHelper(dataNodeType, null, workflow.getName());
            arrayList2.add(importDataHelper);
        }
        return this.findGuides(arrayList2);
    }

    private Map<ImportDataGuideTableModel.ImportDataHelper, List<JSONColumnsType.Attribute>> getAllAvailableDataGuides() throws Exception {
        Map<ImportDataGuideTableModel.ImportDataHelper, List<JSONColumnsType.Attribute>> map = null;
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
            List<ImportDataGuideTableModel.ImportDataHelper> list = ImportDataGuidePanel.loadNodesFromServer(connectionFolder);
            map = this.findGuides(list);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            throw exception;
        }
        return map;
    }

    private Map<ImportDataGuideTableModel.ImportDataHelper, List<JSONColumnsType.Attribute>> findGuides(List<ImportDataGuideTableModel.ImportDataHelper> list) {
        HashMap<ImportDataGuideTableModel.ImportDataHelper, List<JSONColumnsType.Attribute>> hashMap = new HashMap<ImportDataGuideTableModel.ImportDataHelper, List<JSONColumnsType.Attribute>>();
        if (list != null && !list.isEmpty()) {
            for (ImportDataGuideTableModel.ImportDataHelper importDataHelper : list) {
                List list2;
                JSONColumnsType jSONColumnsType = JSONHelper.getJSONColumnsType(importDataHelper.nodeType);
                if (jSONColumnsType == null || (list2 = jSONColumnsType.getAttribute()).isEmpty()) continue;
                for (JSONColumnsType.Attribute attribute : list2) {
                    String string;
                    if (null == attribute.getDataGuideInfo() || null == attribute.getDataGuideInfo().getSystem() || (string = attribute.getDataGuideInfo().getSystem().getDataGuideTable()) == null) continue;
                    ArrayList<JSONColumnsType.Attribute> arrayList = (ArrayList<JSONColumnsType.Attribute>)hashMap.get(importDataHelper);
                    if (arrayList == null) {
                        arrayList = new ArrayList<JSONColumnsType.Attribute>();
                        hashMap.put(importDataHelper, arrayList);
                    }
                    arrayList.add(attribute);
                }
            }
        }
        return hashMap;
    }

    public static List<ImportDataGuideTableModel.ImportDataHelper> loadNodesFromServer(ConnectionManager connectionManager) throws Exception {
        ImportDataGuideTableModel.ImportDataHelper importDataHelper;
        Object object;
        int n;
        ArrayList<ImportDataGuideTableModel.ImportDataHelper> arrayList = new ArrayList<ImportDataGuideTableModel.ImportDataHelper>();
        OdmrNodeReferenceSet[] odmrNodeReferenceSetArray = Workflow.getWorkflowNodesReferences(connectionManager, CREATE_TABLE_NODE);
        OdmrNodeReference[] odmrNodeReferenceArray = odmrNodeReferenceSetArray[0].getArray();
        OdmrNodeReferenceSet[] odmrNodeReferenceSetArray2 = Workflow.getWorkflowNodesReferences(connectionManager, DATA_SOURCE_NODE);
        OdmrNodeReference[] odmrNodeReferenceArray2 = odmrNodeReferenceSetArray2[0].getArray();
        if (odmrNodeReferenceArray != null && odmrNodeReferenceArray.length > 0) {
            for (n = 0; n < odmrNodeReferenceArray.length; ++n) {
                object = Workflow.getWorkflowNodeContent(connectionManager, CREATE_TABLE_NODE, BigDecimal.valueOf(odmrNodeReferenceArray[n].getProjectId().longValue()), BigDecimal.valueOf(odmrNodeReferenceArray[n].getWorkflowId().longValue()), BigDecimal.valueOf(odmrNodeReferenceArray[n].getNodeId().longValue()));
                if (!(object instanceof DataNodeType)) continue;
                importDataHelper = new ImportDataGuideTableModel.ImportDataHelper((DataNodeType)object, odmrNodeReferenceArray[n].getProjectName(), odmrNodeReferenceArray[n].getWorkflowName());
                arrayList.add(importDataHelper);
            }
        }
        if (odmrNodeReferenceArray2 != null && odmrNodeReferenceArray2.length > 0) {
            for (n = 0; n < odmrNodeReferenceArray2.length; ++n) {
                object = Workflow.getWorkflowNodeContent(connectionManager, DATA_SOURCE_NODE, BigDecimal.valueOf(odmrNodeReferenceArray2[n].getProjectId().longValue()), BigDecimal.valueOf(odmrNodeReferenceArray2[n].getWorkflowId().longValue()), BigDecimal.valueOf(odmrNodeReferenceArray2[n].getNodeId().longValue()));
                if (!(object instanceof DataNodeType)) continue;
                importDataHelper = new ImportDataGuideTableModel.ImportDataHelper((DataNodeType)object, odmrNodeReferenceArray2[n].getProjectName(), odmrNodeReferenceArray2[n].getWorkflowName());
                arrayList.add(importDataHelper);
            }
        }
        return arrayList;
    }

    @Override
    protected String getDialogTitle() {
        return DataDialogsLrb.get("IMPORT_DATAGUIDE_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "data_source_import_data_guide";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMinimumSize(new Dimension(600, 400));
    }

    class LoadUI
    extends SwingWorker<Boolean, Void> {
        LoadUI() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            try {
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(ImportDataGuidePanel.this.getContext());
                Set<WorkflowProject> set = WorkflowProject.getProjects(connectionFolder);
                List<Workflow> list = null;
                int n = -1;
                for (WorkflowProject workflowProject : set) {
                    int n2 = workflowProject.getId().intValue();
                    if (n == n2) continue;
                    n = n2;
                    list = Workflow.getWorkflows(connectionFolder, workflowProject.getId());
                    if (list == null || list.isEmpty()) continue;
                    ImportDataGuidePanel.this.allWorkflows.addAll(list);
                }
                Workflow workflow = (Workflow)((WorkflowNode)ImportDataGuidePanel.this.getContext().getNode()).getRepositoryData();
                ImportDataGuidePanel.this.workFlowAvailableGuides = ImportDataGuidePanel.this.getWorkflowAvailableDataGuides(workflow);
                ImportDataGuidePanel.this._success = true;
            }
            catch (Exception exception) {
                ImportDataGuidePanel.this._ex = exception;
                ImportDataGuidePanel.this._success = false;
            }
            return Boolean.TRUE;
        }

        @Override
        protected void done() {
            if (ImportDataGuidePanel.this._success && ImportDataGuidePanel.this._ex == null) {
                ImportDataGuideTableModel importDataGuideTableModel = new ImportDataGuideTableModel(ImportDataGuidePanel.this.workFlowAvailableGuides);
                ImportDataGuidePanel.this.setupTable(importDataGuideTableModel);
                TableColumnModel tableColumnModel = ImportDataGuidePanel.this.dataMinerTablePanel1.getTable().getFullColumnModel();
                tableColumnModel.getColumn(importDataGuideTableModel.getColumnNodeIdx()).setPreferredWidth(60);
                tableColumnModel.getColumn(importDataGuideTableModel.getColumnTypeIdx()).setPreferredWidth(40);
                ImportDataGuidePanel.this.dataMinerTablePanel1.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    }
                });
                ImportDataGuidePanel.this.loading = false;
            } else {
                if (ImportDataGuidePanel.this._ex != null) {
                    ImportDataGuidePanel.this.setupMessagTable(ImportDataGuidePanel.this._ex.getMessage());
                }
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)ImportDataGuidePanel.this._ex, (String)DataDialogsLrb.get("IMPORT_DATAGUIDE_LOADING_FAILURE_TITLE"), (String)DataDialogsLrb.get("IMPORT_DATAGUIDE_LOADING_FAILURE_MESSAGE"), null);
            }
        }
    }

    class LoadComboUI
    extends SwingWorker<Boolean, Void> {
        LoadComboUI() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            if (ImportDataGuidePanel.this.allAvailableDataGuides == null) {
                try {
                    ImportDataGuidePanel.this.allAvailableDataGuides = ImportDataGuidePanel.this.getAllAvailableDataGuides();
                    ImportDataGuidePanel.this._success = true;
                }
                catch (Exception exception) {
                    ImportDataGuidePanel.this._ex = exception;
                    ImportDataGuidePanel.this._success = false;
                }
            }
            return Boolean.TRUE;
        }

        @Override
        protected void done() {
            if (ImportDataGuidePanel.this._success && ImportDataGuidePanel.this._ex == null) {
                ImportDataGuidePanel.this.setupTable(new ImportDataGuideTableModelEx(ImportDataGuidePanel.this.allAvailableDataGuides));
            } else {
                if (ImportDataGuidePanel.this._ex != null) {
                    ImportDataGuidePanel.this.setupMessagTable(ImportDataGuidePanel.this._ex.getMessage());
                }
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)ImportDataGuidePanel.this._ex, (String)DataDialogsLrb.get("IMPORT_DATAGUIDE_LOADING_FAILURE_TITLE"), (String)DataDialogsLrb.get("IMPORT_DATAGUIDE_LOADING_FAILURE_MESSAGE"), null);
            }
        }
    }
}

