/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.common.vo.TableVO;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.Version;

public class DataSourceAttributesDialog
extends DataConsumerAttributesDialog<DataSourceNode> {
    private static final Logger theLogger = Logger.getLogger(DataSourceAttributesDialog.class.getName());
    private boolean checkForUnderlyingTable = true;
    private boolean showChangeDs = false;
    private JButton jsonSettingBtn;
    private boolean _isDatabaseVersion12andUp = false;
    private List<String> isJSONConstraintColumns = new ArrayList<String>();

    public boolean isDatabaseVersion12andUp() {
        return this._isDatabaseVersion12andUp;
    }

    public DataSourceAttributesDialog() {
        this.wizName = "Edit data source node";
    }

    @Override
    protected JEWTDialog buildDialog(Context context, DataSourceNode dataSourceNode, AbstractDataNode abstractDataNode) {
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
            this._isDatabaseVersion12andUp = ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_2, version, true);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        List<AttributeType> list = this.getAvailableAttributes(abstractDataNode);
        if (this.checkForUnderlyingTable && list.isEmpty()) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)abstractDataNode.getData();
            TableType tableType = dataSourceNodeType.getSourceTable();
            String string = tableType.getSchema();
            String string2 = tableType.getName();
            this.errorMessage = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_MISSING"), string + "." + string2);
            return null;
        }
        DataSourceAttributesPanel dataSourceAttributesPanel = new DataSourceAttributesPanel(context, dataSourceNode, list, this.isJSONConstraintColumns, this._isDatabaseVersion12andUp, false);
        dataSourceAttributesPanel.setShowChangeDs(this.showChangeDs);
        JEWTDialog jEWTDialog = super.buildDialog(context, (JPanel)((Object)dataSourceAttributesPanel));
        this.jsonSettingBtn = new JButton(JSON_SETTINGS_TEXT);
        dataSourceAttributesPanel.setJsonButton(this.jsonSettingBtn);
        this.jsonSettingBtn.addActionListener(dataSourceAttributesPanel);
        jEWTDialog.addCustomButton((Component)this.jsonSettingBtn);
        dataSourceAttributesPanel.setDataSourceAttrsDialog(jEWTDialog);
        return jEWTDialog;
    }

    @Override
    protected String getDialogTitle() {
        return DataDialogsLrb.get("DATA_SOURCE_DIALOG_TITLE");
    }

    @Override
    protected List<AttributeType> getAvailableAttributes(final AbstractDataNode abstractDataNode) {
        final ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        class GetAttrs
        extends ProgressRunnable {
            GetAttrs() {
            }

            protected Object doWork() throws Exception {
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(DataSourceAttributesDialog.this.context);
                DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)abstractDataNode.getData();
                TableType tableType = dataSourceNodeType.getSourceTable();
                TableVO tableVO = new TableVO(tableType);
                List<Map<String, Object>> list = DatabaseMetadataUtils.getColumnDetails(connectionFolder, tableVO, DataSourceAttributesDialog.this.isJSONConstraintColumns);
                return list;
            }

            protected void finish(Object object) {
                List list = (List)object;
                if (list != null && !list.isEmpty()) {
                    for (Map map : list) {
                        AttributeType attributeType = new AttributeType();
                        attributeType.setName((String)map.get("COLUMN_NAME"));
                        attributeType.setDataType((String)map.get("DATA_TYPE"));
                        attributeType.setDataTypeQualifier((String)map.get("DATA_QUALIFIER"));
                        attributeType.setStatus(AttributeStatus.VALID);
                        arrayList.add(attributeType);
                    }
                }
            }
        }
        GetAttrs getAttrs = new GetAttrs();
        getAttrs.setTitle(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS"));
        getAttrs.setMessage(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS_DESCR"));
        getAttrs.setCancelable(false);
        try {
            getAttrs.start(true);
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return arrayList;
    }

    @Override
    protected void registerHelp(JEWTDialog jEWTDialog) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "dm_datasource_edit_columns");
    }

    public void setCheckForUnderlyingTable(boolean bl) {
        this.checkForUnderlyingTable = bl;
    }

    public void setShowChangeDs(boolean bl) {
        this.showChangeDs = bl;
    }
}

