/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.JSONDataTypeCellEditor;
import oracle.dmt.dataminer.controls.JSONHelper;
import oracle.dmt.dataminer.controls.JSONJComboBox;
import oracle.dmt.dataminer.controls.JSONTableCellRenderer;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.data.CreateTableAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesBase;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.EditDataGuideDialog;
import oracle.dmt.dataminer.workflow.dialog.data.JSONParsingSettingsPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DBAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DBColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.SwingUtils;
import oracle.javatools.util.Version;

public class CreateTableNodeAttributesPanel
extends DataConsumerAttributesBase<CreateTableNode>
implements ActionListener {
    private static final Logger theLogger = Logger.getLogger(AbstractPanel.class.getName());
    private List<AttributeType> dataProviderAttributes = new ArrayList<AttributeType>();
    private JButton _removeBtn;
    private JButton _editBtn;
    private JButton jsonSettingBtn;
    private DBAttributes cachedDBAttributesObj = new DBAttributes();
    private String _originalTableName;
    private static Icon _editIcon;
    private DataGuideSettingsType dataGuideSettings;
    private static final int NAME = 0;
    private static final int DATA_TYPE = 1;
    private static final int ISKEY = 2;
    private static final int ISINDEX = 3;
    private static final int ALIAS_TABLE = 4;
    private static final int ALIAS_VIEW = 2;
    private static final String[] COLUMN_NAMES_TABLE;
    private static final String[] COLUMN_NAMES_VIEW;
    private GenericTable _jAttributesTable = new GenericTableTooltipCustom();
    private boolean _isDatabaseVersion12andUp = false;
    private List<String> jsonParentNodeColumns = new ArrayList<String>();
    private Map<String, AttributeType> parentNodeJSONColumnsMap = new HashMap<String, AttributeType>();
    protected Map<String, JSONColumnsType.Attribute> thisNodeJSONColumnsMap = new HashMap<String, JSONColumnsType.Attribute>();
    protected Map<String, JSONColumnsType.Attribute> modifiedJSONColumns;
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JCheckBox jChkBoxAuto;
    private JLabel jLabelName;
    private JLabel jLabelType;
    private JRadioButton jRadioButtonTable;
    private JRadioButton jRadioButtonView;
    private JLabel jStatusBar;
    private JTextField jTextFieldName;
    private ButtonGroup buttonGroup1 = new ButtonGroup();

    public CreateTableNodeAttributesPanel(Context context, CreateTableNode createTableNode) {
        super(context, createTableNode);
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
            this._isDatabaseVersion12andUp = ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_2, version, true);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        AbstractNode abstractNode = createTableNode.findParentNode();
        if (abstractNode != null) {
            assert (abstractNode instanceof AbstractDataNode);
            List<AttributeType> list = this.getAvailableAttributes((AbstractDataNode)abstractNode);
            if (list != null) {
                this.dataProviderAttributes.addAll(list);
            }
        }
        this.getParentJSONColumns();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelType = new JLabel();
        this.jRadioButtonTable = new JRadioButton();
        this.jRadioButtonView = new JRadioButton();
        this.jChkBoxAuto = new JCheckBox();
        this.jStatusBar = new JLabel();
        this.jLabelName.setText("Name:");
        this.jLabelType.setText("Type:");
        this.jRadioButtonTable.setText("Table");
        this.jRadioButtonView.setText("View");
        this.jChkBoxAuto.setText("Auto Input Columns Selection");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelName).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jRadioButtonTable).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonView)).addComponent(this.jTextFieldName, -2, 185, -2))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelType, -1, -1, Short.MAX_VALUE).addGap(195, 195, 195))).addGap(180, 180, 180)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jChkBoxAuto, -2, 287, -2).addComponent(this.jStatusBar, -1, 516, Short.MAX_VALUE).addComponent((Component)this.jAttributesComponent, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelType).addComponent(this.jRadioButtonTable).addComponent(this.jRadioButtonView)).addGap(3, 3, 3).addComponent(this.jChkBoxAuto).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.jAttributesComponent, -1, 185, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jStatusBar, -2, 20, -2)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelName, (Component)this.jTextFieldName, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_NAME"));
        ResourceUtils.resLabel((JLabel)this.jLabelType, null, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TYPE"));
        ResourceUtils.resButton((AbstractButton)this.jRadioButtonTable, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TABLE"));
        ResourceUtils.resButton((AbstractButton)this.jRadioButtonView, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_VIEW"));
        ResourceUtils.resButton((AbstractButton)this.jChkBoxAuto, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_AUTO"));
        this.jChkBoxAuto.setOpaque(false);
        this.jRadioButtonTable.setOpaque(false);
        this.jRadioButtonView.setOpaque(false);
        this.buttonGroup1.add(this.jRadioButtonTable);
        this.buttonGroup1.add(this.jRadioButtonView);
        this.jTextFieldName.setDocument(new TextFieldLimit(32));
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
        }
        this.jStatusBar.setText("");
        this.jStatusBar.setVisible(false);
    }

    @Override
    public void initUI() {
        DBColumnType dBColumnType;
        Object object3;
        Object object2;
        JSONColumnsType.Attribute attribute2;
        CreateTableNode createTableNode = (CreateTableNode)this.getData();
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)createTableNode.getData();
        if (null != createTableNodeType.getJSONColumns() && !createTableNodeType.getJSONColumns().getAttribute().isEmpty()) {
            for (JSONColumnsType.Attribute attribute2 : createTableNodeType.getJSONColumns().getAttribute()) {
                this.thisNodeJSONColumnsMap.put(attribute2.getName(), JSONHelper.copyJSONColumnsTypeAttribute(attribute2));
            }
        }
        boolean bl = 0 == createTableNodeType.getAutoSpec().value().compareTo("Yes");
        this.jChkBoxAuto.setSelected(bl);
        this.jChkBoxAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = CreateTableNodeAttributesPanel.this.jChkBoxAuto.isSelected();
                CreateTableNodeAttributesPanel.this._editBtn.setEnabled(!bl);
                CreateTableNodeAttributesPanel.this._removeBtn.setEnabled(!bl);
                TableColumn tableColumn = CreateTableNodeAttributesPanel.this._jAttributesTable.getColumnModel().getColumn(1);
                JSONDataTypeCellEditor jSONDataTypeCellEditor = (JSONDataTypeCellEditor)tableColumn.getCellEditor();
                if (jSONDataTypeCellEditor != null) {
                    jSONDataTypeCellEditor.setEnable(!bl);
                }
                if (bl) {
                    CreateTableNodeAttributesPanel.this.refreshAttributesFromDS();
                    CreateTableNode createTableNode = (CreateTableNode)CreateTableNodeAttributesPanel.this.getData();
                    CreateTableNodeType createTableNodeType = (CreateTableNodeType)createTableNode.getData();
                    GeneralAttributesTableModel generalAttributesTableModel = createTableNodeType.isTable() ? new TableAttributes(CreateTableNodeAttributesPanel.this.cachedDBAttributesObj.getDBAttribute()) : new ViewAttributes(CreateTableNodeAttributesPanel.this.cachedDBAttributesObj.getDBAttribute());
                    CreateTableNodeAttributesPanel.this.setupItemsTable(generalAttributesTableModel);
                }
                CreateTableNodeAttributesPanel.this.setComboBoxRenderer();
            }
        });
        attribute2 = createTableNodeType.getDBAttributes();
        if (attribute2 != null && (object2 = attribute2.getDBAttribute()) != null && !object2.isEmpty()) {
            for (Object object3 : object2) {
                dBColumnType = new DBColumnType();
                dBColumnType.setAlias(object3.getAlias());
                dBColumnType.setAnnotation(object3.getAnnotation());
                dBColumnType.setDataType(object3.getDataType());
                dBColumnType.setDataTypeQualifier(object3.getDataTypeQualifier());
                dBColumnType.setName(object3.getName());
                dBColumnType.setStatus(object3.getStatus());
                dBColumnType.setKey(object3.getKey());
                dBColumnType.setIndex(object3.getIndex());
                this.cachedDBAttributesObj.getDBAttribute().add(dBColumnType);
            }
        }
        if (bl) {
            this.refreshAttributesFromDS();
        }
        object2 = createTableNodeType.isTable() ? new TableAttributes(this.cachedDBAttributesObj.getDBAttribute()) : new ViewAttributes(this.cachedDBAttributesObj.getDBAttribute());
        boolean bl2 = createTableNodeType.isTable();
        this.jRadioButtonTable.setSelected(bl2);
        this.jRadioButtonView.setSelected(!bl2);
        this.setupItemsTable((GeneralAttributesTableModel)((Object)object2));
        object3 = new JScrollPane((Component)this._jAttributesTable);
        this._jAttributesTable.setAutoResizeMode(3);
        this.jAttributesComponent.setComponent((JComponent)object3);
        this.jAttributesComponent.setLabel(new JLabel(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE")));
        dBColumnType = new ControlBar();
        this.installItemFilterActions((ControlBar)dBColumnType);
        this._editBtn.setEnabled(!bl);
        this._removeBtn.setEnabled(!bl);
        this.jAttributesComponent.setControlBar((ControlBar)dBColumnType);
        this._jAttributesTable.setFillsViewportHeight(true);
        this._originalTableName = createTableNodeType.getTableName();
        if (!StringUtils.isValidNonQuotedDBObjectName(this._originalTableName)) {
            this._originalTableName = StringUtils.addDoubleQuotes(this._originalTableName);
        }
        this.jTextFieldName.setText(this._originalTableName);
        this.jRadioButtonTable.addActionListener(this);
        this.jRadioButtonView.addActionListener(this);
        this.setComboBoxRenderer();
    }

    void setJsonButton(JButton jButton) {
        this.jsonSettingBtn = jButton;
        boolean bl = false;
        if (this.jsonSettingBtn != null && this._isDatabaseVersion12andUp) {
            bl = true;
        }
        jButton.setVisible(bl);
    }

    private void setComboBoxRenderer() {
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(1);
        if (this._isDatabaseVersion12andUp) {
            tableColumn.setCellRenderer(new JSONTableCellRenderer());
            JSONJComboBox jSONJComboBox = new JSONJComboBox();
            jSONJComboBox.addActionListener(this);
            boolean bl = this.jChkBoxAuto.isSelected();
            tableColumn.setCellEditor(new JSONDataTypeCellEditor(jSONJComboBox, !bl));
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Serializable serializable;
        Serializable serializable2;
        super.paintComponent(graphics);
        GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)this._jAttributesTable.getModel());
        int n = 100;
        int n2 = 80;
        if (graphics != null) {
            serializable2 = this._jAttributesTable.getFont();
            serializable = graphics.getFontMetrics((Font)serializable2);
            int n3 = generalAttributesTableModel.getMaxNameLength();
            int n4 = generalAttributesTableModel.getMaxTypeLength();
            if (n3 > 0) {
                n = ((FontMetrics)serializable).stringWidth("W") * n3;
            }
            if (n4 > 0) {
                n2 = ((FontMetrics)serializable).stringWidth("W") * n4;
            }
        }
        serializable2 = this._jAttributesTable.getColumnModel().getColumn(0);
        ((TableColumn)serializable2).setPreferredWidth(n);
        serializable = this._jAttributesTable.getColumnModel().getColumn(1);
        ((TableColumn)serializable).setPreferredWidth(n2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.jRadioButtonTable) || actionEvent.getSource().equals(this.jRadioButtonView)) {
            boolean bl = this.jRadioButtonTable.isSelected();
            this.reloadAttributes(bl);
        } else if (actionEvent.getSource() instanceof JSONJComboBox) {
            this.updateStatusBar();
        } else if (actionEvent.getSource() instanceof JButton) {
            JSONParsingSettingsPanel jSONParsingSettingsPanel;
            JButton jButton = (JButton)actionEvent.getSource();
            if (!jButton.getText().equals(DataSourceAttributesDialog.JSON_SETTINGS_TEXT)) {
                return;
            }
            CreateTableNode createTableNode = (CreateTableNode)this.getData();
            CreateTableNodeType createTableNodeType = (CreateTableNodeType)createTableNode.getData();
            if (this.dataGuideSettings == null) {
                this.dataGuideSettings = createTableNodeType.getDataGuideSettings();
                if (null == this.dataGuideSettings) {
                    this.dataGuideSettings = JSONHelper.initDataGuideSettings();
                }
            }
            if ((jSONParsingSettingsPanel = new JSONParsingSettingsPanel(this._context, this.dataGuideSettings)).showAsDialog(this)) {
                this.dataGuideSettings = jSONParsingSettingsPanel.getDataGuideSettings();
            }
        }
    }

    private void reloadAttributes(boolean bl) {
        DBColumnType dBColumnType;
        GeneralAttributesTableModel generalAttributesTableModel;
        int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
        HashMap<String, DBColumnType> hashMap = null;
        if (nArray != null && nArray.length > 0) {
            generalAttributesTableModel = (GeneralAttributesTableModel)((Object)this._jAttributesTable.getModel());
            hashMap = new HashMap<String, DBColumnType>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                dBColumnType = (DBColumnType)generalAttributesTableModel.getSrcData().get(nArray[i]);
                hashMap.put(dBColumnType.getName(), dBColumnType);
            }
        }
        generalAttributesTableModel = bl ? new TableAttributes(this.cachedDBAttributesObj.getDBAttribute()) : new ViewAttributes(this.cachedDBAttributesObj.getDBAttribute());
        this.setupItemsTable(generalAttributesTableModel);
        this.setComboBoxRenderer();
        if (hashMap != null) {
            Object object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            dBColumnType = generalAttributesTableModel.getSrcData();
            for (int i = 0; i < dBColumnType.size(); ++i) {
                object = (DBColumnType)dBColumnType.get(i);
                if (null == hashMap.get(object.getName())) continue;
                arrayList.add(i);
            }
            if (!arrayList.isEmpty()) {
                Integer[] integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                object = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object[i] = (DBColumnType)integerArray[i];
                }
                this._jAttributesTable.setSelectedRowsInModel((int[])object);
            }
        }
    }

    protected JSONColumnsType getMutableJSONColumns() {
        JSONColumnsType jSONColumnsType = null;
        CreateTableNode createTableNode = (CreateTableNode)this.getData();
        CreateTableNodeType createTableNodeType = (CreateTableNodeType)createTableNode.getData();
        if (createTableNodeType != null && null != createTableNodeType.getJSONColumns()) {
            jSONColumnsType = JSONHelper.copyJSONColumnsType(createTableNodeType.getJSONColumns());
        }
        return jSONColumnsType;
    }

    private void getParentJSONColumns() {
        this.parentNodeJSONColumnsMap = new HashMap<String, AttributeType>();
        JSONColumnsType jSONColumnsType = this.getMutableJSONColumns();
        for (AttributeType attributeType : this.dataProviderAttributes) {
            if (!DatabaseMetadataUtils.isJSONDataType(attributeType) || jSONColumnsType != null && !jSONColumnsType.getAttribute().isEmpty() && jSONColumnsType.getAttribute().contains(attributeType)) continue;
            String string = attributeType.getAlias() != null ? attributeType.getAlias() : attributeType.getName();
            this.jsonParentNodeColumns.add(string);
            this.parentNodeJSONColumnsMap.put(string, attributeType);
        }
    }

    private void installItemFilterActions(ControlBar controlBar) {
        this._editBtn = new JButton(_editIcon);
        String string = InspectorArb.getString((int)25);
        this._editBtn.setToolTipText(string);
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    boolean bl;
                    Object object;
                    Dialog dialog;
                    Object object2;
                    if (CreateTableNodeAttributesPanel.this._isDatabaseVersion12andUp && ((int[])(object2 = CreateTableNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel())).length == 1) {
                        dialog = null;
                        object = (GeneralAttributesTableModel)((Object)CreateTableNodeAttributesPanel.this._jAttributesTable.getModel());
                        for (int i = 0; i < ((int[])object2).length; ++i) {
                            DBColumnType dBColumnType = (DBColumnType)((ODMrTableModel)((Object)object)).getSrcData().get(object2[i]);
                            if (!DatabaseMetadataUtils.isJSONDataType((AttributeType)dBColumnType)) continue;
                            dialog = dBColumnType;
                            break;
                        }
                        if (dialog != null) {
                            CreateTableNodeAttributesPanel.this.editDataGuide((AttributeType)dialog);
                            return;
                        }
                    }
                    object2 = (CreateTableNode)CreateTableNodeAttributesPanel.this.getData();
                    dialog = SwingUtils.getAncestorDialog((Component)CreateTableNodeAttributesPanel.this);
                    object = new CreateTableAttributesDialog(CreateTableNodeAttributesPanel.this.cachedDBAttributesObj, CreateTableNodeAttributesPanel.this._isDatabaseVersion12andUp, CreateTableNodeAttributesPanel.this.parentNodeJSONColumnsMap, CreateTableNodeAttributesPanel.this.thisNodeJSONColumnsMap);
                    ((DataConsumerAttributesDialog)object).setParentDialog(dialog);
                    AbstractNode abstractNode = ((AbstractNode)object2).findParentNode();
                    if (abstractNode != null && abstractNode instanceof AbstractDataNode && (bl = ((DataConsumerAttributesDialog)object).invoke(CreateTableNodeAttributesPanel.this._context, object2, (AbstractDataNode)abstractNode))) {
                        Map<String, JSONColumnsType.Attribute> map = ((CreateTableAttributesDialog)object).getModifiedJSONColumns();
                        for (String object32 : map.keySet()) {
                            CreateTableNodeAttributesPanel.this.thisNodeJSONColumnsMap.put(object32, map.get(object32));
                            if (CreateTableNodeAttributesPanel.this.modifiedJSONColumns == null) {
                                CreateTableNodeAttributesPanel.this.modifiedJSONColumns = new HashMap<String, JSONColumnsType.Attribute>();
                            }
                            CreateTableNodeAttributesPanel.this.modifiedJSONColumns.put(object32, map.get(object32));
                        }
                        GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)CreateTableNodeAttributesPanel.this._jAttributesTable.getModel());
                        generalAttributesTableModel.fireTableDataChanged();
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(DataDialogsLrb.get("ATTRIBUTES_TOOLBAR_REMOVE_TOOLTIP"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CreateTableNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)CreateTableNodeAttributesPanel.this._jAttributesTable.getModel());
                    ArrayList<DBColumnType> arrayList = new ArrayList<DBColumnType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        DBColumnType dBColumnType = (DBColumnType)generalAttributesTableModel.getSrcData().get(nArray[i]);
                        if (!CreateTableNodeAttributesPanel.this.cachedDBAttributesObj.getDBAttribute().contains(dBColumnType)) continue;
                        arrayList.add(dBColumnType);
                    }
                    if (!arrayList.isEmpty()) {
                        CreateTableNodeAttributesPanel.this.cachedDBAttributesObj.getDBAttribute().removeAll(arrayList);
                        generalAttributesTableModel.fireTableDataChanged();
                    }
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
    }

    private void setupItemsTable(GeneralAttributesTableModel generalAttributesTableModel) {
        this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(0, true);
        this._jAttributesTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler());
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return IconCellRenderer.getIconForAttrStatus(CreateTableNodeAttributesPanel.this.cachedDBAttributesObj.getDBAttribute(), object);
            }
        });
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(this._context);
        TableColumn tableColumn2 = null;
        tableColumn2 = this.jRadioButtonTable.isSelected() ? this._jAttributesTable.getColumnModel().getColumn(4) : this._jAttributesTable.getColumnModel().getColumn(2);
        tableColumn2.setCellEditor(dBObjectNameEditor);
    }

    private void updateStatusBar() {
        boolean bl = false;
        int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
        if (nArray != null && nArray.length == 1) {
            List list;
            int n = nArray[0];
            GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)this._jAttributesTable.getModel());
            if (generalAttributesTableModel != null && (list = generalAttributesTableModel.getSrcData()) != null) {
                AttributeType attributeType = (AttributeType)list.get(n);
                if (DatabaseMetadataUtils.isJSONDataType(attributeType)) {
                    String string = this.isDataGuideAvailable(attributeType);
                    this.jStatusBar.setText(string);
                    this.jStatusBar.setVisible(true);
                    bl = true;
                } else {
                    this.jStatusBar.setText("");
                }
            }
        } else {
            this.jStatusBar.setText("");
        }
        if (this.showWarningIcon(this.jStatusBar.getText())) {
            this.jStatusBar.setIcon(OracleIcons.getIcon((String)"warning.png"));
        } else {
            this.jStatusBar.setIcon(null);
        }
    }

    private boolean showWarningIcon(String string) {
        return string.equals(JSONHelper.JSON_DATA_GUIDE_NOT_GENERATED);
    }

    private String isDataGuideAvailable(AttributeType attributeType) {
        CreateTableNode createTableNode = (CreateTableNode)this.getData();
        String string = null;
        if (createTableNode instanceof DataGuideProvider) {
            string = JSONHelper.isDataGuideAvailable(createTableNode, attributeType);
        }
        return string != null ? string : JSONHelper.JSON_DATA_GUIDE_NOT_GENERATED;
    }

    private void refreshAttributesFromDS() {
        ArrayList<DBColumnType> arrayList = new ArrayList<DBColumnType>();
        HashMap<String, DBColumnType> hashMap = new HashMap<String, DBColumnType>();
        for (DBColumnType dBColumnType : this.cachedDBAttributesObj.getDBAttribute()) {
            hashMap.put(dBColumnType.getName(), dBColumnType);
        }
        if (this.dataProviderAttributes != null) {
            for (AttributeType attributeType : this.dataProviderAttributes) {
                DBColumnType dBColumnType = (DBColumnType)hashMap.get(attributeType.getName());
                if (null != dBColumnType) {
                    if (dBColumnType.getStatus().equals((Object)AttributeStatus.MISSING)) {
                        dBColumnType.setStatus(attributeType.getStatus());
                    }
                    arrayList.add(dBColumnType);
                    continue;
                }
                dBColumnType = new DBColumnType();
                dBColumnType.setAlias(attributeType.getAlias());
                dBColumnType.setAnnotation(attributeType.getAnnotation());
                dBColumnType.setDataType(attributeType.getDataType());
                dBColumnType.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                dBColumnType.setName(attributeType.getName());
                dBColumnType.setStatus(attributeType.getStatus());
                dBColumnType.setKey("No");
                dBColumnType.setIndex("No");
                arrayList.add(dBColumnType);
            }
            if (!this.cachedDBAttributesObj.getDBAttribute().isEmpty()) {
                this.cachedDBAttributesObj.getDBAttribute().clear();
            }
            this.cachedDBAttributesObj.getDBAttribute().addAll(arrayList);
        }
    }

    @Override
    protected String getDialogTitle() {
        return DataDialogsLrb.get("CREATE_TABLE_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "createtable_node_edit";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        JButton jButton = new JButton(DataDialogsLrb.get("DATA_SOURCE_WZD_JSON_SETTINGS_BUTTON"));
        this.setJsonButton(jButton);
        jButton.addActionListener(this);
        jEWTDialog.addCustomButton((Component)jButton);
    }

    @Override
    public boolean doWork() {
        Object object2;
        JSONColumnsType jSONColumnsType;
        String string = this.jTextFieldName.getText().trim();
        if (string.length() == 0) {
            MessageDialog.error((Component)this, (Object)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_NAME_MISSING"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_ERROR_TITLE"), null);
            return false;
        }
        if (!StringUtils.isDoubleQuotedString(string)) {
            string = string.toUpperCase();
        }
        if (StringUtils.checkDataLossWithMsg(this._context, string, PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"))) {
            return false;
        }
        if (!this._originalTableName.equals(string)) {
            if (!TableNameValidator.isTableNameUnique(this._context, string)) {
                String string2 = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_IN_USE"), string);
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string2, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), null)) {
                    return false;
                }
            }
            if (!TableNameValidator.validateTableName(string, null, this._context, true)) {
                return false;
            }
        }
        string = StringUtils.trimDoubleQuotes(string);
        boolean bl = true;
        CreateTableNode createTableNode = (CreateTableNode)this.getData();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string3 = this.jChkBoxAuto.isSelected() ? "Yes" : "No";
        AutoSpecType autoSpecType = AutoSpecType.fromValue((String)string3);
        hashMap.put("autoSpec", autoSpecType);
        boolean bl2 = this.jRadioButtonTable.isSelected();
        hashMap.put("isTable", bl2);
        hashMap.put("tableName", string);
        hashMap.put("jsonDataGuideSettings", this.dataGuideSettings);
        if (this._isDatabaseVersion12andUp) {
            jSONColumnsType = new JSONColumnsType();
            if (!this.thisNodeJSONColumnsMap.isEmpty()) {
                for (String dBColumnType : this.thisNodeJSONColumnsMap.keySet()) {
                    object2 = this.thisNodeJSONColumnsMap.get(dBColumnType);
                    jSONColumnsType.getAttribute().add(object2);
                }
            }
            for (DBColumnType dBColumnType : this.cachedDBAttributesObj.getDBAttribute()) {
                JSONColumnsType.Attribute attribute;
                if (!dBColumnType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                if (DatabaseMetadataUtils.isJSONDataType((AttributeType)dBColumnType)) {
                    AttributeType attributeType;
                    object2 = dBColumnType.getAlias() != null ? dBColumnType.getAlias() : dBColumnType.getName();
                    attribute = this.thisNodeJSONColumnsMap.get(object2);
                    if (attribute != null || (attributeType = this.parentNodeJSONColumnsMap.get(object2)) != null) continue;
                    attribute = new JSONColumnsType.Attribute();
                    attribute.setName((String)object2);
                    DataGuideInfoType dataGuideInfoType = JSONHelper.getDefaultDataGuideInfo();
                    attribute.setDataGuideInfo(dataGuideInfoType);
                    jSONColumnsType.getAttribute().add(attribute);
                    continue;
                }
                object2 = dBColumnType.getAlias() != null ? dBColumnType.getAlias() : dBColumnType.getName();
                attribute = this.thisNodeJSONColumnsMap.get(object2);
                if (null == attribute) continue;
                jSONColumnsType.getAttribute().remove(attribute);
            }
            hashMap.put("JSONColumnsType", jSONColumnsType);
        }
        jSONColumnsType = new DBAttributes();
        Iterator<DBColumnType> iterator = jSONColumnsType.getDBAttribute();
        for (Object object2 : this.cachedDBAttributesObj.getDBAttribute()) {
            iterator.add((DBColumnType)object2);
        }
        hashMap.put(CreateTableNode.INPUT_COLUMNS, jSONColumnsType);
        try {
            CommandProcessor.getInstance().beginTrans(NodeMessagesLrb.get("CREATE_TABLE_PROPERTIES"));
            createTableNode.setState(NodeStatusType.READY);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("createTableProperties", null, hashMap, null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            object2 = (OdmrSDMUndoFilter)((CreateTableNode)this.getData()).getUndoFilter();
            ((OdmrSDMUndoFilter)((Object)object2)).prepareUndoPropertyList(createTableNode, this.getContext(), arrayList);
            createTableNode.validate(true);
            CommandProcessor.getInstance().endTrans();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            CommandProcessor.getInstance().abortTrans();
            bl = false;
        }
        return bl;
    }

    private void editDataGuide(AttributeType attributeType) {
        JSONColumnsType.Attribute attribute;
        Object object;
        Object object2;
        String string;
        CreateTableNode createTableNode = (CreateTableNode)this.getData();
        JSONColumnsType.Attribute attribute2 = null;
        String string2 = string = attributeType.getAlias() != null ? attributeType.getAlias() : attributeType.getName();
        if (this.modifiedJSONColumns != null) {
            attribute2 = this.modifiedJSONColumns.get(string);
        }
        if (attribute2 == null) {
            CreateTableNode createTableNode2 = createTableNode;
            object2 = createTableNode2.getJSONAttrDataGuideInfoType(attributeType);
            object = (DataGuideInfoType)MetaDataHelper.copyMetadataObject(object2);
            if (null == object) {
                object = JSONHelper.getDefaultDataGuideInfo();
            }
            attribute2 = new JSONColumnsType.Attribute();
            attribute2.setName(attributeType.getName());
            attribute2.setDataGuideInfo((DataGuideInfoType)object);
            if (this.modifiedJSONColumns == null) {
                this.modifiedJSONColumns = new HashMap<String, JSONColumnsType.Attribute>();
            }
            this.modifiedJSONColumns.put(attribute2.getName(), attribute2);
        }
        boolean bl = true;
        if ((null == this.parentNodeJSONColumnsMap.get(attributeType.getName()) || null == this.parentNodeJSONColumnsMap.get(attributeType.getAlias())) && (object2 = this.getMutableJSONColumns()) != null) {
            object = object2.getAttribute();
            attribute = object.iterator();
            while (attribute.hasNext()) {
                JSONColumnsType.Attribute attribute3 = (JSONColumnsType.Attribute)attribute.next();
                if (!attribute3.getName().equals(attributeType.getName()) && !attribute3.getName().equals(attributeType.getAlias())) continue;
                bl = false;
                break;
            }
        }
        object2 = new EditDataGuideDialog();
        ((EditDataGuideDialog)object2).setSelJSONAttribute(attributeType, attribute2, bl);
        object = this.isDataGuideAvailable(attributeType);
        if (((EditDataGuideDialog)object2).invoke(this._context, createTableNode, (AbstractDataNode)null) && (attribute = ((EditDataGuideDialog)object2).getCopyJSONAttributeMetadata()) != null) {
            this.thisNodeJSONColumnsMap.put(attribute.getName(), attribute);
            if (this.modifiedJSONColumns == null) {
                this.modifiedJSONColumns = new HashMap<String, JSONColumnsType.Attribute>();
            }
            this.modifiedJSONColumns.put(attribute.getName(), attribute);
            if (null != attribute.getDataGuideInfo() && null != attribute.getDataGuideInfo().getCustom() && null != attribute.getDataGuideInfo().getCustom().getDataGuide() && !attribute.getDataGuideInfo().getCustom().getDataGuide().getItem().isEmpty()) {
                object = DataDialogsLrb.get("USER_DEFINED_DATA_GUIDE");
            }
        }
        this.jStatusBar.setText((String)object);
        if (this.showWarningIcon(this.jStatusBar.getText())) {
            this.jStatusBar.setIcon(OracleIcons.getIcon((String)"warning.png"));
        } else {
            this.jStatusBar.setIcon(null);
        }
    }

    static {
        COLUMN_NAMES_TABLE = new String[]{TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_NAME_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_TYPE_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_KEY_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_INDEX_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_ALIAS_COLUMN")};
        COLUMN_NAMES_VIEW = new String[]{TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_NAME_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_TYPE_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_ALIAS_COLUMN")};
    }

    private static class GenericTableTooltipCustom
    extends DataMinerTable {
        GenericTableTooltipCustom() {
            this.setTooltipEnable(true);
        }

        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            this.repaint();
        }
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        SelectedItemSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            CreateTableNodeAttributesPanel.this._removeBtn.setEnabled(!CreateTableNodeAttributesPanel.this.jChkBoxAuto.isSelected() && !listSelectionModel.isSelectionEmpty());
            CreateTableNodeAttributesPanel.this.updateStatusBar();
        }
    }

    private class ViewAttributes
    extends GeneralAttributesTableModel {
        ViewAttributes(List<DBColumnType> list) {
            super(COLUMN_NAMES_VIEW, list);
        }

        @Override
        protected int getAliasColumn() {
            return 2;
        }
    }

    private class TableAttributes
    extends GeneralAttributesTableModel {
        TableAttributes(List<DBColumnType> list) {
            super(COLUMN_NAMES_TABLE, list);
        }

        @Override
        protected int getAliasColumn() {
            return 4;
        }
    }

    private abstract class GeneralAttributesTableModel
    extends ODMrTableModel<DBColumnType> {
        protected Map<String, Integer> maxLength;

        private GeneralAttributesTableModel(String[] stringArray, List<DBColumnType> list) {
            super(stringArray, list);
            this.maxLength = new HashMap<String, Integer>();
            this.calulateMaxLength();
        }

        protected abstract int getAliasColumn();

        private void calulateMaxLength() {
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < this.srcData.size(); ++i) {
                String string;
                DBColumnType dBColumnType = (DBColumnType)this.srcData.get(i);
                String string2 = dBColumnType.getName();
                if (string2.length() > n) {
                    n = string2.length();
                }
                if ((string = dBColumnType.getDataType()).length() <= n2) continue;
                n2 = string.length();
            }
            this.maxLength.put(COLUMN_NAMES_VIEW[0], n);
            this.maxLength.put(COLUMN_NAMES_VIEW[1], n2);
        }

        public int getMaxNameLength() {
            Integer n = this.maxLength.get(COLUMN_NAMES_VIEW[0]);
            return n != null ? n : 0;
        }

        public int getMaxTypeLength() {
            Integer n = this.maxLength.get(COLUMN_NAMES_VIEW[1]);
            return n != null ? n : 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != this.getAliasColumn() && n2 != 3 && n2 != 2 && n2 != 1) {
                return;
            }
            DBColumnType dBColumnType = (DBColumnType)this.srcData.get(n);
            if (n2 == this.getAliasColumn()) {
                Vector vector = new Vector();
                vector.addAll(this.srcData);
                vector.remove(dBColumnType);
                String string = null;
                String string2 = dBColumnType.getAlias();
                String string3 = dBColumnType.getName();
                if (object != null) {
                    string = ((String)object).trim();
                }
                if (string2 != null && StringUtils.isDoubleQuotedString(string)) {
                    string2 = StringUtils.addDoubleQuotes(string2);
                }
                if (string.length() != 0) {
                    if (!StringUtils.isDoubleQuotedString(string)) {
                        string = string.toUpperCase();
                    }
                    if (!AttributeNameValidator.validateAttributeName(string, vector, CreateTableNodeAttributesPanel.this._context, true)) {
                        return;
                    }
                } else if (string2 != null && string2.length() != 0 && !AttributeNameValidator.validateAttributeName(string3, vector, CreateTableNodeAttributesPanel.this._context, true)) {
                    return;
                }
                if (string2 != null && string2.compareTo(string) == 0) {
                    return;
                }
                if ("".equals(string = StringUtils.trimDoubleQuotes(string))) {
                    string = null;
                }
                dBColumnType.setAlias(string);
            } else if (n2 == 2) {
                dBColumnType.setKey(object.equals(true) ? "Yes" : "No");
                if (object.equals(true) && dBColumnType.getIndex().equals("Yes")) {
                    dBColumnType.setIndex("No");
                }
            } else if (n2 == 3) {
                dBColumnType.setIndex(object.equals(true) ? "Yes" : "No");
                if (object.equals(true) && dBColumnType.getKey().equals("Yes")) {
                    dBColumnType.setKey("No");
                }
            } else if (n2 == 1) {
                DBColumnType dBColumnType2 = (DBColumnType)this.srcData.get(n);
                String string = object.toString();
                if (DatabaseMetadataUtils.isJSONTypeSupported(string)) {
                    string = DatabaseMetadataUtils.getDataTypeCorresponsingToJSONType(string);
                    dBColumnType2.setDataTypeQualifier("JSON");
                } else {
                    dBColumnType2.setDataTypeQualifier(null);
                }
                dBColumnType2.setDataType(string);
            }
        }

        public Object getValueAt(int n, int n2) {
            if (this.srcData.isEmpty()) {
                return "";
            }
            DBColumnType dBColumnType = (DBColumnType)this.srcData.get(n);
            Object object = null;
            if (n2 == 0) {
                object = dBColumnType.getName();
            } else if (n2 == this.getAliasColumn()) {
                object = dBColumnType.getAlias();
            } else if (n2 == 1) {
                String string = dBColumnType.getDataType();
                String string2 = dBColumnType.getDataTypeQualifier();
                if (null != string2 && DatabaseMetadataUtils.isACharacterOracleDataType(string)) {
                    String string3 = DatabaseMetadataUtils.getJSONDataType(string, string2);
                    String[] stringArray = null;
                    stringArray = DatabaseMetadataUtils.isJSONDataType((AttributeType)dBColumnType) ? new String[]{string3, string} : new String[]{string, string3};
                    JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
                    return jComboBox;
                }
                object = string;
            } else if (n2 == 3) {
                boolean bl = CreateTableNodeAttributesPanel.this.jRadioButtonTable.isSelected();
                String string = dBColumnType.getIndex();
                object = string != null && bl ? Boolean.valueOf("Yes".equals(string)) : Boolean.FALSE;
            } else if (n2 == 2) {
                boolean bl = CreateTableNodeAttributesPanel.this.jRadioButtonTable.isSelected();
                String string = dBColumnType.getKey();
                object = string != null && bl ? Boolean.valueOf("Yes".equals(string)) : Boolean.FALSE;
            } else assert (false) : "Out of bounds column when accessing items";
            return object != null ? object : "";
        }

        @Override
        public Class getColumnClass(int n) {
            if (n == 1) {
                return Object.class;
            }
            Class<?> clazz = this.getValueAt(0, n).getClass();
            return clazz;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == this.getAliasColumn()) {
                return true;
            }
            if (n2 == 3 || n2 == 2) {
                if (CreateTableNodeAttributesPanel.this.jChkBoxAuto.isSelected()) {
                    return false;
                }
                DBColumnType dBColumnType = (DBColumnType)this.srcData.get(n);
                if (!DatabaseMetadataUtils.isTypeSupportedAsTableKey(dBColumnType.getDataType())) {
                    return false;
                }
                boolean bl = CreateTableNodeAttributesPanel.this.jRadioButtonTable.isSelected();
                return bl;
            }
            if (n2 == 1) {
                DBColumnType dBColumnType = (DBColumnType)this.srcData.get(n);
                String string = dBColumnType.getAlias() != null ? dBColumnType.getAlias() : dBColumnType.getName();
                Object object = this.getValueAt(n, n2);
                if (object instanceof JComboBox || object instanceof String) {
                    Object object2 = null;
                    object2 = object instanceof JComboBox ? ((JComboBox)object).getSelectedItem() : object;
                    if (DatabaseMetadataUtils.isACharacterOracleDataType(object2.toString()) || DatabaseMetadataUtils.isJSONTypeSupported(object2.toString())) {
                        if (null == CreateTableNodeAttributesPanel.this.jsonParentNodeColumns || CreateTableNodeAttributesPanel.this.jsonParentNodeColumns.isEmpty()) {
                            return true;
                        }
                        boolean bl = true;
                        for (String string2 : CreateTableNodeAttributesPanel.this.jsonParentNodeColumns) {
                            if (!string2.equals(string)) continue;
                            bl = false;
                            break;
                        }
                        return bl;
                    }
                }
            }
            return false;
        }
    }
}

