/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.columnFilter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.SettingsPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.ColumnFilterNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.ColumnFilterPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.WorkflowColumnFilterNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ColumnFilterNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;

public class OutputColumnPanel
extends DialogDisplayer<ColumnFilterNode> {
    private OutputColumnPanel _parent;
    private WorkflowColumnFilterNodePropertyProxyModel _propertyModel;
    private AttrsTableModel _models;
    private static Icon _editIcon;
    private JButton _includeBtn;
    private JButton _excludeBtn;
    private static int PREFERENCE_WIDTH;
    private JButton _undoBtn;
    private JButton _editBtn;
    private JButton _applyBtn;
    private ColumnFilterAttributeType _columnFilterAttribute;
    private ColumnFilterSettingsType _columnFilterSettings;
    private String _generatedAITableName;
    private boolean _dirty;
    private boolean _useSettings;
    private boolean _DQResultGen = false;
    private boolean _AIResultGen = false;
    private TableColumn _rankTableColumn;
    private TableColumn _importanceTableColumn;
    private TableColumn _nullPercentTableColumn;
    private TableColumn _uniquePercentTableColumn;
    private TableColumn _constantPercentTableColumn;
    private boolean _expandedDialog;
    private Map<String, String> _originalSetting = new HashMap<String, String>();
    private static final String ATTRIBUTE_MAYBE_GOOD;
    private String[] _columnFilters = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
    private String[] _columnNamesEx = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_OUTPUT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_RANK"), DialogsLrb.get("COLUMN_FILTER_COLUMN_IMPORTANCE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_NULL_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_UNIQUE_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_CONSTANT_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
    private String[] _columnFiltersEx = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_RANK"), DialogsLrb.get("COLUMN_FILTER_COLUMN_IMPORTANCE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_NULL_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_UNIQUE_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_CONSTANT_PERCENT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
    private int[] _columnWidthsEx = new int[]{180, 80, 60, 50, 80, 60, 80, 90, 200};
    private static final int ATTRIBUTE = 0;
    private static final int DATA_TYPE = 1;
    private static final int OUTPUT = 2;
    private static final int REASON_HINT = 3;
    private static final int RANK = 3;
    private static final int IMPORTANCE = 4;
    private static final int NULLS_PERCENT = 5;
    private static final int UNIQUE_PERCENT = 6;
    private static final int CONSTANT_PERCENT = 7;
    private static final int REASON_HINT_EX = 8;
    private static final int ATTR_STATUS = 99;
    private JButton jSettingsButton;
    private JCheckBox jShowAICheckBox;
    private JCheckBox jShowDQCheckBox;
    private JPanel jTablePanel;
    private DataMinerTablePanel dataMinerTablePanel = new DataMinerTablePanel();

    public OutputColumnPanel(Context context, ColumnFilterNode columnFilterNode, PropertyModel propertyModel) {
        super(context, columnFilterNode);
        assert (propertyModel != null) : "PropertyModel for ColumnFilter node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this._expandedDialog = true;
        this.init((ColumnFilterNode)this._data, propertyModel);
    }

    public OutputColumnPanel(Context context, ColumnFilterNode columnFilterNode, OutputColumnPanel outputColumnPanel) {
        super(context, columnFilterNode);
        assert (context != null) : "Context must not be null.";
        assert (columnFilterNode != null) : "ColumnFilter node must not be null.";
        this._parent = outputColumnPanel;
        this._expandedDialog = true;
        this.init(columnFilterNode, null);
    }

    public OutputColumnPanel(PropertyModel propertyModel) {
        super((Context)null, null);
        assert (propertyModel != null) : "PropertyModel for ColumnFilter node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this._expandedDialog = true;
        this.addAncestorListener(new PIAncestorListener(this));
        this.init((ColumnFilterNode)this._data, propertyModel);
    }

    private boolean isPIMode() {
        return this._propertyModel != null && this.getDialogInstance() == null;
    }

    private boolean isPIDialogMode() {
        return this._propertyModel != null && this.getDialogInstance() != null;
    }

    private void init(ColumnFilterNode columnFilterNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        this._useSettings = false;
        if (this._parent == null) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
            this._columnFilterAttribute = (ColumnFilterAttributeType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterAttributes());
            this._columnFilterSettings = (ColumnFilterSettingsType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterSettings());
            this._generatedAITableName = columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput();
        } else {
            this._columnFilterAttribute = this._parent.getColumnFilterAttribute();
            this._columnFilterSettings = this._parent.getColumnFilterSettings();
            this._generatedAITableName = this._parent.getAIResultTable();
        }
        this._originalSetting.clear();
        for (ColumnFilterAttributeType.Attribute attribute : this._columnFilterAttribute.getAttribute()) {
            this._originalSetting.put(attribute.getName(), attribute.getOutput());
        }
        this.initComponents();
        this.initRes();
        if (this._expandedDialog) {
            this.initUIEx();
        } else {
            this.initUI();
        }
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)workflowNodeInspectorElement.getNode();
        if (columnFilterNode == null) {
            return;
        }
        this._propertyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = columnFilterNode;
        this._dirty = false;
        this._useSettings = false;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
        this._columnFilterAttribute = (ColumnFilterAttributeType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterAttributes());
        this.refreshUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowColumnFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private ColumnFilterNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowColumnFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ColumnFilterNodeType) {
            return (ColumnFilterNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        try {
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_TRANSACTION_NAME"));
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
            ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
            ComplexProperty complexProperty = new ComplexProperty("ColumnFilterAttributes", this._columnFilterAttribute);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterAttributes());
            arrayList.add(complexProperty);
            complexProperty = new ComplexProperty("ColumnFilterSettings", this._columnFilterSettings);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings());
            arrayList.add(complexProperty);
            complexProperty = new ComplexProperty("AttrImportanceTable", this._generatedAITableName);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput());
            arrayList.add(complexProperty);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((ColumnFilterNode)this.getData()).getUndoFilter();
            odmrSDMUndoFilter.prepareUndoComplexPropertyList(columnFilterNode, this.getContext(), arrayList);
            columnFilterNode.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_ERROR_MESG"), null);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        if ((this.isDirty() || this._useSettings) && !this.isPIMode()) {
            if (this.isPIDialogMode()) {
                this.updateNode();
            } else if (this._parent != null) {
                this._parent.setOutputColumns(this._columnFilterAttribute);
                this._parent.setColumnFilterSettings(this._columnFilterSettings);
                this._parent.setAIResultTable(this._generatedAITableName);
                this._parent.setDirty(true);
                this._parent.refreshUI();
            } else {
                this.updateNode();
            }
        }
        return bl;
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this.jSettingsButton, (String)DialogsLrb.get("COLUMN_FILTER_COLUMN_SETTINGS"));
        ResourceUtils.resButton((AbstractButton)this.jShowDQCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_COLUMN_SHOW_DQ"));
        ResourceUtils.resButton((AbstractButton)this.jShowAICheckBox, (String)DialogsLrb.get("COLUMN_FILTER_COLUMN_SHOW_AI"));
        _editIcon = InspectorArb.getIcon((int)24);
    }

    @Override
    public void initUI() {
        List list = this._columnFilterAttribute.getAttribute();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this._models = new AttrsTableModel(list);
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
        if (!columnFilterNode.isNew()) {
            this._includeBtn = new JButton(WorkflowEditorLrb.get("WORKFLOW_PARALLEL_ALL_ON"));
            this._includeBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_INCLUDE_ALL"));
            this._includeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutputColumnPanel.this.processSelectAll();
                }
            });
            this._includeBtn.setPreferredSize(new Dimension(PREFERENCE_WIDTH, this._includeBtn.getHeight()));
            arrayList.add(this._includeBtn);
            this._excludeBtn = new JButton(WorkflowEditorLrb.get("WORKFLOW_PARALLEL_ALL_OFF"));
            this._excludeBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_EXCLUDE_ALL"));
            this._excludeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutputColumnPanel.this.processDeselectAll();
                }
            });
            this._excludeBtn.setPreferredSize(new Dimension(PREFERENCE_WIDTH, this._excludeBtn.getHeight()));
            arrayList.add(this._excludeBtn);
            if (!this.isPIMode()) {
                this._undoBtn = new JButton(OracleIcons.getIcon((String)"undo.png"));
                this._undoBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_UNDO_RECOMM"));
                this._undoBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        OutputColumnPanel.this.processUndoRecomm();
                    }
                });
                arrayList.add(this._undoBtn);
            }
            this._applyBtn = new JButton(OracleIcons.getIcon((String)"showdifferences.png"));
            this._applyBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_APPLY_RECOMM"));
            this._applyBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutputColumnPanel.this.processApply();
                }
            });
            arrayList.add(this._applyBtn);
        }
        this.dataMinerTablePanel.addControlBarComponents(arrayList.toArray(new Component[0]));
        this.jTablePanel.add(this.dataMinerTablePanel);
        this.dataMinerTablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("COLUMN_FILTER_COLUMN_TABLE_TITLE"), this._columnFilters, 0);
        TableColumn tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new NameCellRenderer());
        tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new OutputCellEditor());
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                if (object instanceof String && (string = (String)object).length() > 0) {
                    return DataMinerIcons.get(Icons.WARNING_STATUS);
                }
                return DataMinerIcons.getNullIcon();
            }
        });
        tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(iconCellRenderer);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
        this.dataMinerTablePanel.getTable().setShowToolTips(true);
        this.dataMinerTablePanel.getTable().setUpdateSelectionOnSort(true);
        this.dataMinerTablePanel.getTable().setRowSelectionAllowed(true);
        this.dataMinerTablePanel.getTable().autoSizeColumnsToFit();
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                OutputColumnPanel.this.handleModelSelectionChanged();
            }
        });
        this.enableControls();
    }

    public void initUIEx() {
        HelpUtils.setHelpID((JComponent)this, (String)"columnfilter_columns_ex");
        this.jSettingsButton.setVisible(!this.isPIMode() && !this.isPIDialogMode());
        this._models = new AttrsTableModelEx();
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
        if (!columnFilterNode.isNew()) {
            this._includeBtn = new JButton(WorkflowEditorLrb.get("WORKFLOW_PARALLEL_ALL_ON"));
            this._includeBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_INCLUDE_ALL"));
            this._includeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutputColumnPanel.this.processSelectAll();
                }
            });
            this._includeBtn.setPreferredSize(new Dimension(PREFERENCE_WIDTH, this._includeBtn.getHeight()));
            arrayList.add(this._includeBtn);
            this._excludeBtn = new JButton(WorkflowEditorLrb.get("WORKFLOW_PARALLEL_ALL_OFF"));
            this._excludeBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_EXCLUDE_ALL"));
            this._excludeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutputColumnPanel.this.processDeselectAll();
                }
            });
            this._excludeBtn.setPreferredSize(new Dimension(PREFERENCE_WIDTH, this._excludeBtn.getHeight()));
            arrayList.add(this._excludeBtn);
            if (!this.isPIMode()) {
                this._undoBtn = new JButton(OracleIcons.getIcon((String)"undo.png"));
                this._undoBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_UNDO_RECOMM"));
                this._undoBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        OutputColumnPanel.this.processUndoRecomm();
                    }
                });
                arrayList.add(this._undoBtn);
            }
            this._applyBtn = new JButton(OracleIcons.getIcon((String)"showdifferences.png"));
            this._applyBtn.setToolTipText(DialogsLrb.get("COLUMN_FILTER_APPLY_RECOMM"));
            this._applyBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutputColumnPanel.this.processApply();
                }
            });
            arrayList.add(this._applyBtn);
        }
        this.dataMinerTablePanel.addControlBarComponents(arrayList.toArray(new Component[0]));
        this.jTablePanel.add(this.dataMinerTablePanel);
        this.dataMinerTablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("COLUMN_FILTER_COLUMN_TABLE_TITLE"), this._columnFiltersEx, 0);
        TableColumn tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new NameCellRenderer());
        tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new OutputCellEditor());
        this._rankTableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(3);
        this._rankTableColumn.setCellRenderer(new NumberCellRenderer());
        this._importanceTableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(4);
        Preferences preferences = Preferences.getPreferences();
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)preferences);
        NumberFormat numberFormat = NumericFormat.getInstance(true, modelViewerPreferenceSettings.getPercentagePrecisionLevel(), 0, 0);
        numberFormat.setMaximumFractionDigits(modelViewerPreferenceSettings.getPercentagePrecisionLevel());
        numberFormat.setMinimumIntegerDigits(1);
        this._importanceTableColumn.setCellRenderer(new HistogramBarRenderer(1L, true, numberFormat));
        this._nullPercentTableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(5);
        this._nullPercentTableColumn.setCellRenderer(new HistogramBarRenderer(100L, true, numberFormat));
        this._uniquePercentTableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(6);
        this._uniquePercentTableColumn.setCellRenderer(new HistogramBarRenderer(100L, true, numberFormat));
        this._constantPercentTableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(7);
        this._constantPercentTableColumn.setCellRenderer(new HistogramBarRenderer(100L, true, numberFormat));
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                if (object instanceof String && (string = (String)object).length() > 0) {
                    return DataMinerIcons.get(Icons.WARNING_STATUS);
                }
                return DataMinerIcons.getNullIcon();
            }
        });
        tableColumn = this.dataMinerTablePanel.getTable().getColumnModel().getColumn(8);
        tableColumn.setCellRenderer(iconCellRenderer);
        this.dataMinerTablePanel.getTable().setAutoResizeMode(0);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
        this.dataMinerTablePanel.getTable().setShowToolTips(true);
        this.dataMinerTablePanel.getTable().setUpdateSelectionOnSort(true);
        this.dataMinerTablePanel.getTable().setRowSelectionAllowed(true);
        int n = 0;
        for (int n2 : this._columnWidthsEx) {
            this.dataMinerTablePanel.getTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                OutputColumnPanel.this.handleModelSelectionChanged();
            }
        });
        this._AIResultGen = false;
        this._DQResultGen = false;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
        this._AIResultGen = columnFilterNodeType.getColumnFilterResults().getAttrImportanceOutput() != null && !columnFilterNode.isNew();
        boolean bl = this._DQResultGen = columnFilterNodeType.getColumnFilterResults().getDataQualityOutput() != null && !columnFilterNode.isNew();
        if (this._AIResultGen) {
            this.jShowAICheckBox.setVisible(true);
            this.jShowAICheckBox.setSelected(this._AIResultGen);
        } else {
            this.jShowAICheckBox.setVisible(false);
            this.dataMinerTablePanel.getTable().removeColumn(this._rankTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._importanceTableColumn);
        }
        if (this._DQResultGen) {
            this.jShowDQCheckBox.setVisible(true);
            this.jShowDQCheckBox.setSelected(this._DQResultGen);
        } else {
            this.jShowDQCheckBox.setVisible(false);
            this.dataMinerTablePanel.getTable().removeColumn(this._nullPercentTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._uniquePercentTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._constantPercentTableColumn);
        }
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public ColumnFilterAttributeType getColumnFilterAttribute() {
        return this._columnFilterAttribute;
    }

    public ColumnFilterSettingsType getColumnFilterSettings() {
        return this._columnFilterSettings;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("EDIT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "columnfilter_columns";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMinimumSize(new Dimension(1000, 500));
    }

    public void refreshUI() {
        List list = this._columnFilterAttribute.getAttribute();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this._models.setSrcData(list);
        this._originalSetting.clear();
        for (ColumnFilterAttributeType.Attribute attribute : this._columnFilterAttribute.getAttribute()) {
            this._originalSetting.put(attribute.getName(), attribute.getOutput());
        }
        this.enableControls();
    }

    private void enableControls() {
        this.jSettingsButton.setVisible(!this.isPIMode() && !this.isPIDialogMode());
        if (!this._expandedDialog) {
            this.jShowAICheckBox.setVisible(false);
            this.jShowDQCheckBox.setVisible(false);
        }
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
        if (this._editBtn != null) {
            this._editBtn.setEnabled(this.isWritable() && !columnFilterNode.isNew());
        }
        int n = this.dataMinerTablePanel.getTable().getSelectedRowCount();
        if (this._applyBtn != null) {
            this._applyBtn.setEnabled(this.isWritable() && n > 0 && !columnFilterNode.isNew());
        }
        int n2 = this.dataMinerTablePanel.getTable().getRowCount();
        if (this._includeBtn != null) {
            this._includeBtn.setEnabled(this.isWritable() && n2 > 0);
        }
        if (this._excludeBtn != null) {
            this._excludeBtn.setEnabled(this.isWritable() && n > 0);
        }
        if (this._undoBtn != null) {
            this._undoBtn.setEnabled(this.isWritable() && this._useSettings);
        }
    }

    private void processSelectAll() {
        int n = this.dataMinerTablePanel.getTable().getRowCount();
        if (n == 0) {
            return;
        }
        this.dataMinerTablePanel.getTable().selectAll();
        this.enableControls();
    }

    private void processDeselectAll() {
        int n = this.dataMinerTablePanel.getTable().getRowCount();
        if (n == 0) {
            return;
        }
        this.dataMinerTablePanel.getTable().clearSelection();
        this.enableControls();
    }

    private void processUndoRecomm() {
        List list = this._models.getSrcData();
        for (ColumnFilterAttributeType.Attribute attribute : list) {
            String string = this._originalSetting.get(attribute.getName());
            if (string == null) continue;
            attribute.setOutput(string);
        }
        this._models.setSrcData(list);
        this._models.fireTableDataChanged();
        this._useSettings = false;
        this.enableControls();
    }

    private void processApply() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)this._columnFilterAttribute.getAttribute().get(n);
            String string = columnFilterNode.getReasonHintsLookupMap().get(attribute.getName());
            if (attribute.getOutput().compareTo("Yes") == 0 && string != null) {
                attribute.setOutput("No");
            }
            if (attribute.getOutput().compareTo("No") != 0 || string != null) continue;
            attribute.setOutput("Yes");
        }
        this.dataMinerTablePanel.getTable().updateUI();
        this._useSettings = true;
        if (this.isPIMode()) {
            this.updateNode();
        }
        this.enableControls();
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    private void initComponents() {
        this.jShowAICheckBox = new JCheckBox();
        this.jShowDQCheckBox = new JCheckBox();
        this.jSettingsButton = new JButton();
        this.jTablePanel = new JPanel();
        this.jShowAICheckBox.setText("Show Attribute Importance");
        this.jShowAICheckBox.setName("jShowAICheckBox");
        this.jShowAICheckBox.setOpaque(false);
        this.jShowAICheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.jShowAICheckBoxActionPerformed(actionEvent);
            }
        });
        this.jShowDQCheckBox.setText("Show Data Quality");
        this.jShowDQCheckBox.setName("jShowDQCheckBox");
        this.jShowDQCheckBox.setOpaque(false);
        this.jShowDQCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.jShowDQCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jSettingsButton.setText("Settings");
        this.jSettingsButton.setName("jSettingsButton");
        this.jSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputColumnPanel.this.jSettingsButtonActionPerformed(actionEvent);
            }
        });
        this.jTablePanel.setName("jTablePanel");
        this.jTablePanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jShowAICheckBox, -2, 210, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 396, Short.MAX_VALUE).addComponent(this.jSettingsButton)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jShowDQCheckBox, -2, 210, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jShowAICheckBox).addComponent(this.jSettingsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jShowDQCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTablePanel, -1, 273, Short.MAX_VALUE).addContainerGap()));
    }

    private void jShowAICheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jShowAICheckBox.isSelected();
        if (bl) {
            this.dataMinerTablePanel.getTable().addColumn(this._rankTableColumn);
            this.dataMinerTablePanel.getTable().moveColumn(this.dataMinerTablePanel.getTable().getColumnCount() - 1, 3);
            this.dataMinerTablePanel.getTable().addColumn(this._importanceTableColumn);
            this.dataMinerTablePanel.getTable().moveColumn(this.dataMinerTablePanel.getTable().getColumnCount() - 1, 4);
        } else {
            this.dataMinerTablePanel.getTable().removeColumn(this._rankTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._importanceTableColumn);
        }
        this.enableControls();
    }

    private void jShowDQCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jShowDQCheckBox.isSelected();
        if (bl) {
            this.dataMinerTablePanel.getTable().addColumn(this._nullPercentTableColumn);
            int n = this.jShowAICheckBox.isSelected() ? 0 : 2;
            this.dataMinerTablePanel.getTable().moveColumn(this.dataMinerTablePanel.getTable().getColumnCount() - 1, 5 - n);
            this.dataMinerTablePanel.getTable().addColumn(this._uniquePercentTableColumn);
            this.dataMinerTablePanel.getTable().moveColumn(this.dataMinerTablePanel.getTable().getColumnCount() - 1, 6 - n);
            this.dataMinerTablePanel.getTable().addColumn(this._constantPercentTableColumn);
            this.dataMinerTablePanel.getTable().moveColumn(this.dataMinerTablePanel.getTable().getColumnCount() - 1, 7 - n);
        } else {
            this.dataMinerTablePanel.getTable().removeColumn(this._nullPercentTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._uniquePercentTableColumn);
            this.dataMinerTablePanel.getTable().removeColumn(this._constantPercentTableColumn);
        }
        this.enableControls();
    }

    private void jSettingsButtonActionPerformed(ActionEvent actionEvent) {
        SettingsPanel settingsPanel = new SettingsPanel(this._context, (ColumnFilterNode)this._data, this);
        settingsPanel.showAsDialog(this);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public void setOutputColumns(ColumnFilterAttributeType columnFilterAttributeType) {
        this._columnFilterAttribute = columnFilterAttributeType;
    }

    public void setColumnFilterSettings(ColumnFilterSettingsType columnFilterSettingsType) {
        this._columnFilterSettings = columnFilterSettingsType;
    }

    public void setAIResultTable(String string) {
        this._generatedAITableName = string;
    }

    public String getAIResultTable() {
        return this._generatedAITableName;
    }

    static {
        PREFERENCE_WIDTH = 35;
        ATTRIBUTE_MAYBE_GOOD = DialogsLrb.get("COLUMN_FILTER_GOOD_ATTRIBUTE_INFO");
    }

    private class NameCellRenderer
    extends DefaultTableCellRenderer {
        private NameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = OutputColumnPanel.this.dataMinerTablePanel.getTable().convertRowIndexToModel(n);
            TableModel tableModel = OutputColumnPanel.this.dataMinerTablePanel.getTable().getModel();
            AttributeStatus attributeStatus = AttributeStatus.VALID;
            if (tableModel instanceof AttrsTableModel && (object2 = tableModel.getValueAt(n3, 99)) instanceof AttributeStatus) {
                attributeStatus = (AttributeStatus)object2;
            }
            if (attributeStatus.equals((Object)AttributeStatus.VALID)) {
                this.setIcon(OracleIcons.getIcon((String)"attribute.png"));
            } else {
                this.setIcon(OracleIcons.getIcon((String)"warning.png"));
            }
            return component;
        }
    }

    private class OutputCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Icon _icon;
        private JButton _btn = new JButton(DataMinerIcons.getNullIcon());
        private static final String EDIT = "edit";

        public OutputCellEditor() {
            this._btn.setActionCommand(EDIT);
            this._btn.addActionListener(this);
            this._btn.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.fireEditingStopped();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            int n3 = OutputColumnPanel.this.dataMinerTablePanel.getTable().convertRowIndexToModel(n);
            TableModel tableModel = OutputColumnPanel.this.dataMinerTablePanel.getTable().getModel();
            this._icon = (Icon)tableModel.getValueAt(n3, 2);
            this._btn.setIcon(this._icon);
            return this._btn;
        }

        @Override
        public Object getCellEditorValue() {
            if (this._icon == OracleIcons.getIcon((String)"messageAsync.png")) {
                this._icon = DataMinerIcons.get(Icons.ATTR_IGNORE);
            } else if (this._icon.equals(DataMinerIcons.get(Icons.ATTR_IGNORE))) {
                this._icon = OracleIcons.getIcon((String)"messageAsync.png");
            }
            return this._icon;
        }
    }

    private class AttrsTableModelEx
    extends AttrsTableModel {
        Map<String, ColumnFilterNode.Statistics> _statisticLookupMap;

        public AttrsTableModelEx() {
            this(null, null);
        }

        public AttrsTableModelEx(List<ColumnFilterAttributeType.Attribute> list, Map<String, ColumnFilterNode.Statistics> map) {
            super(list);
            this._statisticLookupMap = map;
            this.setColumnIdentifiers(OutputColumnPanel.this._columnNamesEx);
        }

        @Override
        public Class getColumnClass(int n) {
            switch (n) {
                case 3: {
                    return Integer.class;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return Double.class;
                }
                case 8: {
                    return String.class;
                }
            }
            return super.getColumnClass(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.srcData == null) {
                return DialogsLrb.get("COLUMN_FILTER_LOADING_MESSAGE");
            }
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)this.srcData.get(n);
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
            ColumnFilterNode.Statistics statistics = columnFilterNode.getStatisticLookupMap().get(attribute.getName());
            Object object = null;
            switch (n2) {
                case 3: {
                    if (statistics == null) break;
                    object = statistics.getRank();
                    break;
                }
                case 4: {
                    if (statistics == null) break;
                    object = statistics.getImportance();
                    break;
                }
                case 5: {
                    if (statistics == null) break;
                    object = statistics.getNulls();
                    break;
                }
                case 6: {
                    if (statistics == null) break;
                    object = statistics.getUnique();
                    break;
                }
                case 7: {
                    if (statistics == null) break;
                    object = statistics.getConstant();
                    break;
                }
                case 8: {
                    object = super.getValueAt(n, 3);
                    break;
                }
                default: {
                    object = super.getValueAt(n, n2);
                }
            }
            return object;
        }

        public void setStatisticLookupMap(Map<String, ColumnFilterNode.Statistics> map) {
            this._statisticLookupMap = map;
        }
    }

    private class AttrsTableModel
    extends ODMrTableModel<ColumnFilterAttributeType.Attribute> {
        private final String[] _columnNames;

        public AttrsTableModel(List<ColumnFilterAttributeType.Attribute> list) {
            super(list);
            this._columnNames = new String[]{DialogsLrb.get("COLUMN_FILTER_COLUMN_ATTRIBUTE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_DATA_TYPE"), DialogsLrb.get("COLUMN_FILTER_COLUMN_OUTPUT"), DialogsLrb.get("COLUMN_FILTER_COLUMN_HINTS")};
            this.setColumnIdentifiers(this._columnNames);
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                return OutputColumnPanel.this.isWritable();
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            if (this.srcData == null || this.srcData.isEmpty()) {
                return DialogsLrb.get("COLUMN_FILTER_LOADING_MESSAGE");
            }
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)this.srcData.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = attribute.getName();
                    break;
                }
                case 1: {
                    object = DatabaseMetadataUtils.getJSONDataType(attribute.getDataType(), attribute.getDataTypeQualifier());
                    break;
                }
                case 2: {
                    if (attribute.getOutput().compareTo("System") == 0) {
                        object = DataMinerIcons.get(Icons.FILTER_ATTR_UNKNOWN);
                        break;
                    }
                    if (attribute.getOutput().compareTo("Yes") == 0) {
                        object = OracleIcons.getIcon((String)"messageAsync.png");
                        break;
                    }
                    if (attribute.getOutput().compareTo("No") != 0) break;
                    object = DataMinerIcons.get(Icons.ATTR_IGNORE);
                    break;
                }
                case 3: {
                    object = "";
                    ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
                    String string = columnFilterNode.getReasonHintsLookupMap().get(attribute.getName());
                    if (string != null) {
                        object = string;
                    }
                    if (attribute.getOutput().compareTo("Yes") == 0 && string != null) {
                        object = string;
                    }
                    if (columnFilterNode.isNew() || attribute.getOutput().compareTo("No") != 0 || string != null) break;
                    object = ATTRIBUTE_MAYBE_GOOD;
                    break;
                }
                case 99: {
                    object = attribute.getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ColumnFilterAttributeType.Attribute attribute = (ColumnFilterAttributeType.Attribute)this.srcData.get(n);
            switch (n2) {
                case 2: {
                    OutputColumnPanel.this._useSettings = true;
                    Icon icon = (Icon)object;
                    int[] nArray = OutputColumnPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
                    if (!OutputColumnPanel.this.isPIMode()) {
                        if (icon.equals(OracleIcons.getIcon((String)"messageAsync.png"))) {
                            attribute.setOutput("Yes");
                        } else if (icon.equals(DataMinerIcons.get(Icons.ATTR_IGNORE))) {
                            attribute.setOutput("No");
                        }
                        for (int i = 0; i < nArray.length; ++i) {
                            int n3 = nArray[i];
                            ColumnFilterAttributeType.Attribute attribute2 = (ColumnFilterAttributeType.Attribute)this.srcData.get(n3);
                            if (icon.equals(OracleIcons.getIcon((String)"messageAsync.png"))) {
                                attribute2.setOutput("Yes");
                                continue;
                            }
                            if (!icon.equals(DataMinerIcons.get(Icons.ATTR_IGNORE))) continue;
                            attribute2.setOutput("No");
                        }
                        break;
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    String string = attribute.getOutput();
                    if (icon.equals(OracleIcons.getIcon((String)"messageAsync.png"))) {
                        hashMap.put(attribute.getName(), "Yes");
                        hashMap2.put(attribute.getName(), string);
                    } else if (icon.equals(DataMinerIcons.get(Icons.ATTR_IGNORE))) {
                        hashMap.put(attribute.getName(), "No");
                        hashMap2.put(attribute.getName(), string);
                    }
                    for (int i = 0; i < nArray.length; ++i) {
                        int n4 = nArray[i];
                        ColumnFilterAttributeType.Attribute attribute3 = (ColumnFilterAttributeType.Attribute)this.srcData.get(n4);
                        string = attribute3.getOutput();
                        if (icon.equals(OracleIcons.getIcon((String)"messageAsync.png"))) {
                            hashMap.put(attribute3.getName(), "Yes");
                            hashMap2.put(attribute3.getName(), string);
                            continue;
                        }
                        if (!icon.equals(DataMinerIcons.get(Icons.ATTR_IGNORE))) continue;
                        hashMap.put(attribute3.getName(), "No");
                        hashMap2.put(attribute3.getName(), string);
                    }
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    ComplexProperty complexProperty = new ComplexProperty("attrOutputs", hashMap);
                    complexProperty.setOldData(hashMap2);
                    arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RowIndex.ATTR_OUTPUTS), null, complexProperty, null, null));
                    OutputColumnPanel.this._propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_COLUMNS_ATTRIBUTE_OUTPUT_COLUMN_CHANGED"), (AbstractNode)OutputColumnPanel.this.getData(), (List<Property>)arrayList);
                }
            }
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        private LoadUI() {
            super(OutputColumnPanel.this, OutputColumnPanel.this.dataMinerTablePanel.getTable());
        }

        @Override
        protected Void doInBackground() throws Exception {
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
            columnFilterNode.loadResults();
            return null;
        }

        @Override
        protected void onSuccess(Void void_) {
            List list = OutputColumnPanel.this._columnFilterAttribute.getAttribute();
            Collections.sort(list, AttributeTypeComparator.getComparator());
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)OutputColumnPanel.this.getData();
            ((AttrsTableModelEx)OutputColumnPanel.this._models).setStatisticLookupMap(columnFilterNode.getStatisticLookupMap());
            OutputColumnPanel.this._models.setSrcData(list);
        }

        @Override
        protected void onFinally() {
            OutputColumnPanel.this.enableControls();
        }
    }
}

