/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelEMBuildDataPrepAnalysisPanel;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Version;

public class ModelEMBuildSettingsPanel
extends AbstractPropertiesPanel {
    private static final String SYSTEM_DETERMINED = AlgSettingsLrb.get("SYSTEM_DETERMINED");
    private HashMap<String, Object> cacheSettings = new HashMap();
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JComboBox jApproximateComputationComboBox;
    private JLabel jApproximateComputationLabel;
    private JRadioButton jClustSystemDeterminedButton;
    private JRadioButton jClustUserSpecifiedButton;
    private JTextField jClustUserSpecifiedTextField;
    private JRadioButton jCompSystemDeterminedButton;
    private JRadioButton jCompUserSpecifiedButton;
    private JTextField jCompUserSpecifiedTextField;
    private JLabel jComponentClusterThresholdLabel;
    private JTextField jComponentClusterThresholdTextField;
    private JCheckBox jComponentClusteringCheckBox;
    private JComboBox jConvergenceCriterionComboBox;
    private JLabel jConvergenceCriterionLabel;
    private JButton jDataPreparationAnalysisButton;
    private JLabel jDataPreparationAnalysisLabel;
    private JCheckBox jGatherClusterStatisticsCheckBox;
    private JComboBox jLinkageFunctionComboBox;
    private JLabel jLinkageFunctionLabel;
    private JLabel jLogLikelihoodImprovementLabel;
    private JTextField jLogLikelihoodImprovementTextField;
    private JLabel jMaxNumOfIterationsLabel;
    private JTextField jMaxNumOfIterationsTextField;
    private JLabel jMinPercentOfAttributeRuleSupportLabel;
    private JTextField jMinPercentOfAttributeRuleSupportTextField;
    private JLabel jNumOfClustersLabel;
    private JLabel jNumberOfComponentsLabel;
    private JComboBox jNumericalDistributionComboBox;
    private JLabel jNumericalDistributionLabel;

    public ModelEMBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this.initComponents();
        this.initUI();
    }

    public int getMaxIterationsValue() {
        int n = 20;
        try {
            Version version = ConfigUtils.getDatabaseVersion(this.getParentPanel().getContext());
            if (ConfigUtils.isDatabaseVersion(DBVersions.V11_2_0_4, version, true)) {
                n = Integer.MAX_VALUE;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        return n;
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.cacheSettings.clear();
        ResourceUtils.resLabel((JLabel)this.jNumOfClustersLabel, null, (String)AlgSettingsLrb.get("CLUS_NUM_CLUSTERS"));
        ResourceUtils.resButton((AbstractButton)this.jClustSystemDeterminedButton, (String)AlgSettingsLrb.get("EMCS_SYSTEM_DETERMINED"));
        ResourceUtils.resButton((AbstractButton)this.jClustUserSpecifiedButton, (String)AlgSettingsLrb.get("EMCS_USER_SPECIFIED"));
        ResourceUtils.resButton((AbstractButton)this.jComponentClusteringCheckBox, (String)AlgSettingsLrb.get("EMCS_CLUSTER_COMPONENTS"));
        ResourceUtils.resLabel((JLabel)this.jComponentClusterThresholdLabel, (Component)this.jComponentClusterThresholdTextField, (String)AlgSettingsLrb.get("EMCS_CLUSTER_THRESH"));
        ResourceUtils.resLabel((JLabel)this.jLinkageFunctionLabel, (Component)this.jLinkageFunctionComboBox, (String)AlgSettingsLrb.get("EMCS_LINKAGE_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jApproximateComputationLabel, (Component)this.jApproximateComputationComboBox, (String)AlgSettingsLrb.get("EMCS_APPROXIMATE_COMPUTATION"));
        ResourceUtils.resLabel((JLabel)this.jNumberOfComponentsLabel, null, (String)AlgSettingsLrb.get("EMCS_NUM_COMPONENTS"));
        ResourceUtils.resButton((AbstractButton)this.jCompSystemDeterminedButton, (String)AlgSettingsLrb.get("EMCS_SYSTEM_DETERMINED"));
        ResourceUtils.resButton((AbstractButton)this.jCompUserSpecifiedButton, (String)AlgSettingsLrb.get("EMCS_USER_SPECIFIED"));
        ResourceUtils.resLabel((JLabel)this.jMaxNumOfIterationsLabel, (Component)this.jMaxNumOfIterationsTextField, (String)AlgSettingsLrb.get("EMCS_NUM_ITERATIONS"));
        ResourceUtils.resLabel((JLabel)this.jLogLikelihoodImprovementLabel, (Component)this.jLogLikelihoodImprovementTextField, (String)AlgSettingsLrb.get("EMCS_LOGLIKE_IMPROVEMENT"));
        ResourceUtils.resLabel((JLabel)this.jConvergenceCriterionLabel, (Component)this.jConvergenceCriterionComboBox, (String)AlgSettingsLrb.get("EMCS_CONVERGENCE_CRITERION"));
        ResourceUtils.resLabel((JLabel)this.jNumericalDistributionLabel, (Component)this.jNumericalDistributionComboBox, (String)AlgSettingsLrb.get("EMCS_NUM_DISTRIBUTION"));
        ResourceUtils.resButton((AbstractButton)this.jGatherClusterStatisticsCheckBox, (String)AlgSettingsLrb.get("EMCS_CLUSTER_STATISTICS"));
        ResourceUtils.resLabel((JLabel)this.jMinPercentOfAttributeRuleSupportLabel, (Component)this.jMinPercentOfAttributeRuleSupportTextField, (String)AlgSettingsLrb.get("EMCS_MIN_PCT_ATTR_SUPPORT"));
        ResourceUtils.resLabel((JLabel)this.jDataPreparationAnalysisLabel, (Component)this.jDataPreparationAnalysisButton, (String)AlgSettingsLrb.get("EMCS_DATA_PREP_ANALYSIS"));
        ResourceUtils.resButton((AbstractButton)this.jDataPreparationAnalysisButton, (String)AlgSettingsLrb.get("EMCS_DATA_PREP_ANALYSIS_SETTING"));
        this.jClustUserSpecifiedTextField.setToolTipText(AlgSettingsLrb.get("CLUS_NUM_CLUSTERS_TOOLTIP"));
        this.setDataType(this.jClustUserSpecifiedTextField, Integer.class);
        this.setSigned(this.jClustUserSpecifiedTextField, false);
        this.setLocale(this.jClustUserSpecifiedTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("CLUS_NUM_CLUSTERS");
        commonSettingDataObject.setBackupValue("CLUS_NUM_CLUSTERS", bigDecimal);
        this.jClustSystemDeterminedButton.setEnabled(true);
        this.jClustUserSpecifiedButton.setEnabled(true);
        if (bigDecimal != null) {
            this.jClustUserSpecifiedButton.setSelected(true);
            this.setNumber(this.jClustUserSpecifiedTextField, bigDecimal);
        } else {
            this.jClustSystemDeterminedButton.setSelected(true);
        }
        this.jComponentClusterThresholdTextField.setToolTipText(AlgSettingsLrb.get("EMCS_CLUSTER_THRESH_TOOLTIP"));
        this.setDataType(this.jComponentClusterThresholdTextField, Double.class);
        ((NumberTextField)this.jComponentClusterThresholdTextField).setDecimal(true, 4);
        this.setSigned(this.jComponentClusterThresholdTextField, false);
        this.setLocale(this.jComponentClusterThresholdTextField, commonSettingDataObject.getLocale());
        String string = commonSettingDataObject.getModelSettingStringValue("EMCS_CLUSTER_COMPONENTS");
        commonSettingDataObject.setBackupValue("EMCS_CLUSTER_COMPONENTS", string);
        boolean bl = string.equals("EMCS_CLUSTER_COMP_ENABLE");
        this.jComponentClusteringCheckBox.setSelected(bl);
        if (bl) {
            bigDecimal = commonSettingDataObject.getModelSettingNumValue("EMCS_CLUSTER_THRESH");
            commonSettingDataObject.setBackupValue("EMCS_CLUSTER_THRESH", bigDecimal);
            if (bigDecimal != null) {
                ((NumberTextField)this.jComponentClusterThresholdTextField).setNumber((Number)bigDecimal);
            } else {
                ((NumberTextField)this.jComponentClusterThresholdTextField).setNumber((Number)2.0);
            }
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{ServerConstants.ClusteringSetings.toHuman("EMCS_LINKAGE_SINGLE"), ServerConstants.ClusteringSetings.toHuman("EMCS_LINKAGE_AVERAGE"), ServerConstants.ClusteringSetings.toHuman("EMCS_LINKAGE_COMPLETE")});
        this.jLinkageFunctionComboBox.setModel(defaultComboBoxModel);
        string = commonSettingDataObject.getModelSettingStringValue("EMCS_LINKAGE_FUNCTION");
        commonSettingDataObject.setBackupValue("EMCS_LINKAGE_FUNCTION", string);
        if (string.isEmpty()) {
            string = "EMCS_LINKAGE_SINGLE";
        }
        this.jLinkageFunctionComboBox.setSelectedItem(ServerConstants.ClusteringSetings.toHuman(string));
        this.jLinkageFunctionLabel.setLabelFor(this.jLinkageFunctionComboBox);
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(new String[]{SYSTEM_DETERMINED, ServerConstants.ClusteringSetings.toHuman("ODMS_APPR_COMP_ENABLE"), ServerConstants.ClusteringSetings.toHuman("ODMS_APPR_COMP_DISABLE")});
        this.jApproximateComputationComboBox.setModel(defaultComboBoxModel2);
        string = commonSettingDataObject.getModelSettingStringValue("ODMS_APPROXIMATE_COMPUTATION");
        commonSettingDataObject.setBackupValue("ODMS_APPROXIMATE_COMPUTATION", string);
        if (string.isEmpty()) {
            this.jApproximateComputationComboBox.setSelectedItem(SYSTEM_DETERMINED);
        } else {
            this.jApproximateComputationComboBox.setSelectedItem(ServerConstants.ClusteringSetings.toHuman(string));
        }
        this.jApproximateComputationLabel.setLabelFor(this.jApproximateComputationComboBox);
        this.jCompUserSpecifiedTextField.setToolTipText(AlgSettingsLrb.get("EMCS_NUM_COMPONENTS_TOOLTIP"));
        this.setDataType(this.jCompUserSpecifiedTextField, Integer.class);
        this.setSigned(this.jCompUserSpecifiedTextField, false);
        this.setLocale(this.jCompUserSpecifiedTextField, commonSettingDataObject.getLocale());
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_COMPONENTS");
        commonSettingDataObject.setBackupValue("EMCS_NUM_COMPONENTS", bigDecimal);
        this.jCompSystemDeterminedButton.setEnabled(true);
        this.jCompUserSpecifiedButton.setEnabled(true);
        if (bigDecimal != null) {
            this.jCompUserSpecifiedButton.setSelected(true);
            this.setNumber(this.jCompUserSpecifiedTextField, bigDecimal);
        } else {
            this.jCompSystemDeterminedButton.setSelected(true);
        }
        int n = this.getMaxIterationsValue();
        String string2 = AlgSettingsLrb.get("EMCS_NUM_ITERATIONS_TOOLTIP");
        string2 = MessageFormat.format(string2, n);
        this.jMaxNumOfIterationsTextField.setToolTipText(string2);
        this.setDataType(this.jMaxNumOfIterationsTextField, Integer.class);
        this.setSigned(this.jMaxNumOfIterationsTextField, false);
        this.setLocale(this.jMaxNumOfIterationsTextField, commonSettingDataObject.getLocale());
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_ITERATIONS");
        commonSettingDataObject.setBackupValue("EMCS_NUM_ITERATIONS", bigDecimal);
        ((NumberTextField)this.jMaxNumOfIterationsTextField).setNumber((Number)bigDecimal);
        this.jLogLikelihoodImprovementTextField.setToolTipText(AlgSettingsLrb.get("EMCS_LOGLIKE_IMPROVEMENT_TOOLTIP"));
        this.setDataType(this.jLogLikelihoodImprovementTextField, Double.class);
        ((NumberTextField)this.jLogLikelihoodImprovementTextField).setDecimal(true, 4);
        this.setSigned(this.jLogLikelihoodImprovementTextField, false);
        this.setLocale(this.jLogLikelihoodImprovementTextField, commonSettingDataObject.getLocale());
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("EMCS_LOGLIKE_IMPROVEMENT");
        commonSettingDataObject.setBackupValue("EMCS_LOGLIKE_IMPROVEMENT", bigDecimal);
        ((NumberTextField)this.jLogLikelihoodImprovementTextField).setNumber((Number)bigDecimal);
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>(new String[]{SYSTEM_DETERMINED, ServerConstants.ClusteringSetings.toHuman("EMCS_CONV_CRIT_BIC"), ServerConstants.ClusteringSetings.toHuman("EMCS_CONV_CRIT_HELDASIDE")});
        this.jConvergenceCriterionComboBox.setModel(defaultComboBoxModel3);
        string = commonSettingDataObject.getModelSettingStringValue("EMCS_CONVERGENCE_CRITERION");
        commonSettingDataObject.setBackupValue("EMCS_CONVERGENCE_CRITERION", string);
        if (string.isEmpty()) {
            this.jConvergenceCriterionComboBox.setSelectedItem(SYSTEM_DETERMINED);
        } else {
            this.jConvergenceCriterionComboBox.setSelectedItem(ServerConstants.ClusteringSetings.toHuman(string));
        }
        this.jConvergenceCriterionLabel.setLabelFor(this.jConvergenceCriterionComboBox);
        DefaultComboBoxModel<String> defaultComboBoxModel4 = new DefaultComboBoxModel<String>(new String[]{SYSTEM_DETERMINED, ServerConstants.ClusteringSetings.toHuman("EMCS_NUM_DISTR_BERNOULLI"), ServerConstants.ClusteringSetings.toHuman("EMCS_NUM_DISTR_GAUSSIAN")});
        this.jNumericalDistributionComboBox.setModel(defaultComboBoxModel4);
        string = commonSettingDataObject.getModelSettingStringValue("EMCS_NUM_DISTRIBUTION");
        commonSettingDataObject.setBackupValue("EMCS_NUM_DISTRIBUTION", string);
        if (string.equals("EMCS_NUM_DISTR_SYSTEM")) {
            this.jNumericalDistributionComboBox.setSelectedItem(SYSTEM_DETERMINED);
        } else {
            this.jNumericalDistributionComboBox.setSelectedItem(ServerConstants.ClusteringSetings.toHuman(string));
        }
        this.jNumericalDistributionLabel.setLabelFor(this.jNumericalDistributionComboBox);
        this.jMinPercentOfAttributeRuleSupportTextField.setToolTipText(AlgSettingsLrb.get("EMCS_MIN_PCT_ATTR_SUPPORT_TOOLTIP"));
        this.setDataType(this.jMinPercentOfAttributeRuleSupportTextField, Double.class);
        ((NumberTextField)this.jMinPercentOfAttributeRuleSupportTextField).setDecimal(true, 4);
        this.setSigned(this.jMinPercentOfAttributeRuleSupportTextField, false);
        this.setLocale(this.jMinPercentOfAttributeRuleSupportTextField, commonSettingDataObject.getLocale());
        string = commonSettingDataObject.getModelSettingStringValue("EMCS_CLUSTER_STATISTICS");
        commonSettingDataObject.setBackupValue("EMCS_CLUSTER_STATISTICS", string);
        bl = string.equals("EMCS_CLUS_STATS_ENABLE");
        this.jGatherClusterStatisticsCheckBox.setSelected(bl);
        if (bl) {
            bigDecimal = commonSettingDataObject.getModelSettingNumValue("EMCS_MIN_PCT_ATTR_SUPPORT");
            commonSettingDataObject.setBackupValue("EMCS_MIN_PCT_ATTR_SUPPORT", bigDecimal);
            if (bigDecimal != null) {
                ((NumberTextField)this.jMinPercentOfAttributeRuleSupportTextField).setNumber((Number)bigDecimal);
            } else {
                ((NumberTextField)this.jMinPercentOfAttributeRuleSupportTextField).setNumber((Number)0.1);
            }
        }
        this.jDataPreparationAnalysisButton.setEnabled(true);
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("EMCS_MAX_NUM_ATTR_2D");
        this.cacheSettings.put("EMCS_MAX_NUM_ATTR_2D", bigDecimal);
        commonSettingDataObject.setBackupValue("EMCS_MAX_NUM_ATTR_2D", bigDecimal);
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_PROJECTIONS");
        this.cacheSettings.put("EMCS_NUM_PROJECTIONS", bigDecimal);
        commonSettingDataObject.setBackupValue("EMCS_NUM_PROJECTIONS", bigDecimal);
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_QUANTILE_BINS");
        this.cacheSettings.put("EMCS_NUM_QUANTILE_BINS", bigDecimal);
        commonSettingDataObject.setBackupValue("EMCS_NUM_QUANTILE_BINS", bigDecimal);
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_TOPN_BINS");
        this.cacheSettings.put("EMCS_NUM_TOPN_BINS", bigDecimal);
        commonSettingDataObject.setBackupValue("EMCS_NUM_TOPN_BINS", bigDecimal);
        bigDecimal = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_EQUIWIDTH_BINS");
        this.cacheSettings.put("EMCS_NUM_EQUIWIDTH_BINS", bigDecimal);
        commonSettingDataObject.setBackupValue("EMCS_NUM_EQUIWIDTH_BINS", bigDecimal);
        string = commonSettingDataObject.getModelSettingStringValue("EMCS_ATTRIBUTE_FILTER");
        this.cacheSettings.put("EMCS_ATTRIBUTE_FILTER", string);
        commonSettingDataObject.setBackupValue("EMCS_ATTRIBUTE_FILTER", string);
        this.enableControls();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jNumOfClustersLabel = new JLabel();
        this.jClustSystemDeterminedButton = new JRadioButton();
        this.jClustUserSpecifiedButton = new JRadioButton();
        this.jClustUserSpecifiedTextField = new NumberTextField();
        this.jComponentClusteringCheckBox = new JCheckBox();
        this.jComponentClusterThresholdLabel = new JLabel();
        this.jComponentClusterThresholdTextField = new NumberTextField();
        this.jLinkageFunctionLabel = new JLabel();
        this.jLinkageFunctionComboBox = new JComboBox();
        this.jApproximateComputationLabel = new JLabel();
        this.jApproximateComputationComboBox = new JComboBox();
        this.jNumberOfComponentsLabel = new JLabel();
        this.jCompSystemDeterminedButton = new JRadioButton();
        this.jCompUserSpecifiedButton = new JRadioButton();
        this.jCompUserSpecifiedTextField = new NumberTextField();
        this.jMaxNumOfIterationsLabel = new JLabel();
        this.jMaxNumOfIterationsTextField = new NumberTextField();
        this.jLogLikelihoodImprovementLabel = new JLabel();
        this.jLogLikelihoodImprovementTextField = new NumberTextField();
        this.jConvergenceCriterionLabel = new JLabel();
        this.jConvergenceCriterionComboBox = new JComboBox();
        this.jNumericalDistributionLabel = new JLabel();
        this.jNumericalDistributionComboBox = new JComboBox();
        this.jGatherClusterStatisticsCheckBox = new JCheckBox();
        this.jMinPercentOfAttributeRuleSupportLabel = new JLabel();
        this.jMinPercentOfAttributeRuleSupportTextField = new NumberTextField();
        this.jDataPreparationAnalysisLabel = new JLabel();
        this.jDataPreparationAnalysisButton = new JButton();
        this.jNumOfClustersLabel.setText("Number of Clusters");
        this.buttonGroup1.add(this.jClustSystemDeterminedButton);
        this.jClustSystemDeterminedButton.setText("System determined");
        this.jClustSystemDeterminedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jClustSystemDeterminedButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jClustUserSpecifiedButton);
        this.jClustUserSpecifiedButton.setText("User specified:");
        this.jClustUserSpecifiedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jClustUserSpecifiedButtonActionPerformed(actionEvent);
            }
        });
        this.jComponentClusteringCheckBox.setText("Component Clustering");
        this.jComponentClusteringCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jComponentClusteringCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jComponentClusteringCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jComponentClusterThresholdLabel.setText("Component Cluster Threshold:");
        this.jLinkageFunctionLabel.setText("Linkage Function:");
        this.jLinkageFunctionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Single"}));
        this.jApproximateComputationLabel.setText("Approximate Computation:");
        this.jApproximateComputationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<System Determined>"}));
        this.jNumberOfComponentsLabel.setText("Number of Components");
        this.buttonGroup2.add(this.jCompSystemDeterminedButton);
        this.jCompSystemDeterminedButton.setText("System determined");
        this.jCompSystemDeterminedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jCompSystemDeterminedButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup2.add(this.jCompUserSpecifiedButton);
        this.jCompUserSpecifiedButton.setText("User specified:");
        this.jCompUserSpecifiedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jCompUserSpecifiedButtonActionPerformed(actionEvent);
            }
        });
        this.jMaxNumOfIterationsLabel.setText("Max Number of Iterations:");
        this.jLogLikelihoodImprovementLabel.setText("Log Likelihood Improvement:");
        this.jConvergenceCriterionLabel.setText("Convergence Criterion:");
        this.jConvergenceCriterionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<System Determined>"}));
        this.jNumericalDistributionLabel.setText("Numerical Distribution:");
        this.jNumericalDistributionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<System Determined>"}));
        this.jGatherClusterStatisticsCheckBox.setText("Gather Cluster Statistics (Require for Model Viewer)");
        this.jGatherClusterStatisticsCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jGatherClusterStatisticsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jGatherClusterStatisticsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jMinPercentOfAttributeRuleSupportLabel.setText("Min Percent of Attribute Rule Support:");
        this.jDataPreparationAnalysisLabel.setText("Data Preparation and Analysis:");
        this.jDataPreparationAnalysisButton.setText("Settings...");
        this.jDataPreparationAnalysisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jDataPreparationAnalysisButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jMinPercentOfAttributeRuleSupportLabel)).addComponent(this.jConvergenceCriterionLabel).addComponent(this.jNumericalDistributionLabel))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLogLikelihoodImprovementLabel)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jMaxNumOfIterationsLabel)).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCompUserSpecifiedButton).addComponent(this.jCompSystemDeterminedButton))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jApproximateComputationLabel)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLinkageFunctionLabel)).addGroup(groupLayout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jComponentClusterThresholdLabel)).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jClustUserSpecifiedButton).addComponent(this.jClustSystemDeterminedButton))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jDataPreparationAnalysisLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComponentClusterThresholdTextField).addComponent(this.jCompUserSpecifiedTextField).addComponent(this.jMaxNumOfIterationsTextField).addComponent(this.jLogLikelihoodImprovementTextField).addComponent(this.jMinPercentOfAttributeRuleSupportTextField).addComponent(this.jClustUserSpecifiedTextField, -2, -1, -2).addComponent(this.jConvergenceCriterionComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jNumericalDistributionComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jLinkageFunctionComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jApproximateComputationComboBox, -2, -1, -2).addComponent(this.jDataPreparationAnalysisButton))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jGatherClusterStatisticsCheckBox).addComponent(this.jNumberOfComponentsLabel).addComponent(this.jNumOfClustersLabel).addComponent(this.jComponentClusteringCheckBox)))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jApproximateComputationComboBox, this.jClustUserSpecifiedTextField, this.jCompUserSpecifiedTextField, this.jComponentClusterThresholdTextField, this.jConvergenceCriterionComboBox, this.jLinkageFunctionComboBox, this.jLogLikelihoodImprovementTextField, this.jMaxNumOfIterationsTextField, this.jMinPercentOfAttributeRuleSupportTextField, this.jNumericalDistributionComboBox);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jNumOfClustersLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jClustSystemDeterminedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jClustUserSpecifiedButton).addComponent(this.jClustUserSpecifiedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComponentClusteringCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComponentClusterThresholdLabel).addComponent(this.jComponentClusterThresholdTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLinkageFunctionLabel).addComponent(this.jLinkageFunctionComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jApproximateComputationLabel).addComponent(this.jApproximateComputationComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNumberOfComponentsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCompSystemDeterminedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCompUserSpecifiedButton).addComponent(this.jCompUserSpecifiedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumOfIterationsLabel).addComponent(this.jMaxNumOfIterationsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLogLikelihoodImprovementLabel).addComponent(this.jLogLikelihoodImprovementTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jConvergenceCriterionLabel).addComponent(this.jConvergenceCriterionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNumericalDistributionLabel).addComponent(this.jNumericalDistributionComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jGatherClusterStatisticsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMinPercentOfAttributeRuleSupportLabel).addComponent(this.jMinPercentOfAttributeRuleSupportTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDataPreparationAnalysisLabel).addComponent(this.jDataPreparationAnalysisButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jClustSystemDeterminedButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jCompSystemDeterminedButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jComponentClusteringCheckBoxActionPerformed(ActionEvent actionEvent) {
        Number number;
        boolean bl = this.jComponentClusteringCheckBox.isSelected();
        if (bl && (number = this.getNumber(this.jComponentClusterThresholdTextField)) == null) {
            this.setNumber(this.jComponentClusterThresholdTextField, 2.0);
        }
        this.enableControls();
    }

    private void jClustUserSpecifiedButtonActionPerformed(ActionEvent actionEvent) {
        Number number;
        boolean bl = this.jClustUserSpecifiedButton.isSelected();
        this.jClustUserSpecifiedTextField.setEnabled(bl);
        if (bl && (number = this.getNumber(this.jClustUserSpecifiedTextField)) == null) {
            this.setNumber(this.jClustUserSpecifiedTextField, 10);
        }
        this.enableControls();
    }

    private void jCompUserSpecifiedButtonActionPerformed(ActionEvent actionEvent) {
        Number number;
        boolean bl = this.jCompUserSpecifiedButton.isSelected();
        this.jCompUserSpecifiedTextField.setEnabled(bl);
        if (bl && (number = this.getNumber(this.jCompUserSpecifiedTextField)) == null) {
            this.setNumber(this.jCompUserSpecifiedTextField, 20);
        }
        this.enableControls();
    }

    private void jGatherClusterStatisticsCheckBoxActionPerformed(ActionEvent actionEvent) {
        Number number;
        boolean bl = this.jGatherClusterStatisticsCheckBox.isSelected();
        if (bl && (number = this.getNumber(this.jMinPercentOfAttributeRuleSupportTextField)) == null) {
            this.setNumber(this.jMinPercentOfAttributeRuleSupportTextField, 0.1);
        }
        this.enableControls();
    }

    private void jDataPreparationAnalysisButtonActionPerformed(ActionEvent actionEvent) {
        ModelEMBuildDataPrepAnalysisPanel modelEMBuildDataPrepAnalysisPanel = new ModelEMBuildDataPrepAnalysisPanel(this);
        modelEMBuildDataPrepAnalysisPanel.showAsDialog(this);
    }

    private void enableControls() {
        this.jClustUserSpecifiedTextField.setEnabled(this.jClustUserSpecifiedButton.isSelected());
        this.jComponentClusterThresholdTextField.setEnabled(this.jComponentClusteringCheckBox.isSelected());
        this.jCompUserSpecifiedTextField.setEnabled(this.jCompUserSpecifiedButton.isSelected());
        this.jMinPercentOfAttributeRuleSupportTextField.setEnabled(this.jGatherClusterStatisticsCheckBox.isSelected());
    }

    @Override
    public void processInput() {
        Number number;
        Object object;
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        commonSettingDataObject.setCommonPerformanceOption();
        Number number2 = null;
        if (this.jClustSystemDeterminedButton.isSelected()) {
            this.setObjectValue("CLUS_NUM_CLUSTERS", null);
        } else {
            number2 = this.getNumber(this.jClustUserSpecifiedTextField);
            if (null == number2 || number2.intValue() < 1) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("CLUS_NUM_CLUSTERS_INVALID"));
                return;
            }
            this.setObjectValue("CLUS_NUM_CLUSTERS", number2);
        }
        boolean bl = false;
        if (this.jComponentClusteringCheckBox.isSelected()) {
            object = this.getNumber(this.jComponentClusterThresholdTextField);
            if (null == object || ((Number)object).doubleValue() < 1.0) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_CLUSTER_THRESH_INVALID"));
                return;
            }
            this.setObjectValue("EMCS_CLUSTER_COMPONENTS", "EMCS_CLUSTER_COMP_ENABLE");
            this.setObjectValue("EMCS_CLUSTER_THRESH", object);
            bl = true;
        } else {
            this.setObjectValue("EMCS_CLUSTER_COMPONENTS", "EMCS_CLUSTER_COMP_DISABLE");
            this.setObjectValue("EMCS_CLUSTER_THRESH", null);
        }
        object = (String)this.jLinkageFunctionComboBox.getSelectedItem();
        this.setObjectValue("EMCS_LINKAGE_FUNCTION", ServerConstants.ClusteringSetings.toAlgorithm((String)object));
        object = (String)this.jApproximateComputationComboBox.getSelectedItem();
        object = ((String)object).equals(ServerConstants.ClusteringSetings.ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_ENABLE.value()) ? "ODMS_APPR_COMP_ENABLE" : (((String)object).equals(ServerConstants.ClusteringSetings.ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_DISABLE.value()) ? "ODMS_APPR_COMP_DISABLE" : null);
        this.setObjectValue("ODMS_APPROXIMATE_COMPUTATION", object);
        Number number3 = null;
        if (this.jCompSystemDeterminedButton.isSelected()) {
            this.setObjectValue("EMCS_NUM_COMPONENTS", null);
        } else {
            number3 = this.getNumber(this.jCompUserSpecifiedTextField);
            if (null == number3 || number3.intValue() < 1) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_NUM_COMPONENTS_INVALID"));
                return;
            }
            this.setObjectValue("EMCS_NUM_COMPONENTS", number3);
        }
        if (number2 != null && number3 != null) {
            if (bl) {
                if (number2.intValue() > number3.intValue()) {
                    this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_COMPONENTS_GREATER_CLUSTERS_INVALID"));
                    return;
                }
            } else if (number2.intValue() != number3.intValue()) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_COMPONENTS_EQUAL_CLUSTERS_INVALID"));
                return;
            }
        }
        if (null == (number = this.getNumber(this.jMaxNumOfIterationsTextField)) || number.intValue() < 1 || number.intValue() > Integer.MAX_VALUE) {
            String string = AlgSettingsLrb.get("EMCS_NUM_ITERATIONS_INVALID");
            string = MessageFormat.format(string, Integer.MAX_VALUE);
            this.setValidationErrorObjectValue(string);
            return;
        }
        this.setObjectValue("EMCS_NUM_ITERATIONS", number);
        number = this.getNumber(this.jLogLikelihoodImprovementTextField);
        if (null == number || !(number.doubleValue() > 0.0) || !(number.doubleValue() < 1.0)) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_LOGLIKE_IMPROVEMENT_INVALID"));
            return;
        }
        this.setObjectValue("EMCS_LOGLIKE_IMPROVEMENT", number);
        object = (String)this.jConvergenceCriterionComboBox.getSelectedItem();
        this.setObjectValue("EMCS_CONVERGENCE_CRITERION", SYSTEM_DETERMINED.equals(object) ? null : ServerConstants.ClusteringSetings.toAlgorithm((String)object));
        object = (String)this.jNumericalDistributionComboBox.getSelectedItem();
        this.setObjectValue("EMCS_NUM_DISTRIBUTION", SYSTEM_DETERMINED.equals(object) ? "EMCS_NUM_DISTR_SYSTEM" : ServerConstants.ClusteringSetings.toAlgorithm((String)object));
        if (this.jGatherClusterStatisticsCheckBox.isSelected()) {
            number = this.getNumber(this.jMinPercentOfAttributeRuleSupportTextField);
            if (null == number || !(number.doubleValue() > 0.0) || !(number.doubleValue() < 1.0)) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_MIN_PCT_ATTR_SUPPORT_INVALID"));
                return;
            }
            this.setObjectValue("EMCS_CLUSTER_STATISTICS", "EMCS_CLUS_STATS_ENABLE");
            this.setObjectValue("EMCS_MIN_PCT_ATTR_SUPPORT", number);
        } else {
            this.setObjectValue("EMCS_CLUSTER_STATISTICS", "EMCS_CLUS_STATS_DISABLE");
            this.setObjectValue("EMCS_MIN_PCT_ATTR_SUPPORT", null);
        }
        this.setObjectValue("EMCS_MAX_NUM_ATTR_2D", this.cacheSettings.get("EMCS_MAX_NUM_ATTR_2D"));
        this.setObjectValue("EMCS_NUM_PROJECTIONS", this.cacheSettings.get("EMCS_NUM_PROJECTIONS"));
        this.setObjectValue("EMCS_NUM_QUANTILE_BINS", this.cacheSettings.get("EMCS_NUM_QUANTILE_BINS"));
        this.setObjectValue("EMCS_NUM_TOPN_BINS", this.cacheSettings.get("EMCS_NUM_TOPN_BINS"));
        this.setObjectValue("EMCS_NUM_EQUIWIDTH_BINS", this.cacheSettings.get("EMCS_NUM_EQUIWIDTH_BINS"));
        this.setObjectValue("EMCS_ATTRIBUTE_FILTER", this.cacheSettings.get("EMCS_ATTRIBUTE_FILTER"));
    }

    public HashMap<String, Object> getCacheSettings() {
        return this.cacheSettings;
    }
}

