/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;

public class ModelARBuildSettingsPanel
extends AbstractPropertiesPanel {
    private JLabel jMaxRuleLengthLabel;
    private JTextField jMaxRuleLengthTextField;
    private JLabel jMinConfidenceLabel;
    private JTextField jMinConfidenceTextField;
    private JLabel jMinSupportLabel;
    private JTextField jMinSupportTextField;
    private JScrollPane jScrollPaneTitle;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public ModelARBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollPaneTitle = new JScrollPane();
        this.jMaxRuleLengthLabel = new JLabel();
        this.jMaxRuleLengthTextField = new NumberTextField();
        this.jMinConfidenceLabel = new JLabel();
        this.jMinConfidenceTextField = new NumberTextField();
        this.jMinSupportLabel = new JLabel();
        this.jMinSupportTextField = new NumberTextField();
        this.jScrollPaneTitle.setBorder(null);
        this.jScrollPaneTitle.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneTitle.setVerticalScrollBarPolicy(21);
        this.jScrollPaneTitle.setName("jScrollPaneTitle");
        this.jMaxRuleLengthLabel.setLabelFor(this.jMaxRuleLengthTextField);
        this.jMaxRuleLengthLabel.setText("Maximum rule length:");
        this.jMaxRuleLengthLabel.setName("jMaxRuleLengthLabel");
        this.jMaxRuleLengthTextField.setName("jMaxRuleLengthTextField");
        this.jMinConfidenceLabel.setLabelFor(this.jMinConfidenceTextField);
        this.jMinConfidenceLabel.setText("Minimum confidence:");
        this.jMinConfidenceLabel.setName("jMinConfidenceLabel");
        this.jMinConfidenceTextField.setName("jMinConfidenceTextField");
        this.jMinSupportLabel.setLabelFor(this.jMinSupportTextField);
        this.jMinSupportLabel.setText("Minimum support:");
        this.jMinSupportLabel.setName("jMinSupportLabel");
        this.jMinSupportTextField.setName("jMinSupportTextField");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMaxRuleLengthLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jMinConfidenceLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jMinSupportLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMaxRuleLengthTextField, -1, 105, Short.MAX_VALUE).addComponent(this.jMinConfidenceTextField).addComponent(this.jMinSupportTextField)).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPaneTitle, -1, 437, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxRuleLengthLabel).addComponent(this.jMaxRuleLengthTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMinConfidenceLabel).addComponent(this.jMinConfidenceTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMinSupportLabel).addComponent(this.jMinSupportTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this._jDescription, this.jScrollPaneTitle);
        ResourceUtils.resLabel((JLabel)this.jMaxRuleLengthLabel, (Component)this.jMaxRuleLengthTextField, (String)AlgSettingsLrb.get("ASSO_MAX_RULE_LENGTH"));
        ResourceUtils.resLabel((JLabel)this.jMinConfidenceLabel, (Component)this.jMinConfidenceTextField, (String)AlgSettingsLrb.get("ASSO_MIN_CONFIDENCE"));
        ResourceUtils.resLabel((JLabel)this.jMinSupportLabel, (Component)this.jMinSupportTextField, (String)AlgSettingsLrb.get("ASSO_MIN_SUPPORT"));
        this.jMaxRuleLengthTextField.setToolTipText(AlgSettingsLrb.get("ASSO_MAX_RULE_LENGTH_TOOLTIP"));
        this.setDataType(this.jMaxRuleLengthTextField, Integer.class);
        this.setSigned(this.jMaxRuleLengthTextField, false);
        this.setLocale(this.jMaxRuleLengthTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("ASSO_MAX_RULE_LENGTH");
        commonSettingDataObject.setBackupValue("ASSO_MAX_RULE_LENGTH", bigDecimal);
        this.setNumber(this.jMaxRuleLengthTextField, bigDecimal);
        this.jMinConfidenceTextField.setToolTipText(AlgSettingsLrb.get("ASSO_MIN_CONFIDENCE_TOOLTIP"));
        this.setDataType(this.jMinConfidenceTextField, Double.class);
        ((NumberTextField)this.jMinConfidenceTextField).setDecimal(true, 4);
        this.setSigned(this.jMinConfidenceTextField, false);
        this.setLocale(this.jMinConfidenceTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal2 = commonSettingDataObject.getModelSettingNumValue("ASSO_MIN_CONFIDENCE");
        commonSettingDataObject.setBackupValue("ASSO_MIN_CONFIDENCE", bigDecimal2);
        this.setNumber(this.jMinConfidenceTextField, bigDecimal2);
        this.jMinSupportTextField.setToolTipText(AlgSettingsLrb.get("ASSO_MIN_SUPPORT_TOOLTIP"));
        this.setDataType(this.jMinSupportTextField, Double.class);
        ((NumberTextField)this.jMinSupportTextField).setDecimal(true, 4);
        this.setSigned(this.jMinSupportTextField, false);
        this.setLocale(this.jMinSupportTextField, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal3 = commonSettingDataObject.getModelSettingNumValue("ASSO_MIN_SUPPORT");
        commonSettingDataObject.setBackupValue("ASSO_MIN_SUPPORT", bigDecimal3);
        this.setNumber(this.jMinSupportTextField, bigDecimal3);
    }

    @Override
    public void processInput() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        Number number = this.getNumber(this.jMaxRuleLengthTextField);
        if (null == number) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MAX_RULE_LENGTH_INVALID"));
            return;
        }
        if (number.intValue() < 2 || number.intValue() > 20) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MAX_RULE_LENGTH_INVALID"));
            return;
        }
        this.setObjectValue("ASSO_MAX_RULE_LENGTH", number);
        number = this.getNumber(this.jMinConfidenceTextField);
        if (null == number) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_CONFIDENCE_INVALID"));
            return;
        }
        double d = number.doubleValue() / 100.0;
        if (d < 0.0 || d > 1.0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_CONFIDENCE_INVALID"));
            return;
        }
        this.setObjectValue("ASSO_MIN_CONFIDENCE", number);
        number = this.getNumber(this.jMinSupportTextField);
        d = number.doubleValue() / 100.0;
        if (null == number) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_SUPPORT_INVALID"));
            return;
        }
        if (d < 0.0 || d > 1.0) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("ASSO_MIN_SUPPORT_INVALID"));
            return;
        }
        this.setObjectValue("ASSO_MIN_SUPPORT", number);
    }
}

