/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistWizard;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.combo.CheckComboModel;
import oracle.javatools.ui.combo.JCheckCombo;

public class TextTransColumnSettingTokenPanel
extends JPanel {
    private BuildNodeType _buildNodeType = null;
    private String _sourceAttributeName = null;
    private BuildNodeType.Stoplists _stoplists = null;
    private AbstractBuildNode _node;
    private Context _context;
    private TransformationTokenType _textTransformation;
    private boolean _isAdjusting = false;
    private boolean _isAllSelected = false;
    private boolean _isNoneSelected = false;
    private static Icon _editIcon;
    private boolean _dirty;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JButton jEditStoplistButton;
    private JLabel jLanguageLabel;
    private JLabel jMaxNumAllDocsLabel;
    private JSpinner jMaxNumAllDocsSpinner;
    private JButton jNewStoplistButton;
    private JComboBox jSelectedStoplistComboBox;
    private JCheckCombo jSingleBtyeComboBox;
    private JCheckBox jStemmingCheckBox;
    private JLabel jStoplistLabel;
    private JLabel jTokensLabel;

    public TextTransColumnSettingTokenPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, String string, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) {
        this._context = context;
        this._node = abstractBuildNode;
        this._buildNodeType = buildNodeType;
        this._stoplists = stoplists;
        this._sourceAttributeName = string;
        this._textTransformation = transformationTokenType;
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initUI() {
        this.jEditStoplistButton.setText(null);
        this.jEditStoplistButton.setIcon(_editIcon);
        this.jEditStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_EDIT_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setText(null);
        this.jNewStoplistButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.jNewStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_ADD_STOPLIST_TOOLTIP"));
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("All"));
        defaultListModel.addElement(ServerConstants.StoplistLanguage.toHuman("None"));
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG bASIC_LEXER_LANG : ServerConstants.StoplistLanguage.BASIC_LEXER_LANG.values()) {
            defaultListModel.addElement(bASIC_LEXER_LANG.value());
        }
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.addSelectionInterval(1, 1);
        CheckComboModel checkComboModel = new CheckComboModel(defaultListModel, (ListSelectionModel)defaultListSelectionModel);
        this.jSingleBtyeComboBox.setModel(checkComboModel);
        ListSelectionModel listSelectionModel = this.jSingleBtyeComboBox.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TextTransColumnSettingTokenPanel.this.jSingleByteLanguageValueChanged(listSelectionEvent);
                }
            }
        });
        this.refreshUI(this._textTransformation);
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLanguageLabel, (Component)this.jSingleBtyeComboBox, (String)DialogsLrb.get("BUILD_TEXT_LANGUAGES"));
        ResourceUtils.resLabel((JLabel)this.jStoplistLabel, (Component)this.jSelectedStoplistComboBox, (String)DialogsLrb.get("BUILD_TEXT_STOPLIST"));
        ResourceUtils.resLabel((JLabel)this.jTokensLabel, null, (String)DialogsLrb.get("BUILD_TEXT_TOKENS"));
        ResourceUtils.resSpinner((JLabel)this.jMaxNumAllDocsLabel, (JSpinner)this.jMaxNumAllDocsSpinner, (String)DialogsLrb.get("BUILD_TEXT_MAX_NUM_ALL_DOCS"));
        _editIcon = InspectorArb.getIcon((int)24);
    }

    private void initStoplists(String string) {
        List list = null;
        list = this._stoplists.getStoplist();
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StoplistType stoplistType : list) {
            arrayList.add(stoplistType.getName());
            if (string == null || !stoplistType.getId().equals(string)) continue;
            string2 = stoplistType.getName();
        }
        Collections.sort(arrayList);
        arrayList.add(0, ServerConstants.StoplistLanguage.toHuman("None"));
        this.jSelectedStoplistComboBox.removeAllItems();
        this.jSelectedStoplistComboBox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        if (string2 != null) {
            this.jSelectedStoplistComboBox.setSelectedItem(string2);
        }
    }

    public void refreshUI(TransformationTokenType transformationTokenType) {
        this.initStoplists(this._textTransformation.getToken().getStoplistId());
        this._textTransformation = transformationTokenType;
        List list = null;
        list = this._textTransformation.getToken().getLanguages().getLanguage();
        this._isAdjusting = true;
        ListSelectionModel listSelectionModel = this.jSingleBtyeComboBox.getSelectionModel();
        listSelectionModel.clearSelection();
        CheckComboModel checkComboModel = this.jSingleBtyeComboBox.getCheckModel();
        boolean bl = false;
        for (Object object : list) {
            for (int i = 0; i < checkComboModel.getSize(); ++i) {
                String string = (String)checkComboModel.getElementAt(i);
                if (!string.equals(ServerConstants.StoplistLanguage.toHuman(object.getName()))) continue;
                listSelectionModel.addSelectionInterval(i, i);
                bl = true;
            }
        }
        if (!bl) {
            listSelectionModel.addSelectionInterval(1, 1);
        }
        this._isAdjusting = false;
        boolean bl2 = false;
        for (LexerType.Settings.Attribute attribute : transformationTokenType.getToken().getLexer().getSettings().getAttribute()) {
            if (!attribute.getName().equals("index_stems")) continue;
            bl2 = true;
            break;
        }
        this.jStemmingCheckBox.setSelected(bl2);
        int n = transformationTokenType.getToken().getMaxNumberAllDocs().intValue();
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(n, 1, 100000, 1000));
        this.enableControls();
    }

    public boolean copySettings(BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) throws ValidationException {
        Object object;
        Object[] objectArray;
        StoplistType stoplistType = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
        TransformationTokenType.Token.Languages.Language language = null;
        CheckComboModel checkComboModel = this.jSingleBtyeComboBox.getCheckModel();
        for (Object object2 : objectArray = checkComboModel.getSelectedItem()) {
            object = (String)object2;
            if (ServerConstants.StoplistLanguage.isALL(ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isNone(ServerConstants.StoplistLanguage.toSchema((String)object))) continue;
            language = new TransformationTokenType.Token.Languages.Language();
            language.setName(ServerConstants.StoplistLanguage.toSchema((String)object));
            if (ServerConstants.StoplistLanguage.isTraditionalChinese(ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isSimplifiedChinese(ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isJapanese(ServerConstants.StoplistLanguage.toSchema((String)object)) || ServerConstants.StoplistLanguage.isKorean(ServerConstants.StoplistLanguage.toSchema((String)object))) {
                language.setType("MultiByte");
            } else {
                language.setType("SingleByte");
            }
            languages.getLanguage().add(language);
            arrayList.add(ServerConstants.StoplistLanguage.toSchema((String)object));
        }
        if (arrayList.size() == 0) {
            throw new ValidationException(DialogsLrb.get("BUILD_TEXT_NO_LANGUAGE_ERROR"));
        }
        transformationTokenType.getToken().setLanguages(languages);
        if (languages.getLanguage().size() <= 1) {
            transformationTokenType.getToken().getLexer().setType("Basic");
        } else {
            transformationTokenType.getToken().getLexer().setType("Auto");
        }
        transformationTokenType.getToken().setStoplistId(null);
        String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        if (string != null) {
            if (ServerConstants.StoplistLanguage.isDefault(ServerConstants.StoplistLanguage.toSchema(string))) {
                String n = null;
                n = languages.getLanguage().size() <= 1 ? ((TransformationTokenType.Token.Languages.Language)languages.getLanguage().get(0)).getName() : "Multi";
                stoplistType = AbstractBuildNode.findDefaultStoplist(stoplists, n);
                String arrayList3 = stoplistType.getId();
                transformationTokenType.getToken().setStoplistId(arrayList3);
            } else {
                transformationTokenType.getToken().setStoplistId(AbstractBuildNode.findStoplistId(stoplists, string));
            }
        }
        Integer n = (Integer)this.jMaxNumAllDocsSpinner.getValue();
        transformationTokenType.getToken().setMaxNumberAllDocs(BigInteger.valueOf(n.intValue()));
        if (stoplistType != null) {
            boolean bl;
            ArrayList<String> arrayList2 = AbstractTextNode.findStoplistLanguages(stoplistType, "Word");
            ArrayList<String> arrayList3 = new ArrayList<String>();
            object = new ArrayList();
            for (String string2 : arrayList) {
                bl = false;
                for (String string3 : arrayList2) {
                    if (!string2.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList3.add(string2);
            }
            for (String string4 : arrayList2) {
                bl = false;
                for (String string3 : arrayList) {
                    if (!string4.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                ((ArrayList)object).add(string4);
            }
            if (arrayList3.size() > 0) {
                AbstractTextNode.stoplistAddDefaultTokens(this._context, stoplistType, "Word", arrayList3);
            }
            if (((ArrayList)object).size() > 0) {
                ArrayList<String> arrayList4 = new ArrayList();
                arrayList4 = AbstractBuildNode.stoplistCheckLanguagesUsed(null, buildNodeType, stoplistType, "Word", (ArrayList<String>)object);
                if (arrayList4.size() == 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Object object3 = ((ArrayList)object).iterator();
                    while (object3.hasNext()) {
                        String string5 = (String)object3.next();
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(ServerConstants.StoplistLanguage.toHuman(string5));
                    }
                    object3 = MessageFormat.format(DialogsLrb.get("BUILD_TEXT_REMOVE_WORDS_FOR_LANG"), stringBuffer.toString());
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)object3, (String)DialogsLrb.get("BUILD_TEXT_DIALOG_TITLE"), null, (boolean)true)) {
                        AbstractTextNode.stoplistRemoveTokens(stoplistType, "Word", (ArrayList<String>)object);
                    }
                }
            }
        }
        return true;
    }

    private void enableControls() {
        if (this.jSelectedStoplistComboBox.getItemCount() > 0) {
            String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
            this.jEditStoplistButton.setEnabled(!ServerConstants.StoplistLanguage.isNone(ServerConstants.StoplistLanguage.toSchema(string)));
        } else {
            this.jEditStoplistButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.jLanguageLabel = new JLabel();
        this.jSingleBtyeComboBox = new JCheckCombo();
        this.jStoplistLabel = new JLabel();
        this.jSelectedStoplistComboBox = new JComboBox();
        this.jEditStoplistButton = new JButton();
        this.jNewStoplistButton = new JButton();
        this.jTokensLabel = new JLabel();
        this.jMaxNumAllDocsLabel = new JLabel();
        this.jMaxNumAllDocsSpinner = new JSpinner();
        this.jStemmingCheckBox = new JCheckBox();
        this.jLanguageLabel.setText("Languages:");
        this.jSingleBtyeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "German", "French"}));
        this.jSingleBtyeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jSingleBtyeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jStoplistLabel.setText("Stoplist:");
        this.jSelectedStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSelectedStoplistComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jSelectedStoplistComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistButton.setText("---");
        this.jEditStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jEditStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jEditStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jNewStoplistButton.setText("+");
        this.jNewStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jNewStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jNewStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jTokensLabel.setText("Tokens:");
        this.jMaxNumAllDocsLabel.setLabelFor(this.jMaxNumAllDocsSpinner);
        this.jMaxNumAllDocsLabel.setText("Max number across all documents");
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(3000, 1, 100000, 100));
        this.jStemmingCheckBox.setText("Stemming");
        this.jStemmingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingTokenPanel.this.jStemmingCheckBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTokensLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jStemmingCheckBox, -2, 94, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jMaxNumAllDocsLabel, -2, 198, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMaxNumAllDocsSpinner))))).addGap(76, 76, 76)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLanguageLabel, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jSingleBtyeComboBox, 0, -1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jStoplistLabel, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectedStoplistComboBox, 0, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditStoplistButton, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNewStoplistButton, -2, 26, -2).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent((Component)this.jSingleBtyeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jStemmingCheckBox).addGap(7, 7, 7).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedStoplistComboBox, -2, -1, -2).addComponent(this.jNewStoplistButton).addComponent(this.jEditStoplistButton).addComponent(this.jStoplistLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokensLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumAllDocsLabel).addComponent(this.jMaxNumAllDocsSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jSelectedStoplistComboBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jEditStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistType stoplistType;
        String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        StoplistType stoplistType2 = null;
        Object object = this._stoplists.getStoplist().iterator();
        while (object.hasNext()) {
            stoplistType = (StoplistType)object.next();
            if (!stoplistType.getName().equals(string)) continue;
            stoplistType2 = stoplistType;
            break;
        }
        if (((DialogDisplayer)(object = new StoplistDetailsPanel(this._context, this._node, this._buildNodeType, this, stoplistType2))).showAsDialog(this) && ((StoplistDetailsPanel)object).isDirty()) {
            stoplistType = ((StoplistDetailsPanel)object).getStoplist();
            for (int i = 0; i < this._stoplists.getStoplist().size(); ++i) {
                if (!((StoplistType)this._stoplists.getStoplist().get(i)).getId().equals(stoplistType.getId())) continue;
                this._stoplists.getStoplist().set(i, stoplistType);
                break;
            }
            this._dirty = true;
            this.initStoplists(stoplistType.getId());
        }
    }

    private void jNewStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistWizard stoplistWizard = new StoplistWizard();
        if (stoplistWizard.runWizard(this, null, this._context, this._node, this._sourceAttributeName)) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = AbstractBuildNode.getStoplistNextId(this._stoplists) + "";
            stoplistType.setId(string);
            this._stoplists.getStoplist().add(stoplistType);
            this._dirty = true;
            this.initStoplists(string);
        }
    }

    private void jSingleBtyeComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jStemmingCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jStemmingCheckBox.isSelected();
        LexerType.Settings.Attribute attribute = null;
        for (LexerType.Settings.Attribute attribute2 : this._textTransformation.getToken().getLexer().getSettings().getAttribute()) {
            if (!attribute2.getName().equals("index_stems")) continue;
            attribute = attribute2;
            break;
        }
        if (bl && attribute == null) {
            LexerType.Settings.Attribute attribute3 = null;
            if (this._textTransformation.getToken().getLanguages().getLanguage().size() <= 1) {
                attribute3 = new LexerType.Settings.Attribute();
                attribute3.setName("index_stems");
                attribute3.setType("String");
                attribute3.setValueString(((TransformationTokenType.Token.Languages.Language)this._textTransformation.getToken().getLanguages().getLanguage().get(0)).getName());
            } else {
                attribute3 = new LexerType.Settings.Attribute();
                attribute3.setName("index_stems");
                attribute3.setType("String");
                attribute3.setValueString("TRUE");
            }
            this._textTransformation.getToken().getLexer().getSettings().getAttribute().add(attribute3);
        } else if (!bl && attribute != null) {
            this._textTransformation.getToken().getLexer().getSettings().getAttribute().remove(attribute);
        }
    }

    private void jSingleByteLanguageValueChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray;
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        CheckComboModel checkComboModel = this.jSingleBtyeComboBox.getCheckModel();
        for (Object object : objectArray = checkComboModel.getSelectedItem()) {
            String string = (String)object;
            if (!this._isNoneSelected && ServerConstants.StoplistLanguage.isNone(ServerConstants.StoplistLanguage.toSchema(string))) {
                listSelectionModel.clearSelection();
                listSelectionModel.addSelectionInterval(1, 1);
                this._isNoneSelected = true;
                this._isAllSelected = false;
                break;
            }
            if (!this._isAllSelected && ServerConstants.StoplistLanguage.isALL(ServerConstants.StoplistLanguage.toSchema(string))) {
                listSelectionModel.removeSelectionInterval(1, 1);
                listSelectionModel.addSelectionInterval(2, checkComboModel.getSize() - 1);
                this._isAllSelected = true;
                this._isNoneSelected = false;
                break;
            }
            listSelectionModel.removeSelectionInterval(0, 0);
            this._isAllSelected = false;
            listSelectionModel.removeSelectionInterval(1, 1);
            this._isNoneSelected = false;
        }
        this._isAdjusting = false;
    }

    public BuildNodeType.Stoplists getStoplists() {
        return this._stoplists;
    }
}

