/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.wizard.AbstractWizardPage;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.dialog.build.AddStopwordsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistWizardModel;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class StoplistReviewPage
extends AbstractWizardPage
implements DataminerGUIPanel {
    private StoplistWizardModel _wizModel;
    private StoplistType _stoplist;
    private StopwordTableModel _stopwordModels;
    private JButton _stopwordRemoveBtn;
    private JButton _stopwordAddBtn;
    private JLabel jLanguageLabel;
    private JLabel jLanguageValueLabel;
    private JLabel jNameLabel;
    private JLabel jNameValueLabel;
    private DataMinerTablePanel stopWordTablePanel;
    private static final String[] _stopwordColumnNames = new String[]{DialogsLrb.get("STOPLIST_COLUMN_NAME"), DialogsLrb.get("STOPLIST_COLUMN_TYPE"), DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE")};
    private static final int STOPWORD_NAME = 0;
    private static final int STOPWORD_TYPE = 1;
    private static final int STOPWORD_LANGUAGE = 2;

    public StoplistReviewPage() {
        this.initComponents();
        this.initRes();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jNameLabel, (Component)this.jNameValueLabel, (String)DialogsLrb.get("STOPLIST_WIZ_NAME"));
        ResourceUtils.resLabel((JLabel)this.jLanguageLabel, (Component)this.jLanguageValueLabel, (String)DialogsLrb.get("ADD_STOPWORD_LANGUAGE"));
    }

    @Override
    public void initUI() {
        this._wizModel = (StoplistWizardModel)this.getTraversableContext().get("wizardModel");
        this._stoplist = this._wizModel.getStoplist();
        this.jNameValueLabel.setText(this._stoplist.getName());
        this._stopwordModels = new StopwordTableModel(this._stoplist);
        this.installStopwordItemFilterActions();
        this.stopWordTablePanel.setup((TableModel)((Object)this._stopwordModels), DialogsLrb.get("STOPLIST_STOPWORD_TABLE_TITLE"), 0, true);
        this.stopWordTablePanel.getTable().setAutoResizeMode(0);
        this.stopWordTablePanel.getTable().setSelectionMode(2);
        this.stopWordTablePanel.getTable().setColumnSelectorAvailable(true);
        this.stopWordTablePanel.getTable().setShowToolTips(true);
        this.stopWordTablePanel.getTable().setUpdateSelectionOnSort(true);
        this.stopWordTablePanel.getTable().setRowSelectionAllowed(true);
        this.stopWordTablePanel.getTable().setSortColumn(0, true);
        TableColumn tableColumn = this.stopWordTablePanel.getTable().getColumnModel().getColumn(0);
        StopwordEditor stopwordEditor = new StopwordEditor();
        stopwordEditor.setDocument(new TextFieldLimit(4000));
        tableColumn.setCellEditor(stopwordEditor);
        this.stopWordTablePanel.getTable().autoSizeColumnsToFit();
        this.stopWordTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                StoplistReviewPage.this.enableControls();
            }
        });
        this.enableControls();
    }

    private void installStopwordItemFilterActions() {
        this._stopwordRemoveBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._stopwordRemoveBtn.setToolTipText(DialogsLrb.get("STOPLIST_DELETE_STOPWORD_TOOLTIP"));
        this._stopwordRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = StoplistReviewPage.this.stopWordTablePanel.getTable().getSelectedRowsInModel();
                if (nArray.length > 0) {
                    StoplistReviewPage.this._stopwordModels.removeSelectedRows(nArray);
                    StoplistReviewPage.this._stopwordModels.fireTableDataChanged();
                }
            }
        });
        this._stopwordAddBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._stopwordAddBtn.setToolTipText(DialogsLrb.get("STOPLIST_ADD_STOPWORD_TOOLTIP"));
        this._stopwordAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoplistReviewPage.this.processAdd();
            }
        });
        this.stopWordTablePanel.addControlBarComponents(this._stopwordRemoveBtn, this._stopwordAddBtn);
    }

    private void processAdd() {
        AddStopwordsPanel addStopwordsPanel = new AddStopwordsPanel(this._wizModel.getContext(), null, (JPanel)((Object)this), this._stoplist);
        if (addStopwordsPanel.showAsDialog((Component)((Object)this))) {
            this._stoplist = addStopwordsPanel.getStoplist();
            this._stopwordModels = new StopwordTableModel(this._stoplist);
            this.stopWordTablePanel.getTable().setModel((TableModel)((Object)this._stopwordModels));
            this.enableControls();
        }
    }

    private void enableControls() {
        String string = null;
        string = this._stoplist.getType().equals("Basic") ? ServerConstants.StoplistLanguage.toHuman(this._stoplist.getLanguage()) : ServerConstants.StoplistLanguage.toHuman("Multi");
        this.jLanguageValueLabel.setText(string);
        this._stopwordAddBtn.setEnabled(true);
        int[] nArray = this.stopWordTablePanel.getTable().getSelectedRowsInModel();
        this._stopwordRemoveBtn.setEnabled(nArray.length > 0);
    }

    @Override
    public String getPageDirtyKey() {
        return "reviewDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        StoplistWizardModel stoplistWizardModel = (StoplistWizardModel)traversableContext.get("wizardModel");
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        return this.validateAndWriteToState(stoplistWizardModel);
    }

    public boolean validateAndWriteToState(StoplistWizardModel stoplistWizardModel) {
        boolean bl = true;
        ValidateWriteThread validateWriteThread = new ValidateWriteThread(stoplistWizardModel);
        validateWriteThread.setMessage(MessageFormat.format(GroupLrb.get("VALIDATING_GROUP_TABLES_DETAILS"), new Object[]{null}));
        validateWriteThread.setCancelable(false);
        try {
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
        return bl;
    }

    private void initComponents() {
        this.jNameLabel = new JLabel();
        this.jNameValueLabel = new JLabel();
        this.jLanguageLabel = new JLabel();
        this.jLanguageValueLabel = new JLabel();
        this.stopWordTablePanel = new DataMinerTablePanel();
        this.jNameLabel.setText("Name:");
        this.jNameValueLabel.setText("jLabel2");
        this.jLanguageLabel.setText("Language:");
        this.jLanguageValueLabel.setText("jLabel2");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stopWordTablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLanguageLabel, -1, 74, Short.MAX_VALUE).addComponent(this.jNameLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNameValueLabel, -2, 243, -2).addComponent(this.jLanguageValueLabel, -2, 243, -2)).addGap(0, 163, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNameLabel).addComponent(this.jNameValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent(this.jLanguageValueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stopWordTablePanel, -1, 276, Short.MAX_VALUE).addContainerGap()));
    }

    private static class StopwordEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JTextField _textField = new JTextField();

        public StopwordEditor() {
            this._textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof String) {
                String string = (String)object;
                this._textField.setText(string);
            } else if (object == null) {
                this._textField.setText("");
            }
            return this._textField;
        }

        @Override
        public Object getCellEditorValue() {
            return this._textField.getText();
        }

        public void setDocument(Document document) {
            this._textField.setDocument(document);
        }
    }

    private static class StopwordTableModel
    extends GenericBaseTableModel {
        private StoplistType _stoplist;

        public StopwordTableModel(StoplistType stoplistType) {
            this._stoplist = stoplistType;
            this.setColumnIdentifiers(_stopwordColumnNames);
            this.setRowCount(this.getRowCount());
        }

        public int getRowCount() {
            if (this._stoplist == null || this._stoplist.getStopTokens() == null) {
                return 0;
            }
            return this._stoplist.getStopTokens().getToken().size();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<StoplistType.StopTokens.Token> vector = new Vector<StoplistType.StopTokens.Token>();
            for (int i = 0; i < nArray.length; ++i) {
                StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._stoplist.getStopTokens().getToken().get(nArray[i]);
                vector.add(token);
            }
            this._stoplist.getStopTokens().getToken().removeAll(vector);
            this.setRowCount(this._stoplist.getStopTokens().getToken().size());
            AbstractTextNode.updateStoplistTypeAndLanguage(this._stoplist);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._stoplist.getStopTokens() == null || this._stoplist.getStopTokens().getToken().size() == 0) {
                return null;
            }
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._stoplist.getStopTokens().getToken().get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = token.getItem();
                    break;
                }
                case 1: {
                    string = ServerConstants.StopTokenType.toHuman(token.getType());
                    break;
                }
                case 2: {
                    string = ServerConstants.StoplistLanguage.toHuman(token.getLanguage());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            StoplistType.StopTokens.Token token = (StoplistType.StopTokens.Token)this._stoplist.getStopTokens().getToken().get(n);
            switch (n2) {
                case 0: {
                    String string = null;
                    if (object != null) {
                        string = ((String)object).trim();
                    }
                    if (!this.validateStopwords(n, string, token.getLanguage(), token.getType(), this._stoplist.getStopTokens().getToken())) {
                        return;
                    }
                    token.setItem(string);
                }
            }
        }

        private boolean validateStopwords(int n, String string, String string2, String string3, List<StoplistType.StopTokens.Token> list) {
            boolean bl = true;
            int n2 = 0;
            if (string == null || string.length() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_STOPWORD_EMPTY"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
            for (StoplistType.StopTokens.Token token : list) {
                String string4 = string2 + ":" + string3 + ":" + string;
                String string5 = token.getLanguage() + ":" + token.getType() + ":" + token.getItem();
                if (n != n2 && string4.compareTo(string5) == 0) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_ERROR_DUPLICATE_STOPWORD"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            }
            return bl;
        }
    }

    private class ValidateWriteThread
    extends ProgressRunnable {
        private StoplistWizardModel _model;
        boolean _validated = true;

        public ValidateWriteThread(StoplistWizardModel stoplistWizardModel) {
            this._model = stoplistWizardModel;
        }

        public boolean getValidation() {
            return this._validated;
        }

        protected Object doWork() throws Exception {
            try {
                this._validated = true;
                this._model.setStoplist(StoplistReviewPage.this._stoplist);
            }
            catch (Exception exception) {
                this._validated = false;
            }
            return null;
        }
    }
}

