/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.CheckBoxTableListener;
import oracle.dmt.dataminer.controls.CheckedItemData;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.renderers.LabeledCheckBoxRenderer;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.table.GenericBaseTableModel;

public final class SelectCompareUsageDialog {
    protected JEWTDialog _dlg;
    protected String dlgName = "Compare Usages!";
    private DialogPanel _panel;

    public Map<ModelType, ModelType> getSelectedModels() {
        return this._panel.getSelectedModels();
    }

    protected JEWTDialog buildDialog(AbstractBuildNode abstractBuildNode) {
        this._panel = new DialogPanel(abstractBuildNode);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 3;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.dlgName, n);
        jEWTDialog.setContent((Component)this._panel);
        jEWTDialog.setTitle(this.getDialogTitle());
        return jEWTDialog;
    }

    protected String getDialogTitle() {
        return BuildEditorLrb.get("BUILD_COMPARE_USAGE_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(AbstractBuildNode abstractBuildNode) {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog(abstractBuildNode);
            jEWTDialog.setResizable(true);
            jEWTDialog.setOKButtonEnabled(false);
            final DialogPanel dialogPanel = (DialogPanel)jEWTDialog.getContent();
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object) && !dialogPanel.doWork()) {
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            });
            this._dlg = jEWTDialog;
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("BUILD_COMPARE_FAILED_TITLE"), (String)BuildEditorLrb.get("BUILD_COMPARE_FAILED_MSG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    protected void cancel() {
    }

    class DialogPanel
    extends JPanel {
        private JScrollPane jInputTableScrollPane;
        private JLabel jInstructions;
        private DataMinerTable jModelsTable;
        private AbstractBuildNode _activity;
        private LabeledCheckBoxRenderer _tableCellRenderer = new LabeledCheckBoxRenderer();
        private CheckListener _tableListener = new CheckListener(this._tableCellRenderer);
        private int _selectionCounter = 0;

        public DialogPanel(AbstractBuildNode abstractBuildNode) {
            this._activity = abstractBuildNode;
            this.initComponents();
            this.initRes();
            this.initUI();
        }

        public boolean doWork() {
            return true;
        }

        private void initComponents() {
            this.jInputTableScrollPane = new JScrollPane();
            this.jModelsTable = new DataMinerTable();
            this.jInstructions = new JLabel();
            this.jModelsTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
            this.jInputTableScrollPane.setViewportView((Component)((Object)this.jModelsTable));
            this.jInstructions.setText("Instructions");
            GroupLayout groupLayout = new GroupLayout(this);
            this.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jInstructions, -1, 160, Short.MAX_VALUE).addContainerGap()).addComponent(this.jInputTableScrollPane, -1, 170, Short.MAX_VALUE));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jInstructions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jInputTableScrollPane, -1, 149, Short.MAX_VALUE)));
        }

        public void initRes() {
            ResourceUtils.resLabel((JLabel)this.jInstructions, (Component)((Object)this.jModelsTable), (String)BuildEditorLrb.get("BUILD_COMPARE_USAGE_MSG"));
        }

        public Component getInitialFocus() {
            return this.jModelsTable;
        }

        public void initUI() {
            this.loadModelsTable(this._activity);
            this.jModelsTable.addMouseListener(this._tableListener);
            this.jModelsTable.addKeyListener(this._tableListener);
        }

        protected boolean doValidation(TraversableContext traversableContext) {
            return true;
        }

        private void loadModelsTable(AbstractBuildNode abstractBuildNode) {
            List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
            ModelsModel modelsModel = new ModelsModel(list);
            this.jModelsTable.setModel((TableModel)((Object)modelsModel));
            this.jModelsTable.getColumnModel().getColumn(0).setCellRenderer(this._tableCellRenderer);
            TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(this.jModelsTable.getModel());
            this.jModelsTable.setRowSorter(tableRowSorter);
        }

        public Map<ModelType, ModelType> getSelectedModels() {
            ModelsModel modelsModel = (ModelsModel)((Object)this.jModelsTable.getModel());
            ArrayList<ModelData> arrayList = modelsModel.getDataList();
            HashMap<ModelType, ModelType> hashMap = new HashMap<ModelType, ModelType>();
            for (ModelData modelData : arrayList) {
                if (!modelData.getCheckBoxState().isTrue()) continue;
                hashMap.put((ModelType)modelData.getData(), (ModelType)modelData.getData());
            }
            return hashMap;
        }

        private void incrementSelectionCount() {
            ++this._selectionCounter;
            boolean bl = this._selectionCounter > 1;
            SelectCompareUsageDialog.this._dlg.setOKButtonEnabled(bl);
        }

        private void decrementSelectionCount() {
            --this._selectionCounter;
            boolean bl = this._selectionCounter > 1;
            SelectCompareUsageDialog.this._dlg.setOKButtonEnabled(bl);
        }

        class ModelsModel
        extends GenericBaseTableModel {
            private ArrayList<ModelData> _data = new ArrayList();
            public static final int NAME = 0;
            private final int COLUMN_COUNT = 1;

            public ModelsModel(List<ModelType> list) {
                for (ModelType modelType : list) {
                    this._data.add(new ModelData(modelType));
                }
                Object[] objectArray = new String[]{BuildEditorLrb.get("BUILD_COMPARE_COLUMN_MODEL")};
                this.setColumnIdentifiers(objectArray);
                this.setRowCount(this._data.size());
                this.setColumnCount(1);
            }

            public Object getValueAt(int n, int n2) {
                assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
                assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
                ModelData modelData = this._data.get(n);
                ModelData modelData2 = null;
                switch (n2) {
                    case 0: {
                        modelData2 = modelData;
                        break;
                    }
                    default: {
                        assert (false) : "Out of bounds column";
                        break;
                    }
                }
                return modelData2;
            }

            public ArrayList<ModelData> getDataList() {
                return this._data;
            }
        }

        class ModelData
        extends CheckedItemData {
            public ModelData(Object object) {
                super(object);
            }

            @Override
            public String toString() {
                return ((ModelType)this.getData()).getName();
            }
        }

        private class CheckListener
        extends CheckBoxTableListener {
            public CheckListener(LabeledCheckBoxRenderer labeledCheckBoxRenderer) {
                super(labeledCheckBoxRenderer);
            }

            @Override
            public void itemChecked(int n) {
                super.itemChecked(n);
                DialogPanel.this.incrementSelectionCount();
            }

            @Override
            public void itemUnchecked(int n) {
                super.itemUnchecked(n);
                DialogPanel.this.decrementSelectionCount();
            }
        }
    }
}

