/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditModelsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.DataUsagePanel;
import oracle.dmt.dataminer.workflow.dialog.build.PartitionPanel;
import oracle.dmt.dataminer.workflow.dialog.build.TextSettingsPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;

public class BuildEditDialog {
    private static final Logger theLogger = Logger.getLogger(BuildEditDialog.class.getName());
    protected JEWTDialog _dlg;
    protected String wizName = "Edit build node";
    protected Context context;
    protected AbstractBuildNode node;
    protected List<String> selectedModels;
    private JTabbedPane tabs;
    private static int lastTabIndex = 0;
    private Version dbVersion;

    protected CustomJEWTDialog buildDialog(Context context, AbstractBuildNode abstractBuildNode, List<String> list) {
        this.context = context;
        this.node = abstractBuildNode;
        this.selectedModels = list;
        TabbedContainer tabbedContainer = new TabbedContainer(abstractBuildNode);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        CustomJEWTDialog customJEWTDialog = new CustomJEWTDialog((Frame)ideMainWindow, this.wizName, n);
        customJEWTDialog.setContent(tabbedContainer);
        customJEWTDialog.setTitle(this.getDialogTitle(abstractBuildNode));
        this.initHelp(customJEWTDialog, abstractBuildNode);
        return customJEWTDialog;
    }

    protected void initHelp(CustomJEWTDialog customJEWTDialog, AbstractBuildNode abstractBuildNode) {
        if (abstractBuildNode instanceof AssociationBuildNode) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)customJEWTDialog.getContent(), "association_node_edit");
        } else if (abstractBuildNode instanceof ClassificationBuildNode) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)customJEWTDialog.getContent(), "classification_node_edit");
        } else if (abstractBuildNode instanceof ClusteringBuildNode) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)customJEWTDialog.getContent(), "clustering_node_edit");
        } else if (abstractBuildNode instanceof RegressionBuildNode) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)customJEWTDialog.getContent(), "regression_node_edit");
        } else if (abstractBuildNode instanceof AnomalyDetectionBuildNode) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)customJEWTDialog.getContent(), "anomaly_node_edit");
        } else if (abstractBuildNode instanceof FeatureExtractionBuildNode) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)customJEWTDialog.getContent(), "feature_node_edit");
        }
    }

    protected String getDialogTitle(AbstractBuildNode abstractBuildNode) {
        if (abstractBuildNode == null) {
            return "Not Found";
        }
        if (abstractBuildNode instanceof ClassificationBuildNode) {
            return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_CLASSIFICATION_NODE_TITLE");
        }
        if (abstractBuildNode instanceof RegressionBuildNode) {
            return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_REGRESSION_NODE_TITLE");
        }
        if (abstractBuildNode instanceof ClusteringBuildNode) {
            return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_CLUSTERING_NODE_TITLE");
        }
        if (abstractBuildNode instanceof AssociationBuildNode) {
            return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_ASSOCIATION_NODE_TITLE");
        }
        if (abstractBuildNode instanceof AnomalyDetectionBuildNode) {
            return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_ANOMALY_DETECTION_NODE_TITLE");
        }
        if (abstractBuildNode instanceof FeatureExtractionBuildNode) {
            return BuildEditorLrb.get("HEURISTIC_DETAILS_EDIT_FEATURE_EXTRACTION_NODE_TITLE");
        }
        return "Not Found";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context, AbstractBuildNode abstractBuildNode, List<String> list) {
        boolean bl = false;
        try {
            CustomJEWTDialog customJEWTDialog = this.buildDialog(context, abstractBuildNode, list);
            customJEWTDialog.setResizable(true);
            final TabbedContainer tabbedContainer = (TabbedContainer)customJEWTDialog.getContent();
            customJEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                        if (!tabbedContainer.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    } else if (string.equals("closed") && object instanceof Integer && tabbedContainer.isDirty()) {
                        int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)BuildEditorLrb.get("BUILD_DIALOG_CHANGES_PENDING_MSG"), (String)BuildEditorLrb.get("BUILD_DIALOG_CHANGES_PENDING_TITLE"));
                        if (n == -1) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                        if (n == 1 && !tabbedContainer.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                }
            });
            this._dlg = customJEWTDialog;
            if (customJEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)((Object)customJEWTDialog));
                lastTabIndex = this.tabs.getSelectedIndex();
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_TITLE"), (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_MSG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    protected void cancel() {
    }

    public static String getModelsDeleteMessage(JTable jTable) {
        int[] nArray = jTable.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = jTable.convertRowIndexToModel(nArray[i]);
        }
        String[] stringArray = new String[3];
        if (nArray.length == 1) {
            stringArray[0] = BuildEditorLrb.get("REMOVE_MODEL_SPEC_MSG");
            stringArray[1] = BuildEditorLrb.get("REMOVE_MODEL_TEST_MSG");
            stringArray[2] = BuildEditorLrb.get("REMOVE_MODEL_NON_MSG");
        } else {
            stringArray[0] = BuildEditorLrb.get("REMOVE_MODEL_MULT_MSG");
            stringArray[1] = BuildEditorLrb.get("REMOVE_MODEL_TEST_MULT_MSG");
            stringArray[2] = BuildEditorLrb.get("REMOVE_MODEL_NON_MULT_MSG");
        }
        List<ModelType> list = ((BuildNodeTableModel)((Object)jTable.getModel())).getDataList();
        String string = null;
        for (int n : nArray) {
            ModelType modelType = list.get(n);
            if (modelType.getCreationDate() == null && string == null) {
                string = stringArray[0];
                continue;
            }
            if (modelType.getCreationDate() == null) continue;
            if (modelType instanceof ClassificationModelType || modelType instanceof RegressionModelType) {
                string = stringArray[1];
                continue;
            }
            string = stringArray[2];
            return string;
        }
        return string;
    }

    private static class CustomJEWTDialog
    extends JEWTDialog {
        public CustomJEWTDialog(Frame frame, String string, int n) {
            super(frame, string, n);
        }

        protected void dismissDialog(boolean bl) {
            if (!bl) {
                super.dismissDialog(bl);
                return;
            }
            try {
                super.fireVetoableChange("closed", (Object)Boolean.FALSE, (Object)0);
            }
            catch (PropertyVetoException propertyVetoException) {
                return;
            }
            super.dismissDialog(bl);
        }
    }

    class TabbedContainer
    extends JPanel {
        private BuildNodeType nodeData;
        private BuildNodeType nodeDataCopy;
        BuildEditModelsPanel buildPanel;
        DataUsagePanel dataPanel;
        TextSettingsPanel textPanel;
        PartitionPanel partitionPanel;

        public TabbedContainer(AbstractBuildNode abstractBuildNode) {
            this.nodeData = (BuildNodeType)BuildEditDialog.this.node.getData();
            this.nodeDataCopy = (BuildNodeType)MetaDataHelper.copyMetadataObject(abstractBuildNode.getData());
            this.initUI();
        }

        public boolean isDirty() {
            return this.buildPanel.isDirty() || this.dataPanel != null && this.dataPanel.isDirty() || this.textPanel != null && this.textPanel.isDirty() || this.partitionPanel != null && this.partitionPanel.isDirty();
        }

        public void initUI() {
            Object object;
            Version version = null;
            try {
                version = ConnectionFolder.getConnectionFolder(BuildEditDialog.this.context).getDbVersion();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            this.setLayout(new BorderLayout());
            HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
            HashMap<String, AttributeType> hashMap2 = new HashMap<String, AttributeType>();
            HashMap<String, AttributeType> hashMap3 = new HashMap<String, AttributeType>();
            if (this.nodeDataCopy instanceof SuperviseBuildNodeType && (object = ((SuperviseBuildNodeType)this.nodeDataCopy).getTargetAttribute()) != null) {
                hashMap.put(object.getName(), (AttributeType)object);
            }
            object = this.nodeDataCopy.getCaseAttributes().getAttribute();
            PartitionExpressions partitionExpressions = object.iterator();
            while (partitionExpressions.hasNext()) {
                AttributeType attributeType = (AttributeType)partitionExpressions.next();
                hashMap2.put(attributeType.getName(), attributeType);
            }
            partitionExpressions = this.nodeDataCopy.getPartitionExpressions();
            if (partitionExpressions != null) {
                for (PartitionExpressionType partitionExpressionType : this.nodeDataCopy.getPartitionExpressions().getPartitionExpression()) {
                    if (partitionExpressionType.getSQLExpression() != null) continue;
                    AttributeType attributeType = partitionExpressionType.getPartitionAttribute();
                    hashMap3.put(attributeType.getName(), attributeType);
                }
            }
            BuildEditDialog.this.tabs = new JTabbedPane();
            this.buildPanel = new BuildEditModelsPanel(BuildEditDialog.this.context, BuildEditDialog.this.node, this.nodeDataCopy, new ArrayList<String>());
            BuildEditDialog.this.tabs.add(BuildEditorLrb.get("BUILD_TAB"), this.buildPanel);
            boolean bl = ConfigUtils.isDatabaseVersion(DBVersions.V12_2_0_0, version, true);
            if (bl) {
                this.partitionPanel = new PartitionPanel(BuildEditDialog.this.context, BuildEditDialog.this.node, this.nodeDataCopy);
                BuildEditDialog.this.tabs.add(BuildEditorLrb.get("PARTITION_TAB"), this.partitionPanel);
            }
            if (!(BuildEditDialog.this.node instanceof AssociationBuildNode)) {
                this.dataPanel = new DataUsagePanel(BuildEditDialog.this.context, BuildEditDialog.this.node, this.nodeDataCopy, this.nodeDataCopy.getMiningAttributes(), hashMap, hashMap2, hashMap3, 6);
                BuildEditDialog.this.tabs.add(BuildEditorLrb.get("DATA_TAB"), this.dataPanel);
                this.buildPanel.addEditChangeListener(this.dataPanel);
                if (this.partitionPanel != null) {
                    this.partitionPanel.addEditChangeListener(this.dataPanel);
                }
                this.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent componentEvent) {
                        TabbedContainer.this.dataPanel.resizeTable(TabbedContainer.this.getSize());
                    }
                });
            }
            if (ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true) && !(BuildEditDialog.this.node instanceof AssociationBuildNode)) {
                this.textPanel = new TextSettingsPanel(BuildEditDialog.this.context, BuildEditDialog.this.node, this.nodeDataCopy);
                this.textPanel.addEditChangeListener(this.dataPanel);
                BuildEditDialog.this.tabs.add(BuildEditorLrb.get("TEXT_TAB"), this.textPanel);
            }
            this.add(BuildEditDialog.this.tabs);
            if (BuildEditDialog.this.tabs.getTabCount() < lastTabIndex + 1) {
                lastTabIndex = 0;
            }
            BuildEditDialog.this.tabs.setSelectedIndex(lastTabIndex);
        }

        public boolean doWork() {
            Object object;
            boolean bl = true;
            if (!this.buildPanel.doWork()) {
                return false;
            }
            if (!(BuildEditDialog.this.node instanceof AssociationBuildNode) && !this.dataPanel.doWork()) {
                return false;
            }
            if (this.textPanel != null && !this.textPanel.doWork()) {
                return false;
            }
            if (this.partitionPanel != null && !this.partitionPanel.doWork()) {
                return false;
            }
            if (!this.isDirty()) {
                return true;
            }
            boolean bl2 = true;
            HashMap<String, ModelType> hashMap = new HashMap<String, ModelType>();
            List<ModelType> list = MetaDataHelper.getModelsCollection(this.nodeData);
            ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
            for (ModelType modelType : list) {
                object = MetaDataHelper.findModelById(this.nodeDataCopy, modelType.getId());
                if (object == null || object.getName().equals(modelType.getName())) continue;
                hashMap.put(object.getName(), modelType);
                arrayList.add((ModelType)object);
            }
            if (!MetaDataHelper.isEqualTargetAndCaseID(this.nodeData, this.nodeDataCopy)) {
                MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
            } else if (this.nodeData instanceof AssociationBuildNodeType) {
                if (!MetaDataHelper.isEqualAssociationSettings(this.nodeData, this.nodeDataCopy)) {
                    MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
                }
            } else if (!hashMap.isEmpty()) {
                MetaDataHelper.setModelsStatus(this.nodeDataCopy, arrayList, ModelStatusType.READY);
            } else if (this.partitionPanel != null && !MetaDataHelper.isEqualPartitionColumns(this.nodeData, this.nodeDataCopy)) {
                MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
            }
            if (this.dataPanel != null) {
                boolean bl3 = this.dataPanel.autoBtn.isSelected();
                boolean bl4 = this.dataPanel.getOriginalAutoValue();
                if (!bl3 && BuildEditDialog.this.node instanceof ClassificationBuildNode) {
                    object = MetaDataHelper.getModelsCollection(this.nodeDataCopy);
                    Iterator<Object> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        ModelType modelType = (ModelType)iterator.next();
                        if (this.dataPanel.isValidRowWeightColumn(modelType, "")) continue;
                        return false;
                    }
                }
                if (bl3 != bl4) {
                    MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
                }
            }
            try {
                CommandProcessor.getInstance().beginTrans(BuildEditorLrb.get("EDIT_NODE"));
                OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)BuildEditDialog.this.node.getUndoFilter();
                odmrSDMUndoFilter.prepareUndo(BuildEditDialog.this.node, BuildEditDialog.this.context, "nodetype", this.nodeDataCopy);
                if (hashMap.size() > 0) {
                    List<RefModelType> list2 = MetaDataHelper.getModelsCollection(this.nodeDataCopy, BuildEditDialog.this.context);
                    object = new HashMap();
                    for (RefModelType refModelType : list2) {
                        if (!hashMap.containsKey(refModelType.getName())) continue;
                        object.put(((ModelType)hashMap.get(refModelType.getName())).getName(), refModelType);
                    }
                    BuildEditDialog.this.node.refactorChildModelReferences((Map<String, RefModelType>)object, false);
                }
                BuildEditDialog.this.node.validateAfterEdit();
                CommandProcessor.getInstance().endTrans();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                bl2 = false;
                CommandProcessor.getInstance().abortTrans();
            }
            return bl;
        }
    }
}

