/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.ModelEditRecord;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformsNodeType;
import oracle.ide.Context;
import oracle.javatools.ui.table.GenericTable;

public abstract class AbstractSettingsPanel
extends JPanel {
    private AdvancedSettingsPanel enclosingPanel;
    private Context context;
    private AbstractBuildNode workflowNode;
    private BuildNodeType metadataCopy;
    private DynamicNode dynamicNode;
    private TransformsNodeType dynamicMedataCopy;
    private boolean isPredictiveQuery;
    protected HashMap<String, ModelEditRecord> modelEdits;

    public AbstractSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, Context context, AbstractNode abstractNode, NodeType nodeType, HashMap<String, ModelEditRecord> hashMap) {
        this.enclosingPanel = advancedSettingsPanel;
        this.context = context;
        if (abstractNode instanceof AbstractBuildNode) {
            assert (nodeType instanceof BuildNodeType) : "Metadata should be a BuildNodeType";
            this.workflowNode = (AbstractBuildNode)abstractNode;
            this.metadataCopy = (BuildNodeType)nodeType;
            this.isPredictiveQuery = false;
        } else if (abstractNode instanceof DynamicNode) {
            assert (nodeType instanceof TransformsNodeType) : "Metadata should be a TransformsNodeType";
            this.dynamicNode = (DynamicNode)abstractNode;
            this.dynamicMedataCopy = (TransformsNodeType)nodeType;
            this.isPredictiveQuery = true;
        }
        this.modelEdits = hashMap;
        this.isPredictiveQuery = false;
    }

    public AbstractSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, Context context, DynamicNode dynamicNode, TransformsNodeType transformsNodeType) {
        this.enclosingPanel = advancedSettingsPanel;
        this.context = context;
        this.dynamicNode = dynamicNode;
        this.dynamicMedataCopy = transformsNodeType;
        this.isPredictiveQuery = true;
    }

    protected boolean handleModelSelectionChanged(ListSelectionModel listSelectionModel) {
        if (listSelectionModel.isSelectionEmpty()) {
            this.loadEmptySelectionUI();
        }
        return true;
    }

    protected boolean canHandleModelSelectionChange(ListSelectionModel listSelectionModel) {
        return true;
    }

    public abstract boolean canProceed(ListSelectionModel var1);

    protected ModelType findEditedModel(ModelType modelType) {
        return this.getEnclosingPanel().findEditedModel(modelType);
    }

    protected ModelEditRecord addEditedModelRecord(ModelType modelType, int n) {
        return this.getEnclosingPanel().addEditedModelRecord(modelType, n);
    }

    protected List<ModelType> getSelectedModels() {
        return this.getEnclosingPanel().getSelectedModels();
    }

    protected int[] getSelectedModelRowsInModel() {
        GenericTable genericTable = this.enclosingPanel.getModelsTable();
        return genericTable.getSelectedRowsInModel();
    }

    protected List<ModelType> getModelsDataList() {
        GenericTable genericTable = this.enclosingPanel.getModelsTable();
        AdvancedSettingsPanel.ModelsTableModel modelsTableModel = (AdvancedSettingsPanel.ModelsTableModel)((Object)genericTable.getModel());
        return modelsTableModel.getDataList();
    }

    protected abstract void loadEmptySelectionUI();

    public AdvancedSettingsPanel getEnclosingPanel() {
        return this.enclosingPanel;
    }

    public AbstractBuildNode getWorkflowNode() {
        assert (!this.isPredictiveQuery) : "Use getDynamicWorkflowNode";
        return this.workflowNode;
    }

    public DynamicNode getDynamicWorkflowNode() {
        assert (this.isPredictiveQuery) : "Use getWorkflowNode";
        return this.dynamicNode;
    }

    public Context getContext() {
        return this.context;
    }

    public BuildNodeType getMetadataCopy() {
        return this.metadataCopy;
    }

    public TransformsNodeType getDynamicMetadataCopy() {
        assert (this.isPredictiveQuery) : "Use getMetadataCopy";
        return this.dynamicMedataCopy;
    }

    public boolean isPredictiveQuery() {
        return this.isPredictiveQuery;
    }
}

