/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AddAggregationExpressionPanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditMainDialog;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateValidationProgress;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class EditAggregationExpressionPanel
extends AddAggregationExpressionPanel {
    public EditAggregationExpressionPanel(Context context, AggregationNode aggregationNode, GroupingElementType groupingElementType, List<AggregationElementType> list, AggregationElementType aggregationElementType) {
        super(context, aggregationNode);
        AbstractNode abstractNode = aggregationNode.findParentNode();
        assert (abstractNode instanceof AbstractDataNode);
        List<AttributeType> list2 = this.getAvailableAttributes((AbstractDataNode)abstractNode);
        assert (list2 != null) : "Available attribute collection must not be null";
        this.allAggregationColumns = list;
        this.mainGroupBy = groupingElementType;
        for (AttributeType attributeType : list2) {
            this.dataProviderAttributes.put(attributeType.getName(), attributeType);
        }
        this.thisAggregationElement = AttributeTypeHelper.cloneAggregationElementType(aggregationElementType);
        this.initUIComponents();
    }

    @Override
    public void initUI() {
        this.jtxtSqlExpression.setText(this.thisAggregationElement.getSource().getExpression());
        this.jtxtSqlExpression.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = EditAggregationExpressionPanel.this.jtxtSqlExpression.getText().trim();
                string = !StringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : string;
                EditAggregationExpressionPanel.this.jBtnEdit.setEnabled(string != null && !string.trim().isEmpty());
            }
        });
        this.initControlBar();
        this.jtxtSubGroupBy.setEditable(false);
        String string = this.jtxtSqlExpression.getText().trim();
        string = !StringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : string;
        this.jBtnEdit.setEnabled(string != null && !string.trim().isEmpty());
        this.jBtnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregationNode aggregationNode = (AggregationNode)EditAggregationExpressionPanel.this.getData();
                AbstractNode abstractNode = aggregationNode.findParentNode();
                assert (abstractNode instanceof AbstractDataNode);
                AttributeType attributeType = new AttributeType();
                attributeType.setName(EditAggregationExpressionPanel.this.jTxtOutput.getText().trim());
                EditAggregationExpressionPanel.this.thisAggregationElement.setOutput(attributeType);
                AggregateEditMainDialog aggregateEditMainDialog = new AggregateEditMainDialog(EditAggregationExpressionPanel.this.constructTempAggregationElementType(), EditAggregationExpressionPanel.this.mainGroupBy);
                if (aggregateEditMainDialog.invoke(EditAggregationExpressionPanel.this._context, aggregationNode, (AbstractDataNode)abstractNode)) {
                    GroupingElementType groupingElementType = aggregateEditMainDialog.getGroupByElement();
                    boolean bl = AttributeTypeHelper.isValidSubGroupBy(EditAggregationExpressionPanel.this.dataProviderAttributes, groupingElementType);
                    EditAggregationExpressionPanel.this.getLabelSubGroupBy().setIcon(bl ? null : OracleIcons.getIcon((String)"warning.png"));
                    EditAggregationExpressionPanel.this.thisAggregationElement.setSubGroupBy(groupingElementType);
                    EditAggregationExpressionPanel.this.jtxtSubGroupBy.setText(AttributeTypeHelper.convertGroupingElementTypetoString(groupingElementType));
                }
            }
        });
        this.jBtnValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = EditAggregationExpressionPanel.this.jTxtOutput.getText().trim();
                if (string == null || string.length() == 0 || string.length() > 30) {
                    MessageDialog.error((Component)EditAggregationExpressionPanel.this, (Object)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY"), (String)AggregateDialogsLrb.get("OUTPUT_NAME_IS_EMPTY_TITLE"), null);
                    return;
                }
                AggregateValidationProgress.startLongRunningOperation(EditAggregationExpressionPanel.this, true);
            }
        });
        this.jTxtOutput.setText(this.thisAggregationElement.getOutput() != null ? this.thisAggregationElement.getOutput().getName() : "");
        GroupingElementType groupingElementType = this.thisAggregationElement.getSubGroupBy();
        if (groupingElementType != null && groupingElementType.getAttributes() != null) {
            boolean bl = AttributeTypeHelper.isValidSubGroupBy(this.dataProviderAttributes, groupingElementType);
            this.getLabelSubGroupBy().setIcon(bl ? null : OracleIcons.getIcon((String)"warning.png"));
        }
        this.jtxtSubGroupBy.setText(AttributeTypeHelper.convertGroupingElementTypetoString(groupingElementType));
    }

    @Override
    protected String getDialogTitle() {
        return AggregateDialogsLrb.get("EDIT_AGGREGATE_ELEMENT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "aggregation_node_edit_element";
    }
}

