/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.ExceptionDialog;

public class PasteExtendedDialog {
    protected JEWTDialog _dlg;
    protected String wizName = "pasteExtended";
    boolean keepModelNamesUnique = false;

    protected JEWTDialog buildDialog() {
        PasteExtendedPanel pasteExtendedPanel = new PasteExtendedPanel();
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        jEWTDialog.setContent((Component)pasteExtendedPanel);
        jEWTDialog.setTitle(WorkflowDialogLrb.get("EXT_PASTE_TITLE"));
        return jEWTDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke() {
        boolean bl = false;
        try {
            JEWTDialog jEWTDialog = this.buildDialog();
            jEWTDialog.setResizable(true);
            final PasteExtendedPanel pasteExtendedPanel = (PasteExtendedPanel)jEWTDialog.getContent();
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                        if (!pasteExtendedPanel.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                        PasteExtendedDialog.this.keepModelNamesUnique = pasteExtendedPanel.getKeepModelNamesUnique();
                    }
                }
            });
            this._dlg = jEWTDialog;
            if (jEWTDialog != null) {
                bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_TITLE"), (String)BuildEditorLrb.get("DATA_USAGE_DIALOG_FAIL_MSG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        return bl;
    }

    public boolean getKeepModelNamesUnique() {
        return this.keepModelNamesUnique;
    }

    protected void cancel() {
    }

    private static class PasteExtendedPanel
    extends JPanel {
        private boolean keepModelNamesUnique = true;
        private JCheckBox chkKeepNamesUnique;
        private JLabel lblExplanation;

        public PasteExtendedPanel() {
            this.initComponents();
            this.initRes();
            this.initUI();
        }

        private void initComponents() {
            this.chkKeepNamesUnique = new JCheckBox();
            this.lblExplanation = new JLabel();
            this.chkKeepNamesUnique.setText("Keep Model Names Unique");
            this.chkKeepNamesUnique.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.chkKeepNamesUniqueActionPerformed(actionEvent);
                }
            });
            this.lblExplanation.setText("Model names are recommended to have unique names.");
            GroupLayout groupLayout = new GroupLayout(this);
            this.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.chkKeepNamesUnique).addContainerGap(261, Short.MAX_VALUE)).addComponent(this.lblExplanation, GroupLayout.Alignment.TRAILING, -1, 418, Short.MAX_VALUE));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblExplanation).addGap(12, 12, 12).addComponent(this.chkKeepNamesUnique).addContainerGap(37, Short.MAX_VALUE)));
        }

        private void chkKeepNamesUniqueActionPerformed(ActionEvent actionEvent) {
        }

        public void initRes() {
            HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
            hashMap.put("<html>" + WorkflowDialogLrb.get("EXT_PASTE_MSG") + "</html>", this.lblExplanation);
            hashMap.put(WorkflowDialogLrb.get("EXT_PASTE_CHK_LABEL"), this.chkKeepNamesUnique);
            UIResourceHelper.setComponentText(hashMap);
            this.initHelp();
        }

        private void initHelp() {
            HelpUtils.setHelpID((JComponent)this, (String)"pasteExtended");
        }

        public void initUI() {
            this.chkKeepNamesUnique.setSelected(this.keepModelNamesUnique);
        }

        public boolean doWork() {
            this.keepModelNamesUnique = this.chkKeepNamesUnique.isSelected();
            return true;
        }

        public boolean getKeepModelNamesUnique() {
            return this.keepModelNamesUnique;
        }
    }
}

