/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.codegen;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.wizard.AbstractWizardPage;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.GenerateSQLScriptWizardModel;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class GenerateSQLScriptTargetDirPage
extends AbstractWizardPage
implements DataminerGUIPanel {
    private GenerateSQLScriptWizardModel _wizModel;
    private String _workingDirectory;
    private String _scriptDirectory;
    private JTextField jBaseDirectoryField;
    private JLabel jBaseDirectoryLabel;
    private JButton jBrowseButton;
    private JLabel jDirectoryPathLabel;
    private JLabel jDirectoryPathValueLabel;
    private JTextField jScriptDirectoryField;
    private JLabel jScriptDirectoryLabel;

    public GenerateSQLScriptTargetDirPage() {
        this.initComponents();
        this.initRes();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jScriptDirectoryLabel, (Component)this.jScriptDirectoryField, (String)CodeGenLrb.get("TARGET_DIR_PAGE_SCRIPT_DIRECTORY"));
        ResourceUtils.resLabel((JLabel)this.jBaseDirectoryLabel, (Component)this.jBaseDirectoryField, (String)CodeGenLrb.get("TARGET_DIR_PAGE_BASE_DIRECTORY"));
        ResourceUtils.resLabel((JLabel)this.jDirectoryPathLabel, (Component)this.jDirectoryPathValueLabel, (String)CodeGenLrb.get("TARGET_DIR_PAGE_PATH_DIRECTORY"));
        ResourceUtils.resButton((AbstractButton)this.jBrowseButton, (String)CodeGenLrb.get("TARGET_DIR_PAGE_BROWSE"));
    }

    @Override
    public void initUI() {
        this._wizModel = (GenerateSQLScriptWizardModel)this.getTraversableContext().get("wizardModel");
        this._workingDirectory = this._wizModel.getWorkingDirectory();
        this._scriptDirectory = this._wizModel.getScriptDirectory();
        this.jScriptDirectoryField.setText(this._scriptDirectory);
        this.jBaseDirectoryField.setText(this._workingDirectory);
        String string = this._workingDirectory + File.separator + this._scriptDirectory;
        this.jDirectoryPathValueLabel.setText(string);
        this.jDirectoryPathValueLabel.setToolTipText(string);
    }

    @Override
    public String getPageDirtyKey() {
        return "ScriptDirDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        this._workingDirectory = this.jBaseDirectoryField.getText();
        this._workingDirectory = this._workingDirectory.trim();
        String string = File.separator;
        char c = string.charAt(string.length() - 1);
        while (this._workingDirectory.length() > 0 && this._workingDirectory.charAt(this._workingDirectory.length() - 1) == c) {
            this._workingDirectory = this._workingDirectory.substring(0, this._workingDirectory.length() - 1);
        }
        this._scriptDirectory = this.jScriptDirectoryField.getText();
        this._scriptDirectory = this._scriptDirectory.trim();
        String string2 = this._workingDirectory + File.separator + this._scriptDirectory;
        this.jDirectoryPathValueLabel.setText(string2);
        this.jDirectoryPathValueLabel.setToolTipText(string2);
        File file = new File(this._workingDirectory + File.separator + this._scriptDirectory);
        if (file.exists()) {
            MessageDialog.error((Component)((Object)this), (Object)CodeGenLrb.get("TARGET_DIR_PAGE_SCRIPT_DIR_EXIST"), (String)CodeGenLrb.get("GENERATE_SCRIPT_WIZ_TITLE"), null);
            return false;
        }
        this._wizModel.setWorkingDirectory(this._workingDirectory);
        this._wizModel.setScriptDirectory(this._scriptDirectory);
        return true;
    }

    private void initComponents() {
        this.jScriptDirectoryLabel = new JLabel();
        this.jScriptDirectoryField = new JTextField();
        this.jBaseDirectoryLabel = new JLabel();
        this.jBaseDirectoryField = new JTextField();
        this.jBrowseButton = new JButton();
        this.jDirectoryPathLabel = new JLabel();
        this.jDirectoryPathValueLabel = new JLabel();
        this.jScriptDirectoryLabel.setText("Script Directory:");
        this.jScriptDirectoryField.setText("jTextField1");
        this.jBaseDirectoryLabel.setText("Base Directory:");
        this.jBaseDirectoryField.setText("jTextField1");
        this.jBaseDirectoryField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                GenerateSQLScriptTargetDirPage.this.jBaseDirectoryFieldKeyReleased(keyEvent);
            }
        });
        this.jBrowseButton.setText("Browse...");
        this.jBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateSQLScriptTargetDirPage.this.jBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.jDirectoryPathLabel.setText("Directory Path:");
        this.jDirectoryPathValueLabel.setText("Path name");
        this.jDirectoryPathValueLabel.setAutoscrolls(true);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDirectoryPathLabel).addComponent(this.jBaseDirectoryLabel, -2, 103, -2).addComponent(this.jScriptDirectoryLabel)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDirectoryPathValueLabel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScriptDirectoryField).addComponent(this.jBaseDirectoryField, -1, 294, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBrowseButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jScriptDirectoryLabel).addComponent(this.jScriptDirectoryField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBaseDirectoryLabel).addComponent(this.jBaseDirectoryField, -2, -1, -2).addComponent(this.jBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDirectoryPathLabel).addComponent(this.jDirectoryPathValueLabel)).addContainerGap(220, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jBrowseButtonActionPerformed(ActionEvent actionEvent) {
        try {
            URLFileChooser uRLFileChooser = new URLFileChooser();
            uRLFileChooser.setCurrentDirectory(new File(this._workingDirectory));
            uRLFileChooser.setFileSelectionMode(1);
            if (uRLFileChooser.showOpenDialog((Component)((Object)this), CodeGenLrb.get("GENERATE_SCRIPT_CHOOSE_DIR_TITLE")) == 0) {
                File file = uRLFileChooser.getSelectedFile();
                this._workingDirectory = file.getAbsolutePath();
                this._scriptDirectory = this.jScriptDirectoryField.getText();
                this.jBaseDirectoryField.setText(this._workingDirectory);
                String string = this._workingDirectory + File.separator + this._scriptDirectory;
                this.jDirectoryPathValueLabel.setText(string);
                this.jDirectoryPathValueLabel.setToolTipText(string);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
    }

    private void jBaseDirectoryFieldKeyReleased(KeyEvent keyEvent) {
        this._workingDirectory = this.jBaseDirectoryField.getText();
        this._scriptDirectory = this.jScriptDirectoryField.getText();
        String string = this._workingDirectory + File.separator + this._scriptDirectory;
        this.jDirectoryPathValueLabel.setText(string);
        this.jDirectoryPathValueLabel.setToolTipText(string);
    }
}

