/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.copypaste.CopyPastePlugin;
import oracle.diagram.framework.palette.PalettePlugin;
import oracle.diagram.framework.palette.modular.ModularPalettePlugin;
import oracle.diagram.framework.publish.PublishPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerDiagramEditor;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.dprofiler.DataProfilerEditor;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataNode;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.dmt.dataminer.navigator.wflownodes.ColumnFilterNavNode;
import oracle.dmt.dataminer.navigator.wflownodes.DataProfileNavNode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.teditor.ai.AIEditor;
import oracle.dmt.dataminer.teditor.data.DataEditor;
import oracle.dmt.dataminer.teditor.graph.GraphEditor;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.workflow.DynamicMenuLoader;
import oracle.dmt.dataminer.workflow.DynamicWorkflowPalettePages;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowDiagram;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowPalettePageProvider;
import oracle.dmt.dataminer.workflow.WorkflowPalettePages;
import oracle.dmt.dataminer.workflow.codegen.CodeGenerator;
import oracle.dmt.dataminer.workflow.codegen.GenerateCode;
import oracle.dmt.dataminer.workflow.dialog.PasteExtendedDialog;
import oracle.dmt.dataminer.workflow.dialog.ShowMessagesDialog;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationNodeAttributesPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.applyText.ApplyTextPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditDialog;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextPanel;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.OutputColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.columnFilterDetails.OutputSettingPanel;
import oracle.dmt.dataminer.workflow.dialog.data.CreateTableNodeAttributesPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataProfileAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizard;
import oracle.dmt.dataminer.workflow.dialog.data.UpdateTableNodeAttributesPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.anomaly.DynamicAnomalyEditorDlg;
import oracle.dmt.dataminer.workflow.dialog.dynamic.cluster.DynamicClusterEditorDlg;
import oracle.dmt.dataminer.workflow.dialog.dynamic.feature.DynamicFeatureEditorDlg;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionEditorDlg;
import oracle.dmt.dataminer.workflow.dialog.join.JoinEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.model.EditModelNodePanel;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.EditModelDetailsAutoPanel;
import oracle.dmt.dataminer.workflow.dialog.rowFilter.RowFilterEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.sample.SettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.SQLQueryEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.tests.TestModelPanel;
import oracle.dmt.dataminer.workflow.dialog.text.TextPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformSettingsEditorDialog;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.ApplyTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ColumnFilterNode;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.DynamicAnomalyNode;
import oracle.dmt.dataminer.workflow.model.DynamicClusterNode;
import oracle.dmt.dataminer.workflow.model.DynamicFeatureNode;
import oracle.dmt.dataminer.workflow.model.DynamicPredictionNode;
import oracle.dmt.dataminer.workflow.model.FilterDetailsDataNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.GraphNode;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.model.JoinNode;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.RowFilterNode;
import oracle.dmt.dataminer.workflow.model.SQLQueryNode;
import oracle.dmt.dataminer.workflow.model.SampleNode;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.parallelquery.WorkflowParallelQueryEditor;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttrImportantSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeRefType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicAnomalyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicClusterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicFeatureNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicPredictionNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.EditorUtil;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.util.Version;

public class WorkflowContextMenu
implements ContextMenuListener,
Controller,
MenuFilter {
    private static final Logger theLogger = Logger.getLogger(WorkflowContextMenu.class.getName());
    private static volatile WorkflowContextMenu _instance = null;
    private static List<WorkflowMenuItem> menuItems;
    private List<AbstractNode> selectedNodes = new ArrayList<AbstractNode>();
    private int nodesWithChildren = 0;
    private int nodesWithParents = 0;
    private Boolean invalidNodesPresent = false;
    public MenuWeight menuWeights = new MenuWeight();
    private MenuSection lastSectionType = null;
    private static final String GRAPH_CREATE_VIEW_PROMPT_PREF = "graph_create_view_prompt";
    public static final int PRIMARY_EDIT_ACTION_ID;
    public static final int SECONDARY_EDIT_ACTION_ID;
    public static final int GENERATE_APPLY_CHAIN_ID;
    public static final int SWAP_BUILD_TEST_DATA_ID;
    public static final int VALIDATE_ACTION_ID;
    public static final int RUN_ACTION_ID;
    public static final int RUN_FORCE_CHILDREN_ACTION_ID;
    public static final int RUN_FORCE_SELECTED_ACTION_ID;
    public static final int RUN_FORCE_SELECTED_AND_CHILDREN_ACTION_ID;
    public static final int RUN_FORCE_PARENTS_ACTION_ID;
    public static final int VIEW_DATA_ACTION_ID;
    public static final int VIEW_DATA_ACTION2_ID;
    public static final int VIEW_ERROR_STATUS_ID;
    public static final int VIEW_VALIDATIONS_ID;
    public static final int COMPARE_TEST_ID;
    public static final int COPY_SQL_TO_CLIPBOARD_ACTION_ID;
    public static final int COPY_SQL_TO_FILE_ACTION_ID;
    public static final int COPY_PLSQL_TO_CLIPBOARD_ACTION_ID;
    public static final int COPY_PLSQL_TO_FILE_ACTION_ID;
    public static final int GEN_SQL_SCRIPT_NODE_PARENT_ACTION_ID;
    public static final int GEN_SQL_SCRIPT_NODE_PARENT_CHILDREN_ACTION_ID;
    public static final int GEN_SQL_SCRIPT_NODE_ALL_CONNECTED_ACTION_ID;
    public static final int CONNECT_ACTION_ID;
    public static final int GO_TO_PROPERTY_ID;
    public static final int COPY_IMAGE_ID;
    public static final int SAVE_IMAGE_ID;
    public static final int WORKFLOW_PARALLEL_QUERY_ID;
    public static final IdeAction EXTENDED_PASTE_ACTION;
    Map<Integer, IdeAction> registeredActions = new HashMap<Integer, IdeAction>();
    private static boolean inExtendedPaste;
    private static boolean keepModelNamesUnique;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WorkflowContextMenu getInstance() {
        if (_instance != null) return _instance;
        Class<WorkflowContextMenu> clazz = WorkflowContextMenu.class;
        synchronized (WorkflowContextMenu.class) {
            if (_instance != null) return _instance;
            _instance = new WorkflowContextMenu();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private WorkflowContextMenu() {
        this.initMenus();
    }

    private void initMenus() {
        menuItems = Arrays.asList(new WorkflowMenuItem(CONNECT_ACTION_ID, WorkflowEditorLrb.get("CONNECT_NODE"), MenuSection.CONNECT, this), new WorkflowMenuItem(RUN_ACTION_ID, WorkflowEditorLrb.get("RUN"), MenuSection.RUN, this), new WorkflowMenuItem(WorkflowEditorLrb.get("RUN_FORCE_RUN"), MenuSection.RUN, Arrays.asList(new WorkflowMenuItem(RUN_FORCE_SELECTED_ACTION_ID, WorkflowEditorLrb.get("RUN_FORCE_RUN_SELECTED"), MenuSection.RUN, this), new WorkflowMenuItem(RUN_FORCE_SELECTED_AND_CHILDREN_ACTION_ID, WorkflowEditorLrb.get("RUN_FORCE_SELECTED_AND_CHILDREN"), MenuSection.RUN, this), new WorkflowMenuItem(RUN_FORCE_PARENTS_ACTION_ID, WorkflowEditorLrb.get("RUN_FORCE_PARENTS"), MenuSection.RUN, this), new WorkflowMenuItem(RUN_FORCE_CHILDREN_ACTION_ID, WorkflowEditorLrb.get("RUN_FORCE_CHILDREN"), MenuSection.RUN, this))), new WorkflowMenuItem(PRIMARY_EDIT_ACTION_ID, WorkflowEditorLrb.get("EDIT_NODE"), MenuSection.EDIT, this), new WorkflowMenuItem(SECONDARY_EDIT_ACTION_ID, WorkflowEditorLrb.get("EDIT_NODE_ADVANCED"), MenuSection.EDIT, this), new WorkflowMenuItem(VIEW_DATA_ACTION_ID, WorkflowEditorLrb.get("VIEW_DATA"), MenuSection.EDIT, this), new WorkflowMenuItem(VIEW_DATA_ACTION2_ID, "", MenuSection.EDIT, this), new WorkflowMenuItem(SWAP_BUILD_TEST_DATA_ID, WorkflowEditorLrb.get("SWAP"), MenuSection.EDIT, this), new WorkflowMenuItem(WorkflowEditorLrb.get("VIEW_MODELS"), MenuSection.EDIT, new ModelMenuLoader()), new WorkflowMenuItem(WorkflowEditorLrb.get("VIEW_RESULTS"), MenuSection.EDIT, new TestMenuLoader()), new WorkflowMenuItem(COMPARE_TEST_ID, WorkflowEditorLrb.get("VIEW_COMPARE"), MenuSection.EDIT, this), new WorkflowMenuItem(GENERATE_APPLY_CHAIN_ID, WorkflowEditorLrb.get("GENERATE_APPLY_CHAIN"), MenuSection.EDIT, this), new WorkflowMenuItem(VIEW_ERROR_STATUS_ID, WorkflowEditorLrb.get("SHOW_EVENT_LOG"), MenuSection.LOG, this), new WorkflowMenuItem(VIEW_VALIDATIONS_ID, WorkflowEditorLrb.get("VIEW_WARNING_STATUS"), MenuSection.LOG, this), new WorkflowMenuItem(VALIDATE_ACTION_ID, WorkflowEditorLrb.get("CONTEXT_VALIDATE_PARENTS"), MenuSection.LOG, this), new WorkflowMenuItem(WorkflowEditorLrb.get("GENERATE_CODE"), MenuSection.DEPLOY, Arrays.asList(new WorkflowMenuItem(GEN_SQL_SCRIPT_NODE_PARENT_ACTION_ID, WorkflowEditorLrb.get("GENERATE_SQL_SCRIPT_NODE_PARENT"), MenuSection.DEPLOY, this), new WorkflowMenuItem(GEN_SQL_SCRIPT_NODE_PARENT_CHILDREN_ACTION_ID, WorkflowEditorLrb.get("GENERATE_SQL_SCRIPT_NODE_PARENT_CHILDREN"), MenuSection.DEPLOY, this), new WorkflowMenuItem(GEN_SQL_SCRIPT_NODE_ALL_CONNECTED_ACTION_ID, WorkflowEditorLrb.get("GENERATE_SQL_SCRIPT_NODE_ALL_CONNECTED"), MenuSection.DEPLOY, this))), new WorkflowMenuItem(WorkflowEditorLrb.get("GENERATE_SAVE_SQL"), MenuSection.DEPLOY, Arrays.asList(new WorkflowMenuItem(COPY_SQL_TO_CLIPBOARD_ACTION_ID, WorkflowEditorLrb.get("GENERATE_SQL_TO_CLIPBOARD"), MenuSection.DEPLOY, this), new WorkflowMenuItem(COPY_SQL_TO_FILE_ACTION_ID, WorkflowEditorLrb.get("GENERATE_SQL_TO_FILE"), MenuSection.DEPLOY, this), new WorkflowMenuItem(COPY_PLSQL_TO_CLIPBOARD_ACTION_ID, WorkflowEditorLrb.get("GENERATE_SQL_SCRIPT_TO_CLIPBOARD"), MenuSection.DEPLOY, this), new WorkflowMenuItem(COPY_PLSQL_TO_FILE_ACTION_ID, WorkflowEditorLrb.get("GENERATE_SQL_SCRIPT_TO_FILE"), MenuSection.DEPLOY, this))), new WorkflowMenuItem(WORKFLOW_PARALLEL_QUERY_ID, WorkflowEditorLrb.get("WORKFLOW_PARALLEL_MENU"), MenuSection.AUXILIARY, this), new WorkflowMenuItem(COPY_IMAGE_ID, WorkflowEditorLrb.get("CONTEXT_MENU_COPY_IMAGE"), MenuSection.AUXILIARY, this), new WorkflowMenuItem(SAVE_IMAGE_ID, WorkflowEditorLrb.get("CONTEXT_MENU_SAVE_IMAGE"), MenuSection.AUXILIARY, this), new WorkflowMenuItem(GO_TO_PROPERTY_ID, WorkflowEditorLrb.get("GO_TO_PROPERTIES"), MenuSection.AUXILIARY, this), new WorkflowMenuItem(EXTENDED_PASTE_ACTION, MenuSection.STANDARD_EDIT_MENU, this));
    }

    public boolean accept(Component component) {
        AbstractNode abstractNode;
        if (!(component instanceof JMenuItem)) {
            return true;
        }
        JMenuItem jMenuItem = (JMenuItem)component;
        String string = "";
        Action action = jMenuItem.getAction();
        if (action == null) {
            string = jMenuItem.getText();
        }
        int n = 0;
        if (action != null && !(action instanceof IdeAction)) {
            return true;
        }
        if (action != null) {
            IdeAction ideAction = (IdeAction)jMenuItem.getAction();
            n = ideAction.getCommandId();
        }
        boolean bl = this.selectedNodes.size() > 0;
        boolean bl2 = this.selectedNodes.size() == 1;
        AbstractNode abstractNode2 = abstractNode = bl ? this.selectedNodes.get(0) : null;
        if (n == WORKFLOW_PARALLEL_QUERY_ID) {
            return !bl2 || !(abstractNode instanceof BuildTextNodeRef) && !(abstractNode instanceof ModelNode);
        }
        if (n == CONNECT_ACTION_ID) {
            return bl2;
        }
        if (n == GO_TO_PROPERTY_ID) {
            return bl2;
        }
        if (n == PRIMARY_EDIT_ACTION_ID) {
            return bl2 && this.isRequirePrimaryEditMenu(abstractNode.getData());
        }
        if (n == SECONDARY_EDIT_ACTION_ID) {
            return bl2 && this.isRequireSecondaryEditMenu(abstractNode.getData());
        }
        if (n == VIEW_DATA_ACTION_ID) {
            return bl2 && (abstractNode instanceof DataSourceNode || abstractNode instanceof DataProfileNode || abstractNode instanceof CreateTableNode || abstractNode instanceof UpdateTableNode || abstractNode instanceof AbstractTransformNode && !(abstractNode instanceof BuildTextNodeRef));
        }
        if (n == VIEW_DATA_ACTION2_ID) {
            if (!bl2) {
                return false;
            }
            JMenuItem jMenuItem2 = (JMenuItem)component;
            if (abstractNode instanceof DataProfileNode) {
                jMenuItem2.setText(WorkflowEditorLrb.get("VIEW_STATISTICS"));
                return true;
            }
            if (abstractNode instanceof ColumnFilterNode) {
                jMenuItem2.setText(WorkflowEditorLrb.get("VIEW_AI"));
                return true;
            }
            return false;
        }
        if (n == SWAP_BUILD_TEST_DATA_ID) {
            return bl2 && this.isSwappableDataSources(abstractNode);
        }
        if (n == GENERATE_APPLY_CHAIN_ID) {
            return bl;
        }
        if (n == COPY_SQL_TO_CLIPBOARD_ACTION_ID || n == COPY_SQL_TO_FILE_ACTION_ID || n == COPY_PLSQL_TO_CLIPBOARD_ACTION_ID || n == COPY_PLSQL_TO_FILE_ACTION_ID) {
            return bl2 && this.isValidState(abstractNode.getData().getStatus()) != false;
        }
        if (string.equals(WorkflowEditorLrb.get("GENERATE_SAVE_SQL"))) {
            if (!bl2) {
                return false;
            }
            return abstractNode instanceof AbstractDataNode && !(abstractNode instanceof BuildTextNodeRef);
        }
        if (string.equals(WorkflowEditorLrb.get("GENERATE_CODE"))) {
            return bl;
        }
        if (n == RUN_ACTION_ID) {
            return bl;
        }
        if (string.equals(WorkflowEditorLrb.get("RUN_FORCE_RUN"))) {
            return bl;
        }
        if (string.equals(WorkflowEditorLrb.get("VIEW_MODELS"))) {
            if (!bl2) {
                return false;
            }
            return abstractNode instanceof AbstractBuildNode || abstractNode instanceof AbstractModelNode || abstractNode instanceof TestNode;
        }
        if (string.equals(WorkflowEditorLrb.get("VIEW_RESULTS"))) {
            if (!bl2) {
                return false;
            }
            return abstractNode instanceof SupervisedBuildNode || abstractNode instanceof TestNode;
        }
        if (n == COMPARE_TEST_ID) {
            if (!bl2) {
                return false;
            }
            return abstractNode instanceof SupervisedBuildNode || abstractNode instanceof TestNode;
        }
        if (n == VIEW_VALIDATIONS_ID) {
            return bl2 && abstractNode.getData().getStatus().equals((Object)NodeStatusType.INVALID);
        }
        if (n == VALIDATE_ACTION_ID) {
            return bl;
        }
        return true;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public Boolean isValidState(NodeStatusType nodeStatusType) {
        if (nodeStatusType.equals((Object)NodeStatusType.COMPLETE) || nodeStatusType.equals((Object)NodeStatusType.READY) || nodeStatusType.equals((Object)NodeStatusType.WARNING)) {
            return true;
        }
        return false;
    }

    public Boolean isCompleted(NodeStatusType nodeStatusType) {
        return nodeStatusType.equals((Object)NodeStatusType.COMPLETE) || nodeStatusType.equals((Object)NodeStatusType.WARNING);
    }

    public Boolean areAllNodesComplete(List<AbstractNode> list) {
        for (AbstractNode abstractNode : list) {
            if (this.isCompleted(abstractNode.getData().getStatus()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (!(view instanceof WorkflowEditor)) {
            return;
        }
        this.nodesWithChildren = 0;
        this.nodesWithParents = 0;
        this.invalidNodesPresent = false;
        this.selectedNodes.clear();
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Iterator<WorkflowMenuItem> iterator = ilvSDMEngine.getSelectedObjects();
            while (iterator.hasMoreElements()) {
                Object object = iterator.nextElement();
                if (!(object instanceof AbstractNode)) continue;
                this.selectedNodes.add((AbstractNode)object);
            }
        } else {
            return;
        }
        for (AbstractNode abstractNode : this.selectedNodes) {
            if (abstractNode.hasParentNodes()) {
                ++this.nodesWithParents;
            }
            if (abstractNode.hasChildrenNodes()) {
                ++this.nodesWithChildren;
            }
            if (!NodeStatusType.INVALID.equals((Object)abstractNode.getData().getStatus())) continue;
            this.invalidNodesPresent = true;
            break;
        }
        if (ConfigUtils.isDebugBuild()) {
            this.registeredActions.clear();
        }
        this.menuWeights.init();
        for (WorkflowMenuItem workflowMenuItem : menuItems) {
            this.addMenu(workflowMenuItem, contextMenu, this.selectedNodes, true);
        }
    }

    private void addMenu(WorkflowMenuItem workflowMenuItem, ContextMenu contextMenu, List<AbstractNode> list, boolean bl) {
        Object object;
        if (ConfigUtils.isDebugBuild()) {
            object = workflowMenuItem.getAction();
            if (object != null && this.registeredActions.get(object.getCommandId()) != null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Duplicate Action Detected", (String)"Duplicate Action", null);
            }
            if (object != null) {
                this.registeredActions.put(object.getCommandId(), (IdeAction)object);
            }
        }
        object = workflowMenuItem.getType();
        float f = 0.0f;
        if (!((Enum)object).equals((Object)this.lastSectionType)) {
            if (((Enum)object).equals((Object)MenuSection.AUXILIARY)) {
                this.menuWeights.initAuxiliary();
            } else if (((Enum)object).equals((Object)MenuSection.STANDARD_EDIT_MENU)) {
                this.menuWeights.initStandard();
            }
            this.menuWeights.increment();
            this.lastSectionType = object;
        }
        f = this.menuWeights.getWeight();
        contextMenu.add((Component)workflowMenuItem.getMenuComponent(contextMenu), f, bl);
        DynamicMenuLoader dynamicMenuLoader = workflowMenuItem.getDynamicLoader();
        if (dynamicMenuLoader != null) {
            Context context = contextMenu.getContext();
            View view = context.getView();
            dynamicMenuLoader.load(contextMenu, (JMenu)workflowMenuItem.getMenuComponent(contextMenu), view);
        } else if (workflowMenuItem.hasChildren().booleanValue()) {
            for (WorkflowMenuItem workflowMenuItem2 : workflowMenuItem.getChildren()) {
                workflowMenuItem.getMenuComponent(contextMenu).add(workflowMenuItem2.getMenuComponent(contextMenu));
                if (!workflowMenuItem2.hasChildren().booleanValue()) continue;
                this.addChildMenu(workflowMenuItem2, workflowMenuItem, contextMenu, list);
            }
        }
    }

    private void addChildMenu(WorkflowMenuItem workflowMenuItem, WorkflowMenuItem workflowMenuItem2, ContextMenu contextMenu, List<AbstractNode> list) {
        workflowMenuItem2.getMenuComponent(contextMenu).add(workflowMenuItem.getMenuComponent(contextMenu));
        if (workflowMenuItem.hasChildren().booleanValue()) {
            for (WorkflowMenuItem workflowMenuItem3 : workflowMenuItem.getChildren()) {
                if (!workflowMenuItem3.hasChildren().booleanValue()) continue;
                this.addChildMenu(workflowMenuItem3, workflowMenuItem, contextMenu, list);
            }
        }
    }

    private boolean isRequirePrimaryEditMenu(NodeType nodeType) {
        if (nodeType instanceof BuildNodeType) {
            return true;
        }
        if (nodeType instanceof DataSourceNodeType) {
            return true;
        }
        if (nodeType instanceof DataProfileNodeType) {
            return true;
        }
        if (nodeType instanceof CreateTableNodeType) {
            return true;
        }
        if (nodeType instanceof UpdateTableNodeType) {
            return true;
        }
        if (nodeType instanceof ModelDetailsDataNodeType) {
            return true;
        }
        if (nodeType instanceof ModelNodeType) {
            return true;
        }
        if (nodeType instanceof ApplyNodeType) {
            return true;
        }
        if (nodeType instanceof JoinNodeType) {
            return true;
        }
        if (nodeType instanceof TestNodeType) {
            return true;
        }
        if (nodeType instanceof ColumnFilterNodeType) {
            return true;
        }
        if (nodeType instanceof AggregationNodeType) {
            return true;
        }
        if (nodeType instanceof FilterDetailsDataNodeType) {
            return true;
        }
        if (nodeType instanceof SampleNodeType) {
            return true;
        }
        if (nodeType instanceof TransformationNodeType) {
            return true;
        }
        if (nodeType instanceof RowFilterNodeType) {
            return true;
        }
        if (nodeType instanceof BuildTextNodeType) {
            return true;
        }
        if (nodeType instanceof ApplyTextNodeType) {
            return true;
        }
        if (nodeType instanceof BuildTextNodeRefType) {
            return true;
        }
        if (nodeType instanceof DynamicPredictionNodeType) {
            return true;
        }
        if (nodeType instanceof DynamicAnomalyNodeType) {
            return true;
        }
        if (nodeType instanceof DynamicClusterNodeType) {
            return true;
        }
        if (nodeType instanceof DynamicFeatureNodeType) {
            return true;
        }
        if (nodeType instanceof SQLQueryNodeType) {
            return true;
        }
        if (nodeType instanceof GraphNodeType) {
            return true;
        }
        return nodeType instanceof JSONQueryNodeType;
    }

    private boolean isRequireSecondaryEditMenu(NodeType nodeType) {
        return nodeType instanceof BuildNodeType;
    }

    private boolean isSwappableDataSources(AbstractNode abstractNode) {
        SuperviseBuildNodeType superviseBuildNodeType;
        boolean bl = false;
        if (abstractNode instanceof SupervisedBuildNode && (superviseBuildNodeType = (SuperviseBuildNodeType)abstractNode.getData()).getBuildDataSource() != null && superviseBuildNodeType.getTestDataSource().getTestData() != null) {
            bl = true;
        }
        return bl;
    }

    private void loadViewModelsMenuForModelNode(final View view, JMenu jMenu, List<ModelNodeType.Models.Model> list) {
        String string = null;
        try {
            Context context = view.getContext();
            Iterator<ModelNodeType.Models.Model> iterator = (WorkflowNode)context.getNode();
            string = ((WorkflowNode)((Object)iterator)).getConnectionFolder().getUserAccountName();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        boolean bl = false;
        for (ModelNodeType.Models.Model model : list) {
            if (model.getSchema().compareTo(string) == 0) continue;
            bl = true;
            break;
        }
        jMenu.removeAll();
        for (ModelNodeType.Models.Model model : list) {
            String string2 = bl ? model.getSchema() + "." + model.getName() : model.getName();
            JMenuItem jMenuItem = new JMenuItem(string2);
            jMenuItem.getModel().setActionCommand(model.getModelId());
            if (model.getStatus().equals((Object)RefModelStatusType.VALID)) {
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    block7: {
                        try {
                            Object object;
                            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                            String string = actionEvent.getActionCommand();
                            AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(view);
                            if (abstractNode == null) {
                                return;
                            }
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            ModelNodeType.Models.Model model = null;
                            if (abstractNode.getData() instanceof ModelNodeType) {
                                object = (ModelNode)abstractNode;
                                model = MetaDataHelper.getModelUsingId((ModelNode)object, string);
                            }
                            if (model == null) {
                                MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_MODEL_NOT_IN_WORKFLOW"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                                return;
                            }
                            object = model.getSchema();
                            if (model.getMiningAlgorithm().equals((Object)MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
                                LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer(view, model, (String)object, context);
                                loadSVMModelViewer.execute();
                                break block7;
                            }
                            BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, abstractNode.getData().getName(), model.getSchema(), model.getName());
                            if (baseTreeNode != null) {
                                EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)baseTreeNode);
                                break block7;
                            }
                            MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                            return;
                        }
                        catch (Exception exception) {
                            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"), null);
                        }
                    }
                }
            });
            jMenu.add(jMenuItem);
        }
    }

    private void loadViewModelsMenu(final View view, JMenu jMenu, List<ModelType> list) {
        jMenu.removeAll();
        for (ModelType modelType : list) {
            JMenuItem jMenuItem = new JMenuItem(modelType.getName());
            if (modelType.getCreationDate() != null) {
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    block8: {
                        try {
                            Object object;
                            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                            String string = jMenuItem.getText();
                            AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(view);
                            if (abstractNode == null) {
                                return;
                            }
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            ModelType modelType = null;
                            if (abstractNode.getData() instanceof BuildNodeType) {
                                object = (AbstractBuildNode)abstractNode;
                                modelType = MetaDataHelper.getModelType((AbstractBuildNode)object, string);
                            }
                            if (modelType == null) {
                                MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_MODEL_NOT_IN_WORKFLOW"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                                return;
                            }
                            object = workflowNode.getConnectionFolder().getUserAccountName();
                            if (((String)object).equals(((String)object).toUpperCase())) {
                                Object object2 = object = StringUtils.isDoubleQuotedString((String)object) ? StringUtils.trimDoubleQuotes((String)object) : ((String)object).toUpperCase();
                            }
                            if (modelType instanceof CSupportVectorMachineModelType || modelType instanceof RSupportVectorMachineModelType) {
                                LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer(view, modelType, (String)object, context);
                                loadSVMModelViewer.execute();
                                break block8;
                            }
                            BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, abstractNode.getData().getName(), null, string);
                            if (baseTreeNode != null) {
                                EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)baseTreeNode);
                                break block8;
                            }
                            MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                            return;
                        }
                        catch (Exception exception) {
                            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"), null);
                        }
                    }
                }
            });
            jMenu.add(jMenuItem);
        }
    }

    private void loadViewResultsMenu(final View view, JMenu jMenu, List<ModelType> list, List<? extends MiningResultType> list2) {
        jMenu.removeAll();
        HashMap<String, MiningResultType> hashMap = new HashMap<String, MiningResultType>();
        for (MiningResultType miningResultType : list2) {
            hashMap.put(miningResultType.getName(), miningResultType);
        }
        jMenu.setEnabled(hashMap.size() != 0);
        for (ModelType modelType : list) {
            JMenuItem jMenuItem = new JMenuItem(modelType.getName());
            MiningResultType miningResultType = (MiningResultType)hashMap.get(modelType.getName());
            if (miningResultType != null && miningResultType.getCreationDate() != null) {
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    LoadViewResults loadViewResults = new LoadViewResults(jMenuItem, view);
                    loadViewResults.execute();
                }
            });
        }
    }

    private void loadViewTestModelsMenu(final View view, JMenu jMenu, List<TestModelType.Model> list) {
        String string = null;
        try {
            Context context = view.getContext();
            Iterator<TestModelType.Model> iterator = (WorkflowNode)context.getNode();
            string = ((WorkflowNode)((Object)iterator)).getConnectionFolder().getUserAccountName();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        boolean bl = false;
        for (TestModelType.Model model : list) {
            if (model.getSchema().compareTo(string) == 0) continue;
            bl = true;
            break;
        }
        jMenu.removeAll();
        for (TestModelType.Model model : list) {
            String string2 = bl ? model.getSchema() + "." + model.getName() : model.getName();
            JMenuItem jMenuItem = new JMenuItem(string2);
            jMenuItem.getModel().setActionCommand(model.getModelId());
            jMenuItem.setEnabled(true);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    block7: {
                        try {
                            Object object;
                            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                            String string = actionEvent.getActionCommand();
                            AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(view);
                            if (abstractNode == null) {
                                return;
                            }
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            TestModelType.Model model = null;
                            if (abstractNode.getData() instanceof TestNodeType) {
                                object = (TestNode)abstractNode;
                                model = MetaDataHelper.getModelUsingId((TestNode)object, string);
                            }
                            if (model == null) {
                                MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_MODEL_NOT_IN_WORKFLOW"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                                return;
                            }
                            object = model.getSchema();
                            if (model.getMiningAlgorithm().equals((Object)MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
                                LoadSVMModelViewer loadSVMModelViewer = new LoadSVMModelViewer(view, model, (String)object, context);
                                loadSVMModelViewer.execute();
                                break block7;
                            }
                            BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, abstractNode.getData().getName(), model.getSchema(), model.getName());
                            if (baseTreeNode != null) {
                                EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)baseTreeNode);
                                break block7;
                            }
                            MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                            return;
                        }
                        catch (Exception exception) {
                            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"), null);
                        }
                    }
                }
            });
            jMenu.add(jMenuItem);
        }
    }

    private void loadViewTestResultsMenu(final View view, JMenu jMenu, List<TestModelType.Model> list, List<? extends MiningResultType> list2) {
        HashMap<String, MiningResultType> hashMap;
        String string = null;
        try {
            Context context = view.getContext();
            hashMap = (WorkflowNode)context.getNode();
            string = ((WorkflowNode)((Object)hashMap)).getConnectionFolder().getUserAccountName();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        boolean bl = false;
        for (TestModelType.Model object : list) {
            if (object.getSchema().compareTo(string) == 0) continue;
            bl = true;
            break;
        }
        jMenu.removeAll();
        hashMap = new HashMap<String, MiningResultType>();
        for (MiningResultType miningResultType : list2) {
            hashMap.put(miningResultType.getModelId(), miningResultType);
        }
        jMenu.setEnabled(hashMap.size() != 0);
        for (TestModelType.Model model : list) {
            String string2 = bl ? model.getSchema() + "." + model.getName() : model.getName();
            JMenuItem jMenuItem = new JMenuItem(string2);
            jMenuItem.getModel().setActionCommand(model.getModelId());
            MiningResultType miningResultType = (MiningResultType)hashMap.get(model.getModelId());
            if (miningResultType != null && miningResultType.getCreationDate() != null) {
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        String string = jMenuItem.getText();
                        AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(view);
                        if (abstractNode == null) {
                            return;
                        }
                        String string2 = actionEvent.getActionCommand();
                        TestNode testNode = (TestNode)abstractNode;
                        TestResultNode testResultNode = null;
                        TestNodeType testNodeType = (TestNodeType)testNode.getData();
                        if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                            List<ClassificationResultType> list = MetaDataHelper.getClassResultsCollection(testNode);
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            String string3 = workflowNode.getConnectionFolder().getUserAccountName();
                            ClassificationResultType classificationResultType = null;
                            block2: for (ClassificationResultType classificationResultType2 : list) {
                                if (!classificationResultType2.getModelId().equals(string2)) continue;
                                classificationResultType = classificationResultType2;
                                for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
                                    if (!model.getModelId().equals(string2)) continue;
                                    string3 = model.getSchema();
                                    break block2;
                                }
                            }
                            testResultNode = WorkflowContextMenu.createClassTestResultNode(context, workflowNode, string3, string, testNodeType, classificationResultType);
                        } else if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                            List<RegressionResultType> list = MetaDataHelper.getRegressResultsCollection(testNode);
                            Context context = view.getContext();
                            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                            String string4 = workflowNode.getConnectionFolder().getUserAccountName();
                            RegressionResultType regressionResultType = null;
                            block4: for (RegressionResultType regressionResultType2 : list) {
                                if (!regressionResultType2.getName().equals(string)) continue;
                                regressionResultType = regressionResultType2;
                                for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
                                    if (!model.getModelId().equals(string2)) continue;
                                    string4 = model.getSchema();
                                    break block4;
                                }
                            }
                            testResultNode = WorkflowContextMenu.createRegressTestResultNode(context, workflowNode, string4, string, testNodeType, regressionResultType);
                        }
                        if (testResultNode == null) {
                            MessageDialog.error((Component)jMenuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                            return;
                        }
                        EditorUtil.openDefaultEditorInFrame(testResultNode);
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
            });
        }
    }

    private AbstractNode getSelectedDiagramNode(View view) {
        Enumeration enumeration;
        Object e;
        IlvManagerView ilvManagerView;
        IlvSDMEngine ilvSDMEngine;
        AbstractNode abstractNode = null;
        if (view instanceof WorkflowEditor && (ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)(ilvManagerView = ((DiagramView)view).getActiveManagerView()))) != null && (e = (enumeration = ilvSDMEngine.getSelectedObjects()).nextElement()) instanceof AbstractNode) {
            abstractNode = (AbstractNode)e;
        }
        return abstractNode;
    }

    public static TestResultNode createClassTestResultNode(Context context, WorkflowNode workflowNode, String string, String string2, ClassificationBuildNodeType classificationBuildNodeType, ClassificationResultType classificationResultType) throws Exception {
        TestResultNode testResultNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Result" + "/" + string2));
        testResultNode = (TestResultNode)NodeFactory.findOrCreate(TestResultNode.class, (URL)uRL);
        if (testResultNode != null) {
            testResultNode.setRepositoryData(new ClassTestResult(context, (BuildNodeType)classificationBuildNodeType, (MiningResultType)classificationResultType));
            testResultNode.setURL(uRL);
            testResultNode.setResultName(string2);
            testResultNode.setUserName(string);
            testResultNode.setContext(context);
            testResultNode.setConnectionFolder(connectionFolder);
            testResultNode.setClassificationTest(true);
            testResultNode.setParentClassificationNodeId(classificationBuildNodeType.getId());
        }
        return testResultNode;
    }

    public static TestCompareNode createClassTestCompareNode(Context context, WorkflowNode workflowNode, ClassificationBuildNodeType classificationBuildNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + classificationBuildNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new ClassTestResult(context, (BuildNodeType)classificationBuildNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
            testCompareNode.setClassificationTest(true);
            testCompareNode.setParentNodeId(classificationBuildNodeType.getId());
        }
        return testCompareNode;
    }

    public static TestResultNode createRegressTestResultNode(Context context, WorkflowNode workflowNode, String string, String string2, RegressionBuildNodeType regressionBuildNodeType, RegressionResultType regressionResultType) throws Exception {
        TestResultNode testResultNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Result" + "/" + string2));
        testResultNode = (TestResultNode)NodeFactory.findOrCreate(TestResultNode.class, (URL)uRL);
        if (testResultNode != null) {
            testResultNode.setRepositoryData(new RegressTestResult(context, (BuildNodeType)regressionBuildNodeType, (MiningResultType)regressionResultType));
            testResultNode.setURL(uRL);
            testResultNode.setResultName(string2);
            testResultNode.setUserName(string);
            testResultNode.setContext(context);
            testResultNode.setConnectionFolder(connectionFolder);
            testResultNode.setClassificationTest(false);
            testResultNode.setParentClassificationNodeId(regressionBuildNodeType.getId());
        }
        return testResultNode;
    }

    public static TestCompareNode createRegressTestCompareNode(Context context, WorkflowNode workflowNode, String string, RegressionBuildNodeType regressionBuildNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + regressionBuildNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new RegressTestResult(context, (BuildNodeType)regressionBuildNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
            testCompareNode.setClassificationTest(false);
            testCompareNode.setParentNodeId(regressionBuildNodeType.getId());
        }
        return testCompareNode;
    }

    public static TestResultNode createClassTestResultNode(Context context, WorkflowNode workflowNode, String string, String string2, TestNodeType testNodeType, ClassificationResultType classificationResultType) throws Exception {
        TestResultNode testResultNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Result" + "/" + string + "/" + string2));
        testResultNode = (TestResultNode)NodeFactory.findOrCreate(TestResultNode.class, (URL)uRL);
        if (testResultNode != null) {
            testResultNode.setRepositoryData(new ClassTestResult(context, testNodeType, (MiningResultType)classificationResultType));
            testResultNode.setURL(uRL);
            testResultNode.setResultName(string2);
            testResultNode.setUserName(string);
            testResultNode.setContext(context);
            testResultNode.setConnectionFolder(connectionFolder);
            testResultNode.setClassificationTest(true);
            testResultNode.setParentClassificationNodeId(testNodeType.getId());
        }
        return testResultNode;
    }

    public static TestCompareNode createClassTestCompareNode(Context context, WorkflowNode workflowNode, String string, TestNodeType testNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + testNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new ClassTestResult(context, testNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
            testCompareNode.setClassificationTest(true);
            testCompareNode.setParentNodeId(testNodeType.getId());
        }
        return testCompareNode;
    }

    public static TestResultNode createRegressTestResultNode(Context context, WorkflowNode workflowNode, String string, String string2, TestNodeType testNodeType, RegressionResultType regressionResultType) throws Exception {
        TestResultNode testResultNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Result" + "/" + string + "/" + string2));
        testResultNode = (TestResultNode)NodeFactory.findOrCreate(TestResultNode.class, (URL)uRL);
        if (testResultNode != null) {
            testResultNode.setRepositoryData(new RegressTestResult(context, testNodeType, (MiningResultType)regressionResultType));
            testResultNode.setURL(uRL);
            testResultNode.setResultName(string2);
            testResultNode.setUserName(string);
            testResultNode.setContext(context);
            testResultNode.setConnectionFolder(connectionFolder);
            testResultNode.setClassificationTest(false);
            testResultNode.setParentClassificationNodeId(testNodeType.getId());
        }
        return testResultNode;
    }

    public static TestCompareNode createRegressTestCompareNode(Context context, WorkflowNode workflowNode, String string, TestNodeType testNodeType, List<? extends MiningResultType> list) throws Exception {
        TestCompareNode testCompareNode = null;
        ConnectionFolder connectionFolder = workflowNode.getConnectionFolder();
        URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)(workflowNode.getURL().getPath() + "/" + "Compare" + "/" + testNodeType.getName()));
        testCompareNode = (TestCompareNode)NodeFactory.findOrCreate(TestCompareNode.class, (URL)uRL);
        if (testCompareNode != null) {
            ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
            for (MiningResultType miningResultType : list) {
                arrayList.add(new RegressTestResult(context, testNodeType, miningResultType));
            }
            testCompareNode.setTestResults(arrayList);
            testCompareNode.setURL(uRL);
            testCompareNode.setContext(context);
            testCompareNode.setConnectionFolder(connectionFolder);
            testCompareNode.setClassificationTest(false);
            testCompareNode.setParentNodeId(testNodeType.getId());
        }
        return testCompareNode;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void handlePrimaryEdit(Context context, WorkflowEditor workflowEditor) throws Exception {
        if (null == workflowEditor.getSelectedDiagramNode()) {
            return;
        }
        AbstractNode abstractNode = (AbstractNode)workflowEditor.getSelectedDiagramNode();
        if (abstractNode instanceof AbstractBuildNode) {
            AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
            BuildEditDialog buildEditDialog = new BuildEditDialog();
            buildEditDialog.invoke(context, abstractBuildNode, new ArrayList<String>());
        } else if (abstractNode instanceof AbstractModelNode) {
            AbstractModelNode abstractModelNode = (AbstractModelNode)abstractNode;
            EditModelNodePanel editModelNodePanel = new EditModelNodePanel(context, abstractModelNode, null);
            editModelNodePanel.showAsDialog();
        } else if (abstractNode instanceof ModelDetailsDataNode) {
            ModelDetailsDataNode modelDetailsDataNode = (ModelDetailsDataNode)abstractNode;
            EditModelDetailsAutoPanel editModelDetailsAutoPanel = new EditModelDetailsAutoPanel(context, modelDetailsDataNode);
            editModelDetailsAutoPanel.showAsDialog();
        } else if (abstractNode instanceof ApplyNode) {
            ApplyNode applyNode = (ApplyNode)abstractNode;
            ApplyEditorPanel applyEditorPanel = new ApplyEditorPanel(context, applyNode, null);
            applyEditorPanel.showAsDialog();
        } else if (abstractNode instanceof JoinNode) {
            JoinNode joinNode = (JoinNode)abstractNode;
            JoinEditorPanel joinEditorPanel = new JoinEditorPanel(context, joinNode, null);
            joinEditorPanel.showAsDialog();
        } else if (abstractNode instanceof ColumnFilterNode) {
            ColumnFilterNode columnFilterNode = (ColumnFilterNode)abstractNode;
            OutputColumnPanel outputColumnPanel = new OutputColumnPanel(context, columnFilterNode, (OutputColumnPanel)null);
            outputColumnPanel.showAsDialog();
        } else if (abstractNode instanceof FilterDetailsDataNode) {
            FilterDetailsDataNode filterDetailsDataNode = (FilterDetailsDataNode)abstractNode;
            OutputSettingPanel outputSettingPanel = new OutputSettingPanel(context, filterDetailsDataNode);
            outputSettingPanel.showAsDialog();
        } else if (abstractNode instanceof TestNode) {
            TestNode testNode = (TestNode)abstractNode;
            TestModelPanel testModelPanel = new TestModelPanel(context, testNode, null);
            testModelPanel.showAsDialog();
        } else if (abstractNode instanceof DataProfileNode) {
            DataProfileAttributesDialog dataProfileAttributesDialog = new DataProfileAttributesDialog();
            AbstractNode abstractNode2 = abstractNode.findParentNode();
            dataProfileAttributesDialog.invoke(context, (DataProfileNode)abstractNode, (AbstractDataNode)abstractNode2);
        } else if (abstractNode instanceof CreateTableNode) {
            CreateTableNodeAttributesPanel createTableNodeAttributesPanel = new CreateTableNodeAttributesPanel(context, (CreateTableNode)abstractNode);
            createTableNodeAttributesPanel.showAsDialog();
        } else if (abstractNode instanceof UpdateTableNode) {
            UpdateTableNodeAttributesPanel.UpdateNodeColumnInfo updateNodeColumnInfo = UpdateTableNodeAttributesPanel.getAvailableUpdateNodeColumnInfo(context, (UpdateTableNode)abstractNode);
            UpdateTableNodeAttributesPanel updateTableNodeAttributesPanel = new UpdateTableNodeAttributesPanel(context, (UpdateTableNode)abstractNode, updateNodeColumnInfo);
            updateTableNodeAttributesPanel.showAsDialog();
        } else if (abstractNode instanceof TransformationNode) {
            TransformSettingsEditorDialog transformSettingsEditorDialog = new TransformSettingsEditorDialog();
            AbstractNode abstractNode3 = abstractNode.findParentNode();
            transformSettingsEditorDialog.invoke(context, (TransformationNode)abstractNode, (AbstractDataNode)abstractNode3);
        } else if (abstractNode instanceof DataSourceNode) {
            DataSourceNode dataSourceNode = (DataSourceNode)abstractNode;
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
            boolean bl = false;
            if (dataSourceNodeType.getSourceTable() != null && dataSourceNodeType.getSourceTable().getName() != null && dataSourceNodeType.getSourceTable().getName().length() != 0) {
                bl = true;
            }
            if (bl) {
                DataSourceAttributesDialog dataSourceAttributesDialog = new DataSourceAttributesDialog();
                dataSourceAttributesDialog.setShowChangeDs(true);
                if (!dataSourceAttributesDialog.invoke(context, dataSourceNode) && null != dataSourceAttributesDialog.getErrorMessage()) {
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)dataSourceAttributesDialog.getErrorMessage(), (String)DataDialogsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), null)) {
                        DataSourceWizard dataSourceWizard = new DataSourceWizard();
                        dataSourceWizard.setTableExists(false);
                        dataSourceWizard.runWizard((Component)Ide.getMainWindow(), context, dataSourceNode);
                    } else {
                        dataSourceAttributesDialog = new DataSourceAttributesDialog();
                        dataSourceAttributesDialog.setCheckForUnderlyingTable(false);
                        dataSourceAttributesDialog.invoke(context, dataSourceNode);
                    }
                }
            } else {
                DataSourceWizard dataSourceWizard = new DataSourceWizard();
                dataSourceWizard.runWizard((Component)Ide.getMainWindow(), context, dataSourceNode);
            }
        } else if (abstractNode instanceof AggregationNode) {
            AggregationNodeAttributesPanel aggregationNodeAttributesPanel = new AggregationNodeAttributesPanel(context, (AggregationNode)abstractNode);
            aggregationNodeAttributesPanel.showAsDialog();
        } else if (abstractNode instanceof SampleNode) {
            SampleNode sampleNode = (SampleNode)abstractNode;
            SettingsPanel settingsPanel = new SettingsPanel(context, sampleNode);
            settingsPanel.showAsDialog();
        } else if (abstractNode instanceof RowFilterNode) {
            RowFilterNode rowFilterNode = (RowFilterNode)abstractNode;
            RowFilterEditorPanel rowFilterEditorPanel = new RowFilterEditorPanel(context, rowFilterNode, null);
            rowFilterEditorPanel.showAsDialog();
        } else if (abstractNode instanceof BuildTextNode) {
            BuildTextNode buildTextNode = (BuildTextNode)abstractNode;
            BuildTextPanel buildTextPanel = new BuildTextPanel(context, buildTextNode);
            buildTextPanel.showAsDialog();
        } else if (abstractNode instanceof ApplyTextNode) {
            ApplyTextNode applyTextNode = (ApplyTextNode)abstractNode;
            ApplyTextPanel applyTextPanel = new ApplyTextPanel(context, applyTextNode);
            applyTextPanel.showAsDialog();
        } else if (abstractNode instanceof BuildTextNodeRef) {
            BuildTextNodeRef buildTextNodeRef = (BuildTextNodeRef)abstractNode;
            TextPanel textPanel = new TextPanel(context, buildTextNodeRef);
            textPanel.showAsDialog();
        } else if (abstractNode instanceof DynamicPredictionNode) {
            PredictionEditorDlg predictionEditorDlg = new PredictionEditorDlg();
            AbstractNode abstractNode4 = abstractNode.findParentNode();
            predictionEditorDlg.invoke(context, (DynamicPredictionNode)abstractNode, (AbstractDataNode)abstractNode4);
        } else if (abstractNode instanceof DynamicClusterNode) {
            DynamicClusterEditorDlg dynamicClusterEditorDlg = new DynamicClusterEditorDlg();
            AbstractNode abstractNode5 = abstractNode.findParentNode();
            dynamicClusterEditorDlg.invoke(context, (DynamicClusterNode)abstractNode, (AbstractDataNode)abstractNode5);
        } else if (abstractNode instanceof DynamicAnomalyNode) {
            DynamicAnomalyEditorDlg dynamicAnomalyEditorDlg = new DynamicAnomalyEditorDlg();
            AbstractNode abstractNode6 = abstractNode.findParentNode();
            dynamicAnomalyEditorDlg.invoke(context, (DynamicAnomalyNode)abstractNode, (AbstractDataNode)abstractNode6);
        } else if (abstractNode instanceof DynamicFeatureNode) {
            DynamicFeatureEditorDlg dynamicFeatureEditorDlg = new DynamicFeatureEditorDlg();
            AbstractNode abstractNode7 = abstractNode.findParentNode();
            dynamicFeatureEditorDlg.invoke(context, (DynamicFeatureNode)abstractNode, (AbstractDataNode)abstractNode7);
        } else if (abstractNode instanceof SQLQueryNode) {
            SQLQueryNode sQLQueryNode = (SQLQueryNode)abstractNode;
            SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)sQLQueryNode.getData();
            SQLContext sQLContext = new SQLContext(context, sQLQueryNode.findSourceNodes(), sQLQueryNode, sQLQueryNodeType.getSQLQueryExpression(), false);
            sQLContext.setHasWithClause(sQLQueryNodeType.isHasWithClause());
            sQLContext.setGenerateView(sQLQueryNodeType.isGenerateView());
            sQLContext.setName(sQLQueryNodeType.getViewName());
            SQLQueryEditorPanel sQLQueryEditorPanel = new SQLQueryEditorPanel(sQLContext, null);
            sQLQueryEditorPanel.showAsDialog((Component)Ide.getMainWindow());
        } else if (abstractNode instanceof GraphNode) {
            this.handleViewGraphAction(context, workflowEditor);
        } else if (abstractNode instanceof JSONQueryNode) {
            AbstractNode abstractNode8 = abstractNode.findParentNode();
            JSONQueryEditorPanel jSONQueryEditorPanel = new JSONQueryEditorPanel(context, (JSONQueryNode)abstractNode, (AbstractDataNode)abstractNode8);
            jSONQueryEditorPanel.showAsDialog((Component)Ide.getMainWindow());
        } else {
            theLogger.log(Level.SEVERE, "Node type: " + abstractNode.getClass().getName() + " not handled in WorflowContextMenu.handlePrimaryEdit ()");
        }
    }

    private void handleSecondaryEdit(Context context, WorkflowEditor workflowEditor) throws Exception {
        if (null == workflowEditor.getSelectedDiagramNode()) {
            return;
        }
        AbstractNode abstractNode = (AbstractNode)workflowEditor.getSelectedDiagramNode();
        if (abstractNode instanceof AbstractBuildNode) {
            AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
            AdvancedSettingsPanel advancedSettingsPanel = new AdvancedSettingsPanel(context, abstractBuildNode, null, null);
            advancedSettingsPanel.showAsDialog();
        } else {
            theLogger.log(Level.SEVERE, "Node type: " + abstractNode.getClass().getName() + " not handled in WorflowContextMenu.handleSecondaryEdit ()");
        }
    }

    private void handleSwapTestData(WorkflowEditor workflowEditor) throws Exception {
        GeneralLink generalLink = workflowEditor.getSelectedDiagramLink();
        AbstractNode abstractNode = (AbstractNode)workflowEditor.getSelectedDiagramNode();
        if (generalLink == null && abstractNode == null) {
            return;
        }
        if (generalLink != null) {
            abstractNode = (AbstractNode)generalLink.getTo();
        }
        if (abstractNode == null) {
            return;
        }
        if (!(abstractNode instanceof SupervisedBuildNode)) {
            return;
        }
        SupervisedBuildNode supervisedBuildNode = (SupervisedBuildNode)abstractNode;
        try {
            CommandProcessor.getInstance().beginTrans(WorkflowEditorLrb.get("SWAP"));
            supervisedBuildNode.swapDataSources();
            CommandProcessor.getInstance().endTrans();
        }
        catch (Exception exception) {
            CommandProcessor.getInstance().abortTrans();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
    }

    private void handleForceRunParentsAction(WorkflowEditor workflowEditor) throws Exception {
        if (!this.validToRun(workflowEditor, true, true)) {
            return;
        }
        StartWorkflowProgressRunnable startWorkflowProgressRunnable = new StartWorkflowProgressRunnable(workflowEditor, true, Workflow.RunMode.RUN);
        startWorkflowProgressRunnable.start(true);
    }

    private void handleForceRunChildrenAction(WorkflowEditor workflowEditor) throws Exception {
        if (!this.validToRun(workflowEditor, false, false)) {
            return;
        }
        StartWorkflowProgressRunnable startWorkflowProgressRunnable = new StartWorkflowProgressRunnable(workflowEditor);
        startWorkflowProgressRunnable.start(true);
    }

    private void handleForceRunSelectedAndChildrenAction(WorkflowEditor workflowEditor) throws Exception {
        if (!this.validToRun(workflowEditor, false, true)) {
            return;
        }
        StartWorkflowProgressRunnable startWorkflowProgressRunnable = new StartWorkflowProgressRunnable(workflowEditor);
        startWorkflowProgressRunnable.start(true);
    }

    public static void handleRunAction(WorkflowEditor workflowEditor, Node node, boolean bl, Workflow.RunMode runMode) throws Exception {
        Object object22;
        List<Object> list = new ArrayList<Node>();
        if (node == null) {
            list = workflowEditor.getSelectedDiagramNodes();
        } else {
            list.add(node);
        }
        List<Object> list2 = list;
        for (Object object22 : list2) {
            if (object22.validateRunChain(false)) continue;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_RUN_CHAIN_INVALID"), (String)WorkflowEditorLrb.get("NODES_IN_RUN_ERROR_TITLE"), null);
            return;
        }
        boolean bl2 = false;
        for (Node node2 : list2) {
            NodeType nodeType = node2.getData();
            if ((nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING)) && !bl2) {
                if (bl || MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODE_IS_ALREADY_COMPLETE"), (String)WorkflowEditorLrb.get("RUN_NODE_WARNING_TITLE"), null)) {
                    bl2 = true;
                } else {
                    return;
                }
            }
            if (!bl2 || runMode == Workflow.RunMode.VALIDATE) continue;
            node2.setNodeReady();
        }
        object22 = new StartWorkflowProgressRunnable(workflowEditor, true, runMode);
        object22.start(true);
    }

    public static void handleRunAction(WorkflowEditor workflowEditor, boolean bl) throws Exception {
        WorkflowContextMenu.handleRunAction(workflowEditor, null, bl);
    }

    public static void handleRunAction(WorkflowEditor workflowEditor, Node node, boolean bl) throws Exception {
        WorkflowContextMenu.handleRunAction(workflowEditor, node, bl, Workflow.RunMode.RUN);
    }

    public static void handleGenerateCodeAction(Context context, WorkflowEditor workflowEditor, GenerateCode.CODE_GENERATION_OPTION cODE_GENERATION_OPTION) throws Exception {
        boolean bl = false;
        Node node = null;
        try {
            node = workflowEditor.getSelectedDiagramNode();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        if (!node.validateLineageChain()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_CHAIN_INVALID"), (String)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_ERROR_TITLE"), null);
            return;
        }
        GenerateCode generateCode = new GenerateCode(context, workflowEditor.getSelectedDiagramNode(), workflowEditor, cODE_GENERATION_OPTION);
        if (cODE_GENERATION_OPTION.equals((Object)GenerateCode.CODE_GENERATION_OPTION.SQL_SCRIPT_TO_CLIPBOARD) || cODE_GENERATION_OPTION.equals((Object)GenerateCode.CODE_GENERATION_OPTION.SQL_TO_CLIPBOARD)) {
            class GenCodeProcess
            extends ProgressRunnable {
                GenerateCode _codeGen;
                Boolean _success = false;

                GenCodeProcess(GenerateCode generateCode) {
                    this._codeGen = generateCode;
                }

                protected Object doWork() throws Exception {
                    this._success = this._codeGen.run();
                    return this._success;
                }

                public boolean isSuccessful() {
                    return this._success;
                }
            }
            GenCodeProcess genCodeProcess = new GenCodeProcess(generateCode);
            genCodeProcess.setTitle(WorkflowEditorLrb.get("GENERATING_CODE"));
            genCodeProcess.setMessage(WorkflowEditorLrb.get("GENERATING_CODE_DESCR"));
            genCodeProcess.setCancelable(false);
            genCodeProcess.start(true);
            bl = genCodeProcess.isSuccessful();
        } else {
            bl = generateCode.run();
        }
        if (!bl) {
            if (generateCode.getException() != null) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)generateCode.getException(), (String)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_ERROR_TITLE"), (String)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_CHAIN_UNEXPECTED"));
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_CHAIN_UNEXPECTED"), (String)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_ERROR_TITLE"), null);
            }
        }
    }

    public static void handleGenerateScriptAction(Context context, WorkflowEditor workflowEditor, CodeGenerator.CODE_GENERATION_OPTION cODE_GENERATION_OPTION) throws Exception {
        boolean bl = false;
        CodeGenerator codeGenerator = new CodeGenerator(context, workflowEditor.getSelectedDiagramNodes(), workflowEditor, cODE_GENERATION_OPTION);
        if (!codeGenerator.validateLineageChain()) {
            String string = null;
            if (cODE_GENERATION_OPTION.equals((Object)CodeGenerator.CODE_GENERATION_OPTION.NODE_PARENT)) {
                string = WorkflowEditorLrb.get("GENERATE_SCRIPT_PARENT_CHAIN_INVALID");
            }
            if (cODE_GENERATION_OPTION.equals((Object)CodeGenerator.CODE_GENERATION_OPTION.NODE_PARENT_CHILDREN)) {
                string = WorkflowEditorLrb.get("GENERATE_SCRIPT_PARENT_CHILDREN_CHAIN_INVALID");
            }
            if (cODE_GENERATION_OPTION.equals((Object)CodeGenerator.CODE_GENERATION_OPTION.NODE_ALL_CONNECTED)) {
                string = WorkflowEditorLrb.get("GENERATE_SCRIPT_CONNECTED_CHAIN_INVALID");
            }
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_ERROR_TITLE"), null);
            return;
        }
        bl = codeGenerator.run();
        if (!bl) {
            if (codeGenerator.getException() != null) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)codeGenerator.getException(), (String)WorkflowEditorLrb.get("NODES_IN_SCRIPT_GEN_ERROR_TITLE"), (String)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_CHAIN_UNEXPECTED"));
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_CODE_GEN_CHAIN_UNEXPECTED"), (String)WorkflowEditorLrb.get("NODES_IN_SCRIPT_GEN_ERROR_TITLE"), null);
            }
        }
    }

    private void handleNodeSpecificViewDataAction(Context context, WorkflowEditor workflowEditor) throws Exception {
        Node node = workflowEditor.getSelectedDiagramNode();
        if (node == null) {
            return;
        }
        this.launchNodeSpecificDataViewer((AbstractDataNode)node, context);
    }

    private void handleViewDataAction(Context context, WorkflowEditor workflowEditor) throws Exception {
        Node node = workflowEditor.getSelectedDiagramNode();
        if (node == null) {
            return;
        }
        this.launchDataViewer((AbstractDataNode)node, context);
    }

    private void handleViewGraphAction(Context context, WorkflowEditor workflowEditor) throws Exception {
        Node node = workflowEditor.getSelectedDiagramNode();
        if (node == null) {
            return;
        }
        if ((node instanceof DataProvider || node instanceof GraphNode) && !this.initGraphData(node, context)) {
            return;
        }
        WorkflowContextMenu.openInGraphEditor((AbstractNode)node, context);
    }

    private boolean initGraphData(Node node, Context context) {
        NodeType nodeType = node.getData();
        AbstractNode abstractNode = node.findParentNode();
        if (node instanceof GraphNode && abstractNode == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)GraphLrb.get("MISSING_DATA_NODE"), (String)GraphLrb.get("NO_SAMPLE_TITLE"), null);
            return false;
        }
        if (nodeType instanceof GraphNodeType) {
            boolean bl;
            GraphNodeType graphNodeType = (GraphNodeType)nodeType;
            if (graphNodeType.getViewName() == null && !(bl = MessageDialog.optionalConfirm((String)GRAPH_CREATE_VIEW_PROMPT_PREF, (Component)Ide.getMainWindow(), (Object)GraphLrb.get("GRAPH_PROMPT_TO_SAVE"), (String)GraphLrb.get("GRAPH_PROMPT_TO_SAVE_TITLE"), null))) {
                return false;
            }
            if (graphNodeType.getViewName() == null || graphNodeType.isViewDirty().booleanValue()) {
                GraphNode graphNode = (GraphNode)node;
                try {
                    graphNode.findOrCreateView(context);
                }
                catch (Exception exception) {
                    if (exception instanceof SQLException) {
                        SQLException sQLException = (SQLException)exception;
                        if (sQLException.getErrorCode() == 942) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)GraphLrb.get("INVALID_DATA"), (String)GraphLrb.get("NO_SAMPLE_TITLE"), null);
                        } else {
                            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                        }
                    } else {
                        if (exception instanceof GraphNode.ViewCreationNotPossibleException) {
                            return false;
                        }
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isExtendedPaste() {
        return inExtendedPaste;
    }

    public static boolean getKeepModelNamesUnique() {
        return keepModelNamesUnique;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Object object;
        inExtendedPaste = false;
        final View view = context.getView();
        if (!(view instanceof WorkflowEditor)) {
            return false;
        }
        WorkflowEditor workflowEditor = (WorkflowEditor)view;
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        ArrayList<GeneralLink> arrayList2 = new ArrayList<GeneralLink>();
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine == null) {
            return true;
        }
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof AbstractNode) {
                arrayList.add((AbstractNode)object);
                continue;
            }
            if (!(object instanceof GeneralLink)) continue;
            arrayList2.add((GeneralLink)object);
        }
        if (ideAction.getCommandId() == COPY_IMAGE_ID) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataMinerDiagramEditor.CopyEditorToClipboard(((DiagramView)view).getActiveManagerView());
                }
            });
            return true;
        }
        if (ideAction.getCommandId() == SAVE_IMAGE_ID) {
            object = DiagramContext.getDiagramContext((IlvManagerView)((DiagramView)view).getActiveManagerView());
            PublishPlugin publishPlugin = (PublishPlugin)object.getPlugin(PublishPlugin.class);
            publishPlugin.publish();
            return true;
        }
        if (ideAction.getCommandId() == WORKFLOW_PARALLEL_QUERY_ID) {
            object = new WorkflowParallelQueryEditor(context, (List<AbstractNode>)arrayList);
            ((DialogDisplayer)object).showAsDialog();
            return true;
        }
        if (ideAction.getCommandId() == 78) {
            object = DiagramContext.getDiagramContext((IlvManagerView)((DiagramView)view).getActiveManagerView());
            inExtendedPaste = true;
            PasteExtendedDialog pasteExtendedDialog = new PasteExtendedDialog();
            if (!pasteExtendedDialog.invoke()) {
                return true;
            }
            keepModelNamesUnique = pasteExtendedDialog.getKeepModelNamesUnique();
            CopyPastePlugin copyPastePlugin = (CopyPastePlugin)object.getPlugin(CopyPastePlugin.class);
            if (copyPastePlugin != null) {
                copyPastePlugin.paste();
            }
            return true;
        }
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            try {
                this.handlePrimaryEdit(context, workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == SECONDARY_EDIT_ACTION_ID) {
            try {
                this.handleSecondaryEdit(context, workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == SWAP_BUILD_TEST_DATA_ID) {
            try {
                this.handleSwapTestData(workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == VIEW_ERROR_STATUS_ID) {
            if (arrayList.size() == 1) {
                object = (Node)arrayList.get(0);
                workflowEditor.displayEventLogForNode(context, (Node)object);
            } else if (arrayList.size() == 0) {
                workflowEditor.displayEventLogForNode(context, null);
            }
            return true;
        }
        if (ideAction.getCommandId() == VIEW_VALIDATIONS_ID) {
            object = (Node)arrayList.get(0);
            ShowMessagesDialog showMessagesDialog = new ShowMessagesDialog((Node)object);
            showMessagesDialog.invoke();
            return true;
        }
        if (ideAction.getCommandId() == GENERATE_APPLY_CHAIN_ID) {
            if (arrayList.size() > 0) {
                try {
                    workflowEditor.handleGenerateApplyChain();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
                }
            }
            return true;
        }
        if (ideAction.getCommandId() == COMPARE_TEST_ID) {
            if (arrayList.get(0) instanceof AbstractBuildNode) {
                object = new LoadClassCompare(view);
                ((SwingWorker)object).execute();
            } else if (arrayList.get(0) instanceof TestNode) {
                object = new LoadClassCompareContext(view);
                ((SwingWorker)object).execute();
            }
            return true;
        }
        if (ideAction.getCommandId() == VALIDATE_ACTION_ID) {
            try {
                WorkflowContextMenu.handleRunAction(workflowEditor, null, true, Workflow.RunMode.VALIDATE);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_ACTION_ID) {
            try {
                WorkflowContextMenu.handleRunAction(workflowEditor, false);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_SELECTED_ACTION_ID) {
            try {
                WorkflowContextMenu.handleRunAction(workflowEditor, true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_CHILDREN_ACTION_ID) {
            try {
                this.handleForceRunChildrenAction(workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_SELECTED_AND_CHILDREN_ACTION_ID) {
            try {
                this.handleForceRunSelectedAndChildrenAction(workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_PARENTS_ACTION_ID) {
            try {
                this.handleForceRunParentsAction(workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == GEN_SQL_SCRIPT_NODE_PARENT_ACTION_ID) {
            try {
                WorkflowContextMenu.handleGenerateScriptAction(context, workflowEditor, CodeGenerator.CODE_GENERATION_OPTION.NODE_PARENT);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == GEN_SQL_SCRIPT_NODE_PARENT_CHILDREN_ACTION_ID) {
            try {
                WorkflowContextMenu.handleGenerateScriptAction(context, workflowEditor, CodeGenerator.CODE_GENERATION_OPTION.NODE_PARENT_CHILDREN);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == GEN_SQL_SCRIPT_NODE_ALL_CONNECTED_ACTION_ID) {
            try {
                WorkflowContextMenu.handleGenerateScriptAction(context, workflowEditor, CodeGenerator.CODE_GENERATION_OPTION.NODE_ALL_CONNECTED);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == COPY_SQL_TO_CLIPBOARD_ACTION_ID) {
            try {
                WorkflowContextMenu.handleGenerateCodeAction(context, workflowEditor, GenerateCode.CODE_GENERATION_OPTION.SQL_TO_CLIPBOARD);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == COPY_SQL_TO_FILE_ACTION_ID) {
            try {
                WorkflowContextMenu.handleGenerateCodeAction(context, workflowEditor, GenerateCode.CODE_GENERATION_OPTION.SQL_TO_FILE);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == COPY_PLSQL_TO_CLIPBOARD_ACTION_ID) {
            try {
                WorkflowContextMenu.handleGenerateCodeAction(context, workflowEditor, GenerateCode.CODE_GENERATION_OPTION.SQL_SCRIPT_TO_CLIPBOARD);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == COPY_PLSQL_TO_FILE_ACTION_ID) {
            try {
                WorkflowContextMenu.handleGenerateCodeAction(context, workflowEditor, GenerateCode.CODE_GENERATION_OPTION.SQL_SCRIPT_TO_FILE);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == VIEW_DATA_ACTION_ID) {
            try {
                this.handleViewDataAction(context, workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == VIEW_DATA_ACTION2_ID) {
            try {
                this.handleNodeSpecificViewDataAction(context, workflowEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == CONNECT_ACTION_ID) {
            this.handleConnectAction(context, workflowEditor);
            return true;
        }
        if (ideAction.getCommandId() == 22) {
            this.handleSelectAll(ideAction, context);
            return true;
        }
        if (ideAction.getCommandId() == 20 || ideAction.getCommandId() == 17) {
            return !this.confirmDelete(workflowEditor);
        }
        if (ideAction.getCommandId() == GO_TO_PROPERTY_ID) {
            if (InspectorManager.getInspectorManager() != null) {
                InspectorManager.getInspectorManager().showLastView(null);
            }
            return true;
        }
        return false;
    }

    private boolean confirmDelete(WorkflowEditor workflowEditor) {
        IlvManagerView ilvManagerView = workflowEditor.getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof AbstractBuildNode) && !(e instanceof CreateTableNode)) continue;
            bl = true;
        }
        boolean bl2 = true;
        MessageDialogPersistence messageDialogPersistence = MessageDialog.getPersistence();
        Boolean bl3 = messageDialogPersistence.getConfirmed("warnDeleteObjects");
        if (Boolean.FALSE.equals(bl3)) {
            messageDialogPersistence.setConfirmed("warnDeleteObjects", Boolean.valueOf(true));
        }
        if (bl) {
            bl2 = MessageDialog.optionalConfirm((String)"warnDeleteObjects", (Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("DELETE_OBJECTS_WARNING_NODE"), (String)WorkflowEditorLrb.get("DELETE_OBJECTS_WARNING_TITLE"), null);
        }
        return bl2;
    }

    public void handleSelectAll(IdeAction ideAction, Context context) {
        View view = context.getView();
        if (!(view instanceof WorkflowEditor)) {
            return;
        }
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        ilvSDMEngine.selectAllObjects();
    }

    public boolean update(IdeAction ideAction, Context context) {
        AbstractNode abstractNode;
        View view = context.getView();
        if (!(view instanceof WorkflowEditor)) {
            ideAction.setEnabled(false);
            return false;
        }
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        ArrayList<GeneralLink> arrayList2 = new ArrayList<GeneralLink>();
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine == null) {
            return true;
        }
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            abstractNode = (AbstractNode)enumeration.nextElement();
            if (abstractNode instanceof AbstractNode) {
                arrayList.add(abstractNode);
                continue;
            }
            if (!(abstractNode instanceof GeneralLink)) continue;
            arrayList2.add((GeneralLink)((Object)abstractNode));
        }
        abstractNode = null;
        NodeType nodeType = null;
        if (!arrayList.isEmpty()) {
            abstractNode = (AbstractNode)arrayList.get(0);
            nodeType = abstractNode.getData();
        }
        int n = arrayList.size();
        boolean bl = false;
        boolean bl2 = workflowNode.isReadOnly();
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            if (this.isRequirePrimaryEditMenu(nodeType)) {
                bl = n == 1 && !bl2;
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (ideAction.getCommandId() == SECONDARY_EDIT_ACTION_ID) {
            if (this.isRequireSecondaryEditMenu(nodeType)) {
                bl = n == 1 && !bl2;
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (ideAction.getCommandId() == 78 || ideAction.getCommandId() == 19) {
            DiagramContext diagramContext = DiagramContext.getDiagramContext((IlvManagerView)ilvManagerView);
            CopyPastePlugin copyPastePlugin = (CopyPastePlugin)diagramContext.getPlugin(CopyPastePlugin.class);
            if (copyPastePlugin != null) {
                ideAction.setEnabled(copyPastePlugin.canPaste() && !bl2);
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (ideAction.getCommandId() == RUN_ACTION_ID) {
            boolean bl3 = n > 0;
            for (AbstractNode abstractNode2 : arrayList) {
                if (abstractNode2.getData() == null || !abstractNode2.getData().getStatus().equals((Object)NodeStatusType.INVALID)) continue;
                bl3 = false;
                break;
            }
            ideAction.setEnabled(!bl2 && bl3);
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_SELECTED_ACTION_ID) {
            boolean bl4 = n > 0;
            for (AbstractNode abstractNode3 : arrayList) {
                if (!abstractNode3.getData().getStatus().equals((Object)NodeStatusType.INVALID)) continue;
                bl4 = false;
                break;
            }
            ideAction.setEnabled(!bl2 && bl4);
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_SELECTED_AND_CHILDREN_ACTION_ID) {
            boolean bl5 = n > 0;
            int n2 = 0;
            for (AbstractNode abstractNode4 : arrayList) {
                if (abstractNode4.getData().getStatus().equals((Object)NodeStatusType.INVALID)) {
                    bl5 = false;
                    break;
                }
                if (!abstractNode4.hasChildrenNodes()) continue;
                ++n2;
            }
            if (bl5) {
                bl5 = n2 > 0;
            }
            ideAction.setEnabled(!bl2 && bl5);
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_CHILDREN_ACTION_ID) {
            boolean bl6 = n > 0;
            int n3 = 0;
            for (AbstractNode abstractNode5 : arrayList) {
                if (abstractNode5.getData().getStatus().equals((Object)NodeStatusType.INVALID)) {
                    bl6 = false;
                    break;
                }
                if (!abstractNode5.hasChildrenNodes()) continue;
                ++n3;
            }
            bl6 = n3 > 0;
            ideAction.setEnabled(!bl2 && bl6);
            return true;
        }
        if (ideAction.getCommandId() == RUN_FORCE_PARENTS_ACTION_ID) {
            boolean bl7 = n > 0;
            int n4 = 0;
            for (AbstractNode abstractNode6 : arrayList) {
                if (abstractNode6.getData().getStatus().equals((Object)NodeStatusType.INVALID)) {
                    bl7 = false;
                    break;
                }
                if (!abstractNode6.hasParentNodes()) continue;
                ++n4;
            }
            if (bl7) {
                bl7 = n4 > 0;
            }
            ideAction.setEnabled(!bl2 && bl7);
            return true;
        }
        if (ideAction.getCommandId() == COPY_SQL_TO_CLIPBOARD_ACTION_ID) {
            ideAction.setEnabled(n == 1 && !bl2);
            return true;
        }
        if (ideAction.getCommandId() == COPY_SQL_TO_FILE_ACTION_ID) {
            ideAction.setEnabled(n == 1 && !bl2);
            return true;
        }
        if (ideAction.getCommandId() == COPY_PLSQL_TO_CLIPBOARD_ACTION_ID) {
            ideAction.setEnabled(n == 1 && !bl2);
            return true;
        }
        if (ideAction.getCommandId() == COPY_PLSQL_TO_FILE_ACTION_ID) {
            ideAction.setEnabled(n == 1 && !bl2);
            return true;
        }
        if (ideAction.getCommandId() == SWAP_BUILD_TEST_DATA_ID) {
            ideAction.setEnabled(n == 1 && !bl2);
            return true;
        }
        if (ideAction.getCommandId() == GENERATE_APPLY_CHAIN_ID) {
            ideAction.setEnabled(!bl2);
            return true;
        }
        if (ideAction.getCommandId() == COMPARE_TEST_ID) {
            if (arrayList.size() != 1) {
                ideAction.setEnabled(false);
                return true;
            }
            List<Object> list = new LinkedList();
            if (abstractNode instanceof SupervisedBuildNode) {
                list = MetaDataHelper.getResultsCollection((SuperviseBuildNodeType)abstractNode.getData());
            } else if (abstractNode instanceof TestNode) {
                list = MetaDataHelper.getResultsCollection((TestNode)abstractNode);
            }
            ArrayList<MiningResultType> arrayList3 = new ArrayList<MiningResultType>();
            for (MiningResultType miningResultType : list) {
                if (miningResultType.getCreationDate() == null) continue;
                arrayList3.add(miningResultType);
            }
            ideAction.setEnabled(arrayList3.size() >= 1 && !bl2);
            return true;
        }
        if (ideAction.getCommandId() == VIEW_DATA_ACTION_ID) {
            if (bl2) {
                ideAction.setEnabled(false);
                return true;
            }
            if (n == 1) {
                if (abstractNode instanceof DataSourceNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                } else if (abstractNode instanceof DataProfileNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                } else if (abstractNode instanceof CreateTableNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                } else if (abstractNode instanceof UpdateTableNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                } else if (abstractNode instanceof AbstractTransformNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                } else if (abstractNode instanceof AggregationNode) {
                    ideAction.setEnabled(nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) || nodeType.getStatus().equals((Object)NodeStatusType.WARNING) || nodeType.getStatus().equals((Object)NodeStatusType.READY));
                }
            }
            return true;
        }
        if (ideAction.getCommandId() == CONNECT_ACTION_ID) {
            ideAction.setEnabled(arrayList.size() == 1 && !bl2);
            return true;
        }
        if (ideAction.getCommandId() == VIEW_ERROR_STATUS_ID) {
            ideAction.setEnabled(arrayList.size() == 1 || arrayList.size() == 0);
            return true;
        }
        if (ideAction.getCommandId() == VIEW_ERROR_STATUS_ID) {
            return true;
        }
        if (ideAction.getCommandId() == 17 || ideAction.getCommandId() == 20) {
            ideAction.setEnabled((arrayList.size() >= 1 || arrayList2.size() >= 1) && !bl2);
            return true;
        }
        if (ideAction.getCommandId() == 22) {
            ideAction.setEnabled(true);
            return true;
        }
        if (ideAction.getCommandId() == GO_TO_PROPERTY_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (ideAction.getCommandId() == GEN_SQL_SCRIPT_NODE_PARENT_ACTION_ID || ideAction.getCommandId() == GEN_SQL_SCRIPT_NODE_PARENT_CHILDREN_ACTION_ID || ideAction.getCommandId() == GEN_SQL_SCRIPT_NODE_ALL_CONNECTED_ACTION_ID) {
            ideAction.setEnabled(arrayList.size() > 0 && !bl2);
            return true;
        }
        return false;
    }

    private void handleConnectAction(Context context, WorkflowEditor workflowEditor) {
        final IlvManagerView ilvManagerView = workflowEditor.getActiveManagerView();
        DiagramContext diagramContext = DiagramContext.getDiagramContext((IlvManagerView)ilvManagerView);
        ModularPalettePlugin modularPalettePlugin = (ModularPalettePlugin)diagramContext.getPlugin(PalettePlugin.class);
        Version version = null;
        try {
            version = ConfigUtils.getDatabaseVersion(context);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        WorkflowPalettePages workflowPalettePages = null;
        workflowPalettePages = ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_0, version, true) ? DynamicWorkflowPalettePages.getInstance() : WorkflowPalettePages.getInstance();
        PaletteItem paletteItem = workflowPalettePages.getItem(WorkflowPalettePageProvider.class.getName(), "transition");
        final WorkflowDiagram.OdmrCreateLinkPaletteItemHandler odmrCreateLinkPaletteItemHandler = (WorkflowDiagram.OdmrCreateLinkPaletteItemHandler)modularPalettePlugin.getPaletteItemTypeHandler("WorkflowLink");
        try {
            IlvSDMEngine ilvSDMEngine = ((WorkflowNode)context.getNode()).getEngine();
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            Object e = enumeration.nextElement();
            final IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic(e, false);
            modularPalettePlugin.paletteItemSelected(paletteItem);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    odmrCreateLinkPaletteItemHandler.getLastCreatedInteractor().startConnectionFrom(ilvManagerView, ilvGraphic);
                }
            });
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public static boolean openInGraphEditor(AbstractNode abstractNode, Context context) throws Exception {
        DataNode dataNode;
        boolean bl = false;
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        if (abstractNode instanceof GraphNode) {
            dataNode = null;
            dataNode = DataNode.findDataNode(workflowNode, abstractNode.getData().getName());
            if (null == dataNode) {
                throw new NoDataProviderException("could not find the proper node to display");
            }
        } else {
            throw new RuntimeException("Unable to display node. Unexpected node type");
        }
        GraphNode graphNode = (GraphNode)abstractNode;
        graphNode.checkForLegacySettings();
        Context context2 = Context.newIdeContext((oracle.ide.model.Node)dataNode);
        context2.setProperty("wfNavNode", (Object)workflowNode);
        context2.setProperty("dataNode", (Object)abstractNode);
        EditorUtil.openExplicitEditorInFrame(GraphEditor.class, (Context)context2);
        bl = true;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean launchNodeSpecificDataViewer(AbstractDataNode abstractDataNode, Context context) throws Exception {
        boolean bl = false;
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        if (abstractDataNode == null) throw new Exception("Unable to display node.");
        DataNode dataNode = null;
        dataNode = DataNode.findDataNode(workflowNode, abstractDataNode.getData().getName());
        if (dataNode == null) throw new RuntimeException("could not find the proper node to display");
        Context context2 = Context.newIdeContext((oracle.ide.model.Node)dataNode);
        context2.setProperty("wfNode", (Object)workflowNode);
        context2.setProperty("dataNode", (Object)abstractDataNode);
        NodeType nodeType = abstractDataNode.getData();
        if (dataNode instanceof ColumnFilterNavNode) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)abstractDataNode.getData();
            AttrImportantSettingsType attrImportantSettingsType = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings();
            AttributeType attributeType = attrImportantSettingsType.getTargetAttribute();
            if (attributeType == null) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("COLUMN_FILTER_AI_NOT_ENABLED"), (String)WorkflowEditorLrb.get("COLUMN_FILTER_AI_NOT_ENABLED_TITLE"), null);
                return false;
            }
            if (attributeType != null && !columnFilterNodeType.getStatus().equals((Object)NodeStatusType.COMPLETE)) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("COLUMN_FILTER_AI_NOT_COMPLETE"), (String)WorkflowEditorLrb.get("NOT_COMPLETE_TITLE"), null);
                return false;
            }
            EditorUtil.openExplicitEditorInFrame(AIEditor.class, (Context)context2);
            return true;
        }
        if (!(dataNode instanceof DataProfileNavNode)) return bl;
        if (!nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE)) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("PROFILE_NOT_COMPLETE"), (String)WorkflowEditorLrb.get("NOT_COMPLETE_TITLE"), null);
            return false;
        }
        EditorUtil.openExplicitEditorInFrame(DataProfilerEditor.class, (Context)context2);
        return true;
    }

    private boolean launchDataViewer(AbstractDataNode abstractDataNode, Context context) throws Exception {
        boolean bl = false;
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        if (abstractDataNode != null) {
            DataNode dataNode = null;
            dataNode = DataNode.findDataNode(workflowNode, abstractDataNode.getData().getName());
            Context context2 = Context.newIdeContext((oracle.ide.model.Node)dataNode);
            context2.setProperty("wfNode", (Object)workflowNode);
            context2.setProperty("dataNode", (Object)abstractDataNode);
            if (dataNode == null) {
                throw new RuntimeException("could not find the proper node to display");
            }
            EditorUtil.openExplicitEditorInFrame(DataEditor.class, (Context)context2);
        } else {
            throw new Exception("Unable to display node.");
        }
        bl = true;
        return bl;
    }

    private boolean validToRun(WorkflowEditor workflowEditor, boolean bl, boolean bl2) {
        List<Node> list;
        try {
            list = workflowEditor.getSelectedDiagramNodes();
        }
        catch (Exception exception) {
            return false;
        }
        for (Node node : list) {
            if (bl) {
                if (node.validateRunChain(true)) continue;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_RUN_CHAIN_INVALID"), (String)WorkflowEditorLrb.get("NODES_IN_RUN_ERROR_TITLE"), null);
                return false;
            }
            if (node.validateChildrenRunChain(true)) continue;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODES_IN_RUN_CHAIN_INVALID"), (String)WorkflowEditorLrb.get("NODES_IN_RUN_ERROR_TITLE"), null);
            return false;
        }
        for (Node node : list) {
            NodeType nodeType = node.getData();
            if (!bl2 || !nodeType.getStatus().equals((Object)NodeStatusType.COMPLETE) && !nodeType.getStatus().equals((Object)NodeStatusType.WARNING)) continue;
            node.setNodeReady();
        }
        return true;
    }

    static {
        PRIMARY_EDIT_ACTION_ID = Ide.findOrCreateCmdID((String)"EditNodeAction");
        SECONDARY_EDIT_ACTION_ID = Ide.findOrCreateCmdID((String)"EditNodeActionSecondary");
        GENERATE_APPLY_CHAIN_ID = Ide.findOrCreateCmdID((String)"GenerateApplyChain");
        SWAP_BUILD_TEST_DATA_ID = Ide.findOrCreateCmdID((String)"SwapDataAction");
        VALIDATE_ACTION_ID = Ide.findOrCreateCmdID((String)"ValidateParentsNodeAction");
        RUN_ACTION_ID = Ide.findOrCreateCmdID((String)"RunNodeAction");
        RUN_FORCE_CHILDREN_ACTION_ID = Ide.findOrCreateCmdID((String)"RunForceChildrenNodeAction");
        RUN_FORCE_SELECTED_ACTION_ID = Ide.findOrCreateCmdID((String)"RunForceSelectedNodeAction");
        RUN_FORCE_SELECTED_AND_CHILDREN_ACTION_ID = Ide.findOrCreateCmdID((String)"RunForceSelectedAndChildrenNodeAction");
        RUN_FORCE_PARENTS_ACTION_ID = Ide.findOrCreateCmdID((String)"RunForceParentsNodeAction");
        VIEW_DATA_ACTION_ID = Ide.findOrCreateCmdID((String)"ViewDataAction");
        VIEW_DATA_ACTION2_ID = Ide.findOrCreateCmdID((String)"ViewDataAction2");
        VIEW_ERROR_STATUS_ID = Ide.findOrCreateCmdID((String)"ViewErrorStatus");
        VIEW_VALIDATIONS_ID = Ide.findOrCreateCmdID((String)"ViewValidations");
        COMPARE_TEST_ID = Ide.findOrCreateCmdID((String)"CompareTest");
        COPY_SQL_TO_CLIPBOARD_ACTION_ID = Ide.findOrCreateCmdID((String)"CopySQLToClipboardAction");
        COPY_SQL_TO_FILE_ACTION_ID = Ide.findOrCreateCmdID((String)"CopySQLToFileAction");
        COPY_PLSQL_TO_CLIPBOARD_ACTION_ID = Ide.findOrCreateCmdID((String)"CopyPLSQLToClipboardAction");
        COPY_PLSQL_TO_FILE_ACTION_ID = Ide.findOrCreateCmdID((String)"CopyPLSQLToFileAction");
        GEN_SQL_SCRIPT_NODE_PARENT_ACTION_ID = Ide.findOrCreateCmdID((String)"GenSQLScriptNodeParentAction");
        GEN_SQL_SCRIPT_NODE_PARENT_CHILDREN_ACTION_ID = Ide.findOrCreateCmdID((String)"GenSQLScriptNodeParentChildrenAction");
        GEN_SQL_SCRIPT_NODE_ALL_CONNECTED_ACTION_ID = Ide.findOrCreateCmdID((String)"GenSQLScriptNodeAllConnectedAction");
        CONNECT_ACTION_ID = Ide.findOrCreateCmdID((String)"dataminer.ConnectAction");
        GO_TO_PROPERTY_ID = Ide.findOrCreateCmdID((String)"dataminer.GoToPropertyInspector");
        COPY_IMAGE_ID = Ide.findOrCreateCmdID((String)"copyImage");
        SAVE_IMAGE_ID = Ide.findOrCreateCmdID((String)"saveImage");
        WORKFLOW_PARALLEL_QUERY_ID = Ide.findOrCreateCmdID((String)"workflowParallelQueryEditor");
        EXTENDED_PASTE_ACTION = IdeAction.find((int)78);
        inExtendedPaste = false;
        keepModelNamesUnique = false;
    }

    public static class NoDataProviderException
    extends Exception {
        NoDataProviderException(String string) {
            super(string);
        }
    }

    static class StartWorkflowProgressRunnable
    extends ProgressRunnable {
        private boolean upStream;
        private Workflow.RunMode runMode;
        private WorkflowEditor editor;

        StartWorkflowProgressRunnable(WorkflowEditor workflowEditor) {
            this(workflowEditor, false, Workflow.RunMode.RUN);
        }

        StartWorkflowProgressRunnable(WorkflowEditor workflowEditor, boolean bl, Workflow.RunMode runMode) {
            this.editor = workflowEditor;
            this.upStream = bl;
            this.runMode = runMode;
            this.setTitle(WorkflowEditorLrb.get("START_WORKFLOW"));
            this.setMessage(WorkflowEditorLrb.get("START_WORKFLOW_DESCR"));
            this.setCancelable(false);
        }

        protected Object doWork() throws Exception {
            this.startWorkflow(this.editor, this, this.editor.getSelectedDiagramNodes(), this.upStream, this.runMode);
            return true;
        }

        private Object startWorkflow(WorkflowEditor workflowEditor, ProgressRunnable progressRunnable, List<Node> list, boolean bl, Workflow.RunMode runMode) throws Exception {
            try {
                WorkflowNode workflowNode = (WorkflowNode)workflowEditor.getContext().getNode();
                Workflow workflow = (Workflow)((WorkflowNode)workflowEditor.getContext().getNode()).getRepositoryData();
                if (workflowNode.isReadOnly()) {
                    throw new Exception(WorkflowEditorLrb.get("WORKFLOW_READ_ONLY_RUN_NOT_ALLOWED"));
                }
                progressRunnable.setMessage(WorkflowEditorLrb.get("SAVING_WORKFLOW"));
                if (workflowNode.isDirty()) {
                    workflowNode.save();
                    workflowNode.markDirty(false);
                }
                workflowEditor.startJobMonitoring();
                theLogger.log(Level.INFO, "Start monitoring");
                AddinManager addinManager = AddinManager.getAddinManager();
                RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
                String string = ConnectionFolder.getConnectionName(workflowEditor.getContext());
                int n = 0;
                while (!workflowEditor.isJobsListenerInitialized()) {
                    Thread.sleep(500L);
                    if (++n <= 60) continue;
                    if (runManager.isActive(string) && runManager.getListener(workflowEditor, string) != null) {
                        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("START_DELAY_DESCR"), (String)WorkflowEditorLrb.get("START_DELAY"), null)) {
                            throw new Exception("Jobs monitor timed out, aborting run request");
                        }
                        n = 0;
                        continue;
                    }
                    throw new RuntimeException("Unexpected state: waiting for monitor to initialize, but it's not running");
                }
                theLogger.log(Level.INFO, "Monitor initialized, continue");
                progressRunnable.setMessage(WorkflowEditorLrb.get("STARTING_WORKFLOW"));
                String[] stringArray = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    stringArray[i] = list.get(i).getData().getId();
                }
                theLogger.log(Level.INFO, "Starting workflow...");
                workflow.run(workflowNode.getSessionConnection(), stringArray, workflowNode.getLastSavedOn(), bl, runMode);
                workflowEditor.setLockOwner(true);
            }
            catch (Exception exception) {
                theLogger.log(Level.INFO, "Exception caught during WorkflowContextMenu.startWorkflow()", exception);
                workflowEditor.stopJobMonitoring();
                throw exception;
            }
            return true;
        }
    }

    private class LoadSVMModelViewer
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        ModelType _modelType;
        boolean _isLinear = false;
        Context _context = null;
        String _userName = "";
        View _view = null;
        ModelNodeType.Models.Model _model = null;
        TestModelType.Model _testModel = null;
        String _modelName = null;

        public LoadSVMModelViewer(View view, ModelType modelType, String string, Context context) {
            this._modelType = modelType;
            this._modelName = modelType.getName();
            this._context = context;
            this._userName = string;
            this._view = view;
        }

        public LoadSVMModelViewer(View view, ModelNodeType.Models.Model model, String string, Context context) {
            this._model = model;
            this._modelName = model.getName();
            this._context = context;
            this._userName = string;
            this._view = view;
        }

        public LoadSVMModelViewer(View view, TestModelType.Model model, String string, Context context) {
            this._testModel = model;
            this._modelName = model.getName();
            this._context = context;
            this._userName = string;
            this._view = view;
        }

        protected Object doInBackground() throws Exception {
            try {
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
                Model model = new Model();
                Vector<MiningModelSettings> vector = model.getModelSetting(connectionFolder, this._userName, this._modelName);
                MiningModelSettings miningModelSettings = MiningModelSettings.findSetting("SVMS_KERNEL_FUNCTION", vector);
                this._isLinear = miningModelSettings != null ? miningModelSettings.getSettingValue().equals("SVMS_LINEAR") : false;
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return this._isLinear;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void done() {
            super.done();
            if (this._success && this._ex == null) {
                BaseTreeNode baseTreeNode = null;
                String string = this._modelName;
                try {
                    if (string == null) return;
                    String string2 = WorkflowContextMenu.this.getSelectedDiagramNode(this._view).getData().getName();
                    String string3 = null;
                    if (this._testModel != null) {
                        string3 = this._testModel.getSchema();
                    } else if (this._model != null) {
                        string3 = this._model.getSchema();
                    }
                    baseTreeNode = ModelNodeUtils.findModelNode((WorkflowNode)this._context.getNode(), string2, string3, string);
                    EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)baseTreeNode);
                    return;
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"), null);
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                return;
            } else if (this._ex != null) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"), null);
                return;
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_DISPLAY"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
            }
        }
    }

    private class LoadClassCompareContext
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        private TestCompareNode rn = null;
        private View view = null;
        private WorkflowEditor wfe = null;

        public LoadClassCompareContext(View view) {
            this.view = view;
            if (view instanceof WorkflowEditor) {
                this.wfe = (WorkflowEditor)view.getContext().getView();
                if (this.wfe != null) {
                    this.wfe.displayOverLayPanel(view, BlockingComponent.Message.LOADING);
                }
            }
        }

        protected Object doInBackground() throws Exception {
            try {
                ArrayList<MiningResultType> arrayList;
                String string;
                WorkflowNode workflowNode;
                Context context;
                AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(this.view);
                if (abstractNode == null) {
                    return null;
                }
                TestNode testNode = (TestNode)abstractNode;
                TestNodeType testNodeType = (TestNodeType)testNode.getData();
                if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.CLASSIFICATION)) {
                    context = this.view.getContext();
                    workflowNode = (WorkflowNode)context.getNode();
                    string = workflowNode.getConnectionFolder().getUserAccountName();
                    arrayList = null;
                    if (testNodeType.getResults().getClassificationResult().size() > 0) {
                        arrayList = new ArrayList<MiningResultType>();
                        for (MiningResultType miningResultType : testNodeType.getResults().getClassificationResult()) {
                            if (miningResultType.getCreationDate() == null) continue;
                            arrayList.add(miningResultType);
                        }
                    }
                    this.rn = WorkflowContextMenu.createClassTestCompareNode(context, workflowNode, string, testNodeType, arrayList);
                }
                if (testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION)) {
                    context = this.view.getContext();
                    workflowNode = (WorkflowNode)context.getNode();
                    string = workflowNode.getConnectionFolder().getUserAccountName();
                    arrayList = null;
                    if (testNodeType.getResults().getRegressionResult().size() > 0) {
                        arrayList = new ArrayList();
                        for (MiningResultType miningResultType : testNodeType.getResults().getRegressionResult()) {
                            if (miningResultType.getCreationDate() == null) continue;
                            arrayList.add(miningResultType);
                        }
                    }
                    this.rn = WorkflowContextMenu.createRegressTestCompareNode(context, workflowNode, string, testNodeType, arrayList);
                }
                this._success = true;
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                this._ex = exception;
                this._success = false;
            }
            return true;
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    if (this.rn != null) {
                        EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)this.rn);
                    }
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                }
            }
            finally {
                if (this.wfe != null) {
                    this.wfe.hideOverLayPanel();
                }
            }
        }
    }

    private class LoadClassCompare
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        private TestCompareNode rn = null;
        private View view = null;
        private WorkflowEditor wfe;

        public LoadClassCompare(View view) {
            this.view = view;
            if (view instanceof WorkflowEditor) {
                this.wfe = (WorkflowEditor)view.getContext().getView();
                if (this.wfe != null) {
                    this.wfe.displayOverLayPanel(view, BlockingComponent.Message.LOADING);
                }
            }
        }

        protected Object doInBackground() throws Exception {
            try {
                AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(this.view);
                if (abstractNode == null) {
                    return null;
                }
                AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
                if (abstractBuildNode instanceof ClassificationBuildNode) {
                    ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)abstractBuildNode.getData();
                    Context context = this.view.getContext();
                    WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                    ArrayList<MiningResultType> arrayList = null;
                    if (classificationBuildNodeType.getResults() != null) {
                        arrayList = new ArrayList<MiningResultType>();
                        for (MiningResultType miningResultType : classificationBuildNodeType.getResults().getClassificationResult()) {
                            if (miningResultType.getCreationDate() == null) continue;
                            arrayList.add(miningResultType);
                        }
                    }
                    this.rn = WorkflowContextMenu.createClassTestCompareNode(context, workflowNode, classificationBuildNodeType, arrayList);
                } else if (abstractBuildNode instanceof RegressionBuildNode) {
                    RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)abstractBuildNode.getData();
                    Context context = this.view.getContext();
                    WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                    String string = workflowNode.getConnectionFolder().getUserAccountName();
                    ArrayList<MiningResultType> arrayList = null;
                    if (regressionBuildNodeType.getResults() != null) {
                        arrayList = new ArrayList<MiningResultType>();
                        for (MiningResultType miningResultType : regressionBuildNodeType.getResults().getRegressionResult()) {
                            if (miningResultType.getCreationDate() == null) continue;
                            arrayList.add(miningResultType);
                        }
                    }
                    this.rn = WorkflowContextMenu.createRegressTestCompareNode(context, workflowNode, string, regressionBuildNodeType, arrayList);
                }
                this._success = true;
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                this._ex = exception;
                this._success = false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    if (this.rn != null) {
                        EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)this.rn);
                        return;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                    return;
                }
                if (this._ex == null) return;
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                return;
            }
            finally {
                if (this.wfe != null) {
                    this.wfe.hideOverLayPanel();
                }
            }
        }
    }

    private class LoadViewResults
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        private JMenuItem menuItem;
        private TestResultNode rn = null;
        private View view = null;
        private WorkflowEditor wfe = null;

        public LoadViewResults(JMenuItem jMenuItem, View view) {
            this.menuItem = jMenuItem;
            this.view = view;
            if (view instanceof WorkflowEditor) {
                this.wfe = (WorkflowEditor)view.getContext().getView();
                if (this.wfe != null) {
                    this.wfe.displayOverLayPanel(view, BlockingComponent.Message.LOADING);
                }
            }
        }

        protected Object doInBackground() throws Exception {
            try {
                String string = this.menuItem.getText();
                AbstractNode abstractNode = WorkflowContextMenu.this.getSelectedDiagramNode(this.view);
                if (abstractNode == null) {
                    return null;
                }
                AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
                if (abstractBuildNode instanceof ClassificationBuildNode) {
                    List<ClassificationResultType> list = MetaDataHelper.getClassResultsCollection(abstractBuildNode);
                    Context context = this.view.getContext();
                    WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                    String string2 = workflowNode.getConnectionFolder().getUserAccountName();
                    ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)abstractBuildNode.getData();
                    ClassificationResultType classificationResultType = null;
                    for (ClassificationResultType classificationResultType2 : list) {
                        if (!classificationResultType2.getName().equals(string)) continue;
                        classificationResultType = classificationResultType2;
                        break;
                    }
                    this.rn = WorkflowContextMenu.createClassTestResultNode(context, workflowNode, string2, string, classificationBuildNodeType, classificationResultType);
                } else if (abstractBuildNode instanceof RegressionBuildNode) {
                    List<RegressionResultType> list = MetaDataHelper.getRegressResultsCollection(abstractBuildNode);
                    Context context = this.view.getContext();
                    WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                    String string3 = workflowNode.getConnectionFolder().getUserAccountName();
                    RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)abstractBuildNode.getData();
                    RegressionResultType regressionResultType = null;
                    for (RegressionResultType regressionResultType2 : list) {
                        if (!regressionResultType2.getName().equals(string)) continue;
                        regressionResultType = regressionResultType2;
                        break;
                    }
                    this.rn = WorkflowContextMenu.createRegressTestResultNode(context, workflowNode, string3, string, regressionBuildNodeType, regressionResultType);
                }
                this._success = true;
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                this._ex = exception;
                this._success = false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    if (this.rn != null) {
                        EditorUtil.openDefaultEditorInFrame((oracle.ide.model.Node)this.rn);
                        return;
                    }
                    MessageDialog.error((Component)this.menuItem, (Object)WorkflowEditorLrb.get("MODEL_DISPLAY_UNABLE_TO_GENERATE_NODE"), (String)WorkflowEditorLrb.get("MODEL_DISPLAY_ERROR_TITLE"), null);
                    return;
                }
                if (this._ex == null) return;
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                return;
            }
            finally {
                if (this.wfe != null) {
                    this.wfe.hideOverLayPanel();
                }
            }
        }
    }

    static enum MenuSection {
        CONNECT,
        RUN,
        EDIT,
        VIEW,
        LOG,
        DEPLOY,
        STANDARD_EDIT_MENU,
        AUXILIARY;

    }

    private class TestMenuLoader
    implements DynamicMenuLoader {
        private TestMenuLoader() {
        }

        @Override
        public Boolean isValidForNode(AbstractNode abstractNode) {
            if (abstractNode instanceof AbstractBuildNode || abstractNode instanceof TestNode) {
                return true;
            }
            return false;
        }

        @Override
        public void load(ContextMenu contextMenu, JMenu jMenu, View view) {
            AbstractNode abstractNode = null;
            if (WorkflowContextMenu.this.selectedNodes.size() != 1 || WorkflowContextMenu.this.selectedNodes.get(0) == null) {
                return;
            }
            abstractNode = (AbstractNode)WorkflowContextMenu.this.selectedNodes.get(0);
            if (!this.isValidForNode(abstractNode).booleanValue()) {
                return;
            }
            if (abstractNode instanceof AbstractBuildNode) {
                List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)abstractNode.getData());
                boolean bl = list.size() > 0;
                List<Object> list2 = null;
                list2 = abstractNode instanceof ClassificationBuildNode ? MetaDataHelper.getClassResultsCollection((AbstractBuildNode)abstractNode) : (abstractNode instanceof RegressionBuildNode ? MetaDataHelper.getRegressResultsCollection((AbstractBuildNode)abstractNode) : new LinkedList<ClassificationResultType>());
                WorkflowContextMenu.this.loadViewResultsMenu(view, jMenu, list, list2);
                jMenu.setEnabled(bl);
            } else if (abstractNode instanceof TestNode) {
                TestNode testNode = (TestNode)abstractNode;
                List<TestModelType.Model> list = MetaDataHelper.getModelsCollection((TestNodeType)testNode.getData());
                boolean bl = list.size() > 0;
                List<? extends MiningResultType> list3 = null;
                list3 = MetaDataHelper.getResultsCollection(testNode);
                WorkflowContextMenu.this.loadViewTestResultsMenu(view, jMenu, list, list3);
                jMenu.setEnabled(bl);
            }
        }
    }

    private class ModelMenuLoader
    implements DynamicMenuLoader {
        private ModelMenuLoader() {
        }

        @Override
        public Boolean isValidForNode(AbstractNode abstractNode) {
            if (abstractNode instanceof AbstractBuildNode || abstractNode instanceof AbstractModelNode || abstractNode instanceof TestNode) {
                return true;
            }
            return false;
        }

        @Override
        public void load(ContextMenu contextMenu, JMenu jMenu, View view) {
            AbstractNode abstractNode = null;
            if (WorkflowContextMenu.this.selectedNodes.size() != 1 || WorkflowContextMenu.this.selectedNodes.get(0) == null) {
                return;
            }
            abstractNode = (AbstractNode)WorkflowContextMenu.this.selectedNodes.get(0);
            if (!this.isValidForNode(abstractNode).booleanValue()) {
                return;
            }
            boolean bl = false;
            if (abstractNode instanceof AbstractBuildNode) {
                AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
                List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
                bl = list.size() > 0;
                WorkflowContextMenu.this.loadViewModelsMenu(view, jMenu, list);
            } else if (abstractNode instanceof AbstractModelNode) {
                AbstractModelNode abstractModelNode = (AbstractModelNode)abstractNode;
                List<ModelNodeType.Models.Model> list = MetaDataHelper.getModelsCollection((ModelNodeType)abstractModelNode.getData());
                bl = list.size() > 0;
                WorkflowContextMenu.this.loadViewModelsMenuForModelNode(view, jMenu, list);
            } else if (abstractNode instanceof TestNode) {
                TestNode testNode = (TestNode)abstractNode;
                List<TestModelType.Model> list = MetaDataHelper.getModelsCollection((TestNodeType)testNode.getData());
                bl = list.size() > 0;
                WorkflowContextMenu.this.loadViewTestModelsMenu(view, jMenu, list);
            }
            jMenu.setEnabled(bl);
        }
    }

    private class WorkflowMenuItem {
        private JMenuItem menuComponent;
        private IdeAction action;
        private String name;
        private MenuSection type;
        private List<WorkflowMenuItem> children;
        private Boolean hasChildren;
        private DynamicMenuLoader menuLoader;

        public WorkflowMenuItem(int n, String string, MenuSection menuSection, Controller controller) {
            this.action = IdeAction.get((int)n);
            this.action.setName(string);
            this.action.addController(controller);
            this.type = menuSection;
            this.children = null;
            this.hasChildren = false;
            this.name = string;
            this.menuLoader = null;
        }

        public WorkflowMenuItem(IdeAction ideAction, MenuSection menuSection, Controller controller) {
            this.action = ideAction;
            ideAction.addController(controller);
            this.type = menuSection;
            this.children = null;
            this.hasChildren = false;
            this.name = null;
            this.menuLoader = null;
        }

        public WorkflowMenuItem(String string, MenuSection menuSection, List<WorkflowMenuItem> list) {
            this.type = menuSection;
            this.children = list;
            this.hasChildren = true;
            this.action = null;
            this.name = string;
            this.menuLoader = null;
        }

        public WorkflowMenuItem(String string, MenuSection menuSection, DynamicMenuLoader dynamicMenuLoader) {
            this(string, menuSection, new ArrayList<WorkflowMenuItem>());
            this.menuLoader = dynamicMenuLoader;
        }

        private JMenuItem createMenuComponent(ContextMenu contextMenu) {
            if (this.hasChildren().booleanValue()) {
                this.menuComponent = contextMenu.createMenu(this.name, 1.0f);
                for (WorkflowMenuItem workflowMenuItem : this.getChildren()) {
                    workflowMenuItem.createMenuComponent(contextMenu);
                }
            } else {
                this.menuComponent = this.action == EXTENDED_PASTE_ACTION ? contextMenu.createMenuItem((ToggleAction)this.action, MenuConstants.WEIGHT_EDIT_EXTENDED_PASTE) : contextMenu.createMenuItem((ToggleAction)this.action, 1.0f);
            }
            return this.menuComponent;
        }

        public JMenuItem getMenuComponent(ContextMenu contextMenu) {
            if (this.menuComponent == null) {
                this.menuComponent = this.createMenuComponent(contextMenu);
            }
            return this.menuComponent;
        }

        public DynamicMenuLoader getDynamicLoader() {
            return this.menuLoader;
        }

        public IdeAction getAction() {
            return this.action;
        }

        public Boolean hasChildren() {
            return this.hasChildren;
        }

        public MenuSection getType() {
            return this.type;
        }

        public List<WorkflowMenuItem> getChildren() {
            return this.children;
        }
    }

    private class MenuWeight {
        private float menuSectionId;

        public void init() {
            this.menuSectionId = MenuConstants.SECTION_EDIT_CTXT_MENU - 4.0f;
        }

        public void initAuxiliary() {
            this.menuSectionId = MenuConstants.SECTION_ADDITIONAL_CTXT_MENU + 10.0f;
        }

        public void initStandard() {
            this.menuSectionId = MenuConstants.SECTION_EDIT_CTXT_MENU - 0.001f;
        }

        public float getWeight() {
            return this.menuSectionId;
        }

        public void increment() {
            this.menuSectionId = MenuConstants.increment((float)this.menuSectionId);
        }
    }
}

