/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.wizard.workflow;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.wizard.workflow.WorkflowLrb;
import oracle.ide.Context;

public class WorkflowDialogState {
    private Context _context;
    private String _name;
    private boolean _editMode = false;
    private Workflow _workflowState = null;
    private static final Logger theLogger = Logger.getLogger(WorkflowDialogState.class.getName());

    public WorkflowDialogState(Context context) {
        this._context = context;
        this._editMode = false;
        this.loadDefaults();
    }

    public boolean isWorkflowModelEditMode() {
        return this._editMode;
    }

    private Workflow finishCreate() throws Exception {
        BigDecimal bigDecimal = null;
        Workflow workflow = null;
        ProjectFolder projectFolder = ProjectFolder.getProjectFolder(this._context);
        Timestamp[] timestampArray = new Timestamp[]{new Timestamp(0L)};
        Connection connection = ConnectionFolder.getConnection(this._context);
        try {
            bigDecimal = Workflow.create(connection, projectFolder.getId(), this.getName(), "", timestampArray);
            if (bigDecimal != null) {
                workflow = new Workflow(this.getName(), bigDecimal, null);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            SQLHelper.close(connection);
        }
        return workflow;
    }

    private Workflow finishEdit() {
        if (this._workflowState != null) {
            this._workflowState.unload();
        }
        return this._workflowState;
    }

    public Workflow finish() throws Exception {
        if (!this._editMode) {
            return this.finishCreate();
        }
        return this.finishEdit();
    }

    private void loadDefaults() {
        this._name = this.loadDefaultName();
    }

    private String loadDefaultName() {
        String string = WorkflowLrb.get("DEFAULT_NAME");
        String string2 = "";
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
            ProjectFolder projectFolder = ProjectFolder.getProjectFolder(this._context);
            string2 = Workflow.createUniqueName(connectionFolder, projectFolder.getId(), string);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        return string2;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public Context getContext() {
        return this._context;
    }
}

