/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.wizard.project;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.NodeNameValidator;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.wizard.project.ProjectLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.MessageDialog;

public class ProjectModel {
    private static final Logger theLogger = Logger.getLogger(ProjectModel.class.getName());
    private Context _context;
    private String _name;
    private String _comment;
    private boolean _editMode = false;
    private WorkflowProject _projectState = null;

    public ProjectModel(Context context) {
        this._context = context;
        this._editMode = false;
        this.loadDefaults();
    }

    public ProjectModel(Context context, WorkflowProject workflowProject) throws Exception {
        this._context = context;
        this._editMode = true;
        this._projectState = workflowProject;
        this.loadProject();
    }

    private void loadProject() throws Exception {
        if (!this._projectState.isLoaded()) {
            this.loadProjectStateFromDB();
        }
        this._name = this._projectState.getName();
        this._comment = this._projectState.getComment();
    }

    private void loadProjectStateFromDB() throws Exception {
        class Loader
        extends ProgressRunnable {
            Loader() {
            }

            protected Object doWork() throws Exception {
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(ProjectModel.this._context);
                ProjectModel.this._projectState.load(connectionFolder);
                return ProjectModel.this._projectState;
            }
        }
        Loader loader = new Loader();
        loader.setTitle(ProjectLrb.get("RETRIEVING_PROJECT"));
        loader.setMessage(ProjectLrb.get("RETRIEVING_PROJECT_DETAILS"));
        loader.setCancelable(false);
        try {
            loader.start(true);
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
            throw progressException;
        }
    }

    public boolean isProjectModelEditMode() {
        return this._editMode;
    }

    public static boolean validateProjectComment(ConnectionManager connectionManager, String string) {
        boolean bl = true;
        String string2 = "";
        if (!WorkflowProject.validateCommentLength(string)) {
            bl = false;
            string2 = MessageFormat.format(ProjectLrb.get("COMMENT_TOO_LONG"), Integer.toString(4000));
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)ProjectLrb.get("CREATE_PROJECT_ERROR_COMMENT"), null);
        } else if (!WorkflowProject.validateCommentLengthAtDB(connectionManager, string)) {
            bl = false;
            string2 = MessageFormat.format(ProjectLrb.get("COMMENT_TOO_LONG_BYTES"), Integer.toString(4000));
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)ProjectLrb.get("CREATE_PROJECT_ERROR_COMMENT"), null);
        }
        return bl;
    }

    public static boolean validateProjectName(ConnectionManager connectionManager, String string) {
        boolean bl = true;
        String string2 = "";
        try {
            if (string.length() == 0) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ProjectLrb.get("PROJECT_NAME_EMPTY"), (String)ProjectLrb.get("CREATE_PROJECT_ERROR_NAME"), null);
            } else if (!WorkflowProject.validateProjectNameLength(string)) {
                bl = false;
                string2 = MessageFormat.format(ProjectLrb.get("PROJECT_NAME_TOO_LONG"), Integer.toString(30));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)ProjectLrb.get("CREATE_PROJECT_ERROR_NAME"), null);
            } else if (!WorkflowProject.validateProjectNameHasNoSlash(string)) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ProjectLrb.get("PROJECT_NAME_CONTAINS_SLASH"), (String)ProjectLrb.get("CREATE_PROJECT_ERROR_NAME"), null);
            } else if (!WorkflowProject.validateProjectNameUnique(connectionManager, string)) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ProjectLrb.get("PROJECT_NAME_NOT_UNIQUE"), (String)ProjectLrb.get("CREATE_PROJECT_ERROR_NAME"), null);
            } else if (!WorkflowProject.validateProjectNameLengthAtDB(connectionManager, string)) {
                bl = false;
                string2 = MessageFormat.format(ProjectLrb.get("PROJECT_NAME_TOO_LONG_BYTES"), Integer.toString(30));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)ProjectLrb.get("CREATE_PROJECT_ERROR_NAME"), null);
            } else if (!NodeNameValidator.validate(string)) {
                bl = false;
                string2 = DataminerNavigatorLrb.get("INVALID_PROJECT_NAME");
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)ProjectLrb.get("CREATE_PROJECT_ERROR_NAME"), null);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return bl;
    }

    private WorkflowProject finishCreate() throws SQLException {
        BigDecimal bigDecimal = null;
        WorkflowProject workflowProject = null;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        bigDecimal = WorkflowProject.createProject(connectionFolder, this.getName(), this.getComment());
        if (bigDecimal != null) {
            workflowProject = new WorkflowProject(this.getName(), bigDecimal, null);
        }
        return workflowProject;
    }

    private WorkflowProject finishEdit() throws SQLException {
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
            if (!this._projectState.getComment().equals(this._comment)) {
                this._projectState.setComment(connectionFolder, this._comment);
                this._projectState.setComment(this._comment);
            }
        }
        finally {
            try {
                this._projectState.unload();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return this._projectState;
    }

    public WorkflowProject finish() throws SQLException {
        if (!this._editMode) {
            return this.finishCreate();
        }
        return this.finishEdit();
    }

    private void loadDefaults() {
        this._name = this.loadDefaultName();
        this._comment = "";
    }

    private String loadDefaultName() {
        String string = ProjectLrb.get("PROJECT_DEFAULT_NAME");
        String string2 = "";
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
            string2 = WorkflowProject.createUniqueProjectName(connectionFolder, string);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        return string2;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getComment() {
        return this._comment == null ? "" : this._comment;
    }

    public void setComment(String string) {
        this._comment = string;
    }

    public Context getContext() {
        return this._context;
    }
}

