/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConnectionProperties;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionObject;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElements;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.BinGeneration;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.CategoricalBin;
import oracle.dmt.dataminer.workflow.xmlschema.DateBin;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.NumericBin;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TimestampTimezoneBin;
import oracle.dmt.dataminer.workflow.xmlschema.TransformNulls;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ide.Context;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleCallableStatement;

public class AttributeTypeHelper {
    private static final Logger theLogger = Logger.getLogger(AttributeTypeHelper.class.getName());
    public static final int NAME_MAX_LENGTH = 30;
    private static final String NO_TRANSFORM_DISTINCT_AGG = " /*+ NO_TRANSFORM_DISTINCT_AGG */ ";
    private static final String NOT_NULL = " IS NOT NULL ";
    public static final String WHERE = " WHERE ";
    private static String _maintable_alias = "t0";
    private static String DBMS_SQL_PARSE_AGGREGATE = "DECLARE   curid      NUMBER;\n  ret_value  NUMBER;\n  id_var     NUMBER;\nBEGIN\n  curid := DBMS_SQL.OPEN_CURSOR;\n  DBMS_SQL.PARSE(curid, 'select count (*) from ([SQL_EXPRESSION])', DBMS_SQL.NATIVE);\n  DBMS_SQL.DEFINE_COLUMN (curid, 1, id_var);\n  ret_value := DBMS_SQL.EXECUTE(curid);\n  ret_value := DBMS_SQL.FETCH_ROWS(curid);\n  DBMS_SQL.COLUMN_VALUE(curid, 1, id_var);\n  DBMS_SQL.CLOSE_CURSOR(curid);\n  EXCEPTION WHEN OTHERS THEN\n    DBMS_SQL.CLOSE_CURSOR(curid);\n    RAISE;  \nEND;\n";

    public static String getMaintable_alias() {
        return _maintable_alias;
    }

    public static String getHint(Context context) {
        String string = NO_TRANSFORM_DISTINCT_AGG;
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
            Version version = connectionFolder.getDbVersion();
            Version version2 = new Version("11.2.0.1.2");
            if (version2.compareTo((Object)version) <= 0) {
                string = " ";
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage());
        }
        return string;
    }

    public static ExTransformationSourceAttribute[] toExTransformationSourceAttributes(TransformationSourceAttribute[] transformationSourceAttributeArray) {
        ExTransformationSourceAttribute[] exTransformationSourceAttributeArray = new ExTransformationSourceAttribute[transformationSourceAttributeArray.length];
        for (int i = 0; i < transformationSourceAttributeArray.length; ++i) {
            exTransformationSourceAttributeArray[i] = new ExTransformationSourceAttribute(transformationSourceAttributeArray[i]);
        }
        return exTransformationSourceAttributeArray;
    }

    public static void copyAttribute(AttributeType attributeType, AttributeType attributeType2) {
        attributeType.setName(attributeType2.getName());
        attributeType.setAlias(attributeType2.getAlias());
        attributeType.setDataType(attributeType2.getDataType());
        attributeType.setStatus(attributeType2.getStatus());
        attributeType.setAnnotation(attributeType2.getAnnotation());
        attributeType.setDataTypeQualifier(attributeType2.getDataTypeQualifier());
    }

    public static TransformationNodeColumns getAllColumns(TransformationNodeType transformationNodeType) {
        TransformationNodeColumns transformationNodeColumns = new TransformationNodeColumns(transformationNodeType.getTransformedAttributes(), transformationNodeType.getTransformationSourceAttributes());
        return transformationNodeColumns;
    }

    public static TextTransformationNodeColumns getAllColumns(TextNodeType textNodeType) {
        TextTransformationNodeColumns textTransformationNodeColumns = new TextTransformationNodeColumns(textNodeType.getTransformedAttributes(), textNodeType.getTransformationSourceAttributes());
        return textTransformationNodeColumns;
    }

    public static TextTransformationNodeColumns getAllColumns(TransformedAttributesType transformedAttributesType, TransformationSourceAttributes transformationSourceAttributes) {
        TextTransformationNodeColumns textTransformationNodeColumns = new TextTransformationNodeColumns(transformedAttributesType, transformationSourceAttributes);
        return textTransformationNodeColumns;
    }

    public static TransformedAttributesType cloneTransformedAttributesType(TransformedAttributesType transformedAttributesType) {
        return (TransformedAttributesType)MetaDataHelper.copyMetadataObject(transformedAttributesType);
    }

    public static void copyTransformedAttributesType(TransformedAttributesType transformedAttributesType, TransformedAttributesType transformedAttributesType2) {
        if (null == transformedAttributesType2 || transformedAttributesType == null) {
            return;
        }
        TransformedAttributesType transformedAttributesType3 = AttributeTypeHelper.cloneTransformedAttributesType(transformedAttributesType2);
        transformedAttributesType.getMapTextTransformedSource().clear();
        List list = transformedAttributesType.getMapTextTransformedSource();
        for (MapTextTransformedSourceType mapTextTransformedSourceType : transformedAttributesType3.getMapTextTransformedSource()) {
            list.add(mapTextTransformedSourceType);
        }
    }

    public static void copyMapTextTransformedSource(MapTextTransformedSourceType mapTextTransformedSourceType, MapTextTransformedSourceType mapTextTransformedSourceType2) {
        AttributeTypeHelper.copyTextTransformationOutputAttribute(mapTextTransformedSourceType.getKey(), mapTextTransformedSourceType2.getKey());
    }

    public static boolean areEqual(TransformationOutputAttribute transformationOutputAttribute, TransformationOutputAttribute transformationOutputAttribute2) {
        if (transformationOutputAttribute == null && transformationOutputAttribute2 == null) {
            return true;
        }
        if (transformationOutputAttribute != null && transformationOutputAttribute2 != null && (transformationOutputAttribute.isModified() && transformationOutputAttribute2.isModified() || !transformationOutputAttribute.isModified() && !transformationOutputAttribute2.isModified()) && (transformationOutputAttribute.isIsOutput() && transformationOutputAttribute2.isIsOutput() || !transformationOutputAttribute.isIsOutput() && !transformationOutputAttribute2.isIsOutput())) {
            TransformationType transformationType = transformationOutputAttribute.getTransformationElementType();
            TransformationType transformationType2 = transformationOutputAttribute2.getTransformationElementType();
            if (transformationType != null && transformationType2 != null) {
                if (null != transformationType.getBinning() && null != transformationType2.getBinning()) {
                    TransformationType.Binning binning = transformationType.getBinning();
                    TransformationType.Binning binning2 = transformationType2.getBinning();
                    if (null != binning.getCustomCategorical() && null != binning2.getCustomCategorical() ? !AttributeTypeHelper.areEqual(binning.getCustomCategorical(), binning2.getCustomCategorical()) : (null != binning.getCustomDate() && null != binning2.getCustomDate() ? !AttributeTypeHelper.areEqual(binning.getCustomDate(), binning2.getCustomDate()) : (null != binning.getCustomNumeric() && null != binning2.getCustomNumeric() ? !AttributeTypeHelper.areEqual(binning.getCustomNumeric(), binning2.getCustomNumeric()) : (null != binning.getCustomTimestamp() && null != binning2.getCustomTimestamp() ? !AttributeTypeHelper.areEqual(binning.getCustomTimestamp(), binning2.getCustomTimestamp()) : (null != binning.getDateEqualWidth() && null != binning2.getDateEqualWidth() ? !AttributeTypeHelper.areEqual(AttributeTypeHelper.binWrapper(binning.getDateEqualWidth()), AttributeTypeHelper.binWrapper(binning2.getDateEqualWidth())) : (null != binning.getQuantile() && null != binning2.getQuantile() ? !AttributeTypeHelper.areEqual(AttributeTypeHelper.binWrapper(binning.getQuantile()), AttributeTypeHelper.binWrapper(binning2.getQuantile())) : (null != binning.getTimestampEqualWidth() && null != binning2.getTimestampEqualWidth() ? !AttributeTypeHelper.areEqual(AttributeTypeHelper.binWrapper(binning.getTimestampEqualWidth()), AttributeTypeHelper.binWrapper(binning2.getTimestampEqualWidth())) : (null != binning.getTopN() && null != binning2.getTopN() ? !AttributeTypeHelper.areEqual(binning.getTopN(), binning2.getTopN()) : null != binning.getEqualWidth() && null != binning2.getEqualWidth() && !AttributeTypeHelper.areEqual(AttributeTypeHelper.binWrapper(binning.getEqualWidth()), AttributeTypeHelper.binWrapper(binning2.getEqualWidth())))))))))) {
                        return false;
                    }
                } else if (null != transformationType.getCustomTransformation() && null != transformationType2.getCustomTransformation()) {
                    if (!transformationType.getCustomTransformation().getValue().equals(transformationType2.getCustomTransformation().getValue())) {
                        return false;
                    }
                } else if (null != transformationType.getCustomTransformationEx() && null != transformationType2.getCustomTransformationEx()) {
                    if (!transformationType.getCustomTransformationEx().equals(transformationType2.getCustomTransformationEx())) {
                        return false;
                    }
                } else if (null != transformationType.getMissingValuesCategorical() && null != transformationType2.getMissingValuesCategorical()) {
                    if (transformationType.getMissingValuesCategorical().getCategoricalStatistic() == null || transformationType2.getMissingValuesCategorical().getCategoricalStatistic() == null) {
                        return false;
                    }
                    if (!transformationType.getMissingValuesCategorical().getCategoricalStatistic().getReplaceNullsWith().equals(transformationType2.getMissingValuesCategorical().getCategoricalStatistic().getReplaceNullsWith())) {
                        return false;
                    }
                    if (!transformationType.getMissingValuesCategorical().getCategoricalStatistic().getValue().equals(transformationType2.getMissingValuesCategorical().getCategoricalStatistic().getValue())) {
                        return false;
                    }
                } else if (null != transformationType.getMissingValuesDate() && null != transformationType2.getMissingValuesDate()) {
                    if (transformationType.getMissingValuesDate().getDateStatistic() == null || transformationType2.getMissingValuesDate().getDateStatistic() == null) {
                        return false;
                    }
                    if (!transformationType.getMissingValuesDate().getDateStatistic().getReplaceNullsWith().equals(transformationType2.getMissingValuesDate().getDateStatistic().getReplaceNullsWith())) {
                        return false;
                    }
                    if (!transformationType.getMissingValuesDate().getDateStatistic().getValue().equals(transformationType2.getMissingValuesDate().getDateStatistic().getValue())) {
                        return false;
                    }
                } else if (null != transformationType.getMissingValuesNumeric() && null != transformationType2.getMissingValuesNumeric()) {
                    if (transformationType.getMissingValuesNumeric().getNumericStatistic() == null || transformationType2.getMissingValuesNumeric().getNumericStatistic() == null) {
                        return false;
                    }
                    if (!transformationType.getMissingValuesNumeric().getNumericStatistic().getReplaceNullsWith().equals(transformationType2.getMissingValuesNumeric().getNumericStatistic().getReplaceNullsWith())) {
                        return false;
                    }
                    if (!transformationType.getMissingValuesNumeric().getNumericStatistic().getValue().equals(transformationType2.getMissingValuesNumeric().getNumericStatistic().getValue())) {
                        return false;
                    }
                } else if (null != transformationType.getNormalization() && null != transformationType2.getNormalization()) {
                    if (transformationType.getNormalization().getLinearScale() == null || transformationType2.getNormalization().getLinearScale() == null) {
                        return false;
                    }
                    if (transformationType.getNormalization().getManual() == null || transformationType2.getNormalization().getManual() == null) {
                        return false;
                    }
                    if (transformationType.getNormalization().getMinMax() == null || transformationType2.getNormalization().getMinMax() == null) {
                        return false;
                    }
                    if (transformationType.getNormalization().getZScore() == null || transformationType2.getNormalization().getZScore() == null) {
                        return false;
                    }
                } else if (null != transformationType.getOutlier() && null != transformationType2.getOutlier()) {
                    if (transformationType.getOutlier().getPercent() == null || transformationType2.getOutlier().getPercent() == null) {
                        return false;
                    }
                    if (transformationType.getOutlier().getReplaceWith() == null || transformationType2.getOutlier().getReplaceWith() == null) {
                        return false;
                    }
                    if (transformationType.getOutlier().getStandardDeviation() == null || transformationType2.getOutlier().getStandardDeviation() == null) {
                        return false;
                    }
                    if (transformationType.getOutlier().getValue() == null || transformationType2.getOutlier().getValue() == null) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static void copyTextTransformationOutputAttribute(TextTransformationOutputAttributeType textTransformationOutputAttributeType, TextTransformationOutputAttributeType textTransformationOutputAttributeType2) {
        AttributeTypeHelper.copyTransformationSourceAttribute((TransformationSourceAttribute)textTransformationOutputAttributeType, (TransformationSourceAttribute)textTransformationOutputAttributeType2);
        textTransformationOutputAttributeType.setTransformationElement(AttributeTypeHelper.cloneTextTransformationType(textTransformationOutputAttributeType2.getTransformationElement()));
        textTransformationOutputAttributeType.setModified(textTransformationOutputAttributeType2.isModified());
    }

    public static TextTransformationType cloneTextTransformationType(TextTransformationType textTransformationType) {
        return (TextTransformationType)MetaDataHelper.copyMetadataObject(textTransformationType);
    }

    public static UpdateTableNodeType cloneUpdateTableNodeType(UpdateTableNodeType updateTableNodeType) {
        UpdateTableNodeType updateTableNodeType2 = new UpdateTableNodeType();
        updateTableNodeType2.setAutoSpec(updateTableNodeType.getAutoSpec());
        updateTableNodeType2.setDropExisting(updateTableNodeType.isDropExisting());
        updateTableNodeType2.setUpdateTargetTable(updateTableNodeType.getUpdateTargetTable());
        UpdateTableAttributes updateTableAttributes = new UpdateTableAttributes();
        List list = updateTableAttributes.getUpdateTableItemType();
        updateTableNodeType2.setUpdateTableAttributes(updateTableAttributes);
        UpdateTableAttributes updateTableAttributes2 = updateTableNodeType.getUpdateTableAttributes();
        UpdateTableNode.copyAttributes(list, updateTableAttributes2.getUpdateTableItemType());
        return updateTableNodeType2;
    }

    public static void copyUpdateTableNodeType(UpdateTableNodeType updateTableNodeType, UpdateTableNodeType updateTableNodeType2) {
        updateTableNodeType2.setAutoSpec(updateTableNodeType.getAutoSpec());
        updateTableNodeType2.setDropExisting(updateTableNodeType.isDropExisting());
        updateTableNodeType2.setUpdateTargetTable(updateTableNodeType.getUpdateTargetTable());
        UpdateTableAttributes updateTableAttributes = new UpdateTableAttributes();
        List list = updateTableAttributes.getUpdateTableItemType();
        updateTableNodeType2.setUpdateTableAttributes(updateTableAttributes);
        UpdateTableAttributes updateTableAttributes2 = updateTableNodeType.getUpdateTableAttributes();
        UpdateTableNode.copyAttributes(list, updateTableAttributes2.getUpdateTableItemType());
    }

    public static TransformationNodeType cloneTransformationNodeType(TransformationNodeType transformationNodeType) {
        SampleSettings.Method.Random random;
        TransformationNodeType transformationNodeType2 = new TransformationNodeType();
        TransformedAttributes transformedAttributes = null;
        TransformationSourceAttributes transformationSourceAttributes = new TransformationSourceAttributes();
        if (null != transformationNodeType) {
            transformedAttributes = AttributeTypeHelper.cloneTransformedAttributes(transformationNodeType.getTransformedAttributes());
            if (null != transformationNodeType.getTransformationSourceAttributes()) {
                AttributeTypeHelper.copyTransformationSourceAttributes(transformationSourceAttributes.getTransformationSourceAttributeType(), transformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType());
            }
        }
        transformationNodeType2.setTransformationSourceAttributes(transformationSourceAttributes);
        transformationNodeType2.setTransformedAttributes(transformedAttributes);
        ResultType resultType = new ResultType();
        if (null != transformationNodeType.getInputStatisticTable()) {
            resultType.setCreationDate(transformationNodeType.getInputStatisticTable().getCreationDate());
            resultType.setName(transformationNodeType.getInputStatisticTable().getName());
        }
        transformationNodeType2.setInputStatisticTable(resultType);
        ResultType resultType2 = new ResultType();
        if (null != transformationNodeType.getTransformedStatisticTable()) {
            resultType2.setCreationDate(transformationNodeType.getTransformedStatisticTable().getCreationDate());
            resultType2.setName(transformationNodeType.getTransformedStatisticTable().getName());
        }
        transformationNodeType2.setTransformedStatisticTable(resultType2);
        SampleSettings sampleSettings = transformationNodeType.getSampleSettings();
        SampleSettings sampleSettings2 = new SampleSettings();
        sampleSettings2.setNumberOfRows(sampleSettings.getNumberOfRows());
        sampleSettings2.setPercentOfTotal(sampleSettings.getPercentOfTotal());
        SampleSettings.Method method = new SampleSettings.Method();
        if (sampleSettings.getMethod().getRandom() != null) {
            random = new SampleSettings.Method.Random();
            random.setSeed(sampleSettings.getMethod().getRandom().getSeed());
            method.setRandom(random);
        } else if (sampleSettings.getMethod().getStratified() != null) {
            random = new SampleSettings.Method.Stratified();
            random.setTargetAttr(sampleSettings.getMethod().getStratified().getTargetAttr());
            method.setStratified((SampleSettings.Method.Stratified)random);
        } else if (sampleSettings.getMethod().getTopN() != null) {
            random = new SampleSettings.Method.TopN();
            method.setTopN((SampleSettings.Method.TopN)random);
        }
        sampleSettings2.setMethod(method);
        sampleSettings2.setUseFullData(sampleSettings.isUseFullData());
        sampleSettings2.setGenerateCache(Boolean.valueOf(sampleSettings.isGenerateCache()));
        random = new ResultType();
        ResultType resultType3 = sampleSettings.getOutputTable();
        if (resultType3 != null) {
            if (resultType3.getCreationDate() != null) {
                random.setCreationDate(resultType3.getCreationDate());
            }
            if (resultType3.getName() != null) {
                random.setName(resultType3.getName());
            }
        }
        sampleSettings2.setOutputTable((ResultType)random);
        transformationNodeType2.setSampleSettings(sampleSettings2);
        StatsSelection statsSelection = new StatsSelection();
        StatsSelection statsSelection2 = transformationNodeType.getStatsSelection();
        if (statsSelection2 != null) {
            statsSelection.setAvg(Boolean.valueOf(statsSelection2.isAvg()));
            statsSelection.setKurtosis(Boolean.valueOf(statsSelection2.isKurtosis()));
            statsSelection.setMax(Boolean.valueOf(statsSelection2.isMax()));
            statsSelection.setMedian(Boolean.valueOf(statsSelection2.isMedian()));
            statsSelection.setMin(Boolean.valueOf(statsSelection2.isMin()));
            statsSelection.setMode(Boolean.valueOf(statsSelection2.isMode()));
            statsSelection.setModeall(Boolean.valueOf(statsSelection2.isModeall()));
            statsSelection.setModesampled(Boolean.valueOf(statsSelection2.isModesampled()));
            statsSelection.setPercentdistinct(Boolean.valueOf(statsSelection2.isPercentdistinct()));
            statsSelection.setPercentnull(Boolean.valueOf(statsSelection2.isPercentnull()));
            statsSelection.setSkewness(Boolean.valueOf(statsSelection2.isSkewness()));
            statsSelection.setStd(Boolean.valueOf(statsSelection2.isStd()));
            statsSelection.setVar(Boolean.valueOf(statsSelection2.isVar()));
            statsSelection.setHistogram(Boolean.valueOf(statsSelection2.isHistogram()));
        } else {
            statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
        }
        transformationNodeType2.setStatsSelection(statsSelection);
        return transformationNodeType2;
    }

    public static TransformedAttributes cloneTransformedAttributes(TransformedAttributes transformedAttributes) {
        TransformedAttributes transformedAttributes2 = new TransformedAttributes();
        if (null == transformedAttributes) {
            return transformedAttributes2;
        }
        List list = transformedAttributes2.getMapTransformedSourceType();
        if (null != transformedAttributes && !transformedAttributes.getMapTransformedSourceType().isEmpty()) {
            for (MapTransformedSource mapTransformedSource : transformedAttributes.getMapTransformedSourceType()) {
                MapTransformedSource mapTransformedSource2 = new MapTransformedSource();
                TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource.getKey();
                TransformationOutputAttribute transformationOutputAttribute2 = new TransformationOutputAttribute();
                AttributeTypeHelper.copyTransformationSourceAttribute((TransformationSourceAttribute)transformationOutputAttribute2, (TransformationSourceAttribute)transformationOutputAttribute);
                transformationOutputAttribute2.setTransformationElementType(AttributeTypeHelper.cloneTransformationType(transformationOutputAttribute.getTransformationElementType()));
                transformationOutputAttribute2.setModified(transformationOutputAttribute.isModified());
                mapTransformedSource2.setKey(transformationOutputAttribute2);
                StringCollection stringCollection = mapTransformedSource.getStringCollectionNames();
                StringCollection stringCollection2 = new StringCollection();
                if (stringCollection != null) {
                    stringCollection2.getValue().addAll(stringCollection.getValue());
                }
                mapTransformedSource2.setStringCollectionNames(stringCollection2);
                list.add(mapTransformedSource2);
            }
        }
        return transformedAttributes2;
    }

    public static MapTransformedSource cloneMapTransformedSource(MapTransformedSource mapTransformedSource) {
        MapTransformedSource mapTransformedSource2 = new MapTransformedSource();
        TransformationOutputAttribute transformationOutputAttribute = new TransformationOutputAttribute();
        AttributeTypeHelper.copyTransformationOutputAttribute(transformationOutputAttribute, mapTransformedSource.getKey());
        mapTransformedSource2.setKey(transformationOutputAttribute);
        StringCollection stringCollection = new StringCollection();
        stringCollection.getValue().addAll(mapTransformedSource.getStringCollectionNames().getValue());
        mapTransformedSource2.setStringCollectionNames(stringCollection);
        return mapTransformedSource2;
    }

    public static void copyMapTransformedSource(MapTransformedSource mapTransformedSource, MapTransformedSource mapTransformedSource2) {
        AttributeTypeHelper.copyTransformationOutputAttribute(mapTransformedSource.getKey(), mapTransformedSource2.getKey());
        mapTransformedSource.getStringCollectionNames().getValue().clear();
        mapTransformedSource.getStringCollectionNames().getValue().addAll(mapTransformedSource2.getStringCollectionNames().getValue());
    }

    public static MapTransformedSource findMapTransformedSource(TransformedAttributes transformedAttributes, AttributeType attributeType) {
        return AttributeTypeHelper.findMapTransformedSource(transformedAttributes, attributeType.getName());
    }

    public static MapTransformedSource findMapTransformedSource(TransformedAttributes transformedAttributes, String string) {
        MapTransformedSource mapTransformedSource = null;
        List list = transformedAttributes.getMapTransformedSourceType();
        for (MapTransformedSource mapTransformedSource2 : list) {
            if (!mapTransformedSource2.getKey().getName().equals(string)) continue;
            mapTransformedSource = mapTransformedSource2;
            break;
        }
        return mapTransformedSource;
    }

    public static void copyTransformedAttributes(TransformedAttributes transformedAttributes, TransformedAttributes transformedAttributes2) {
        if (null == transformedAttributes2 || transformedAttributes == null) {
            return;
        }
        transformedAttributes.getMapTransformedSourceType().clear();
        List list = transformedAttributes.getMapTransformedSourceType();
        if (null != transformedAttributes2 && !transformedAttributes2.getMapTransformedSourceType().isEmpty()) {
            for (MapTransformedSource mapTransformedSource : transformedAttributes2.getMapTransformedSourceType()) {
                MapTransformedSource mapTransformedSource2 = new MapTransformedSource();
                TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource.getKey();
                TransformationOutputAttribute transformationOutputAttribute2 = new TransformationOutputAttribute();
                AttributeTypeHelper.copyTransformationSourceAttribute((TransformationSourceAttribute)transformationOutputAttribute2, (TransformationSourceAttribute)transformationOutputAttribute);
                transformationOutputAttribute2.setTransformationElementType(AttributeTypeHelper.cloneTransformationType(transformationOutputAttribute.getTransformationElementType()));
                transformationOutputAttribute2.setModified(transformationOutputAttribute.isModified());
                mapTransformedSource2.setKey(transformationOutputAttribute2);
                StringCollection stringCollection = mapTransformedSource.getStringCollectionNames();
                StringCollection stringCollection2 = new StringCollection();
                if (stringCollection != null) {
                    stringCollection2.getValue().addAll(stringCollection.getValue());
                }
                mapTransformedSource2.setStringCollectionNames(stringCollection2);
                list.add(mapTransformedSource2);
            }
        }
    }

    public static Vector<TransformationSourceAttribute> toVector(List<TransformationSourceAttribute> list) {
        Vector<TransformationSourceAttribute> vector = new Vector<TransformationSourceAttribute>(list);
        return vector;
    }

    public static TransformNulls cloneTransformNulls(TransformNulls transformNulls) {
        TransformNulls transformNulls2 = new TransformNulls();
        if (transformNulls != null) {
            transformNulls2.setIncludeNulls(transformNulls.isIncludeNulls());
            transformNulls2.setLabel(transformNulls.getLabel());
            transformNulls2.setNullBinId(transformNulls.getNullBinId());
            transformNulls2.setNullBinsSelection(transformNulls.getNullBinsSelection());
        } else {
            transformNulls2.setIncludeNulls(true);
            transformNulls2.setLabel(GraphModelProvider.NULL_BINS);
            transformNulls2.setNullBinsSelection("Auto");
        }
        return transformNulls2;
    }

    public static boolean areEqual(TransformNulls transformNulls, TransformNulls transformNulls2) {
        if (transformNulls == null && transformNulls2 == null) {
            return true;
        }
        if (transformNulls != null && transformNulls2 != null) {
            if (null != transformNulls.getLabel() && null != transformNulls2.getLabel() ? !transformNulls.getLabel().equals(transformNulls2.getLabel()) : null != transformNulls.getLabel() || null != transformNulls2.getLabel()) {
                return false;
            }
            if (transformNulls.isIncludeNulls() != transformNulls2.isIncludeNulls()) {
                return false;
            }
            if (transformNulls.getNullBinId() != null && transformNulls2.getNullBinId() != null ? !transformNulls.getNullBinId().equals(transformNulls2.getNullBinId()) : transformNulls.getNullBinId() != null || transformNulls2.getNullBinId() != null) {
                return false;
            }
            if (transformNulls.getNullBinsSelection() != null && transformNulls2.getNullBinsSelection() != null ? !transformNulls.getNullBinsSelection().equals(transformNulls2.getNullBinsSelection()) : transformNulls.getNullBinsSelection() != null || transformNulls2.getNullBinsSelection() != null) {
                return false;
            }
        }
        return true;
    }

    public static boolean areEqualCategoricalBinLists(List<CategoricalBin> list, List<CategoricalBin> list2) {
        if (null == list && null == list2) {
            return true;
        }
        if (null == list || null == list2) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            CategoricalBin categoricalBin = list.get(i);
            CategoricalBin categoricalBin2 = list2.get(i);
            if (!categoricalBin.getName().equals(categoricalBin2.getName())) {
                return false;
            }
            if (categoricalBin.isIsOther() != categoricalBin2.isIsOther()) {
                return false;
            }
            StringCollection stringCollection = categoricalBin.getStringCollectionValues();
            StringCollection stringCollection2 = categoricalBin2.getStringCollectionValues();
            if (stringCollection == null || stringCollection2 == null) continue;
            List list3 = stringCollection.getValue();
            List list4 = stringCollection2.getValue();
            if (null == list3 || null == list4) continue;
            if (list3.size() != list4.size()) {
                return false;
            }
            for (int j = 0; j < list3.size(); ++j) {
                String string;
                String string2 = (String)list3.get(j);
                if (string2.equals(string = (String)list4.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean areEqual(TransformationType.Binning.CustomCategorical customCategorical, TransformationType.Binning.CustomCategorical customCategorical2) {
        if (null == customCategorical && null == customCategorical2) {
            return true;
        }
        if (customCategorical == null || customCategorical2 == null) {
            return false;
        }
        if (!AttributeTypeHelper.areEqual(customCategorical.getTransformNulls(), customCategorical2.getTransformNulls())) {
            return false;
        }
        return AttributeTypeHelper.areEqualCategoricalBinLists(customCategorical.getCategoricalBin(), customCategorical.getCategoricalBin());
    }

    public static boolean areEqual(TransformationType.Binning.CustomDate customDate, TransformationType.Binning.CustomDate customDate2) {
        if (null == customDate && null == customDate2) {
            return true;
        }
        if (customDate == null || customDate2 == null) {
            return false;
        }
        if (!AttributeTypeHelper.areEqual(customDate.getTransformNulls(), customDate2.getTransformNulls())) {
            return false;
        }
        BinLabels binLabels = customDate.getBinLabels();
        BinLabels binLabels2 = customDate2.getBinLabels();
        if (binLabels.getNumberSequence() != null && binLabels2.getNumberSequence() != null || binLabels.getRange() != null && binLabels2.getRange() != null) {
            List list = customDate.getDateBin();
            List list2 = customDate2.getDateBin();
            if (null == list || null == list2) {
                return false;
            }
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                DateBin dateBin = (DateBin)list.get(i);
                DateBin dateBin2 = (DateBin)list2.get(i);
                if (dateBin.getLowerBound() != dateBin2.getLowerBound()) {
                    return false;
                }
                if (dateBin.getName() == dateBin2.getName()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean areEqual(TransformationType.Binning.CustomTimestamp customTimestamp, TransformationType.Binning.CustomTimestamp customTimestamp2) {
        if (null == customTimestamp && null == customTimestamp2) {
            return true;
        }
        if (customTimestamp == null || customTimestamp2 == null) {
            return false;
        }
        if (!AttributeTypeHelper.areEqual(customTimestamp.getTransformNulls(), customTimestamp2.getTransformNulls())) {
            return false;
        }
        BinLabels binLabels = customTimestamp.getBinLabels();
        BinLabels binLabels2 = customTimestamp2.getBinLabels();
        if (binLabels.getNumberSequence() != null && binLabels2.getNumberSequence() != null || binLabels.getRange() != null && binLabels2.getRange() != null) {
            List list = customTimestamp.getTimestampTimezoneBin();
            List list2 = customTimestamp2.getTimestampTimezoneBin();
            if (null == list || null == list2) {
                return false;
            }
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                TimestampTimezoneBin timestampTimezoneBin = (TimestampTimezoneBin)list.get(i);
                TimestampTimezoneBin timestampTimezoneBin2 = (TimestampTimezoneBin)list2.get(i);
                if (timestampTimezoneBin.getLowerBound() != timestampTimezoneBin2.getLowerBound()) {
                    return false;
                }
                if (timestampTimezoneBin.getName() == timestampTimezoneBin2.getName()) continue;
                return false;
            }
        }
        return true;
    }

    public static Wrapper binWrapper(Object object) {
        return new Wrapper(object);
    }

    public static boolean areEqual(Wrapper wrapper, Wrapper wrapper2) {
        if (null == wrapper && null == wrapper2) {
            return true;
        }
        if (wrapper == null || wrapper2 == null) {
            return false;
        }
        if (!AttributeTypeHelper.areEqual(wrapper.getTransformNulls(), wrapper2.getTransformNulls())) {
            return false;
        }
        BinLabels binLabels = wrapper.getBinLabels();
        BinLabels binLabels2 = wrapper2.getBinLabels();
        if (binLabels.getNumberSequence() != null && binLabels2.getNumberSequence() != null || binLabels.getRange() != null && binLabels2.getRange() != null) {
            if (wrapper.getBinCount() != wrapper2.getBinCount()) {
                return false;
            }
            if (wrapper.getBinGeneration() != null && wrapper2.getBinGeneration() != null) {
                if (wrapper.getBinGeneration().getAuto() == null || wrapper2.getBinGeneration().getAuto() == null) {
                    return false;
                }
                if (wrapper.getBinGeneration().getManual() == null || wrapper2.getBinGeneration().getManual() == null) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean areEqual(TransformationType.Binning.TopN topN, TransformationType.Binning.TopN topN2) {
        if (null == topN && null == topN2) {
            return true;
        }
        if (topN == null || topN2 == null) {
            return false;
        }
        if (!AttributeTypeHelper.areEqual(topN.getTransformNulls(), topN2.getTransformNulls())) {
            return false;
        }
        if (topN.getBinCount() != topN2.getBinCount()) {
            return false;
        }
        if (!topN.getOther().equals(topN2.getOther())) {
            return false;
        }
        return AttributeTypeHelper.areEqualCategoricalBinLists(topN.getCategoricalBin(), topN2.getCategoricalBin());
    }

    public static boolean areEqual(TransformationType.Binning.CustomNumeric customNumeric, TransformationType.Binning.CustomNumeric customNumeric2) {
        if (null == customNumeric2 && null == customNumeric2) {
            return true;
        }
        if (customNumeric == null || customNumeric2 == null) {
            return false;
        }
        if (!AttributeTypeHelper.areEqual(customNumeric.getTransformNulls(), customNumeric2.getTransformNulls())) {
            return false;
        }
        BinLabels binLabels = customNumeric.getBinLabels();
        BinLabels binLabels2 = customNumeric.getBinLabels();
        if (binLabels.getNumberSequence() != null && binLabels2.getNumberSequence() != null || binLabels.getRange() != null && binLabels2.getRange() != null) {
            List list = customNumeric.getNumericBin();
            List list2 = customNumeric2.getNumericBin();
            if (null == list || null == list2) {
                return false;
            }
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                NumericBin numericBin = (NumericBin)list.get(i);
                NumericBin numericBin2 = (NumericBin)list2.get(i);
                if (numericBin.getLowerBound() != numericBin2.getLowerBound()) {
                    return false;
                }
                if (numericBin.getBinName() == numericBin2.getBinName()) continue;
                return false;
            }
        }
        return true;
    }

    private static void copyNumBins(List<NumericBin> list, List<NumericBin> list2) {
        for (NumericBin numericBin : list2) {
            NumericBin numericBin2 = new NumericBin();
            numericBin2.setBinName(numericBin.getBinName());
            numericBin2.setLowerBound(numericBin.getLowerBound());
            list.add(numericBin2);
        }
    }

    private static void copyDateBins(List<DateBin> list, List<DateBin> list2) {
        for (DateBin dateBin : list2) {
            DateBin dateBin2 = new DateBin();
            dateBin2.setName(dateBin.getName());
            dateBin2.setLowerBound(dateBin.getLowerBound());
            list.add(dateBin2);
        }
    }

    private static void copyTimestampTimezoneBins(List<TimestampTimezoneBin> list, List<TimestampTimezoneBin> list2) {
        for (TimestampTimezoneBin timestampTimezoneBin : list2) {
            TimestampTimezoneBin timestampTimezoneBin2 = new TimestampTimezoneBin();
            timestampTimezoneBin2.setName(timestampTimezoneBin.getName());
            timestampTimezoneBin2.setLowerBound(timestampTimezoneBin.getLowerBound());
            list.add(timestampTimezoneBin2);
        }
    }

    private static void copyCategoricalBins(List<CategoricalBin> list, List<CategoricalBin> list2) {
        for (CategoricalBin categoricalBin : list2) {
            CategoricalBin categoricalBin2 = new CategoricalBin();
            categoricalBin2.setIsOther(categoricalBin.isIsOther());
            categoricalBin2.setName(categoricalBin.getName());
            StringCollection stringCollection = categoricalBin.getStringCollectionValues();
            if (stringCollection != null) {
                StringCollection stringCollection2 = new StringCollection();
                stringCollection2.getValue().addAll(stringCollection.getValue());
                categoricalBin2.setStringCollectionValues(stringCollection2);
            }
            list.add(categoricalBin2);
        }
    }

    public static TransformationType cloneTransformationType(TransformationType transformationType) {
        TransformationType transformationType2 = new TransformationType();
        if (null != transformationType.getBinning()) {
            TransformationType.Binning binning = transformationType.getBinning();
            TransformationType.Binning binning2 = new TransformationType.Binning();
            if (null != binning.getQuantile()) {
                TransformationType.Binning.Quantile quantile = new TransformationType.Binning.Quantile();
                quantile.setBinCount(binning.getQuantile().getBinCount());
                quantile.setBinGeneration(binning.getQuantile().getBinGeneration());
                quantile.setBinLabels(binning.getQuantile().getBinLabels());
                AttributeTypeHelper.copyNumBins(quantile.getNumericBin(), binning.getQuantile().getNumericBin());
                quantile.setTransformNulls(AttributeTypeHelper.cloneTransformNulls(binning.getQuantile().getTransformNulls()));
                binning2.setQuantile(quantile);
            } else if (null != binning.getCustomCategorical() && null != binning.getCustomCategorical().getCategoricalBin()) {
                TransformationType.Binning.CustomCategorical customCategorical = new TransformationType.Binning.CustomCategorical();
                AttributeTypeHelper.copyCategoricalBins(customCategorical.getCategoricalBin(), binning.getCustomCategorical().getCategoricalBin());
                customCategorical.setTransformNulls(AttributeTypeHelper.cloneTransformNulls(binning.getCustomCategorical().getTransformNulls()));
                binning2.setCustomCategorical(customCategorical);
            } else if (null != binning.getCustomNumeric() && null != binning.getCustomNumeric().getNumericBin()) {
                TransformationType.Binning.CustomNumeric customNumeric = new TransformationType.Binning.CustomNumeric();
                AttributeTypeHelper.copyNumBins(customNumeric.getNumericBin(), binning.getCustomNumeric().getNumericBin());
                BinLabels binLabels = new BinLabels();
                if (null != binning.getCustomNumeric().getBinLabels().getNumberSequence()) {
                    binLabels.setNumberSequence(new BinLabels.NumberSequence());
                } else {
                    binLabels.setRange(new BinLabels.Range());
                }
                customNumeric.setBinLabels(binLabels);
                customNumeric.setTransformNulls(AttributeTypeHelper.cloneTransformNulls(binning.getCustomNumeric().getTransformNulls()));
                binning2.setCustomNumeric(customNumeric);
            } else if (null != binning.getCustomDate() && null != binning.getCustomDate().getDateBin()) {
                TransformationType.Binning.CustomDate customDate = new TransformationType.Binning.CustomDate();
                AttributeTypeHelper.copyDateBins(customDate.getDateBin(), binning.getCustomDate().getDateBin());
                BinLabels binLabels = new BinLabels();
                if (null != binning.getCustomDate().getBinLabels().getNumberSequence()) {
                    binLabels.setNumberSequence(new BinLabels.NumberSequence());
                } else {
                    binLabels.setRange(new BinLabels.Range());
                }
                customDate.setBinLabels(binLabels);
                customDate.setTransformNulls(AttributeTypeHelper.cloneTransformNulls(binning.getCustomDate().getTransformNulls()));
                binning2.setCustomDate(customDate);
            } else if (null != binning.getCustomTimestamp() && null != binning.getCustomTimestamp().getTimestampTimezoneBin()) {
                TransformationType.Binning.CustomTimestamp customTimestamp = new TransformationType.Binning.CustomTimestamp();
                AttributeTypeHelper.copyTimestampTimezoneBins(customTimestamp.getTimestampTimezoneBin(), binning.getCustomTimestamp().getTimestampTimezoneBin());
                BinLabels binLabels = new BinLabels();
                if (null != binning.getCustomTimestamp().getBinLabels().getNumberSequence()) {
                    binLabels.setNumberSequence(new BinLabels.NumberSequence());
                } else {
                    binLabels.setRange(new BinLabels.Range());
                }
                customTimestamp.setBinLabels(binLabels);
                customTimestamp.setTransformNulls(AttributeTypeHelper.cloneTransformNulls(binning.getCustomTimestamp().getTransformNulls()));
                binning2.setCustomTimestamp(customTimestamp);
            } else if (null != binning.getEqualWidth()) {
                TransformationType.Binning.EqualWidth equalWidth = new TransformationType.Binning.EqualWidth();
                equalWidth.setBinCount(binning.getEqualWidth().getBinCount());
                equalWidth.setBinGeneration(binning.getEqualWidth().getBinGeneration());
                equalWidth.setBinLabels(binning.getEqualWidth().getBinLabels());
                AttributeTypeHelper.copyNumBins(equalWidth.getNumericBin(), binning.getEqualWidth().getNumericBin());
                equalWidth.setTransformNulls(AttributeTypeHelper.cloneTransformNulls(binning.getEqualWidth().getTransformNulls()));
                binning2.setEqualWidth(equalWidth);
            } else if (null != binning.getDateEqualWidth()) {
                TransformationType.Binning.DateEqualWidth dateEqualWidth = new TransformationType.Binning.DateEqualWidth();
                dateEqualWidth.setBinCount(binning.getDateEqualWidth().getBinCount());
                dateEqualWidth.setBinGeneration(binning.getDateEqualWidth().getBinGeneration());
                dateEqualWidth.setBinLabels(binning.getDateEqualWidth().getBinLabels());
                AttributeTypeHelper.copyDateBins(dateEqualWidth.getDateBin(), binning.getDateEqualWidth().getDateBin());
                dateEqualWidth.setTransformNulls(AttributeTypeHelper.cloneTransformNulls(binning.getDateEqualWidth().getTransformNulls()));
                binning2.setDateEqualWidth(dateEqualWidth);
            } else if (null != binning.getTimestampEqualWidth()) {
                TransformationType.Binning.TimestampEqualWidth timestampEqualWidth = new TransformationType.Binning.TimestampEqualWidth();
                timestampEqualWidth.setBinCount(binning.getTimestampEqualWidth().getBinCount());
                timestampEqualWidth.setBinGeneration(binning.getTimestampEqualWidth().getBinGeneration());
                timestampEqualWidth.setBinLabels(binning.getTimestampEqualWidth().getBinLabels());
                AttributeTypeHelper.copyTimestampTimezoneBins(timestampEqualWidth.getTimestampTimezoneBin(), binning.getTimestampEqualWidth().getTimestampTimezoneBin());
                timestampEqualWidth.setTransformNulls(AttributeTypeHelper.cloneTransformNulls(binning.getTimestampEqualWidth().getTransformNulls()));
                binning2.setTimestampEqualWidth(timestampEqualWidth);
            } else if (null != binning.getTopN()) {
                TransformationType.Binning.TopN topN = new TransformationType.Binning.TopN();
                topN.setBinCount(binning.getTopN().getBinCount());
                topN.setOther(binning.getTopN().getOther());
                AttributeTypeHelper.copyCategoricalBins(topN.getCategoricalBin(), binning.getTopN().getCategoricalBin());
                topN.setTransformNulls(AttributeTypeHelper.cloneTransformNulls(binning.getTopN().getTransformNulls()));
                binning2.setTopN(topN);
            }
            transformationType2.setBinning(binning2);
        } else if (null == transformationType.getCustomTransformationEx() && null != transformationType.getCustomTransformation()) {
            TransformationType.CustomTransformation customTransformation = transformationType.getCustomTransformation();
            TransformationType.CustomTransformation customTransformation2 = new TransformationType.CustomTransformation();
            customTransformation2.setValue(customTransformation.getValue());
            transformationType2.setCustomTransformation(customTransformation2);
            if (null == transformationType.getCustomTransformationEx()) {
                transformationType2.setCustomTransformationEx(customTransformation.getValue());
            }
        } else if (null != transformationType.getCustomTransformationEx()) {
            transformationType2.setCustomTransformationEx(transformationType.getCustomTransformationEx());
        } else if (null != transformationType.getMissingValuesCategorical()) {
            TransformationType.MissingValuesCategorical missingValuesCategorical = transformationType.getMissingValuesCategorical();
            TransformationType.MissingValuesCategorical missingValuesCategorical2 = new TransformationType.MissingValuesCategorical();
            missingValuesCategorical2.setValue(missingValuesCategorical.getValue());
            missingValuesCategorical2.setCategoricalStatistic(missingValuesCategorical.getCategoricalStatistic());
            transformationType2.setMissingValuesCategorical(missingValuesCategorical2);
        } else if (null != transformationType.getMissingValuesDate()) {
            TransformationType.MissingValuesDate missingValuesDate = transformationType.getMissingValuesDate();
            TransformationType.MissingValuesDate missingValuesDate2 = new TransformationType.MissingValuesDate();
            missingValuesDate2.setValue(missingValuesDate.getValue());
            missingValuesDate2.setDateStatistic(missingValuesDate.getDateStatistic());
            transformationType2.setMissingValuesDate(missingValuesDate2);
        } else if (null != transformationType.getMissingValuesNumeric()) {
            TransformationType.MissingValuesNumeric missingValuesNumeric = transformationType.getMissingValuesNumeric();
            TransformationType.MissingValuesNumeric missingValuesNumeric2 = new TransformationType.MissingValuesNumeric();
            missingValuesNumeric2.setValue(missingValuesNumeric.getValue());
            missingValuesNumeric2.setNumericStatistic(missingValuesNumeric.getNumericStatistic());
            transformationType2.setMissingValuesNumeric(missingValuesNumeric2);
        } else if (null != transformationType.getNormalization()) {
            TransformationType.Normalization normalization = transformationType.getNormalization();
            TransformationType.Normalization normalization2 = new TransformationType.Normalization();
            normalization2.setLinearScale(normalization.getLinearScale());
            normalization2.setMinMax(normalization.getMinMax());
            normalization2.setZScore(normalization.getZScore());
            normalization2.setManual(normalization.getManual());
            transformationType2.setNormalization(normalization2);
        } else if (null != transformationType.getOutlier()) {
            TransformationType.Outlier outlier = transformationType.getOutlier();
            TransformationType.Outlier outlier2 = new TransformationType.Outlier();
            outlier2.setPercent(outlier.getPercent());
            outlier2.setValue(outlier.getValue());
            outlier2.setStandardDeviation(outlier.getStandardDeviation());
            outlier2.setReplaceWith(outlier.getReplaceWith());
            transformationType2.setOutlier(outlier2);
        }
        return transformationType2;
    }

    public static void copyTransformationSourceAttribute(TransformationSourceAttribute transformationSourceAttribute, TransformationSourceAttribute transformationSourceAttribute2) {
        transformationSourceAttribute.setIsOutput(transformationSourceAttribute2.isIsOutput());
        AttributeTypeHelper.copyAttribute((AttributeType)transformationSourceAttribute, (AttributeType)transformationSourceAttribute2);
    }

    public static void copyTransformationOutputAttribute(TransformationOutputAttribute transformationOutputAttribute, TransformationOutputAttribute transformationOutputAttribute2) {
        AttributeTypeHelper.copyTransformationSourceAttribute((TransformationSourceAttribute)transformationOutputAttribute, (TransformationSourceAttribute)transformationOutputAttribute2);
        transformationOutputAttribute.setTransformationElementType(AttributeTypeHelper.cloneTransformationType(transformationOutputAttribute2.getTransformationElementType()));
        transformationOutputAttribute.setModified(transformationOutputAttribute2.isModified());
    }

    public static TransformationSourceAttribute cloneTransformationAttribute(AttributeType attributeType) {
        TransformationOutputAttribute transformationOutputAttribute = null;
        if (attributeType instanceof TransformationOutputAttribute) {
            transformationOutputAttribute = new TransformationOutputAttribute();
            AttributeTypeHelper.copyTransformationOutputAttribute(transformationOutputAttribute, (TransformationOutputAttribute)attributeType);
        } else if (attributeType instanceof TransformationSourceAttribute) {
            transformationOutputAttribute = new TransformationSourceAttribute();
            AttributeTypeHelper.copyTransformationSourceAttribute((TransformationSourceAttribute)transformationOutputAttribute, (TransformationSourceAttribute)attributeType);
        }
        return transformationOutputAttribute;
    }

    public static void copyTransformationSourceAttributes(List<TransformationSourceAttribute> list, List<TransformationSourceAttribute> list2) {
        list.clear();
        for (TransformationSourceAttribute transformationSourceAttribute : list2) {
            TransformationSourceAttribute transformationSourceAttribute2 = new TransformationSourceAttribute();
            AttributeTypeHelper.copyTransformationSourceAttribute(transformationSourceAttribute2, transformationSourceAttribute);
            list.add(transformationSourceAttribute2);
        }
    }

    public static String createUniqueTransformationOutputNameWizard(String string, String string2, List<TransformationSourceAttribute> list, List<MapTransformedSource> list2, List<String> list3) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        if (list3 != null) {
            for (String string3 : list3) {
                hashMap.put(string3, new AttributeType());
            }
        }
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), (AttributeType)transformationSourceAttribute);
        }
        for (MapTransformedSource mapTransformedSource : list2) {
            if (null == mapTransformedSource.getKey()) continue;
            hashMap.put(mapTransformedSource.getKey().getName(), (AttributeType)mapTransformedSource.getKey());
        }
        return AttributeTypeHelper.createUniqueOutputName(string, string2, hashMap);
    }

    public static String createUniqueTransformationOutputName(String string, String string2, List<TransformationSourceAttribute> list, List<MapTransformedSource> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), (AttributeType)transformationSourceAttribute);
        }
        for (MapTransformedSource mapTransformedSource : list2) {
            hashMap.put(mapTransformedSource.getKey().getName(), (AttributeType)mapTransformedSource.getKey());
        }
        return AttributeTypeHelper.createUniqueOutputName(string, string2, hashMap);
    }

    public static String createUniqueTextTransformationOutputName(String string, String string2, List<TransformationSourceAttribute> list, List<MapTextTransformedSourceType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), (AttributeType)transformationSourceAttribute);
        }
        for (MapTextTransformedSourceType mapTextTransformedSourceType : list2) {
            hashMap.put(mapTextTransformedSourceType.getKey().getName(), (AttributeType)mapTextTransformedSourceType.getKey());
        }
        return AttributeTypeHelper.createUniqueOutputName(string, string2, hashMap);
    }

    public static boolean isUniqueTransformationOutputName(String string, List<TransformationSourceAttribute> list, List<MapTransformedSource> list2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute);
        }
        for (MapTransformedSource mapTransformedSource : list2) {
            hashMap.put(mapTransformedSource.getKey().getName(), mapTransformedSource.getKey());
        }
        return null == hashMap.get(string);
    }

    public static void copyAttributes(List<AggregationElementType> list, List<AggregationElementType> list2, Map<String, AggregationElementType> map) {
        for (AggregationElementType aggregationElementType : list2) {
            if (map != null && !map.isEmpty() && null != map.get(aggregationElementType.getOutput().getName())) continue;
            AggregationElementType aggregationElementType2 = new AggregationElementType();
            aggregationElementType2.setAggregationFunction(aggregationElementType.getAggregationFunction());
            AttributeType attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, aggregationElementType.getOutput());
            aggregationElementType2.setOutput(attributeType);
            GroupingElementType groupingElementType = new GroupingElementType();
            GroupingElementType groupingElementType2 = aggregationElementType.getSource();
            AttributeTypeHelper.copyGroupingElementType(groupingElementType, groupingElementType2);
            aggregationElementType2.setSource(groupingElementType);
            GroupingElementType groupingElementType3 = new GroupingElementType();
            GroupingElementType groupingElementType4 = aggregationElementType.getSubGroupBy();
            if (groupingElementType4 != null) {
                AttributeTypeHelper.copyGroupingElementType(groupingElementType3, groupingElementType4);
            }
            aggregationElementType2.setSubGroupBy(groupingElementType3);
            list.add(aggregationElementType2);
        }
    }

    public static AggregationElementType cloneAggregationElementType(AggregationElementType aggregationElementType) {
        GroupingElementType groupingElementType;
        AttributeType attributeType;
        AggregationElementType aggregationElementType2 = new AggregationElementType();
        aggregationElementType2.setAggregationFunction(aggregationElementType.getAggregationFunction());
        if (null != aggregationElementType.getOutput()) {
            attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, aggregationElementType.getOutput());
            aggregationElementType2.setOutput(attributeType);
        }
        if (null != aggregationElementType.getSource()) {
            attributeType = new GroupingElementType();
            groupingElementType = aggregationElementType.getSource();
            AttributeTypeHelper.copyGroupingElementType((GroupingElementType)attributeType, groupingElementType);
            aggregationElementType2.setSource((GroupingElementType)attributeType);
        }
        if (null != aggregationElementType.getSubGroupBy()) {
            attributeType = new GroupingElementType();
            groupingElementType = aggregationElementType.getSubGroupBy();
            AttributeTypeHelper.copyGroupingElementType((GroupingElementType)attributeType, groupingElementType);
            aggregationElementType2.setSubGroupBy((GroupingElementType)attributeType);
        }
        return aggregationElementType2;
    }

    public static void copyAggregationElementType(AggregationElementType aggregationElementType, AggregationElementType aggregationElementType2) {
        GroupingElementType groupingElementType;
        AttributeType attributeType;
        aggregationElementType.setAggregationFunction(aggregationElementType2.getAggregationFunction());
        if (null != aggregationElementType2.getOutput()) {
            attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, aggregationElementType2.getOutput());
            aggregationElementType.setOutput(attributeType);
        }
        if (null != aggregationElementType2.getSource()) {
            attributeType = new GroupingElementType();
            groupingElementType = aggregationElementType2.getSource();
            AttributeTypeHelper.copyGroupingElementType((GroupingElementType)attributeType, groupingElementType);
            aggregationElementType.setSource((GroupingElementType)attributeType);
        }
        if (null != aggregationElementType2.getSubGroupBy()) {
            attributeType = new GroupingElementType();
            groupingElementType = aggregationElementType2.getSubGroupBy();
            AttributeTypeHelper.copyGroupingElementType((GroupingElementType)attributeType, groupingElementType);
            aggregationElementType.setSubGroupBy((GroupingElementType)attributeType);
        }
    }

    public static void copyAttributes(List<AggregationElementType> list, List<AggregationElementType> list2) {
        AttributeTypeHelper.copyAttributes(list, list2, null);
    }

    public static void copyGroupingElementType(GroupingElementType groupingElementType, GroupingElementType groupingElementType2) {
        if (null != groupingElementType2.getExpression()) {
            groupingElementType.setExpression(groupingElementType2.getExpression());
        } else if (null != groupingElementType2.getAttributes() && null != groupingElementType2.getAttributes().getAttribute()) {
            Attributes attributes = new Attributes();
            List list = attributes.getAttribute();
            for (AttributeType attributeType : groupingElementType2.getAttributes().getAttribute()) {
                AttributeType attributeType2 = new AttributeType();
                AttributeTypeHelper.copyAttribute(attributeType2, attributeType);
                list.add(attributeType2);
            }
            groupingElementType.setAttributes(attributes);
        }
    }

    public static String convertGroupingElementTypetoString(GroupingElementType groupingElementType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementType.getExpression()) {
            stringBuffer.append(groupingElementType.getExpression());
        } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
            List list = groupingElementType.getAttributes().getAttribute();
            for (AttributeType attributeType : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(attributeType.getName());
            }
        }
        return stringBuffer.toString();
    }

    public static String generateSQLExpression(Context context, AggregationElements aggregationElements, GroupingElementType groupingElementType, String string, boolean bl) {
        String string222;
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        Object object422;
        if (aggregationElements == null || null == aggregationElements.getAggregationElement()) {
            return null;
        }
        boolean bl3 = null == groupingElementType.getExpression() && (null == groupingElementType.getAttributes() || groupingElementType.getAttributes().getAttribute().isEmpty());
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage());
        }
        if (version == null) {
            return null;
        }
        String string3 = AttributeTypeHelper.getHint(context);
        List list = aggregationElements.getAggregationElement();
        String string4 = AttributeTypeHelper.mainGroupBytoString(groupingElementType);
        String string5 = groupingElementType.getExpression() != null ? AttributeTypeHelper.createAlias(string4) : string4;
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<AggregationElementType> arrayList2 = new ArrayList<AggregationElementType>();
        int n = 0;
        for (Object object422 : list) {
            object3 = object422.getSubGroupBy();
            object2 = null;
            if (AttributeTypeHelper.isSubGropByPresent((GroupingElementType)object3)) {
                object = AttributeTypeHelper.convertGroupingElementTypetoSQL((GroupingElementType)object3);
                object2 = (AggregationSQLElement)hashMap.get(object);
                if (null == object2) {
                    object2 = new AggregationSQLElement((AggregationElementType)object422);
                    hashMap.put((String)object, object2);
                    arrayList.add(object2);
                    ((AggregationSQLElement)object2).sqlSubGroupBy = (String)object;
                    ((AggregationSQLElement)object2).idString = "ID" + ++n;
                    ((AggregationSQLElement)object2).tableAlias = " t" + String.valueOf(n - 1);
                    ((AggregationSQLElement)object2).sb.append("  (SELECT ");
                    if (null != groupingElementType.getExpression()) {
                        ((AggregationSQLElement)object2).sb.append(string5);
                    } else {
                        ((AggregationSQLElement)object2).sb.append(string4);
                    }
                } else {
                    ((AggregationSQLElement)object2).addSourceAttr((AggregationElementType)object422);
                }
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl4 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MODE.toString());
                boolean bl5 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MAX.toString());
                bl2 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MIN.toString());
                boolean bl6 = null != object422.getAggregationFunction() && (object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT.toString()) || object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT_DISTINCT.toString()));
                string222 = null;
                String string6 = null;
                if (bl4 || bl5 || bl2) {
                    if (null != object422.getSource().getAttributes() && null != object422.getSource().getAttributes().getAttribute() && !object422.getSource().getAttributes().getAttribute().isEmpty()) {
                        AttributeType attributeType = (AttributeType)object422.getSource().getAttributes().getAttribute().get(0);
                        if (attributeType.getDataType().equals("VARCHAR2") || attributeType.getDataType().equals("CHAR") || attributeType.getDataType().equals("NVARCHAR2") || attributeType.getDataType().equals("NCHAR")) {
                            string222 = "\n\tCAST(COLLECT(DM_NESTED_CATEGORICAL(";
                            string6 = ")) AS DM_NESTED_CATEGORICALS) ";
                        } else if (attributeType.getDataType().equals("NUMBER") || attributeType.getDataType().equals("FLOAT") || attributeType.getDataType().equals("BINARY_DOUBLE") || attributeType.getDataType().equals("BINARY_FLOAT")) {
                            string222 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                            string6 = ")) AS DM_NESTED_NUMERICALS) ";
                        }
                    }
                } else if (bl6) {
                    string222 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                    string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                } else if (null != object422.getSource().getExpression()) {
                    String string7 = object422.getSource().getExpression();
                    ((AggregationSQLElement)object2).setExpression(string7);
                } else if (version.toCanonicalString().startsWith("11")) {
                    string222 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                    string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                } else {
                    boolean bl7;
                    boolean bl8 = bl7 = object3.getAttributes() != null && object3.getAttributes().getAttribute() != null && !object3.getAttributes().getAttribute().isEmpty();
                    if (bl7) {
                        String string8 = ((AttributeType)object3.getAttributes().getAttribute().get(0)).getDataType();
                        if (string8.equals("BINARY_FLOAT")) {
                            string222 = "\n\tCAST(COLLECT(DM_NESTED_BINARY_FLOAT(";
                            string6 = ")) AS DM_NESTED_BINARY_FLOATS  ) ";
                        } else if (string8.equals("BINARY_DOUBLE")) {
                            string222 = "\n\tCAST(COLLECT(DM_NESTED_BINARY_DOUBLE(";
                            string6 = ")) AS DM_NESTED_BINARY_DOUBLES  ) ";
                        } else {
                            string222 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                            string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                        }
                    } else {
                        string222 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                        string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                    }
                }
                if (string222 != null) {
                    stringBuilder.append(string222);
                }
                stringBuilder.append(((AggregationSQLElement)object2).idString);
                stringBuilder.append(", ");
                stringBuilder.append(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                if (string6 != null) {
                    stringBuilder.append(string6);
                }
                stringBuilder.append(" " + AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                ((AggregationSQLElement)object2).nestedElement.add(stringBuilder.toString());
                ((AggregationSQLElement)object2).internalResultColumns.add(AttributeTypeHelper.convertAggregationElementSourcetoSQL(context, (AggregationElementType)object422));
                ((AggregationSQLElement)object2).resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                continue;
            }
            if (!bl) {
                arrayList2.add((AggregationElementType)object422);
                continue;
            }
            object2 = new AggregationSQLElement((AggregationElementType)object422);
            arrayList.add(object2);
            ((AggregationSQLElement)object2).tableAlias = " t" + String.valueOf(++n - 1);
            ((AggregationSQLElement)object2).resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
            ((AggregationSQLElement)object2).sb.append("  (SELECT ");
            ((AggregationSQLElement)object2).sb.append(string3);
            if (null != groupingElementType.getExpression()) {
                ((AggregationSQLElement)object2).sb.append(string4);
                ((AggregationSQLElement)object2).sb.append(" ");
                ((AggregationSQLElement)object2).sb.append(string5);
            } else {
                ((AggregationSQLElement)object2).sb.append(string4);
            }
            if (!bl3) {
                ((AggregationSQLElement)object2).sb.append(", ");
            }
            ((AggregationSQLElement)object2).sb.append(AttributeTypeHelper.convertAggregationElementSourcetoSQL(context, (AggregationElementType)object422));
            if (bl) {
                ((AggregationSQLElement)object2).sb.append("\n\tFROM (");
                ((AggregationSQLElement)object2).sb.append(string);
                ((AggregationSQLElement)object2).sb.append(") ");
            } else {
                ((AggregationSQLElement)object2).sb.append("\n\tFROM {INPUT_SOURCE} " + ((AggregationSQLElement)object2).getSourceColumnWhereClause(true) + " ");
            }
            if (!bl3) {
                ((AggregationSQLElement)object2).sb.append("\n\tGROUP BY ");
                ((AggregationSQLElement)object2).sb.append(string4);
            }
            ((AggregationSQLElement)object2).sb.append(")");
            ((AggregationSQLElement)object2).sb.append(((AggregationSQLElement)object2).tableAlias);
        }
        AggregationSQLElement aggregationSQLElement = AttributeTypeHelper.aggregateWithoutSubGroupBy(context, arrayList2, n, groupingElementType, string4, string5, bl3, string3);
        if (null != aggregationSQLElement) {
            arrayList.add(aggregationSQLElement);
        }
        object422 = new StringBuilder("SELECT ");
        object3 = new StringBuilder();
        Object object4 = object2 = arrayList.isEmpty() ? _maintable_alias : ((AggregationSQLElement)arrayList.get(0)).tableAlias;
        if (!arrayList.isEmpty()) {
            ((StringBuilder)object422).append(AttributeTypeHelper.convertGroupingElementTypetoSQL(groupingElementType, (String)object2));
        } else {
            ((StringBuilder)object422).append(AttributeTypeHelper.mainGroupBytoString(groupingElementType));
            if (null != groupingElementType.getExpression()) {
                ((StringBuilder)object422).append(" AS ");
                ((StringBuilder)object422).append(string5);
            }
        }
        object = new ArrayList();
        boolean bl9 = !bl3 && !arrayList.isEmpty();
        for (AggregationSQLElement aggregationSQLElement2 : arrayList) {
            for (Iterator iterator : aggregationSQLElement2.resultColumns) {
                if (bl9) {
                    ((StringBuilder)object422).append(", ");
                }
                ((StringBuilder)object422).append("\n");
                ((StringBuilder)object422).append(aggregationSQLElement2.tableAlias);
                ((StringBuilder)object422).append(".");
                ((StringBuilder)object422).append((String)((Object)iterator));
                if (bl9) continue;
                bl9 = true;
            }
            if (((StringBuilder)object3).length() > 0) {
                ((StringBuilder)object3).append(",\n");
            }
            ((StringBuilder)object3).append((CharSequence)aggregationSQLElement2.sb);
            boolean bl10 = bl2 = !bl3 && !aggregationSQLElement2.nestedElement.isEmpty();
            if (!aggregationSQLElement2.nestedElement.isEmpty()) {
                Iterator iterator;
                for (String string222 : aggregationSQLElement2.nestedElement) {
                    if (bl2) {
                        ((StringBuilder)object3).append(", ");
                    }
                    ((StringBuilder)object3).append(string222);
                    if (bl2) continue;
                    bl2 = true;
                }
                ((StringBuilder)object3).append("\n\tFROM\n");
                ((StringBuilder)object3).append("\t\t(SELECT ");
                ((StringBuilder)object3).append(string3);
                ((StringBuilder)object3).append(" ");
                if (null != groupingElementType.getExpression()) {
                    ((StringBuilder)object3).append("(");
                    ((StringBuilder)object3).append(string4);
                    ((StringBuilder)object3).append(") AS ");
                    ((StringBuilder)object3).append(string5);
                } else {
                    ((StringBuilder)object3).append(string4);
                }
                if (!bl3) {
                    ((StringBuilder)object3).append(",");
                }
                ((StringBuilder)object3).append("\n\t\t");
                ((StringBuilder)object3).append(aggregationSQLElement2.sqlSubGroupBy + " ");
                ((StringBuilder)object3).append(aggregationSQLElement2.idString);
                iterator = aggregationSQLElement2.internalResultColumns.iterator();
                while (iterator.hasNext()) {
                    string222 = (String)iterator.next();
                    ((StringBuilder)object3).append(",\n\t\t");
                    ((StringBuilder)object3).append(string222);
                }
                if (bl) {
                    ((StringBuilder)object3).append("\n\t\tFROM (");
                    ((StringBuilder)object3).append(string);
                    ((StringBuilder)object3).append(") ");
                } else {
                    ((StringBuilder)object3).append("\n\t\tFROM {INPUT_SOURCE} " + aggregationSQLElement2.getSourceColumnWhereClause(true) + " ");
                }
                ((StringBuilder)object3).append("\n\t\tGROUP BY ");
                if (null != groupingElementType.getExpression()) {
                    ((StringBuilder)object3).append("(");
                    ((StringBuilder)object3).append(string4);
                    ((StringBuilder)object3).append(") ");
                } else {
                    ((StringBuilder)object3).append(string4);
                }
                if (!bl3) {
                    ((StringBuilder)object3).append(", ");
                }
                ((StringBuilder)object3).append("(");
                ((StringBuilder)object3).append(aggregationSQLElement2.sqlSubGroupBy);
                ((StringBuilder)object3).append(") ");
                ((StringBuilder)object3).append(")");
                ((StringBuilder)object3).append("\n\t ");
                if (null == aggregationSQLElement2.getExpression()) {
                    if (!bl3) {
                        ((StringBuilder)object3).append("GROUP BY ");
                    }
                    if (null != groupingElementType.getExpression()) {
                        ((StringBuilder)object3).append(string5);
                    } else {
                        ((StringBuilder)object3).append(string4);
                    }
                }
                ((StringBuilder)object3).append(") ");
                ((StringBuilder)object3).append(aggregationSQLElement2.tableAlias);
            }
            object.add(aggregationSQLElement2.tableAlias);
        }
        if (arrayList.isEmpty()) {
            if (bl) {
                ((StringBuilder)object3).append(" (");
                ((StringBuilder)object3).append(string);
                ((StringBuilder)object3).append(") ");
            } else {
                ((StringBuilder)object3).append("{INPUT_SOURCE} ");
            }
            ((StringBuilder)object3).append("\nGROUP BY ");
            ((StringBuilder)object3).append(string4);
        }
        ((StringBuilder)object422).append("\nFROM\n");
        ((StringBuilder)object422).append((CharSequence)object3);
        ((StringBuilder)object422).append("\n");
        String string9 = object.isEmpty() ? _maintable_alias : (String)object.get(0);
        ((StringBuilder)object422).append(AttributeTypeHelper.convertGroupingElementTypetoWhereClause(groupingElementType, string9, (List<String>)object));
        return ((StringBuilder)object422).toString();
    }

    private static String convertAggregationElementSourcetoSQL(Context context, AggregationElementType aggregationElementType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != aggregationElementType.getSource().getExpression()) {
            stringBuffer.append(aggregationElementType.getSource().getExpression());
        } else if (null != aggregationElementType.getSource().getAttributes() && null != aggregationElementType.getSource().getAttributes().getAttribute() && 1 == aggregationElementType.getSource().getAttributes().getAttribute().size()) {
            boolean bl = aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.CAST_COLLECT.toString());
            List list = aggregationElementType.getSource().getAttributes().getAttribute();
            for (AttributeType attributeType : list) {
                String string = aggregationElementType.getAggregationFunction();
                int n = string.indexOf("()");
                StringBuilder stringBuilder = new StringBuilder(string.substring(0, n));
                stringBuilder.append("(");
                stringBuilder.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
                if (bl) {
                    String string2 = AttributeTypeHelper.getNestedCategoricalType(context, attributeType);
                    stringBuilder.append(") AS " + string2);
                    stringBuilder.append(string.substring(n + 2, string.length()));
                } else {
                    stringBuilder.append(string.substring(n + 1, string.length()));
                }
                stringBuffer.append((CharSequence)stringBuilder);
            }
        }
        stringBuffer.append(" ");
        stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(aggregationElementType.getOutput()));
        return stringBuffer.toString();
    }

    public static String mainGroupBytoString(GroupingElementType groupingElementType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementType.getExpression()) {
            stringBuffer.append(groupingElementType.getExpression());
        } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
            List list = groupingElementType.getAttributes().getAttribute();
            for (AttributeType attributeType : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
            }
        }
        return stringBuffer.toString();
    }

    public static String processDoubleQuotedName(AttributeType attributeType) {
        String string;
        String string2 = string = attributeType.getAlias() != null ? attributeType.getAlias() : attributeType.getName();
        if (!StringUtils.isDoubleQuotedString(string)) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    public static String processDoubleQuotedName(String string) {
        if (!StringUtils.isDoubleQuotedString(string)) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    private static String convertGroupingElementTypetoSQL(GroupingElementType groupingElementType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
            List list = groupingElementType.getAttributes().getAttribute();
            for (AttributeType attributeType : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" || ");
                    stringBuffer.append("'");
                    stringBuffer.append(" - ");
                    stringBuffer.append("'");
                    stringBuffer.append(" || ");
                } else {
                    stringBuffer.append("(");
                }
                stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
            }
            stringBuffer.append(")");
        } else if (null != groupingElementType.getExpression()) {
            stringBuffer.append(groupingElementType.getExpression());
        }
        return stringBuffer.toString();
    }

    private static String convertGroupingElementTypetoSQL(GroupingElementType groupingElementType, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty()) {
            List list = groupingElementType.getAttributes().getAttribute();
            for (AttributeType attributeType : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
                stringBuffer.append(".");
                stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
            }
        } else if (null != groupingElementType.getExpression()) {
            stringBuffer.append(string);
            stringBuffer.append(".");
            stringBuffer.append(AttributeTypeHelper.createAlias(groupingElementType.getExpression()));
        }
        return stringBuffer.toString();
    }

    public static String createAlias(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length() && i < 28; ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\'') continue;
            stringBuilder.append(c);
        }
        return "\"" + stringBuilder.toString() + "\"";
    }

    public static String createNonQuotedAlias(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length() && i < 28; ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\'') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static String convertGroupingElementTypetoWhereClause(GroupingElementType groupingElementType, String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
            List list2 = groupingElementType.getAttributes().getAttribute();
            for (AttributeType attributeType : list2) {
                StringBuilder stringBuilder2 = new StringBuilder();
                for (String string2 : list) {
                    if (string2.equals(string)) continue;
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append(" AND ");
                    }
                    stringBuilder2.append(string);
                    stringBuilder2.append(".");
                    stringBuilder2.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
                    stringBuilder2.append(" = ");
                    stringBuilder2.append(string2);
                    stringBuilder2.append(".");
                    stringBuilder2.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
                    stringBuilder2.append("(+)\n");
                }
                if (stringBuilder2.length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" AND ");
                } else {
                    stringBuilder.append(WHERE);
                }
                stringBuilder.append((CharSequence)stringBuilder2);
            }
        }
        return stringBuilder.toString();
    }

    public static boolean isUniqueAggregationOutputName(String string, List<AggregationElementType> list, Map<String, AttributeType> map) {
        if (null != map.get(string)) {
            return false;
        }
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AggregationElementType aggregationElementType : list) {
            hashMap.put(aggregationElementType.getOutput().getName(), aggregationElementType.getOutput());
        }
        return null == hashMap.get(string);
    }

    public static String createUniqueAggregationOutputName(String string, String string2, List<AggregationElementType> list) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AggregationElementType aggregationElementType : list) {
            hashMap.put(aggregationElementType.getOutput().getName(), aggregationElementType.getOutput());
        }
        return AttributeTypeHelper.createUniqueOutputName(string, string2, hashMap);
    }

    public static String createUniqueJSONAggregationOutputName(String string, String string2, List<AggregationElementsExType.AggregationElement> list) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AggregationElementsExType.AggregationElement aggregationElement : list) {
            if (aggregationElement.getOutput() == null) continue;
            hashMap.put(aggregationElement.getOutput().getName(), aggregationElement.getOutput());
        }
        return AttributeTypeHelper.createUniqueOutputName(string, string2, hashMap);
    }

    private static String createUniqueCustomName(Map<String, AttributeType> map) {
        String string;
        int n;
        int n2 = 25;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM_EXPRESSION();
        stringBuilder.append(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM_EXPRESSION());
        int n3 = 0;
        while (null != map.get(stringBuilder.toString()) && (n = n2 - (1 + (string = String.valueOf(++n3)).length())) > 0) {
            stringBuilder = new StringBuilder();
            if (string2.length() > n) {
                stringBuilder.append(string2.substring(0, n - 1));
            } else {
                stringBuilder.append(string2);
            }
            stringBuilder.append("_");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String createUniqueOutputName(String string, String string2, Map<String, AttributeType> map) {
        int n;
        if (string2.equals(TransformationTypes.getCUSTOM_ABBREVIATION())) {
            return AttributeTypeHelper.createUniqueCustomName(map);
        }
        int n2 = 25;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.length() + string2.length() + 1;
        if (n3 <= n2) {
            stringBuilder.append(string);
        } else {
            n = n2 - (string2.length() + 1);
            stringBuilder.append(string.substring(0, n - 1));
        }
        stringBuilder.append("_");
        stringBuilder.append(string2);
        n = 0;
        while (null != map.get(stringBuilder.toString())) {
            String string3 = String.valueOf(++n);
            int n4 = n2 - (string2.length() + 2 + string3.length());
            if (n4 <= 0) break;
            stringBuilder = new StringBuilder();
            if (string.length() > n4) {
                stringBuilder.append(string.substring(0, n4 - 1));
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append("_");
            stringBuilder.append(string2);
            stringBuilder.append("_");
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static String getValidationSQLForGroupByExpression(Context context, GroupingElementType groupingElementType, AggregationElementType aggregationElementType, String string, String string2, String string3) {
        String string4 = AttributeTypeHelper.mainGroupBytoString(groupingElementType);
        String string5 = string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t\t(SELECT ");
        if (string4 != null && !string4.isEmpty()) {
            if (null != groupingElementType.getExpression()) {
                stringBuilder.append("(");
                stringBuilder.append(string4);
                stringBuilder.append(")");
            } else {
                stringBuilder.append(string4);
            }
            stringBuilder.append(",\n");
        }
        stringBuilder.append("\t\t(");
        stringBuilder.append(string5);
        stringBuilder.append(") ");
        stringBuilder.append(string2);
        stringBuilder.append(", ");
        stringBuilder.append(AttributeTypeHelper.convertAggregationElementSourcetoSQL(context, aggregationElementType));
        stringBuilder.append("\n\t\tFROM (");
        stringBuilder.append(string3);
        stringBuilder.append(")\n\t\tGROUP BY ");
        if (string4 != null && !string4.isEmpty()) {
            if (null != groupingElementType.getExpression()) {
                stringBuilder.append("(");
                stringBuilder.append(string4);
                stringBuilder.append(")");
            } else {
                stringBuilder.append(string4);
            }
            stringBuilder.append(", ");
        }
        stringBuilder.append("(");
        stringBuilder.append(string5);
        stringBuilder.append("))");
        return stringBuilder.toString();
    }

    public static String getAggregationElementValidationSQL(Context context, GroupingElementType groupingElementType, AggregationElementType aggregationElementType, String string) {
        String string2 = StringUtils.escapeSingleQuotesForSQL(AttributeTypeHelper.mainGroupBytoString(groupingElementType));
        String string3 = null;
        if (AttributeTypeHelper.isSubGropByPresent(aggregationElementType.getSubGroupBy())) {
            string3 = AttributeTypeHelper.convertGroupingElementTypetoSQL(aggregationElementType.getSubGroupBy());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(SELECT ");
        stringBuilder.append(AttributeTypeHelper.convertAggregationElementSourcetoSQL(context, aggregationElementType));
        stringBuilder.append("\nFROM (");
        stringBuilder.append(string);
        stringBuilder.append(")\n");
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append("GROUP BY ");
            stringBuilder.append(string2);
            if (string3 != null && !string3.trim().isEmpty()) {
                stringBuilder.append(",\n");
                stringBuilder.append(string3);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String getMainGroupByElementValidationSQL(GroupingElementType groupingElementType, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT (");
        String string2 = StringUtils.escapeSingleQuotesForSQL(AttributeTypeHelper.mainGroupBytoString(groupingElementType));
        stringBuilder.append(string2);
        stringBuilder.append(") \nFROM (");
        stringBuilder.append(string);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static boolean isSubGropByPresent(GroupingElementType groupingElementType) {
        return groupingElementType != null && (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty() || null != groupingElementType.getExpression());
    }

    public static boolean isJSONSubGropByPresent(AggregationElementsExType.AggregationElement.SubGroupBy subGroupBy) {
        return subGroupBy != null && null != subGroupBy.getAttributes() && null != subGroupBy.getAttributes().getJSONAttribute() && !subGroupBy.getAttributes().getJSONAttribute().isEmpty();
    }

    public static void setJSONOutputAttributeType(Context context, String string, AggregationElementsExType.AggregationElement aggregationElement) {
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage());
        }
        if (version == null) {
            return;
        }
        AttributeType attributeType = new AttributeType();
        attributeType.setStatus(AttributeStatus.VALID);
        attributeType.setName(string);
        boolean bl = null != aggregationElement.getAggregationFunction() && aggregationElement.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MAX.toString());
        boolean bl2 = null != aggregationElement.getAggregationFunction() && aggregationElement.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MIN.toString());
        boolean bl3 = aggregationElement.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MODE.toString());
        boolean bl4 = null != aggregationElement.getAggregationFunction() && (aggregationElement.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT.toString()) || aggregationElement.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT_DISTINCT.toString()));
        boolean bl5 = aggregationElement.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.CAST_COLLECT.toString());
        JSONAttributeType jSONAttributeType = aggregationElement.getJSONAttribute();
        String string2 = jSONAttributeType.getDBDataType();
        if (AttributeTypeHelper.isJSONSubGropByPresent(aggregationElement.getSubGroupBy())) {
            String string3 = null;
            if (bl3 || bl || bl2) {
                if (string2.equals("VARCHAR2") || string2.equals("CHAR") || string2.equals("NVARCHAR2") || string2.equals("NCHAR")) {
                    string3 = "DM_NESTED_CATEGORICALS";
                } else if (string2.equals("NUMBER")) {
                    string3 = "DM_NESTED_NUMERICALS";
                }
            } else if (bl4) {
                string3 = "DM_NESTED_NUMERICALS";
            } else if (version.toCanonicalString().startsWith("11")) {
                String string4 = ((JSONAttributeType)aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute().get(0)).getDataType();
                string3 = string4.equals("VARCHAR2") ? "DM_NESTED_CATEGORICALS" : "DM_NESTED_NUMERICALS";
            } else {
                String string5;
                boolean bl6;
                boolean bl7 = bl6 = aggregationElement.getSubGroupBy().getAttributes() != null && aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute() != null && !aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute().isEmpty();
                string3 = bl6 ? ((string5 = ((JSONAttributeType)aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute().get(0)).getDataType()).equals("BINARY_FLOAT") ? "DM_NESTED_BINARY_FLOATS" : (string5.equals("BINARY_DOUBLE") ? "DM_NESTED_BINARY_DOUBLES" : "DM_NESTED_NUMERICALS")) : "DM_NESTED_NUMERICALS";
            }
            attributeType.setDataType(string3);
        } else {
            String string6 = "NUMBER";
            if (bl3) {
                if (string2.equals("VARCHAR2") || string2.equals("CHAR")) {
                    string6 = "VARCHAR2";
                } else if (string2.equals("NVARCHAR2") || string2.equals("NCHAR")) {
                    string6 = "NVARCHAR2";
                }
            } else if (bl5) {
                string6 = AttributeTypeHelper.getJSONNestedCategoricalType(context, string2);
            }
            if (DatabaseMetadataUtils.AggregateFunctions.isTypeTransparentFunction(aggregationElement.getAggregationFunction())) {
                attributeType.setDataType(string2);
            } else {
                attributeType.setDataType(string6);
            }
        }
        aggregationElement.setOutput(attributeType);
    }

    public static void setOutputAttributeType(Context context, String string, AggregationElementType aggregationElementType) {
        Version version = null;
        try {
            version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage());
        }
        if (version == null) {
            return;
        }
        AttributeType attributeType = new AttributeType();
        attributeType.setStatus(AttributeStatus.VALID);
        attributeType.setName(string);
        boolean bl = null != aggregationElementType.getAggregationFunction() && aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MAX.toString());
        boolean bl2 = null != aggregationElementType.getAggregationFunction() && aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MIN.toString());
        boolean bl3 = aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MODE.toString());
        boolean bl4 = null != aggregationElementType.getAggregationFunction() && (aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT.toString()) || aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT_DISTINCT.toString()));
        boolean bl5 = aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.CAST_COLLECT.toString());
        GroupingElementType groupingElementType = aggregationElementType.getSource();
        if (AttributeTypeHelper.isSubGropByPresent(aggregationElementType.getSubGroupBy())) {
            String string2 = null;
            if (bl3 || bl || bl2) {
                if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty()) {
                    AttributeType attributeType2 = (AttributeType)groupingElementType.getAttributes().getAttribute().get(0);
                    if (attributeType2.getDataType().equals("VARCHAR2") || attributeType2.getDataType().equals("CHAR") || attributeType2.getDataType().equals("NVARCHAR2") || attributeType2.getDataType().equals("NCHAR")) {
                        string2 = "DM_NESTED_CATEGORICALS";
                    } else if (attributeType2.getDataType().equals("NUMBER")) {
                        string2 = "DM_NESTED_NUMERICALS";
                    }
                }
            } else if (bl4) {
                string2 = "DM_NESTED_NUMERICALS";
            } else if (null != aggregationElementType.getSource().getExpression()) {
                string2 = "DM_NESTED_CATEGORICALS";
            } else if (version.toCanonicalString().startsWith("11")) {
                String string3 = ((AttributeType)aggregationElementType.getSubGroupBy().getAttributes().getAttribute().get(0)).getDataType();
                string2 = string3.equals("VARCHAR2") ? "DM_NESTED_CATEGORICALS" : "DM_NESTED_NUMERICALS";
            } else {
                String string4;
                boolean bl6;
                boolean bl7 = bl6 = aggregationElementType.getSubGroupBy().getAttributes() != null && aggregationElementType.getSubGroupBy().getAttributes().getAttribute() != null && !aggregationElementType.getSubGroupBy().getAttributes().getAttribute().isEmpty();
                string2 = bl6 ? ((string4 = ((AttributeType)aggregationElementType.getSubGroupBy().getAttributes().getAttribute().get(0)).getDataType()).equals("BINARY_FLOAT") ? "DM_NESTED_BINARY_FLOATS" : (string4.equals("BINARY_DOUBLE") ? "DM_NESTED_BINARY_DOUBLES" : "DM_NESTED_NUMERICALS")) : "DM_NESTED_NUMERICALS";
            }
            attributeType.setDataType(string2);
        } else {
            AttributeType attributeType3;
            String string5 = "NUMBER";
            if (bl3) {
                if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty()) {
                    attributeType3 = (AttributeType)groupingElementType.getAttributes().getAttribute().get(0);
                    if (attributeType3.getDataType().equals("VARCHAR2") || attributeType3.getDataType().equals("CHAR")) {
                        string5 = "VARCHAR2";
                    } else if (attributeType3.getDataType().equals("NVARCHAR2") || attributeType3.getDataType().equals("NCHAR")) {
                        string5 = "NVARCHAR2";
                    }
                } else if (null != groupingElementType.getExpression()) {
                    string5 = "VARCHAR2";
                }
            } else if (bl5) {
                if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty()) {
                    attributeType3 = (AttributeType)groupingElementType.getAttributes().getAttribute().get(0);
                    string5 = AttributeTypeHelper.getNestedCategoricalType(context, attributeType3);
                } else if (null != groupingElementType.getExpression()) {
                    string5 = "VARCHAR2";
                }
            }
            if (DatabaseMetadataUtils.AggregateFunctions.isTypeTransparentFunction(aggregationElementType.getAggregationFunction())) {
                attributeType3 = (AttributeType)groupingElementType.getAttributes().getAttribute().get(0);
                attributeType.setDataType(attributeType3.getDataType());
            } else {
                attributeType.setDataType(string5);
            }
        }
        aggregationElementType.setOutput(attributeType);
    }

    public static boolean isValidSubGroupBy(Map<String, AttributeType> map, GroupingElementType groupingElementType) {
        if (null != groupingElementType.getExpression()) {
            return true;
        }
        if (groupingElementType == null || groupingElementType.getAttributes() == null) {
            return false;
        }
        List list = groupingElementType.getAttributes().getAttribute();
        boolean bl = true;
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = map.get(attributeType.getName());
            if (null == attributeType2) {
                bl = false;
            }
            if (attributeType2 != null && !attributeType2.getStatus().equals((Object)AttributeStatus.VALID)) {
                bl = false;
            }
            if (bl) continue;
            attributeType.setStatus(AttributeStatus.INVALID);
            break;
        }
        return bl;
    }

    public static boolean tableExists(Context context, UpdateTableNode updateTableNode) {
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)updateTableNode.getData();
        boolean bl = false;
        String string = updateTableNodeType.getUpdateTargetTable().getName();
        String string2 = updateTableNodeType.getUpdateTargetTable().getSchema();
        if (string != null && !string.isEmpty()) {
            try {
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
                bl = DatabaseMetadataUtils.datasourceExists(connectionFolder, string2, string);
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.FINEST, sQLException.getMessage());
            }
        }
        return bl;
    }

    public static boolean areCompatibleTypes(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return DatabaseMetadataUtils.isANumberOracleDataType(string) && DatabaseMetadataUtils.isANumberOracleDataType(string2);
    }

    public static String getNestedCategoricalType(Context context, AttributeType attributeType) {
        String string = null;
        boolean bl = SQLHelper.isExtendedTypeEnabled(context);
        if (attributeType.getDataType().equals("VARCHAR2")) {
            string = bl ? "ODMR_NESTED_VARCHAR2_EX" : "ODMR_NESTED_VARCHAR2";
        } else if (attributeType.getDataType().equals("CHAR")) {
            string = "ODMR_NESTED_CHAR";
        } else if (attributeType.getDataType().equals("NVARCHAR2")) {
            string = bl ? "ODMR_NESTED_NVARCHAR2_EX" : "ODMR_NESTED_NVARCHAR2";
        } else if (attributeType.getDataType().equals("NCHAR")) {
            string = "ODMR_NESTED_NCHAR";
        } else assert (false);
        return string;
    }

    public static String getNestedCategoricalType(Context context, String string) {
        String string2 = null;
        boolean bl = SQLHelper.isExtendedTypeEnabled(context);
        if (string.equals("VARCHAR2")) {
            string2 = bl ? "ODMR_NESTED_VARCHAR2_EX" : "ODMR_NESTED_VARCHAR2";
        } else if (string.equals("CHAR")) {
            string2 = "ODMR_NESTED_CHAR";
        } else if (string.equals("NVARCHAR2")) {
            string2 = bl ? "ODMR_NESTED_NVARCHAR2_EX" : "ODMR_NESTED_NVARCHAR2";
        } else if (string.equals("NCHAR")) {
            string2 = "ODMR_NESTED_NCHAR";
        } else assert (false);
        return string2;
    }

    public static String getJSONNestedCategoricalType(Context context, String string) {
        String string2 = null;
        boolean bl = SQLHelper.isExtendedTypeEnabled(context);
        if (string.equals("VARCHAR2")) {
            string2 = bl ? "ODMR_NESTED_VARCHAR2_EX" : "ODMR_NESTED_VARCHAR2";
        } else if (string.equals("CHAR")) {
            string2 = "ODMR_NESTED_CHAR";
        } else if (string.equals("NVARCHAR2")) {
            string2 = bl ? "ODMR_NESTED_NVARCHAR2_EX" : "ODMR_NESTED_NVARCHAR2";
        } else if (string.equals("NCHAR")) {
            string2 = "ODMR_NESTED_NCHAR";
        } else assert (false);
        return string2;
    }

    public static boolean executeSQLAggregate(Context context, String string) throws SQLException {
        boolean bl = false;
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string2 = StringUtils.escapeSingleQuotesForSQL(string);
            String string3 = StringUtils.getReplacedString(DBMS_SQL_PARSE_AGGREGATE, "[SQL_EXPRESSION]", string2);
            sQLHelper.conn = ConnectionFolder.getConnection(context, ConnectionProperties.ALTER_SESSION_FIXES);
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall(string3);
            sQLHelper.cstmt.execute();
            bl = true;
        }
        return bl;
    }

    private static AggregationSQLElement aggregateWithoutSubGroupBy(Context context, List<AggregationElementType> list, int n, GroupingElementType groupingElementType, String string, String string2, boolean bl, String string3) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        AggregationSQLElement aggregationSQLElement = new AggregationSQLElement();
        aggregationSQLElement.tableAlias = " t" + String.valueOf(n);
        aggregationSQLElement.sb = new StringBuilder("  (SELECT ");
        aggregationSQLElement.sb.append(string3);
        if (null != groupingElementType.getExpression()) {
            aggregationSQLElement.sb.append(string);
            aggregationSQLElement.sb.append(" ");
            aggregationSQLElement.sb.append(string2);
        } else {
            aggregationSQLElement.sb.append(string);
        }
        if (!bl) {
            aggregationSQLElement.sb.append(", ");
        }
        StringBuilder stringBuilder = null;
        int n2 = 0;
        for (AggregationElementType aggregationElementType : list) {
            AggregationSQLElement aggregationSQLElement2 = new AggregationSQLElement(aggregationElementType);
            aggregationSQLElement.sb.append("\n    ");
            if (n2 > 0) {
                aggregationSQLElement.sb.append(",");
            }
            aggregationSQLElement.resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(aggregationElementType.getOutput()));
            aggregationSQLElement.sb.append(AttributeTypeHelper.convertAggregationElementSourcetoSQL(context, aggregationElementType));
            ++n2;
            String string4 = aggregationSQLElement2.getSourceColumnWhereClause(false);
            if (string4 == null || string4.isEmpty()) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder("WHERE ");
            } else {
                stringBuilder.append("\n    AND ");
            }
            stringBuilder.append(string4 + " ");
        }
        Object object = "";
        if (stringBuilder != null) {
            object = stringBuilder.toString();
        }
        aggregationSQLElement.sb.append("\n  FROM {INPUT_SOURCE}\n  " + (String)object + " ");
        if (!bl) {
            aggregationSQLElement.sb.append("\n  GROUP BY ");
            aggregationSQLElement.sb.append(string);
        }
        aggregationSQLElement.sb.append(")");
        aggregationSQLElement.sb.append(aggregationSQLElement.tableAlias);
        return aggregationSQLElement;
    }

    public static boolean areEqual(List<AttributeType> list, List<AttributeType> list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (list == null && list2 != null || list != null && list2 == null) {
            return false;
        }
        if (list.equals(list2)) {
            return true;
        }
        if (list.isEmpty() && !list2.isEmpty() || !list.isEmpty() && list2.isEmpty()) {
            return false;
        }
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        for (AttributeType attributeType : list2) {
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null) {
                return false;
            }
            if (!attributeType2.getDataType().equals(attributeType.getDataType())) {
                return false;
            }
            if (attributeType2.getDataTypeQualifier() == null && attributeType.getDataTypeQualifier() != null || attributeType2.getDataTypeQualifier() != null && attributeType.getDataTypeQualifier() == null) {
                return false;
            }
            if (attributeType2.getDataTypeQualifier() != null && attributeType.getDataTypeQualifier() != null && !attributeType2.getDataTypeQualifier().equals(attributeType.getDataTypeQualifier())) {
                return false;
            }
            hashMap.remove(attributeType.getName());
        }
        return hashMap.isEmpty();
    }

    private static class AggregationSQLElement {
        private List<AttributeType> sourceAttrs;
        private String sqlSubGroupBy;
        private StringBuilder sb = new StringBuilder();
        private List<String> nestedElement = new ArrayList<String>();
        private String tableAlias;
        private List<String> resultColumns = new ArrayList<String>();
        private List<String> internalResultColumns = new ArrayList<String>();
        private String idString;
        private String expression;

        AggregationSQLElement() {
        }

        AggregationSQLElement(AggregationElementType aggregationElementType) {
            if (null != aggregationElementType.getSource().getAttributes() && null != aggregationElementType.getSource().getAttributes().getAttribute() && !aggregationElementType.getSource().getAttributes().getAttribute().isEmpty()) {
                this.sourceAttrs = new ArrayList<AttributeType>();
                this.sourceAttrs.add((AttributeType)aggregationElementType.getSource().getAttributes().getAttribute().get(0));
            }
        }

        void addSourceAttr(AggregationElementType aggregationElementType) {
            if (this.sourceAttrs == null) {
                this.sourceAttrs = new ArrayList<AttributeType>();
            }
            if (null != aggregationElementType.getSource().getAttributes() && null != aggregationElementType.getSource().getAttributes().getAttribute() && !aggregationElementType.getSource().getAttributes().getAttribute().isEmpty()) {
                this.sourceAttrs.add((AttributeType)aggregationElementType.getSource().getAttributes().getAttribute().get(0));
            }
        }

        String getSourceColumnWhereClause(boolean bl) {
            return "";
        }

        public void setExpression(String string) {
            this.expression = string;
        }

        public String getExpression() {
            return this.expression;
        }
    }

    static class Wrapper
    implements T {
        Object t;

        Wrapper(Object object) {
            this.t = object;
        }

        @Override
        public TransformNulls getTransformNulls() {
            return ((T)this.t).getTransformNulls();
        }

        @Override
        public BinLabels getBinLabels() {
            return ((T)this.t).getBinLabels();
        }

        @Override
        public int getBinCount() {
            return ((T)this.t).getBinCount();
        }

        @Override
        public BinGeneration getBinGeneration() {
            return ((T)this.t).getBinGeneration();
        }
    }

    static interface T {
        public TransformNulls getTransformNulls();

        public BinLabels getBinLabels();

        public int getBinCount();

        public BinGeneration getBinGeneration();
    }

    public static class TextTransformationNodeColumns {
        private TransformedAttributesType _xformedAttributes;
        private TransformationSourceAttributes _xformSourceAttributes;

        private TextTransformationNodeColumns(TransformedAttributesType transformedAttributesType, TransformationSourceAttributes transformationSourceAttributes) {
            if (null != transformedAttributesType) {
                this._xformedAttributes = AttributeTypeHelper.cloneTransformedAttributesType(transformedAttributesType);
            }
            if (null != transformationSourceAttributes) {
                this._xformSourceAttributes = new TransformationSourceAttributes();
                AttributeTypeHelper.copyTransformationSourceAttributes(this._xformSourceAttributes.getTransformationSourceAttributeType(), transformationSourceAttributes.getTransformationSourceAttributeType());
            }
        }

        public TransformedAttributesType getXformedAttributes() {
            return this._xformedAttributes;
        }

        public TransformationSourceAttributes getXformSourceAttributes() {
            return this._xformSourceAttributes;
        }
    }

    public static class TransformationNodeColumns {
        private TransformedAttributes _xformedAttributes;
        private TransformationSourceAttributes _xformSourceAttributes;

        private TransformationNodeColumns(TransformedAttributes transformedAttributes, TransformationSourceAttributes transformationSourceAttributes) {
            if (null != transformedAttributes) {
                this._xformedAttributes = AttributeTypeHelper.cloneTransformedAttributes(transformedAttributes);
            }
            if (null != transformationSourceAttributes) {
                this._xformSourceAttributes = new TransformationSourceAttributes();
                AttributeTypeHelper.copyTransformationSourceAttributes(this._xformSourceAttributes.getTransformationSourceAttributeType(), transformationSourceAttributes.getTransformationSourceAttributeType());
            }
        }

        public TransformedAttributes getXformedAttributes() {
            return this._xformedAttributes;
        }

        public TransformationSourceAttributes getXformSourceAttributes() {
            return this._xformSourceAttributes;
        }
    }

    public static class ExTransformationSourceAttribute {
        private TransformationSourceAttribute _src;

        public ExTransformationSourceAttribute(TransformationSourceAttribute transformationSourceAttribute) {
            this._src = transformationSourceAttribute;
        }

        public String toString() {
            if (this._src != null) {
                return this._src.getName();
            }
            return "";
        }

        public TransformationSourceAttribute getTransformationSourceAttribute() {
            return this._src;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof ExTransformationSourceAttribute) {
                if (null != ((ExTransformationSourceAttribute)object)._src && this._src != null) {
                    return ((ExTransformationSourceAttribute)object)._src.getName().equals(this._src.getName());
                }
                if (null == ((ExTransformationSourceAttribute)object)._src && this._src == null) {
                    return true;
                }
            }
            return false;
        }
    }
}

