/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.awt.Color;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.ide.Context;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ROCTabPanelState {
    private static final Logger theLogger = Logger.getLogger(ROCTabPanelState.class.getName());
    private SharedTestEditorState _parentTestViewerState;
    private Context _context;
    private List<TestResult> _testResults;
    private Vector<String> _targetValues;
    private String _selectedTargetValue;
    private String _selectedTestResult;
    private HashMap<String, Map<String, List<ROCData>>> _rocdata;
    private HashMap<String, Map<String, StatisticsData>> _statdata;
    private HashMap<String, Map<String, Integer>> _confusionMatrix;
    public static final String CUSTOM_THRESHOLD_OP_HIT_RATIO = "CUSTOM_THRESHOLD_OP_HIT_RATIO";
    public static final String CUSTOM_THRESHOLD_OP_FALSE_ALARM = "CUSTOM_THRESHOLD_OP_FALSE_ALARM";
    public static final String CUSTOM_THRESHOLD_OP_FALSE_RATIO = "CUSTOM_THRESHOLD_OP_FALSE_RATIO";
    private String _customThresholdOption;
    private double _customThresholdValue;
    private ROCTableModel _rocTableModel;
    private DefaultGraphDataModel _rocGraphModel;
    private static String QRY_CM_VALUES_PARTITIONED = "select actual_target_value, value from {0} where <partition_clause> and actual_target_value = predicted_target_value";

    public SharedTestEditorState getParentTestViewerState() {
        return this._parentTestViewerState;
    }

    public ROCTabPanelState(SharedTestEditorState sharedTestEditorState, Context context) {
        this._parentTestViewerState = sharedTestEditorState;
        this._context = context;
        this._targetValues = new Vector();
        this._rocdata = new HashMap();
        this._statdata = new HashMap();
        this._confusionMatrix = new HashMap();
        this._customThresholdOption = CUSTOM_THRESHOLD_OP_HIT_RATIO;
        this._customThresholdValue = 0.0;
        this._rocTableModel = null;
        this._testResults = this._parentTestViewerState.getTestResults();
        this._rocGraphModel = new DefaultGraphDataModel(null, 61, null, null, null);
        this._rocGraphModel.setX1(TestViewerLrb.get("FALSE_POSITIVE_FRACTION"), 1.0);
        this._rocGraphModel.setY1(TestViewerLrb.get("TRUE_POSITIVE_FRACTION"), 1.0);
    }

    public void load(boolean bl) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        this._targetValues.clear();
        this._testResults = this._parentTestViewerState.getTestResults();
        try {
            for (TestResult testResult : this._testResults) {
                if (!((ClassTestResult)testResult).rocResultExists()) continue;
                Vector<String> vector = ((ClassTestResult)testResult).getTargetValues();
                for (String string : vector) {
                    if (this._targetValues.contains(string)) continue;
                    this._targetValues.add(string);
                }
            }
            Object object = ((ClassTestResult)this._testResults.get(0)).getLeastTargetValue(this._parentTestViewerState.isEnabledPartitioning(), this._parentTestViewerState.getSelectedPartitionName());
            if (object == null || !this._targetValues.contains(object)) {
                object = this._targetValues.get(0);
            }
            this.setSelectedTargetValue((String)object);
            if (bl) {
                this.loadROCPartitioned();
            } else {
                this.loadROC();
            }
            this.loadROCGraph();
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    public void refreshROCStatData(boolean bl) throws SQLException {
        try {
            if (bl) {
                this.loadROCPartitioned();
            } else {
                this.loadROC();
            }
            this.loadROCGraph();
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
    }

    private void loadROC() throws SQLException {
        String string = this.getSelectedTargetValue();
        int n = 10;
        int n2 = 3000;
        SQLHelper sQLHelper = new SQLHelper();
        TreeMap<String, List<ROCData>> treeMap = new TreeMap<String, List<ROCData>>();
        TreeMap<String, StatisticsData> treeMap2 = new TreeMap<String, StatisticsData>();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        try {
            for (TestResult testResult : this._testResults) {
                Object object;
                List<ROCData> list;
                Map<String, List<ROCData>> map;
                Object object2;
                String string2;
                String string3 = testResult.toString();
                Map<String, Integer> map2 = this._confusionMatrix.get(string3);
                if (map2 == null) {
                    map2 = new HashMap<String, Integer>();
                    string2 = ((ClassTestResult)testResult).getConfusionMatrixTable();
                    object2 = "select actual_target_value, value from " + string2 + " where actual_target_value = predicted_target_value";
                    sQLHelper.conn = connectionFolder.getConnection();
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement((String)object2);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        map = sQLHelper.rs.getString("actual_target_value");
                        int n3 = sQLHelper.rs.getInt("value");
                        map2.put((String)((Object)map), n3);
                    }
                    sQLHelper.close();
                    this._confusionMatrix.put(string3, map2);
                }
                string2 = ((ClassTestResult)testResult).geRocResultTable(string);
                object2 = ((ClassTestResult)testResult).getRocAreaUnderCurve(string);
                map = this._rocdata.get(string);
                if (map == null) {
                    map = new HashMap<String, List<ROCData>>();
                    this._rocdata.put(string, map);
                }
                if ((list = map.get(string3)) == null) {
                    list = new ArrayList<ROCData>();
                    ((ArrayList)list).ensureCapacity(n2);
                    object = "SELECT TRUNC(PROBABILITY,25) PROBABILITY, TRUNC(TRUE_POSITIVE_FRACTION," + n + ") TRUE_POSITIVE_FRACTION, TRUNC(FALSE_POSITIVE_FRACTION," + n + ") FALSE_POSITIVE_FRACTION, " + "TRUE_POSITIVES, FALSE_NEGATIVES, FALSE_POSITIVES, TRUE_NEGATIVES " + "FROM (SELECT t.*, ROWNUM RNUM FROM " + string2 + " t) " + "WHERE ORA_HASH(RNUM,((SELECT COUNT(*) FROM " + string2 + ")-1),12345) < " + n2 + " " + "ORDER BY FALSE_POSITIVE_FRACTION , TRUE_POSITIVE_FRACTION ";
                    sQLHelper.conn = connectionFolder.getConnection();
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement((String)object);
                    sQLHelper.pstmt.setFetchSize(n2);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        int n4 = sQLHelper.rs.getInt("TRUE_POSITIVES");
                        int n5 = sQLHelper.rs.getInt("FALSE_NEGATIVES");
                        int n6 = sQLHelper.rs.getInt("FALSE_POSITIVES");
                        int n7 = sQLHelper.rs.getInt("TRUE_NEGATIVES");
                        double d = sQLHelper.rs.getDouble("TRUE_POSITIVE_FRACTION");
                        double d2 = sQLHelper.rs.getDouble("FALSE_POSITIVE_FRACTION");
                        double d3 = sQLHelper.rs.getDouble("PROBABILITY");
                        ROCData rOCData = new ROCData(d3, n4, n5, n6, n7, d, d2);
                        list.add(rOCData);
                    }
                    sQLHelper.close();
                    map.put(string3, list);
                }
                this.loadStatisticsData(string3, (Double)object2, testResult.getMiningAlgorithm(), testResult.getCreationTime(), false);
                treeMap.put(string3, list);
                object = this._statdata.get(this.getSelectedTargetValue()).get(string3);
                treeMap2.put(string3, (StatisticsData)object);
            }
            TuneState tuneState = (TuneState)this._context.getProperty("TUNE_STATE");
            this._rocTableModel = tuneState == null ? new ROCTableModel(treeMap2, treeMap, false) : new ROCTuneTableModel(tuneState, treeMap2, treeMap, false);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    private void loadROCPartitioned() throws SQLException {
        String string = this.getSelectedTargetValue();
        int n = 10;
        int n2 = 3000;
        SQLHelper sQLHelper = new SQLHelper();
        TreeMap<String, List<ROCData>> treeMap = new TreeMap<String, List<ROCData>>();
        TreeMap<String, StatisticsData> treeMap2 = new TreeMap<String, StatisticsData>();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        try {
            for (TestResult testResult : this._testResults) {
                Object object;
                List<ROCData> list;
                Map<String, List<ROCData>> map;
                Object[] objectArray;
                String string2;
                String string3 = testResult.toString();
                String string4 = this._parentTestViewerState.getSelectedPartitionName();
                String string5 = SharedTestEditorState.setPartitionClause(QRY_CM_VALUES_PARTITIONED, string4);
                Map<String, Integer> map2 = this._confusionMatrix.get(string3);
                if (map2 == null) {
                    map2 = new HashMap<String, Integer>();
                    string2 = ((ClassTestResult)testResult).getConfusionMatrixTable();
                    objectArray = new Object[]{string2};
                    string5 = MessageFormat.format(string5, objectArray);
                    sQLHelper.conn = connectionFolder.getConnection();
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string5);
                    if (string4 != null) {
                        sQLHelper.pstmt.setString(1, string4);
                    }
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        map = sQLHelper.rs.getString("actual_target_value");
                        int n3 = sQLHelper.rs.getInt("value");
                        map2.put((String)((Object)map), n3);
                    }
                    this._confusionMatrix.put(string3, map2);
                    sQLHelper.close();
                }
                string2 = ((ClassTestResult)testResult).geRocResultTable(string);
                objectArray = ((ClassTestResult)testResult).getRocAreaUnderCurve(string);
                map = this._rocdata.get(string);
                if (map == null) {
                    map = new HashMap<String, List<ROCData>>();
                    this._rocdata.put(string, map);
                }
                if ((list = map.get(string3)) == null) {
                    list = new ArrayList<ROCData>();
                    ((ArrayList)list).ensureCapacity(n2);
                    object = "SELECT TRUNC(PROBABILITY,25) PROBABILITY, TRUNC(TRUE_POSITIVE_FRACTION," + n + ") TRUE_POSITIVE_FRACTION, TRUNC(FALSE_POSITIVE_FRACTION," + n + ") FALSE_POSITIVE_FRACTION, " + "TRUE_POSITIVES, FALSE_NEGATIVES, FALSE_POSITIVES, TRUE_NEGATIVES " + "FROM (SELECT t.*, ROWNUM RNUM FROM " + string2 + " t) " + "WHERE ORA_HASH(RNUM,((SELECT COUNT(*) FROM " + string2 + ")-1),12345) < " + n2 + " " + "ORDER BY FALSE_POSITIVE_FRACTION , TRUE_POSITIVE_FRACTION ";
                    sQLHelper.conn = connectionFolder.getConnection();
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement((String)object);
                    sQLHelper.pstmt.setFetchSize(n2);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        int n4 = sQLHelper.rs.getInt("TRUE_POSITIVES");
                        int n5 = sQLHelper.rs.getInt("FALSE_NEGATIVES");
                        int n6 = sQLHelper.rs.getInt("FALSE_POSITIVES");
                        int n7 = sQLHelper.rs.getInt("TRUE_NEGATIVES");
                        double d = sQLHelper.rs.getDouble("TRUE_POSITIVE_FRACTION");
                        double d2 = sQLHelper.rs.getDouble("FALSE_POSITIVE_FRACTION");
                        double d3 = sQLHelper.rs.getDouble("PROBABILITY");
                        ROCData rOCData = new ROCData(d3, n4, n5, n6, n7, d, d2);
                        list.add(rOCData);
                    }
                    sQLHelper.close();
                    map.put(string3, list);
                }
                this.loadStatisticsData(string3, (Double)objectArray, testResult.getMiningAlgorithm(), testResult.getCreationTime(), true);
                treeMap.put(string3, list);
                object = this._statdata.get(this.getSelectedTargetValue()).get(string3);
                treeMap2.put(string3, (StatisticsData)object);
            }
            TuneState tuneState = (TuneState)this._context.getProperty("TUNE_STATE");
            this._rocTableModel = tuneState == null ? new ROCTableModel(treeMap2, treeMap, true) : new ROCTuneTableModel(tuneState, treeMap2, treeMap, true);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
    }

    private void loadROCGraph() {
        List<ROCData> list;
        Object object;
        Map<String, List<ROCData>> map = this._rocdata.get(this.getSelectedTargetValue());
        Map<String, StatisticsData> map2 = this._statdata.get(this.getSelectedTargetValue());
        this._rocGraphModel.clear();
        ArrayList<Color> arrayList = new ArrayList<Color>();
        int n = 0;
        int n2 = 0;
        for (TestResult testResult : this._testResults) {
            String string = testResult.toString();
            List<ROCData> list2 = map.get(string);
            if (list2 != null && list2.size() > 0) {
                ++n;
                object = this._parentTestViewerState.getTestResultGraphColors().get(n2);
                arrayList.add((Color)object);
            }
            ++n2;
        }
        Object[][] objectArray = new Object[n * 5][];
        Object[] objectArray2 = new Object[n * 5];
        Object[] objectArray3 = new Object[n * 5];
        int n3 = 0;
        int n4 = 0;
        for (TestResult testResult : this._testResults) {
            object = testResult.toString();
            list = map.get(object);
            objectArray[n3] = new Object[list.size() * 2];
            n4 = 0;
            for (int i = 0; i < list.size(); ++i) {
                objectArray[n3][n4++] = list.get(i).getFalsePositivesFraction();
                objectArray[n3][n4++] = list.get(i).getTruePositivesFraction();
            }
            objectArray2[n3] = TestViewerLrb.get("RESULT_NAME") + ": " + (String)object;
            objectArray3[n3] = 0;
            ++n3;
        }
        for (TestResult testResult : this._testResults) {
            object = testResult.toString();
            list = map.get(object);
            StatisticsData statisticsData = map2.get(object);
            n4 = 0;
            objectArray[n3] = new Object[2];
            objectArray[n3][n4++] = list.get(statisticsData.getMaxOverallAccuracyIdx()).getFalsePositivesFraction();
            objectArray[n3][n4++] = list.get(statisticsData.getMaxOverallAccuracyIdx()).getTruePositivesFraction();
            objectArray2[n3] = TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 1;
            n4 = 0;
            objectArray[++n3] = new Object[2];
            objectArray[n3][n4++] = list.get(statisticsData.getMaxAvgAccuracyIdx()).getFalsePositivesFraction();
            objectArray[n3][n4++] = list.get(statisticsData.getMaxAvgAccuracyIdx()).getTruePositivesFraction();
            objectArray2[n3] = TestViewerLrb.get("MAX_AVG_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 2;
            n4 = 0;
            objectArray[++n3] = new Object[2];
            if (statisticsData.getCustomAccuracyIdx() >= 0) {
                objectArray[n3][n4++] = list.get(statisticsData.getCustomAccuracyIdx()).getFalsePositivesFraction();
                objectArray[n3][n4++] = list.get(statisticsData.getCustomAccuracyIdx()).getTruePositivesFraction();
            } else {
                objectArray[n3][n4++] = 0.0;
                objectArray[n3][n4++] = 0.0;
            }
            objectArray2[n3] = TestViewerLrb.get("CUSTOM_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 4;
            n4 = 0;
            objectArray[++n3] = new Object[2];
            objectArray[n3][n4++] = list.get(statisticsData.getModelAccuracyIdx()).getFalsePositivesFraction();
            objectArray[n3][n4++] = list.get(statisticsData.getModelAccuracyIdx()).getTruePositivesFraction();
            objectArray2[n3] = TestViewerLrb.get("CURRENT_ACCURACY_COL") + ": " + (String)object;
            objectArray3[n3] = 3;
            ++n3;
        }
        this._rocGraphModel.addRowLabels(objectArray2);
        this._rocGraphModel.addRowMarkerShapes(objectArray3);
        this._rocGraphModel.addGraphData(objectArray);
        this._rocGraphModel.addRowColors(arrayList.toArray(new Color[arrayList.size()]));
    }

    private void loadStatisticsData(String string, Double d, String string2, Date date, boolean bl) {
        String string3 = this.getSelectedTargetValue();
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        Map<String, List<ROCData>> map = this._rocdata.get(string3);
        Map<String, StatisticsData> map2 = this._statdata.get(string3);
        if (map2 == null) {
            map2 = new HashMap<String, StatisticsData>();
            this._statdata.put(string3, map2);
        }
        if (map2.get(string) == null) {
            Object object;
            double d4 = 0.0;
            int n5 = 0;
            String string4 = null;
            if (bl) {
                string4 = this._parentTestViewerState.getSelectedPartitionName();
            }
            for (TestResult testResult : this._testResults) {
                object = (ClassTestResult)testResult;
                if (!((TestResult)object).toString().equals(string)) continue;
                d4 = ((ClassTestResult)object).getAvgAccuracy(bl, string4).doubleValue();
                if (!bl) continue;
                n5 = ((ClassTestResult)object).getTestRows(bl, string4);
            }
            List<ROCData> list = map.get(string);
            for (int i = 0; i < list.size(); ++i) {
                object = (ROCData)list.get(i);
                double d5 = ((ROCData)object)._prob;
                double d6 = ((ROCData)object)._avgAccuracy;
                double d7 = 0.0;
                double d8 = 0.0;
                if (i < list.size() - 1) {
                    d7 = ((ROCData)list.get((int)(i + 1)))._prob;
                    d8 = ((ROCData)list.get((int)(i + 1)))._avgAccuracy;
                }
                if (d5 >= 0.5 && d7 < 0.5) {
                    n3 = Math.abs(d4 - d6) < Math.abs(d4 - d8) ? i : i + 1;
                }
                if (d2 < ((ROCData)object).getAccuracy()) {
                    d2 = ((ROCData)object).getAccuracy();
                    n = i;
                }
                if (!(d3 < ((ROCData)object).getAvgAccuracy())) continue;
                d3 = ((ROCData)object).getAvgAccuracy();
                n2 = i;
            }
            map2.put(string, new StatisticsData(d, n, n2, n4, n3, n5, string2, date));
        }
    }

    public void refreshCustomThresholdData() {
        String string = this.getSelectedTargetValue();
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        Map<String, List<ROCData>> map = this._rocdata.get(string);
        Map<String, StatisticsData> map2 = this._statdata.get(string);
        for (Map.Entry<String, List<ROCData>> entry : map.entrySet()) {
            String string2 = entry.getKey();
            List<ROCData> list = entry.getValue();
            for (int i = 0; i < list.size() - 1; ++i) {
                if (CUSTOM_THRESHOLD_OP_HIT_RATIO.equals(this.getCustomThresholdOption())) {
                    d = list.get(i).getTruePositivesFraction();
                    d2 = list.get(i + 1).getTruePositivesFraction();
                } else if (CUSTOM_THRESHOLD_OP_FALSE_ALARM.equals(this.getCustomThresholdOption())) {
                    d = list.get(i).getFalsePositivesFraction();
                    d2 = list.get(i + 1).getFalsePositivesFraction();
                } else if (CUSTOM_THRESHOLD_OP_FALSE_RATIO.equals(this.getCustomThresholdOption())) {
                    d = (double)list.get(i).getFalsePositives() / (double)list.get(i).getFalseNegatives();
                    d2 = (double)list.get(i + 1).getFalsePositives() / (double)list.get(i + 1).getFalseNegatives();
                }
                if (!(this._customThresholdValue >= d) || !(this._customThresholdValue <= d2)) continue;
                double d3 = this._customThresholdValue - d;
                double d4 = d2 - this._customThresholdValue;
                if (d3 <= d4) {
                    n = i;
                    break;
                }
                n = i + 1;
                break;
            }
            StatisticsData statisticsData = map2.get(string2);
            statisticsData.setCustomAccuracyIdx(n);
        }
    }

    public void setSelectedTargetValue(String string) {
        this._selectedTargetValue = string;
    }

    public String getSelectedTargetValue() {
        return this._selectedTargetValue;
    }

    public void setCustomThresholdOption(String string) {
        this._customThresholdOption = string;
    }

    public String getCustomThresholdOption() {
        return this._customThresholdOption;
    }

    public void setCustomThresholdValue(double d) {
        this._customThresholdValue = d;
    }

    public double getCustomThresholdValue() {
        return this._customThresholdValue;
    }

    public Map<String, List<ROCData>> getROCData() {
        return this._rocdata.get(this.getSelectedTargetValue());
    }

    public Map<String, StatisticsData> getStatisticsData() {
        return this._statdata.get(this.getSelectedTargetValue());
    }

    public ROCTableModel getRocTableModel() {
        return this._rocTableModel;
    }

    public Vector<String> getTargetValues() {
        return this._targetValues;
    }

    public DefaultGraphDataModel getRocGraphModel() {
        return this._rocGraphModel;
    }

    public void setSelectedTestResult(String string) {
        this._selectedTestResult = string;
    }

    public String getSelectedTestResult() {
        return this._selectedTestResult;
    }

    public Context getContext() {
        return this._context;
    }

    public TestResult getSelectedTestResultObj() {
        for (TestResult testResult : this._testResults) {
            if (!testResult.toString().equals(this.getSelectedTestResult())) continue;
            return testResult;
        }
        return null;
    }

    public int getMODEL() {
        return this._rocTableModel.getMODEL();
    }

    public int getTUNE() {
        return ((ROCTuneTableModel)this._rocTableModel).getTUNE();
    }

    public int getAREA_UNDER_CURVE() {
        return this._rocTableModel.getAREA_UNDER_CURVE();
    }

    public int getMAX_OVERALL() {
        return this._rocTableModel.getMAX_OVERALL();
    }

    public int getMAX_AVG() {
        return this._rocTableModel.getMAX_AVG();
    }

    public int getCUSTOM() {
        return this._rocTableModel.getCUSTOM();
    }

    public int getCURRENT() {
        return this._rocTableModel.getCURRENT();
    }

    public int getALGORITHM() {
        return this._rocTableModel.getALGORITHM();
    }

    public int getBUILD_ROWS() {
        return this._rocTableModel.getBUILD_ROWS();
    }

    public int getTEST_ROWS() {
        return this._rocTableModel.getTEST_ROWS();
    }

    public int getCREATION_DATE() {
        return this._rocTableModel.getCREATION_DATE();
    }

    public class ROCTuneTableModel
    extends ROCTableModel {
        private int _start;
        private int MODEL;
        private int TUNE;
        private int AREA_UNDER_CURVE;
        private int MAX_OVERALL;
        private int MAX_AVG;
        private int CUSTOM;
        private int CURRENT;
        private int ALGORITHM;
        private int BUILD_ROWS;
        private int TEST_ROWS;
        private int CREATION_DATE;
        private TuneState _tuneState;
        private String TUNE_NONE;
        private String TUNE_BENEFIT;
        private String TUNE_COST;
        private String TUNE_ROC;
        private String TUNE_LIFT;
        private String TUNE_PROFIT;

        @Override
        public int getMODEL() {
            return this.MODEL;
        }

        public int getTUNE() {
            return this.TUNE;
        }

        @Override
        public int getAREA_UNDER_CURVE() {
            return this.AREA_UNDER_CURVE;
        }

        @Override
        public int getMAX_OVERALL() {
            return this.MAX_OVERALL;
        }

        @Override
        public int getMAX_AVG() {
            return this.MAX_AVG;
        }

        @Override
        public int getCUSTOM() {
            return this.CUSTOM;
        }

        @Override
        public int getCURRENT() {
            return this.CURRENT;
        }

        @Override
        public int getALGORITHM() {
            return this.ALGORITHM;
        }

        @Override
        public int getBUILD_ROWS() {
            return this.BUILD_ROWS;
        }

        @Override
        public int getTEST_ROWS() {
            return this.TEST_ROWS;
        }

        @Override
        public int getCREATION_DATE() {
            return this.CREATION_DATE;
        }

        @Override
        protected void updateColumnIndices(boolean bl) {
        }

        private void updateColumnIndices2(boolean bl) {
            if (bl) {
                this.BUILD_ROWS = this._start++;
                this.TEST_ROWS = this._start++;
            } else {
                this.CREATION_DATE = this._start++;
            }
        }

        @Override
        protected void createColumns(boolean bl) {
            this._columnNames = bl ? new String[]{TestViewerLrb.get("RESULT_NAME"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"), TestViewerLrb.get("AREA_UNDER_CURVE"), TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL"), TestViewerLrb.get("MAX_AVG_ACCURACY_COL"), TestViewerLrb.get("CUSTOM_ACCURACY_COL"), TestViewerLrb.get("CURRENT_ACCURACY_COL"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS"), TestViewerLrb.get("CREATION_DATE")} : new String[]{TestViewerLrb.get("RESULT_NAME"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"), TestViewerLrb.get("AREA_UNDER_CURVE"), TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL"), TestViewerLrb.get("MAX_AVG_ACCURACY_COL"), TestViewerLrb.get("CUSTOM_ACCURACY_COL"), TestViewerLrb.get("CURRENT_ACCURACY_COL"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
        }

        public ROCTuneTableModel(TuneState tuneState, boolean bl) {
            super(bl);
            this._start = 0;
            this.MODEL = this._start++;
            this.TUNE = this._start++;
            this.AREA_UNDER_CURVE = this._start++;
            this.MAX_OVERALL = this._start++;
            this.MAX_AVG = this._start++;
            this.CUSTOM = this._start++;
            this.CURRENT = this._start++;
            this.ALGORITHM = this._start++;
            this.BUILD_ROWS = -1;
            this.TEST_ROWS = -1;
            this.CREATION_DATE = -1;
            this.TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
            this.TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
            this.TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
            this.TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
            this.TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
            this.TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
            this.updateColumnIndices2(bl);
            this._tuneState = tuneState;
        }

        public ROCTuneTableModel(TuneState tuneState, Map<String, StatisticsData> map, Map<String, List<ROCData>> map2, boolean bl) {
            super(map, map2, bl);
            this._start = 0;
            this.MODEL = this._start++;
            this.TUNE = this._start++;
            this.AREA_UNDER_CURVE = this._start++;
            this.MAX_OVERALL = this._start++;
            this.MAX_AVG = this._start++;
            this.CUSTOM = this._start++;
            this.CURRENT = this._start++;
            this.ALGORITHM = this._start++;
            this.BUILD_ROWS = -1;
            this.TEST_ROWS = -1;
            this.CREATION_DATE = -1;
            this.TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
            this.TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
            this.TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
            this.TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
            this.TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
            this.TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
            this.updateColumnIndices2(bl);
            this._tuneState = tuneState;
        }

        @Override
        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == this.getMODEL()) {
                return super.getValueAt(n, this.getMODEL());
            }
            if (n2 == this.getAREA_UNDER_CURVE()) {
                return super.getValueAt(n, this.getAREA_UNDER_CURVE());
            }
            if (n2 == this.getMAX_OVERALL()) {
                return super.getValueAt(n, this.getMAX_OVERALL());
            }
            if (n2 == this.getMAX_AVG()) {
                return super.getValueAt(n, this.getMAX_AVG());
            }
            if (n2 == this.getCUSTOM()) {
                return super.getValueAt(n, this.getCUSTOM());
            }
            if (n2 == this.getCURRENT()) {
                return super.getValueAt(n, this.getCURRENT());
            }
            if (n2 == this.getALGORITHM()) {
                return super.getValueAt(n, this.getALGORITHM());
            }
            if (n2 == this.getCREATION_DATE()) {
                return super.getValueAt(n, this.getCREATION_DATE());
            }
            if (n2 == this.getTUNE()) {
                if (this._statData != null) {
                    Object[] objectArray = this._statData.keySet().toArray();
                    String string = (String)objectArray[n];
                    if (this._tuneState.isTuningNone(string)) {
                        return this.TUNE_NONE;
                    }
                    if (this._tuneState.isTuningBenefit(string)) {
                        return this.TUNE_BENEFIT;
                    }
                    if (this._tuneState.isTuningCost(string)) {
                        return this.TUNE_COST;
                    }
                    if (this._tuneState.isTuningCustomROC(string)) {
                        return this.TUNE_ROC;
                    }
                    if (this._tuneState.isTuningCustomLift(string)) {
                        return this.TUNE_LIFT;
                    }
                    if (this._tuneState.isTuningCustomProfit(string)) {
                        return this.TUNE_PROFIT;
                    }
                }
            } else {
                if (this._columnNames[n2].equals(TestViewerLrb.get("BUILD_ROWS"))) {
                    return "TODO";
                }
                if (this._columnNames[n2].equals(TestViewerLrb.get("TEST_ROWS"))) {
                    return "TODO";
                }
            }
            return null;
        }
    }

    public class ROCTableModel
    extends GenericBaseTableModel {
        private int _start = 0;
        private int MODEL = this._start++;
        private int AREA_UNDER_CURVE = this._start++;
        private int MAX_OVERALL = this._start++;
        private int MAX_AVG = this._start++;
        private int CUSTOM = this._start++;
        private int CURRENT = this._start++;
        private int ALGORITHM = this._start++;
        private int BUILD_ROWS = -1;
        private int TEST_ROWS = -1;
        private int CREATION_DATE = -1;
        protected Map<String, StatisticsData> _statData = null;
        protected Map<String, List<ROCData>> _rocData = null;
        protected String[] _columnNames;
        private final String LOADING = TestViewerLrb.get("LOADING");

        public int getMODEL() {
            return this.MODEL;
        }

        public int getAREA_UNDER_CURVE() {
            return this.AREA_UNDER_CURVE;
        }

        public int getMAX_OVERALL() {
            return this.MAX_OVERALL;
        }

        public int getMAX_AVG() {
            return this.MAX_AVG;
        }

        public int getCUSTOM() {
            return this.CUSTOM;
        }

        public int getCURRENT() {
            return this.CURRENT;
        }

        public int getALGORITHM() {
            return this.ALGORITHM;
        }

        public int getBUILD_ROWS() {
            return this.BUILD_ROWS;
        }

        public int getTEST_ROWS() {
            return this.TEST_ROWS;
        }

        public int getCREATION_DATE() {
            return this.CREATION_DATE;
        }

        protected void createColumns(boolean bl) {
            this._columnNames = bl ? new String[]{TestViewerLrb.get("RESULT_NAME"), TestViewerLrb.get("AREA_UNDER_CURVE"), TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL"), TestViewerLrb.get("MAX_AVG_ACCURACY_COL"), TestViewerLrb.get("CUSTOM_ACCURACY_COL"), TestViewerLrb.get("CURRENT_ACCURACY_COL"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS"), TestViewerLrb.get("CREATION_DATE")} : new String[]{TestViewerLrb.get("RESULT_NAME"), TestViewerLrb.get("AREA_UNDER_CURVE"), TestViewerLrb.get("MAX_OVERALL_ACCURACY_COL"), TestViewerLrb.get("MAX_AVG_ACCURACY_COL"), TestViewerLrb.get("CUSTOM_ACCURACY_COL"), TestViewerLrb.get("CURRENT_ACCURACY_COL"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
        }

        public ROCTableModel(boolean bl) {
            this.createColumns(bl);
            this.updateColumnIndices(bl);
            this.setColumnIdentifiers(this._columnNames);
            this.setRowCount(1);
            this.setColumnCount(this._columnNames.length);
        }

        protected void updateColumnIndices(boolean bl) {
            if (bl) {
                this.BUILD_ROWS = this._start++;
                this.TEST_ROWS = this._start++;
            } else {
                this.CREATION_DATE = this._start++;
            }
        }

        public ROCTableModel(Map<String, StatisticsData> map, Map<String, List<ROCData>> map2, boolean bl) {
            this.createColumns(bl);
            this.updateColumnIndices(bl);
            this.setColumnIdentifiers(this._columnNames);
            this._statData = map;
            this._rocData = map2;
            this.setRowCount(this._statData.size());
            this.setColumnCount(this._columnNames.length);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return this.getValueAt(0, n).getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._statData == null) {
                if (n2 == this.getMODEL()) {
                    return this.LOADING;
                }
                return null;
            }
            Object[] objectArray = this._statData.keySet().toArray();
            List<ROCData> list = this._rocData.get(objectArray[n]);
            int n3 = 0;
            if (n2 == this.getMODEL()) {
                return objectArray[n];
            }
            if (n2 == this.getAREA_UNDER_CURVE()) {
                return this._statData.get(objectArray[n]).getAreaUnderCurve();
            }
            if (n2 == this.getMAX_OVERALL()) {
                n3 = this._statData.get(objectArray[n]).getMaxOverallAccuracyIdx();
                return list.get(n3).getAccuracy();
            }
            if (n2 == this.getMAX_AVG()) {
                n3 = this._statData.get(objectArray[n]).getMaxAvgAccuracyIdx();
                return list.get(n3).getAvgAccuracy();
            }
            if (n2 == this.getCUSTOM()) {
                n3 = this._statData.get(objectArray[n]).getCustomAccuracyIdx();
                if (n3 >= 0) {
                    return list.get(n3).getAccuracy();
                }
                return 0.0;
            }
            if (n2 == this.getCURRENT()) {
                n3 = this._statData.get(objectArray[n]).getModelAccuracyIdx();
                return list.get(n3).getAccuracy();
            }
            if (n2 == this.getALGORITHM()) {
                return this._statData.get(objectArray[n]).getAlgorithm();
            }
            if (n2 == this.getCREATION_DATE()) {
                return this._statData.get(objectArray[n]).getCreationDate();
            }
            if (n2 == this.getBUILD_ROWS()) {
                return "TODO";
            }
            if (n2 == this.getTEST_ROWS()) {
                return this._statData.get(objectArray[n]).getTestRows();
            }
            return "Undefined";
        }
    }

    public class StatisticsData {
        private double _areaUnderCurve;
        private int _maxOverallAccuracyIdx;
        private int _maxAvgAccuracyIdx;
        private int _customAccuracyIdx;
        private int _modelAccuracyIdx;
        private String _algorithm;
        private Date _creation_date;
        private int _testRows;

        public StatisticsData(double d, int n, int n2, int n3, int n4, int n5, String string, Date date) {
            this._areaUnderCurve = d;
            this._maxOverallAccuracyIdx = n;
            this._maxAvgAccuracyIdx = n2;
            this._customAccuracyIdx = n3;
            this._modelAccuracyIdx = n4;
            this._testRows = n5;
            this._algorithm = string;
            this._creation_date = date;
        }

        public double getAreaUnderCurve() {
            return this._areaUnderCurve;
        }

        public int getMaxOverallAccuracyIdx() {
            return this._maxOverallAccuracyIdx;
        }

        public int getMaxAvgAccuracyIdx() {
            return this._maxAvgAccuracyIdx;
        }

        public int getCustomAccuracyIdx() {
            return this._customAccuracyIdx;
        }

        public int getModelAccuracyIdx() {
            return this._modelAccuracyIdx;
        }

        public int getTestRows() {
            return this._testRows;
        }

        public void setCustomAccuracyIdx(int n) {
            this._customAccuracyIdx = n;
        }

        public String getAlgorithm() {
            return this._algorithm;
        }

        public Date getCreationDate() {
            return this._creation_date;
        }
    }

    public class ROCData
    implements Element {
        protected double _prob;
        protected int _tp;
        protected int _fn;
        protected int _tn;
        protected int _fp;
        protected double _tpf;
        protected double _fpf;
        protected double _accuracy;
        protected double _avgAccuracy;
        private String _label;

        public void setLabel(String string) {
            this._label = string;
        }

        public ROCData(double d, int n, int n2, int n3, int n4, double d2, double d3) {
            this._prob = d;
            this._tp = n;
            this._fn = n2;
            this._tn = n4;
            this._fp = n3;
            this._tpf = d2;
            this._fpf = d3;
            this._accuracy = (double)(this._tp + this._tn) / (double)(this._tp + this._fp + this._tn + this._fn) * 100.0;
            double d4 = 0.0;
            if (this._tp + this._fn != 0) {
                d4 = (double)this._tp / (double)(this._tp + this._fn);
            }
            double d5 = 0.0;
            if (this._tn + this._fp != 0) {
                d5 = (double)this._tn / (double)(this._tn + this._fp);
            }
            this._avgAccuracy = (d4 + d5) / 2.0 * 100.0;
        }

        public double getProb() {
            return this._prob;
        }

        public int getTruePositives() {
            return this._tp;
        }

        public int getFalseNegatives() {
            return this._fn;
        }

        public int getFalsePositives() {
            return this._fp;
        }

        public int getTrueNegatives() {
            return this._tn;
        }

        public double getTruePositivesFraction() {
            return this._tpf;
        }

        public double getFalsePositivesFraction() {
            return this._fpf;
        }

        public double getAccuracy() {
            return this._accuracy;
        }

        public double getAvgAccuracy() {
            return this._avgAccuracy;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return null;
        }

        public Object getData() {
            return null;
        }

        public String getShortLabel() {
            return this._label;
        }

        public String getLongLabel() {
            return "";
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return "";
        }

        public String toString() {
            return "";
        }
    }
}

