/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.matrix;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.BaseCostMatrixTableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.Reloadable;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.legend.LegendEvent;
import oracle.dmt.dataminer.legend.LegendListener;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestResultsSelectorPanel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.TestViewerPartitionToolbar;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixEditor;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixTabState;
import oracle.dmt.dataminer.tviewer.performance.CPerformanceTabState;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.table.GenericTable;

public class PMatrixPanel
extends DataMinerViewGUI
implements Reloadable {
    private static final Logger theLogger = Logger.getLogger(PMatrixPanel.class.getName());
    PMatrixTabState _pMatrixTabState = null;
    Context _context;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel dataMinerTablePanel;
    private JComboBox jCB_Display;
    private JComboBox jCB_Measure1;
    private JCheckBox jCB_showTotalsAndCost;
    private JComboBox jCB_testResults;
    private JPanel jCompareResultsPanel;
    private JSplitPane jCompareResultsSplitPane;
    private JLabel jLBTargetDetails;
    private JLabel jLBV_avgAccuracy;
    private JLabel jLBV_overallAccuracy;
    private JLabel jLBV_totalCost;
    private JLabel jLB_Display;
    private JLabel jLB_Measure1;
    private JLabel jLB_PMatrix;
    private JLabel jLB_RowsCols;
    private JLabel jLB_avgAccuracy;
    private JLabel jLB_overallAccuracy;
    private JLabel jLB_testResults;
    private JLabel jLB_totalCost;
    private DataMinerTable jNT_PMatrixDetails;
    private DataMinerTable jNT_PMatrixSummary;
    private GenericTable jNT_TargetDetails;
    private JPanel jPMatrixDetailsPanel;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jSP_PMatrixDetails;
    private JScrollPane jSP_PMatrixSummary;
    private JScrollPane jSP_TargetDeatils;
    private JSeparator jSeparator1;
    private JSplitPane jShowDetailSplitPane;
    private JPanel jTargetDetailsPane;
    private TestViewerPartitionToolbar testViewerPartitionToolbar1;
    private JButton _jBT_AddOrRemove;

    public PMatrixPanel(PMatrixEditor pMatrixEditor, Context context) {
        super(pMatrixEditor, context);
        this._pMatrixTabState = new PMatrixTabState((SharedTestEditorState)pMatrixEditor.getCachedLegendState());
        this._context = context;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLB_Display, (Component)this.jCB_Display, (String)TestViewerLrb.get("LOADING"));
        ResourceUtils.resLabel((JLabel)this.jLB_testResults, (Component)this.jCB_testResults, (String)(TestViewerLrb.get("PMATRIX_TEST_RESULTS") + ":"));
        ResourceUtils.resLabel((JLabel)this.jLB_avgAccuracy, (Component)this.jLBV_avgAccuracy, (String)(TestViewerLrb.get("PMATRIX_AVG_ACCURACY") + ":"));
        ResourceUtils.resLabel((JLabel)this.jLB_overallAccuracy, (Component)this.jLBV_overallAccuracy, (String)(TestViewerLrb.get("PMATRIX_OVERALL_ACCURACY") + ":"));
        ResourceUtils.resLabel((JLabel)this.jLB_totalCost, (Component)this.jLBV_totalCost, (String)(TestViewerLrb.get("PMATRIX_TOTAL_COST") + ":"));
        this.jLB_PMatrix.setText(TestViewerLrb.get("PMATRIX") + ":");
        this.jLB_RowsCols.setText(TestViewerLrb.get("PMATRIX_ROWS_COLS") + ":");
        this.jCB_showTotalsAndCost.setText(TestViewerLrb.get("PMATRIX_SHOW_TOTALS_COST") + ":");
        this.jCB_Display.removeAllItems();
        this.jCB_Display.addItem(TestViewerLrb.get("PMATRIX_DISPLAY_COMPARE"));
        this.jCB_Display.addItem(TestViewerLrb.get("PMATRIX_DISPLAY_DETAILS"));
        this.jCB_Measure1.removeAllItems();
        this.jCB_Measure1.addItem(TestViewerLrb.get("PMATRIX_CORRECT_PREDICTIONS"));
        this.jCB_Measure1.addItem(TestViewerLrb.get("PMATRIX_COST"));
        this.jLBTargetDetails.setText(TestViewerLrb.get("TEST_VIEWER_TARGET_VALUE_DETAILS"));
        ResourceUtils.resLabel((JLabel)this.jLB_Measure1, (Component)this.jCB_Measure1, (String)CommonLrb.get("COMMON_MEASURE"));
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this.jPMatrixDetailsPanel.setVisible(false);
        this.jCompareResultsPanel.setVisible(false);
        this.jCB_Display.setVisible(false);
        this.jCB_testResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PMatrixPanel.this.jCB_testResults.getSelectedIndex();
                PMatrixPanel.this.displaySelectedTestResults(n);
            }
        });
        this.jCB_showTotalsAndCost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((PMatrixTable)PMatrixPanel.this.jNT_PMatrixDetails).setTotalsAndCostVisible(PMatrixPanel.this.jCB_showTotalsAndCost.isSelected());
            }
        });
        this.jCB_Display.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PMatrixPanel.this.jCB_Display.getSelectedIndex() == 0) {
                    PMatrixPanel.this.jPMatrixDetailsPanel.setVisible(false);
                    PMatrixPanel.this.jCompareResultsPanel.setVisible(true);
                } else {
                    PMatrixPanel.this.jPMatrixDetailsPanel.setVisible(true);
                    PMatrixPanel.this.jCompareResultsPanel.setVisible(false);
                }
            }
        });
        this.jCB_Measure1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PMatrixPanel.this.setCompareModel();
            }
        });
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (PMatrixPanel.this.isLoading()) {
                    return;
                }
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int[] nArray = PMatrixPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
                    Vector<String> vector = new Vector<String>();
                    if (nArray != null && nArray.length != 0) {
                        for (int i = 0; i < nArray.length; ++i) {
                            String string = (String)PMatrixPanel.this._pMatrixTabState.getCompareSummaryModel().getValueAt(nArray[i], 0);
                            vector.add(string);
                        }
                        PMatrixPanel.this._pMatrixTabState.setCurrentSelectedTestResults(vector);
                        PMatrixPanel.this.setCompareModel();
                    }
                }
            }
        });
        this.installPMatrixSummaryActions();
        this.jShowDetailSplitPane.setDividerLocation(0.5);
        this.jShowDetailSplitPane.setResizeWeight(0.5);
        this.jCompareResultsSplitPane.setDividerLocation(0.5);
        this.jCompareResultsSplitPane.setResizeWeight(0.5);
        if (this.isEnabledPartitioning()) {
            this.testViewerPartitionToolbar1.setEditor(this.getEditor());
            this.setSelectedPartition();
        } else {
            this.testViewerPartitionToolbar1.setVisible(false);
        }
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    @Override
    public void reload() {
        PMatrixEditor pMatrixEditor = (PMatrixEditor)this.getEditor();
        this._pMatrixTabState = new PMatrixTabState((SharedTestEditorState)pMatrixEditor.getCachedLegendState());
        this._context = pMatrixEditor.getContext();
        this.setSelectedPartition();
        LoadUI loadUI = new LoadUI(true);
        loadUI.execute();
    }

    private void installPMatrixSummaryActions() {
        this.dataMinerTablePanel.removeSearchField();
        if (this._pMatrixTabState.getParentTestViewerState().getAllTestResults().size() > 1) {
            this._jBT_AddOrRemove = new JButton(OracleIcons.getIcon((String)"compare.png"));
            this._jBT_AddOrRemove.setDisabledIcon(OracleIcons.getIcon((String)"compare.png"));
            this._jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this._jBT_AddOrRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PMatrixPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            });
            this.dataMinerTablePanel.addControlBarComponents(this._jBT_AddOrRemove);
        }
    }

    private void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        TestResultsSelectorPanel testResultsSelectorPanel = new TestResultsSelectorPanel(this._pMatrixTabState.getParentTestViewerState());
        if (testResultsSelectorPanel.showAsDialog(this)) {
            List<TestResult> list = testResultsSelectorPanel.getSelectedTestResults();
            this._pMatrixTabState.getParentTestViewerState().setTestResults(list);
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            LoadUI loadUI = new LoadUI(true);
            loadUI.execute();
        }
    }

    private void setCompareModel() {
        int n = Integer.MAX_VALUE;
        switch (this.jCB_Measure1.getSelectedIndex()) {
            case 1: {
                PMatrixTabState.PMatrixTargetCompareModel pMatrixTargetCompareModel = this._pMatrixTabState.createPMatrixTargetCompareModel(this._pMatrixTabState.getCurrentSelectedTestResults(), 3);
                this.jNT_TargetDetails.setModel((TableModel)((Object)pMatrixTargetCompareModel));
                n = pMatrixTargetCompareModel.getTotalValue();
                break;
            }
            default: {
                this.jNT_TargetDetails.setModel((TableModel)((Object)this._pMatrixTabState.createPMatrixTargetCompareModel(this._pMatrixTabState.getCurrentSelectedTestResults(), 5)));
                n = 100;
            }
        }
        this.jNT_TargetDetails.setSorted(true);
        this.jNT_TargetDetails.autoSizeColumnsToFit();
        for (int i = 1; i < this.jNT_TargetDetails.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.jNT_TargetDetails.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(new HistogramBarRenderer(n, true, this._percentageFormat));
        }
    }

    public void setLegendState(LegendEvent legendEvent) {
        if (this.isLoading() || legendEvent.getTarget() != this._editor || !"LEGEND_ADD_EVENT".equals(legendEvent.getAction())) {
            theLogger.log(Level.FINEST, "In the Add event code");
        }
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void initComponents() {
        this.jLB_Display = new JLabel();
        this.jCB_Display = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jPMatrixDetailsPanel = new JPanel();
        this.jLB_avgAccuracy = new JLabel();
        this.jLB_testResults = new JLabel();
        this.jCB_testResults = new JComboBox();
        this.jLBV_avgAccuracy = new JLabel();
        this.jLBV_overallAccuracy = new JLabel();
        this.jLB_overallAccuracy = new JLabel();
        this.jLB_totalCost = new JLabel();
        this.jLBV_totalCost = new JLabel();
        this.jShowDetailSplitPane = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jSP_PMatrixSummary = new JScrollPane();
        this.jNT_PMatrixSummary = new DataMinerTable();
        this.jPanel3 = new JPanel();
        this.jLB_PMatrix = new JLabel();
        this.jLB_RowsCols = new JLabel();
        this.jCB_showTotalsAndCost = new JCheckBox();
        this.jSP_PMatrixDetails = new JScrollPane();
        this.jNT_PMatrixDetails = new PMatrixTable();
        this.jCompareResultsPanel = new JPanel();
        this.jCompareResultsSplitPane = new JSplitPane();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.jTargetDetailsPane = new JPanel();
        this.jLBTargetDetails = new JLabel();
        this.jLB_Measure1 = new JLabel();
        this.jCB_Measure1 = new JComboBox();
        this.jSP_TargetDeatils = new JScrollPane();
        this.jNT_TargetDetails = new GenericTable();
        this.testViewerPartitionToolbar1 = new TestViewerPartitionToolbar();
        this.jLB_Display.setText("Display:");
        this.jCB_Display.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLB_avgAccuracy.setText("Average Accuracy:");
        this.jLB_testResults.setText("Test Results:");
        this.jCB_testResults.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLBV_avgAccuracy.setText("avg");
        this.jLBV_overallAccuracy.setText("overall");
        this.jLB_overallAccuracy.setText("Overall Accuracy:");
        this.jLB_totalCost.setText("Total Cost:");
        this.jLBV_totalCost.setText("cost");
        this.jShowDetailSplitPane.setDividerLocation(100);
        this.jShowDetailSplitPane.setOrientation(0);
        this.jShowDetailSplitPane.setResizeWeight(0.5);
        this.jShowDetailSplitPane.setMinimumSize(new Dimension(0, 0));
        this.jShowDetailSplitPane.setOneTouchExpandable(true);
        this.jNT_PMatrixSummary.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jSP_PMatrixSummary.setViewportView((Component)((Object)this.jNT_PMatrixSummary));
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 575, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSP_PMatrixSummary, GroupLayout.Alignment.TRAILING, -1, 575, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 99, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSP_PMatrixSummary, -1, 99, Short.MAX_VALUE)));
        this.jShowDetailSplitPane.setTopComponent(this.jPanel2);
        this.jLB_PMatrix.setText("Performance Matrix:");
        this.jLB_RowsCols.setText("Rows=Actual, Columns=Predicted");
        this.jCB_showTotalsAndCost.setText("Show totals and cost");
        this.jCB_showTotalsAndCost.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCB_showTotalsAndCost.setMargin(new Insets(0, 0, 0, 0));
        this.jNT_PMatrixDetails.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jSP_PMatrixDetails.setViewportView((Component)((Object)this.jNT_PMatrixDetails));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSP_PMatrixDetails, GroupLayout.Alignment.TRAILING, -1, 575, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jLB_PMatrix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLB_RowsCols).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCB_showTotalsAndCost).addContainerGap(176, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_PMatrix).addComponent(this.jLB_RowsCols).addComponent(this.jCB_showTotalsAndCost)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSP_PMatrixDetails, -1, 92, Short.MAX_VALUE)));
        this.jShowDetailSplitPane.setRightComponent(this.jPanel3);
        GroupLayout groupLayout3 = new GroupLayout(this.jPMatrixDetailsPanel);
        this.jPMatrixDetailsPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jShowDetailSplitPane, -1, -1, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jLB_testResults).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCB_testResults, -2, 180, -2)).addGroup(groupLayout3.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLB_avgAccuracy).addComponent(this.jLB_overallAccuracy).addComponent(this.jLB_totalCost)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLBV_overallAccuracy).addComponent(this.jLBV_totalCost).addComponent(this.jLBV_avgAccuracy)))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCB_testResults, -2, -1, -2).addComponent(this.jLB_testResults)).addGap(10, 10, 10).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_avgAccuracy).addComponent(this.jLBV_avgAccuracy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_overallAccuracy).addComponent(this.jLBV_overallAccuracy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_totalCost).addComponent(this.jLBV_totalCost)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jShowDetailSplitPane, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jCompareResultsSplitPane.setDividerLocation(110);
        this.jCompareResultsSplitPane.setOrientation(0);
        this.jCompareResultsSplitPane.setResizeWeight(0.4);
        this.jCompareResultsSplitPane.setMinimumSize(new Dimension(0, 0));
        this.jCompareResultsSplitPane.setOneTouchExpandable(true);
        this.jCompareResultsSplitPane.setLeftComponent(this.dataMinerTablePanel);
        this.jLBTargetDetails.setText("Target Value Details:");
        this.jLB_Measure1.setText("Measure:");
        this.jCB_Measure1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jNT_TargetDetails.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jNT_TargetDetails.setAutoResizeMode(4);
        this.jSP_TargetDeatils.setViewportView((Component)this.jNT_TargetDetails);
        GroupLayout groupLayout4 = new GroupLayout(this.jTargetDetailsPane);
        this.jTargetDetailsPane.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSP_TargetDeatils, -1, 555, Short.MAX_VALUE).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLBTargetDetails, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout4.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLB_Measure1, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCB_Measure1, -2, 180, -2))).addContainerGap(303, Short.MAX_VALUE)))));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jLBTargetDetails).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_Measure1).addComponent(this.jCB_Measure1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSP_TargetDeatils, -1, 130, Short.MAX_VALUE).addContainerGap()));
        this.jCompareResultsSplitPane.setBottomComponent(this.jTargetDetailsPane);
        GroupLayout groupLayout5 = new GroupLayout(this.jCompareResultsPanel);
        this.jCompareResultsPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.jCompareResultsSplitPane, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.jCompareResultsSplitPane, -1, 314, Short.MAX_VALUE)));
        GroupLayout groupLayout6 = new GroupLayout(this);
        this.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPMatrixDetailsPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout6.createSequentialGroup().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jCompareResultsPanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.testViewerPartitionToolbar1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout6.createSequentialGroup().addComponent(this.jLB_Display).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCB_Display, -2, 162, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING)))).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addComponent(this.testViewerPartitionToolbar1, -2, -1, -2).addGap(7, 7, 7).addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_Display).addComponent(this.jCB_Display, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPMatrixDetailsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCompareResultsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void displaySelectedTestResults(int n) {
        TestResult testResult = (TestResult)this.jCB_testResults.getItemAt(n);
        BigDecimal bigDecimal = testResult.getId();
        CPerformanceTabState.PerformanceMetric performanceMetric = this._pMatrixTabState.getPerformanceMetric(bigDecimal);
        PMatrixTabState.PerformanceMatrixModel performanceMatrixModel = this._pMatrixTabState.getPerformanceMatrixModel(bigDecimal);
        PMatrixTabState.PerformanceMatrixSummaryModel performanceMatrixSummaryModel = this._pMatrixTabState.getPerformanceMatrixSummaryModel(bigDecimal);
        this.jLBV_avgAccuracy.setText(this._percentageFormat.format(performanceMetric._measureItemValue1.doubleValue()));
        this.jLBV_overallAccuracy.setText(this._percentageFormat.format(performanceMetric._measureItemValue2.doubleValue()));
        if (performanceMetric._measureItemValue3 == null) {
            this.jLB_totalCost.setVisible(false);
            this.jLBV_totalCost.setVisible(false);
        } else {
            this.jLB_totalCost.setVisible(true);
            this.jLBV_totalCost.setVisible(true);
            this.jLBV_totalCost.setText(this._percentageFormat.format(performanceMetric._measureItemValue3.doubleValue()));
        }
        this.jNT_PMatrixSummary.setModel((TableModel)((Object)performanceMatrixSummaryModel));
        this.jNT_PMatrixSummary.setSorted(true);
        this.jNT_PMatrixSummary.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this.jNT_PMatrixSummary.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(165);
        tableColumnModel.getColumn(1).setPreferredWidth(130);
        tableColumnModel.getColumn(2).setPreferredWidth(130);
        tableColumnModel.getColumn(3).setPreferredWidth(75);
        tableColumnModel.getColumn(4).setPreferredWidth(75);
        NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
        tableColumnModel.getColumn(1).setCellRenderer(numberCellRenderer);
        tableColumnModel.getColumn(2).setCellRenderer(numberCellRenderer);
        tableColumnModel.getColumn(3).setCellRenderer(numberCellRenderer);
        tableColumnModel.getColumn(4).setCellRenderer(numberCellRenderer);
        ((PMatrixTable)this.jNT_PMatrixDetails).setModel(performanceMatrixModel);
        ((PMatrixTable)this.jNT_PMatrixDetails).setTotalsAndCostVisible(this.jCB_showTotalsAndCost.isSelected());
        this.jNT_PMatrixDetails.setSorted(false);
        this.jNT_PMatrixDetails.setAutoResizeMode(0);
        this.jNT_PMatrixDetails.setColumnSelectorAvailable(false);
        tableColumnModel = this.jNT_PMatrixDetails.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(70);
        }
    }

    private boolean isEnabledPartitioning() {
        PMatrixEditor pMatrixEditor = (PMatrixEditor)this.getEditor();
        return ((SharedTestEditorState)pMatrixEditor.getCachedLegendState()).isEnabledPartitioning();
    }

    public void setSelectedPartition() {
        if (!this.testViewerPartitionToolbar1.isVisible()) {
            return;
        }
        String string = this.testViewerPartitionToolbar1.getSelectedPartitionID();
        PMatrixEditor pMatrixEditor = (PMatrixEditor)this.getEditor();
        ((SharedTestEditorState)pMatrixEditor.getCachedLegendState()).setSelectedPartition(string);
    }

    private static class PMatrixTable
    extends BaseCostMatrixTable {
        boolean totalsAndCostVisible = false;
        PMatrixTabState.PerformanceMatrixModel _model = null;

        private PMatrixTable() {
        }

        @Override
        public void setModel(BaseCostMatrixTableModel baseCostMatrixTableModel) {
            super.setModel(baseCostMatrixTableModel);
            this._model = (PMatrixTabState.PerformanceMatrixModel)baseCostMatrixTableModel;
            this.setHighlights(this._model.getTotalAndCostColumnIndexes(), this._model.getTotalAndCostRowIndexes(), new int[][]{{this._model.getTotalAndCostRowIndexes()[0], this._model.getTotalAndCostColumnIndexes()[0]}});
        }

        public synchronized void setTotalsAndCostVisible(boolean bl) {
            int n;
            this._model.hide(!bl);
            int[] nArray = this._model.getTotalAndCostColumnIndexes();
            TableColumn[] tableColumnArray = this._model.getHiddenColumns();
            if (tableColumnArray == null) {
                tableColumnArray = new TableColumn[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    tableColumnArray[n] = this.getColumnModel().getColumn(nArray[n]);
                }
                this._model.setHiddenColumns(tableColumnArray);
            }
            if (bl) {
                if (!this.totalsAndCostVisible) {
                    for (n = 0; n < nArray.length; ++n) {
                        this.setColumnVisible(tableColumnArray[n], nArray[n], true);
                    }
                    this.setHiddenColumns(new int[0]);
                }
            } else {
                int[] nArray2 = this.getHiddenColumns();
                if (nArray2 == null || nArray2.length == 0) {
                    this.setHiddenColumns(nArray);
                }
            }
            this.totalsAndCostVisible = bl;
        }
    }

    class TestLegendListener
    implements LegendListener {
        TestLegendListener() {
        }

        @Override
        public void addEvent(LegendEvent legendEvent) {
            PMatrixPanel.this.setLegendState(legendEvent);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        protected Object doInBackground() throws Exception {
            try {
                if (PMatrixPanel.this.isEnabledPartitioning()) {
                    PMatrixPanel.this._pMatrixTabState.loadPartitioned();
                } else {
                    PMatrixPanel.this._pMatrixTabState.load();
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return PMatrixPanel.this._pMatrixTabState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    Object[] objectArray = PMatrixPanel.this._pMatrixTabState.getParentTestViewerState().getTestResults().toArray();
                    PMatrixPanel.this.jCB_testResults.setModel(new DefaultComboBoxModel<Object>(objectArray));
                    PMatrixPanel.this.jCB_testResults.setSelectedIndex(0);
                    PMatrixPanel.this.jLB_Display.setText(TestViewerLrb.get("PMATRIX_DISPLAY") + ":");
                    PMatrixPanel.this.jCB_Display.setVisible(true);
                    PMatrixPanel.this._percentageFormat.setMaximumFractionDigits(PMatrixPanel.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    PMatrixPanel.this.dataMinerTablePanel.getTable().setFixedColumns(1, 165);
                    PMatrixPanel.this.dataMinerTablePanel.getTable().setSelectionMode(2);
                    PMatrixPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)PMatrixPanel.this._pMatrixTabState.getCompareSummaryModel());
                    PMatrixPanel.this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
                    PMatrixPanel.this.dataMinerTablePanel.getTable().setSorted(true);
                    TableColumnModel tableColumnModel = PMatrixPanel.this.dataMinerTablePanel.getTable().getFullColumnModel();
                    tableColumnModel.getColumn(1).setPreferredWidth(300);
                    tableColumnModel.getColumn(2).setPreferredWidth(150);
                    tableColumnModel.getColumn(3).setPreferredWidth(110);
                    tableColumnModel.getColumn(4).setPreferredWidth(80);
                    NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
                    tableColumnModel.getColumn(1).setCellRenderer(new HistogramBarRenderer(100L, true, PMatrixPanel.this._percentageFormat));
                    tableColumnModel.getColumn(2).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(3).setCellRenderer(numberCellRenderer);
                    tableColumnModel.getColumn(4).setCellRenderer(numberCellRenderer);
                    if (PMatrixPanel.this.jCB_Display.getSelectedIndex() == 0) {
                        PMatrixPanel.this.jPMatrixDetailsPanel.setVisible(false);
                        PMatrixPanel.this.jCompareResultsPanel.setVisible(true);
                    } else {
                        PMatrixPanel.this.jPMatrixDetailsPanel.setVisible(true);
                        PMatrixPanel.this.jCompareResultsPanel.setVisible(false);
                    }
                    if (objectArray.length <= 1) {
                        PMatrixPanel.this.jLB_testResults.setVisible(false);
                        PMatrixPanel.this.jCB_testResults.setVisible(false);
                        PMatrixPanel.this.jLB_Display.setVisible(false);
                        PMatrixPanel.this.jCB_Display.setVisible(false);
                        PMatrixPanel.this.jSeparator1.setVisible(false);
                        PMatrixPanel.this.jPMatrixDetailsPanel.setVisible(true);
                        PMatrixPanel.this.jCompareResultsPanel.setVisible(false);
                    }
                    PMatrixPanel.this.jNT_PMatrixDetails.setAutoResizeMode(0);
                    PMatrixPanel.this.setCompareModel();
                    PMatrixPanel.this.setLoaded(true);
                }
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            finally {
                if (this._ex != null) {
                    DataMinerEditor.handleEditorException(PMatrixPanel.this.getEditor().getContext(), this._ex, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
                }
                PMatrixPanel.this.setLoading(false);
                if (PMatrixPanel.this.overLayPanel != null) {
                    PMatrixPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

