/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.structure;

import java.util.Comparator;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.teditor.structure.ColumnDataRow;
import oracle.dmt.dataminer.teditor.structure.StructureLrb;
import oracle.dmt.dataminer.utils.comparator.NumberComparator;

public class StructureViewTableModel
extends ODMrTableModel<ColumnDataRow> {
    public static final String[] COLUMN_NAMES = new String[]{StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_NAME"), StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_TYPE"), StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_MINING_TYPE"), StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_LENGTH"), StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_PRECISION"), StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_DATA_SCALE"), StructureLrb.get("TABLE_STRUCTURE_EDITOR_COLUMN_COLUMN_ID")};
    public static final int _COLUMN_NAME = 0;
    public static final int _COLUMN_DATA_TYPE = 1;
    public static final int _COLUMN_MINING_TYPE = 2;
    public static final int _COLUMN_LENGTH = 3;
    public static final int _COLUMN_PRECISION = 4;
    public static final int _COLUMN_SCALE = 5;
    public static final int _COLUMN_ID = 6;

    public StructureViewTableModel(List<ColumnDataRow> list) {
        super(COLUMN_NAMES, list);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ColumnDataRow columnDataRow = (ColumnDataRow)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = columnDataRow.getName();
                break;
            }
            case 1: {
                object = columnDataRow.getDataType();
                String string = columnDataRow.getDataTypeQualifier();
                object = DatabaseMetadataUtils.getJSONDataType((String)object, string);
                break;
            }
            case 2: {
                if (columnDataRow.getDataType() == null) {
                    object = null;
                    break;
                }
                object = columnDataRow.getDataType().isEmpty() ? columnDataRow.getDataType() : DatabaseMetadataUtils.getDefaultUIMiningType(columnDataRow.getDataType());
                break;
            }
            case 3: {
                object = columnDataRow.getLength();
                break;
            }
            case 4: {
                object = columnDataRow.getPrecision();
                break;
            }
            case 5: {
                object = columnDataRow.getScale();
                break;
            }
            case 6: {
                object = columnDataRow.getColumn_id();
                break;
            }
            default: {
                assert (false) : "Out of bounds column";
                break;
            }
        }
        return object != null ? object : "";
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return NumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }
}

