/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningSettingsType;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressRunnable;

class BinningWorker
extends ProgressRunnable {
    private boolean _canceled;
    private Map<String, List<NameValuePair>> values;
    private Context context;
    private List<AttributeType> binnedAttributes;
    private List<BinningSettingsType> binningSettings;
    public static final int DEFAULT_TOPN = 10;
    private static Logger LOGGER = Logger.getLogger(BinningWorker.class.getName());

    public BinningWorker(Context context, List<AttributeType> list, List<BinningSettingsType> list2) {
        this.context = context;
        this.binnedAttributes = list;
        this.binningSettings = list2;
    }

    public Map<String, List<NameValuePair>> getValues() {
        return this.values;
    }

    public Object doWork() throws Exception {
        BaseTreeNode baseTreeNode = (BaseTreeNode)this.context.getNode();
        WorkflowNode workflowNode = (WorkflowNode)baseTreeNode.getParent().getAncestor(WorkflowNode.class);
        WorkflowModel workflowModel = workflowNode.getWorkflowModel();
        if (workflowModel == null) {
            return null;
        }
        String string = GraphUtils.getSampleTableName(this.context);
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.context);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            for (int i = 0; i < this.binnedAttributes.size(); ++i) {
                AttributeType attributeType = this.binnedAttributes.get(i);
                arrayList.add(attributeType.getName());
                arrayList2.add(attributeType.getDataType());
                if (GraphUtils.isNumericType(attributeType.getDataType())) {
                    arrayList3.add(this.binningSettings.get(i).getNumericBinCount().intValue());
                    continue;
                }
                arrayList3.add(1000);
            }
            this.values = TransformationStatisticsState.generateGraphBins(connectionFolder, "select * from " + string, arrayList, arrayList2, arrayList3, null, null);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected void finish(Object object) {
    }

    protected void doCancel() {
        super.doCancel();
        this._canceled = true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public static Map<String, List<NameValuePair>> getDefaultBins(Context context, List<AttributeType> list, List<BinningSettingsType> list2, boolean bl) throws Exception {
        HashMap<String, List<NameValuePair>> hashMap = new HashMap();
        if (!bl) {
            BinningWorker binningWorker = new BinningWorker(context, list, list2);
            binningWorker.doWork();
            return binningWorker.getValues();
        }
        BinningWorker binningWorker = new BinningWorker(context, list, list2);
        binningWorker.setTitle("Getting Values");
        binningWorker.setMessage("Getting Distinct Values");
        binningWorker.setCancelable(false);
        binningWorker.start(true);
        hashMap = binningWorker.getValues();
        return hashMap;
    }

    public static Map<String, List<NameValuePair>> getDefaultBins(Context context, List<AttributeType> list, List<BinningSettingsType> list2) throws Exception {
        return BinningWorker.getDefaultBins(context, list, list2, false);
    }
}

