/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel;

public class ODMrColumnAutoSize
extends MouseAdapter {
    private static final int DEFAULT_COLUMN_PADDING = 5;
    private static final int DEFAULT_COLUMN_WIDTH = 200;
    protected static final String AUTO_FIT_ALL = "Auto-fit All Columns";
    protected static final String AUTO_FIT_SELECTED = "Auto-fit Selected Column";
    protected static final String AUTO_FIT_ON_DATA = "on Data";
    protected static final String AUTO_FIT_ON_HEADER = "on Header";
    protected static final String AUTO_FIT_DEFAULT = "default";
    protected static final String AUTO_FIT_OPTIMUM = "Best Fit";

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            TableColumn tableColumn = this.getResizingColumn(jTableHeader, mouseEvent.getPoint());
            if (tableColumn != null) {
                ODMrColumnAutoSize.autoResizeTableColumn(jTable, tableColumn, AUTO_FIT_OPTIMUM, 5);
                jTableHeader.setResizingColumn(tableColumn);
                jTable.getParent().validate();
            }
        }
    }

    public static int autoResizeTable(JTable jTable, String string) {
        return ODMrColumnAutoSize.autoResizeTable(jTable, null, string, 5);
    }

    public static int autoResizeTable(JTable jTable, JTable jTable2, String string) {
        return ODMrColumnAutoSize.autoResizeTable(jTable, jTable2, string, 5);
    }

    public static int autoResizeSelectedColumns(JTable jTable, String string) {
        int n = 0;
        int[] nArray = jTable.getSelectedColumns();
        for (int i = 0; i < nArray.length; ++i) {
            n += ODMrColumnAutoSize.autoResizeTableColumn(jTable, jTable.getColumnModel().getColumn(nArray[i]), string, 5);
        }
        return n;
    }

    public static int autoResizeTable(JTable jTable, String string, int n) {
        return ODMrColumnAutoSize.autoResizeTable(jTable, null, string, n);
    }

    public static int autoResizeTable(JTable jTable, JTable jTable2, String string, int n) {
        TableColumn tableColumn;
        int n2 = 0;
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        Dimension dimension = jTable.getIntercellSpacing();
        int[] nArray = jTable.getSelectedColumns();
        int n3 = nArray.length;
        n3 = jTable.getColumnCount();
        nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = i;
        }
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            tableColumn = tableColumnModel.getColumn(nArray[i]);
            nArray2[i] = ODMrColumnAutoSize.getMaxColumnWidth(jTable, tableColumn, string, n);
            n2 += nArray2[i];
        }
        JTableHeader jTableHeader = jTable.getTableHeader();
        Dimension dimension2 = jTableHeader.getPreferredSize();
        dimension2.width = n2 += (n3 - 1) * dimension.width;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            tableColumn = tableColumnModel.getColumn(nArray[i]);
            tableColumn.setPreferredWidth(nArray2[i]);
            n4 += nArray2[i];
        }
        Dimension dimension3 = jTable.getPreferredScrollableViewportSize();
        if (dimension3.width > n4) {
            jTable.setAutoResizeMode(3);
        }
        jTable.setFillsViewportHeight(true);
        if (jTable2 != null) {
            jTable2.setFillsViewportHeight(true);
        }
        ODMrColumnAutoSize.repaint(jTable);
        return n2;
    }

    public static int autoResizeTableColumn(JTable jTable, TableColumn tableColumn, String string, int n) {
        int n2 = 0;
        tableColumn.setPreferredWidth(ODMrColumnAutoSize.getMaxColumnWidth(jTable, tableColumn, string, n));
        return n2;
    }

    private static int getMaxColumnWidth(JTable jTable, TableColumn tableColumn, String string, int n) {
        int n2 = 0;
        if (string.equals(AUTO_FIT_ON_HEADER) || string.equals(AUTO_FIT_DEFAULT)) {
            n2 = ODMrColumnAutoSize.getHeaderWidth(jTable, tableColumn);
        } else if (string.equals(AUTO_FIT_ON_DATA)) {
            n2 = ODMrColumnAutoSize.getMaxCellDataWidth(jTable, tableColumn);
        } else if (string.equals(AUTO_FIT_OPTIMUM)) {
            int n3 = ODMrColumnAutoSize.getHeaderWidth(jTable, tableColumn);
            int n4 = ODMrColumnAutoSize.getMaxCellDataWidth(jTable, tableColumn);
            n2 = Math.max(n3, n4);
        }
        if (string.equals(AUTO_FIT_DEFAULT)) {
            n2 = Math.max(n2, 200);
        }
        return n2 + n;
    }

    private static int getHeaderWidth(JTable jTable, TableColumn tableColumn) {
        int n = jTable.convertColumnIndexToView(tableColumn.getModelIndex());
        Component component = null;
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer != null) {
            component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, -1, n);
            return ODMrColumnAutoSize.getComponentWidth(component);
        }
        String string = (String)tableColumn.getHeaderValue();
        JLabel jLabel = new JLabel(string);
        return ODMrColumnAutoSize.getComponentWidth(jLabel);
    }

    private static int getMaxCellDataWidth(JTable jTable, TableColumn tableColumn) {
        int n = 0;
        int n2 = jTable.convertColumnIndexToView(tableColumn.getModelIndex());
        Component component = null;
        int n3 = 0;
        n3 = jTable.getModel() instanceof ODMrResultSetTableModel ? ((ODMrResultSetTableModel)jTable.getModel()).getLoadedCount() : jTable.getRowCount();
        for (int i = 0; i < n3; ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(i, n2);
            component = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(i, n2), false, false, i, n2);
            n = Math.max(n, ODMrColumnAutoSize.getComponentWidth(component));
        }
        return n;
    }

    private static int getComponentWidth(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            String string = jTextComponent.getText();
            Font font = jTextComponent.getFont();
            FontMetrics fontMetrics = jTextComponent.getFontMetrics(font);
            return SwingUtilities.computeStringWidth(fontMetrics, string);
        }
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            Font font = jLabel.getFont();
            FontMetrics fontMetrics = jLabel.getFontMetrics(font);
            return SwingUtilities.computeStringWidth(fontMetrics, jLabel.getText());
        }
        return component.getPreferredSize().width;
    }

    private TableColumn getResizingColumn(JTableHeader jTableHeader, Point point) {
        return this.getResizingColumn(jTableHeader, point, jTableHeader.columnAtPoint(point));
    }

    private TableColumn getResizingColumn(JTableHeader jTableHeader, Point point, int n) {
        int n2;
        if (n == -1) {
            return null;
        }
        Rectangle rectangle = jTableHeader.getHeaderRect(n);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n3 = rectangle.x + rectangle.width / 2;
        if (jTableHeader.getComponentOrientation().isLeftToRight()) {
            n2 = point.x < n3 ? n - 1 : n;
        } else {
            int n4 = n2 = point.x < n3 ? n : n - 1;
        }
        if (n2 == -1) {
            return null;
        }
        return jTableHeader.getColumnModel().getColumn(n2);
    }

    private static void repaint(JTable jTable) {
        jTable.invalidate();
        jTable.doLayout();
        jTable.repaint();
    }
}

