/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.common.vo.TableVO;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.DataSourceViewOption;
import oracle.dmt.dataminer.teditor.data.DataViewerState;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTable;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModel;
import oracle.dmt.dataminer.utils.DelayedLoadInterface;
import oracle.dmt.dataminer.utils.DelayedProcessWorker;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpInfo;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class DataViewerPanel
extends DataMinerViewGUI
implements DelayedLoadInterface {
    boolean _loadFromNode = true;
    boolean _loadFromSQLExpression = false;
    TableVO _selectedTable = null;
    String SYN_SELECTED_TABLE = "syn_selected_table";
    boolean _initialLoad = true;
    String _connectionName;
    String _schemaName;
    String _tableName;
    String _sqlExpression;
    BufferedImage _image = null;
    private DelayedProcessWorker worker;
    private ODMrResultSetTableModel _mdl;
    private int _fetchSize;
    private BlockingComponent overLayPanel = null;
    private JTable _dataNiceTable;
    private JScrollPane jScrollPane1;
    private DataViewerState _state;
    private JViewport _viewRows = new JViewport();
    private LoadingTableModel loadingModel;

    public DataViewerPanel(Editor editor, Context context) throws Exception {
        super(editor, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public DataViewerPanel(Context context, boolean bl) {
        super(null, context);
        this._loadFromNode = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public DataViewerPanel(String string, String string2, String string3) throws Exception {
        super(null, null);
        this._loadFromNode = true;
        this._connectionName = string;
        this._schemaName = string2;
        this._tableName = string3;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public DataViewerPanel(Context context, String string) throws Exception {
        super(null, context);
        this._loadFromNode = false;
        this._loadFromSQLExpression = true;
        this._sqlExpression = string;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this._dataNiceTable = new ODMrResultSetTable();
        this._dataNiceTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this._dataNiceTable);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 380, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 148, Short.MAX_VALUE).addContainerGap()));
    }

    public DataViewerState getState() {
        return this._state;
    }

    @Override
    public void initRes() {
    }

    ODMrResultSetTable getTableData() {
        return (ODMrResultSetTable)this._dataNiceTable;
    }

    public void setDataSourceViewOption(DataSourceViewOption dataSourceViewOption) throws Exception {
        this._state.setCurrentSourceOption(dataSourceViewOption);
    }

    @Override
    public void initUI() {
        this.initializeControls(this._loadFromNode || this._loadFromSQLExpression);
        this._state = this._context != null ? (this._loadFromSQLExpression ? new DataViewerState(this._context, this._sqlExpression) : new DataViewerState(this._context, this._loadFromNode)) : new DataViewerState(this._connectionName, this._schemaName, this._tableName);
        ((ODMrResultSetTable)this._dataNiceTable).setState(this._state);
        this.setLoading(true);
        if (this._loadFromNode || this._loadFromSQLExpression) {
            LoadUI loadUI = new LoadUI();
            loadUI.execute();
        }
    }

    public void loadTable(TableVO tableVO) {
        this.setLoading(true);
        this.initializeControls(true);
        TableVO tableVO2 = this.getSelectedTable();
        if (tableVO != tableVO2) {
            this._state.closeRS();
        }
        this.setSelectedTable(tableVO);
        LoadUISync loadUISync = new LoadUISync(tableVO != null ? tableVO.getSchema() : "", tableVO != null ? tableVO.getName() : "");
        loadUISync.execute();
    }

    public void loadTable(String string) {
        this.setLoading(true);
        this.initializeControls(true);
        this.setSelectedSQLExpression(string);
        LoadUISync loadUISync = new LoadUISync(string);
        loadUISync.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableVO getSelectedTable() {
        String string = this.SYN_SELECTED_TABLE;
        synchronized (string) {
            return this._selectedTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedTable(TableVO tableVO) {
        String string = this.SYN_SELECTED_TABLE;
        synchronized (string) {
            this._selectedTable = tableVO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedSQLExpression(String string) {
        String string2 = this.SYN_SELECTED_TABLE;
        synchronized (string2) {
            this._sqlExpression = string;
        }
    }

    public void reloadUI() {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this.setLoading(true);
        this.initializeControls(true);
        if (this._loadFromNode || this._loadFromSQLExpression) {
            ReloadUI reloadUI = new ReloadUI();
            reloadUI.execute();
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("dm_datasourceviewer_data");
    }

    private void initializeControls(boolean bl) {
        ((ODMrResultSetTable)this._dataNiceTable).setParentPanel(this);
        this.loadingModel = new LoadingTableModel(DataLrb.get("DATA_VIEWER_EDITOR_LOADING"));
        ((ODMrResultSetTable)this._dataNiceTable).setSuperModel((TableModel)((Object)this.loadingModel));
        JTable jTable = ((ODMrResultSetTable)this._dataNiceTable).getDummyRowHeader();
        this._viewRows.setView(jTable);
        this._viewRows.setPreferredSize(jTable.getMaximumSize());
        jTable.setFillsViewportHeight(true);
        this.jScrollPane1.setRowHeader(this._viewRows);
        if (!bl) {
            this.loadingModel.showSelectionRequired();
        } else {
            this.loadingModel.showLoading();
        }
        this._dataNiceTable.setFillsViewportHeight(true);
    }

    public void headerSortClicked(int n, boolean bl) {
        if (this._dataNiceTable.getModel() instanceof ODMrResultSetTableModel) {
            ODMrResultSetTableModel oDMrResultSetTableModel = (ODMrResultSetTableModel)this._dataNiceTable.getModel();
            if (oDMrResultSetTableModel.isSorting()) {
                return;
            }
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            oDMrResultSetTableModel.setSorting(true);
            if (((ODMrResultSetTable)this._dataNiceTable).isColSortable(n)) {
                int n2 = oDMrResultSetTableModel.getLoadedCount();
                int n3 = this._dataNiceTable.convertColumnIndexToModel(n);
                ODMrResultSetTableModel oDMrResultSetTableModel2 = ((ODMrResultSetTable)this._dataNiceTable).resetModelSorting();
                oDMrResultSetTableModel2.setSortCol(n3);
                if (bl) {
                    oDMrResultSetTableModel2.setSortDirection(" asc");
                } else {
                    oDMrResultSetTableModel2.setSortDirection(" desc");
                }
                this.launchProcess(oDMrResultSetTableModel2, n2, true);
            } else {
                oDMrResultSetTableModel.setSorting(false);
                if (this.overLayPanel != null) {
                    this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }

    public void sort2() {
        if (this._dataNiceTable.getModel() instanceof ODMrResultSetTableModel) {
            ODMrResultSetTableModel oDMrResultSetTableModel = (ODMrResultSetTableModel)this._dataNiceTable.getModel();
            if (oDMrResultSetTableModel.isSorting()) {
                return;
            }
            oDMrResultSetTableModel.setSorting(true);
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            int n = oDMrResultSetTableModel.getLoadedCount();
            ODMrResultSetTableModel oDMrResultSetTableModel2 = ((ODMrResultSetTable)this._dataNiceTable).resetModelSorting();
            this.launchProcess(oDMrResultSetTableModel2, n, true);
        }
    }

    void launchProcess(ODMrResultSetTableModel oDMrResultSetTableModel, int n, boolean bl) {
        this._mdl = oDMrResultSetTableModel;
        this._fetchSize = n;
        this.worker = new DelayedProcessWorker(this);
        this.worker.setReloadData(bl);
        this.worker.execute();
    }

    @Override
    public void loadDataProcess() {
        ((ODMrResultSetTable)this._dataNiceTable).setModel(this._mdl, this._fetchSize);
    }

    @Override
    public void reloadDataProcess() {
        ((ODMrResultSetTable)this._dataNiceTable).setModel(this._mdl, this._fetchSize);
    }

    @Override
    public void loadGUIProcess() {
        JTable jTable = ((ODMrResultSetTable)this._dataNiceTable).getRowHeader();
        this._viewRows.setView(jTable);
        this._viewRows.setPreferredSize(jTable.getMaximumSize());
        jTable.setFillsViewportHeight(true);
        ((ODMrResultSetTable)this._dataNiceTable).applyDefaultSettings();
        this.setLoaded(true);
        if (!this._mdl.isSorting() && this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
        }
        this._mdl.setSorting(false);
        this._dataNiceTable.invalidate();
    }

    public void close() {
        this._state.setClosing(true);
        ((ODMrResultSetTable)this._dataNiceTable).interruptSorting();
        this._state.close();
    }

    public static class LoadingTableModel
    extends GenericBaseTableModel {
        private Vector<String> _data = new Vector();
        public static final int _COLUMN_NAME = 0;

        public LoadingTableModel(String string) {
            Vector<String> vector = new Vector<String>();
            vector.add("");
            this.setColumnIdentifiers(vector);
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.setColumnCount(vector.size());
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public void showSelectionRequired() {
            this._data.clear();
            String string = DataLrb.get("DATA_VIEWER_EDITOR_SELECTION_REQUIRED");
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        public void showLoading() {
            this._data.clear();
            String string = DataLrb.get("DATA_VIEWER_EDITOR_LOADING");
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        public void showError(String string) {
            this._data.clear();
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            String string = this._data.get(n);
            String string2 = null;
            switch (n2) {
                case 0: {
                    string2 = string;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds";
                    break;
                }
            }
            return string2 != null ? string2 : "";
        }
    }

    private class ReloadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        protected Object doInBackground() throws Exception {
            try {
                DataViewerPanel.this._state.reloadModel();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return DataViewerPanel.this._state;
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    DataViewerPanel.this._dataNiceTable.setModel(DataViewerPanel.this._state.getResultSetModel());
                    DataViewerPanel.this._state.getResultSetModel().fireTableStructureChanged();
                    JTable jTable = ((ODMrResultSetTable)DataViewerPanel.this._dataNiceTable).getRowHeader();
                    DataViewerPanel.this._viewRows.setView(jTable);
                    DataViewerPanel.this._viewRows.setPreferredSize(jTable.getMaximumSize());
                    jTable.setFillsViewportHeight(true);
                    DataViewerPanel.this.jScrollPane1.setRowHeader(DataViewerPanel.this._viewRows);
                    DataViewerPanel.this.setLoaded(true);
                    if (DataViewerPanel.this.overLayPanel != null) {
                        DataViewerPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                    }
                } else {
                    if (DataViewerPanel.this._state.getResultSetModel() != null) {
                        DataViewerPanel.this._dataNiceTable.setModel(new DefaultTableModel(new Object[][]{{DataLrb.get("DATA_VIEWER_FAILURE_MESG")}}, new String[]{" "}));
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                DataViewerPanel.this.setLoading(false);
                if (DataViewerPanel.this.overLayPanel != null) {
                    DataViewerPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        protected Object doInBackground() throws Exception {
            try {
                DataViewerPanel.this._state.load();
                DataViewerPanel.this._state.loadModel();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return DataViewerPanel.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    DataViewerPanel.this._dataNiceTable.setModel(DataViewerPanel.this._state.getResultSetModel());
                    DataViewerPanel.this._state.getResultSetModel().fireTableStructureChanged();
                    JTable jTable = ((ODMrResultSetTable)DataViewerPanel.this._dataNiceTable).getRowHeader();
                    DataViewerPanel.this._viewRows.setView(jTable);
                    DataViewerPanel.this._viewRows.setPreferredSize(jTable.getMaximumSize());
                    jTable.setFillsViewportHeight(true);
                    DataViewerPanel.this.jScrollPane1.setRowHeader(DataViewerPanel.this._viewRows);
                    ((ODMrResultSetTable)DataViewerPanel.this._dataNiceTable).applyDefaultSettings();
                    DataViewerPanel.this.setLoaded(true);
                    if (DataViewerPanel.this.overLayPanel != null) {
                        DataViewerPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                    }
                } else {
                    DataViewerPanel.this.loadingModel.showError(DataLrb.get("DATA_VIEWER_FAILURE_DS_DOES_NOT_EXIST"));
                    if (this._ex.getMessage().startsWith("ORA-00942")) {
                        DataMinerEditor.handleEditorException(DataViewerPanel.this.getEditor().getContext(), this._ex, DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), DataLrb.get("DATA_VIEWER_FAILURE_DS_DOES_NOT_EXIST"));
                        return;
                    }
                    DataViewerPanel.this.loadingModel.showError(DataLrb.get("DATA_VIEWER_FAILURE_MESG_TRY_RERUN"));
                    if (this._ex != null) {
                        BaseTreeNode baseTreeNode;
                        NodeType nodeType;
                        boolean bl = false;
                        oracle.ide.model.Node node = DataViewerPanel.this._context.getNode();
                        if (node instanceof BaseTreeNode && !(nodeType = (NodeType)(baseTreeNode = (BaseTreeNode)node).getRepositoryData()).getStatus().equals((Object)NodeStatusType.COMPLETE) && !(nodeType instanceof DataSourceNodeType)) {
                            TNode tNode = baseTreeNode.getParent();
                            WorkflowNode workflowNode = (WorkflowNode)tNode.getAncestor(WorkflowNode.class);
                            WorkflowModel workflowModel = workflowNode.getWorkflowModel();
                            Node node2 = workflowModel.findNodeByName(node.getShortLabel());
                            List<AbstractNode> list = node2.findParentNodes();
                            String string = null;
                            for (AbstractNode abstractNode : list) {
                                NodeStatusType nodeStatusType = abstractNode.getState();
                                if (nodeStatusType.equals((Object)NodeStatusType.COMPLETE)) continue;
                                string = DataLrb.get("DATA_VIEWER_FAILURE_NOT_COMPLETE_PARENT");
                                break;
                            }
                            string = string == null ? DataLrb.get("DATA_VIEWER_FAILURE_NOT_COMPLETE_PARENT") : DataLrb.get("DATA_VIEWER_FAILURE_NOT_COMPLETE_THIS_NODE");
                            DataMinerEditor.handleEditorException(DataViewerPanel.this.getEditor().getContext(), this._ex, DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), string);
                            bl = true;
                        }
                        if (!bl) {
                            DataMinerEditor.handleEditorException(DataViewerPanel.this.getEditor().getContext(), this._ex, DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), DataLrb.get("DATA_VIEWER_FAILURE_MESG_TRY_RERUN"));
                        }
                    } else {
                        DataMinerEditor.handleEditorException(DataViewerPanel.this.getEditor().getContext(), this._ex, DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), DataLrb.get("DATA_VIEWER_FAILURE_MESG"));
                    }
                }
            }
            catch (Exception exception) {
                DataMinerEditor.handleEditorException(DataViewerPanel.this.getEditor().getContext(), this._ex, DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), DataLrb.get("DATA_VIEWER_FAILURE_MESG"));
            }
            finally {
                DataViewerPanel.this.setLoading(false);
            }
        }
    }

    private class LoadUISync
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        static final String _syncObject = "SyncObject";
        String _schema;
        String _table;
        String _sqlExpression = null;
        boolean _abandon = false;

        public LoadUISync(String string, String string2) {
            this._schema = string;
            this._table = string2;
        }

        public LoadUISync(String string) {
            this._sqlExpression = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground() throws Exception {
            try {
                String string = _syncObject;
                synchronized (_syncObject) {
                    if (DataViewerPanel.this._loadFromSQLExpression) {
                        if (this._sqlExpression == null) {
                            this._abandon = true;
                            this._success = false;
                        } else {
                            DataViewerPanel.this._state.setSqlExpression(this._sqlExpression);
                            DataViewerPanel.this._state.load();
                            DataViewerPanel.this._state.reloadModel();
                            this._abandon = false;
                            this._success = true;
                        }
                    } else {
                        TableVO tableVO = DataViewerPanel.this.getSelectedTable();
                        if (tableVO == null) {
                            this._abandon = true;
                            this._success = false;
                        } else if (tableVO.getSchema().equals(this._schema) && tableVO.getName().equals(this._table)) {
                            DataViewerPanel.this._state.setTableName(this._schema, this._table);
                            DataViewerPanel.this._state.load();
                            DataViewerPanel.this._state.reloadModel();
                            tableVO = DataViewerPanel.this.getSelectedTable();
                            if (tableVO == null) {
                                this._abandon = true;
                            } else if (!tableVO.getSchema().equals(this._schema) || !tableVO.getName().equals(this._table)) {
                                this._abandon = true;
                            } else {
                                this._success = true;
                            }
                        } else {
                            this._abandon = true;
                            this._success = false;
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                this._abandon = true;
            }
            {
                return DataViewerPanel.this._state;
            }
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._abandon) {
                    if (DataViewerPanel.this._dataNiceTable.getModel() instanceof LoadingTableModel && "".equals(this._table)) {
                        ((LoadingTableModel)((Object)DataViewerPanel.this._dataNiceTable.getModel())).showSelectionRequired();
                    }
                    return;
                }
                if (this._success && this._ex == null) {
                    Object object;
                    if (this._sqlExpression == null && (((TableVO)(object = DataViewerPanel.this.getSelectedTable())).getSchema().compareTo(this._schema) != 0 || ((TableVO)object).getName().compareTo(this._table) != 0)) {
                        return;
                    }
                    DataViewerPanel.this._dataNiceTable.setModel(DataViewerPanel.this._state.getResultSetModel());
                    DataViewerPanel.this._state.getResultSetModel().fireTableStructureChanged();
                    object = ((ODMrResultSetTable)DataViewerPanel.this._dataNiceTable).getRowHeader();
                    DataViewerPanel.this._viewRows.setView((Component)object);
                    DataViewerPanel.this._viewRows.setPreferredSize(((JComponent)object).getMaximumSize());
                    ((JTable)object).setFillsViewportHeight(true);
                    DataViewerPanel.this.jScrollPane1.setRowHeader(DataViewerPanel.this._viewRows);
                    DataViewerPanel.this.setLoaded(true);
                } else if (!this._success && this._table.compareTo("") == 0) {
                    if (DataViewerPanel.this._dataNiceTable.getModel() instanceof LoadingTableModel) {
                        ((LoadingTableModel)((Object)DataViewerPanel.this._dataNiceTable.getModel())).showSelectionRequired();
                    }
                } else {
                    if (DataViewerPanel.this._state.getResultSetModel() != null) {
                        DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[][]{{DataLrb.get("DATA_VIEWER_FAILURE_MESG")}}, new String[]{" "});
                        DataViewerPanel.this._dataNiceTable.setModel(defaultTableModel);
                        DataViewerPanel.this._state.getResultSetModel().fireTableStructureChanged();
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                DataViewerPanel.this.setLoading(false);
            }
        }
    }
}

