/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.ai;

import java.awt.Component;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.wflownodes.ColumnFilterNavNode;
import oracle.dmt.dataminer.teditor.ai.DialogsLrb;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterResultType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class AIViewerPanel
extends DataMinerViewGUI {
    private AttrsTableModelEx _models;
    private Map<String, Statistics> _statisticLookupMap = new TreeMap<String, Statistics>();
    private Map<String, String> _attrTypeLookupMap = new HashMap<String, String>();
    private BlockingComponent overLayPanel = null;
    private static final String[] _columnNamesEx = new String[]{DialogsLrb.get("AI_EDITOR_TABLE_COL_NAME"), DialogsLrb.get("AI_EDITOR_TABLE_COL_TYPE"), DialogsLrb.get("AI_EDITOR_TABLE_COL_RANK"), DialogsLrb.get("AI_EDITOR_TABLE_COL_IMPORTANCE")};
    private static final int[] _columnWidthsEx = new int[]{180, 80, 50, 80};
    private static final int ATTRIBUTE = 0;
    private static final int DATA_TYPE = 1;
    private static final int RANK = 2;
    private static final int IMPORTANCE = 3;
    private JLabel jTargetColumnLabel;
    private JLabel jTargetLabel;
    private DataMinerTablePanel tablePanel;

    public AIViewerPanel(Editor editor, Context context) {
        super(editor, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLabel, (Component)this.jTargetColumnLabel, (String)DialogsLrb.get("AI_EDITOR_TARGET_LABEL"));
    }

    @Override
    public void initUI() {
        this._models = new AttrsTableModelEx();
        this.tablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("AI_EDITOR_TABLE_TITLE"), 0);
        TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new NumberCellRenderer());
        tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(3);
        Preferences preferences = Preferences.getPreferences();
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)preferences);
        NumberFormat numberFormat = NumericFormat.getInstance(true, modelViewerPreferenceSettings.getPercentagePrecisionLevel(), 0, 0);
        numberFormat.setMaximumFractionDigits(modelViewerPreferenceSettings.getPercentagePrecisionLevel());
        numberFormat.setMinimumIntegerDigits(1);
        tableColumn.setCellRenderer(new HistogramBarRenderer(1L, true, numberFormat));
        this.tablePanel.getTable().setColumnSelectorAvailable(true);
        this.tablePanel.getTable().setShowToolTips(true);
        this.tablePanel.getTable().setUpdateSelectionOnSort(true);
        this.tablePanel.getTable().setRowSelectionAllowed(true);
        this.tablePanel.getTable().setSortColumn(2, true);
        int n = 0;
        for (int n2 : _columnWidthsEx) {
            this.tablePanel.getTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        Object object = new LoadUI();
        ((SwingWorker)object).execute();
    }

    public void reload() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public HelpInfo getHelpInfo() {
        String string = "ai_viewer_help";
        return new HelpInfo(string);
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private void initComponents() {
        this.jTargetLabel = new JLabel();
        this.jTargetColumnLabel = new JLabel();
        this.tablePanel = new DataMinerTablePanel();
        this.jTargetLabel.setText("Target:");
        this.jTargetLabel.setName("jTargetLabel");
        this.jTargetColumnLabel.setText("Target Column");
        this.jTargetColumnLabel.setName("jTargetColumnLabel");
        this.tablePanel.setName("tablePanel");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTargetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetColumnLabel, -2, 213, -2).addGap(0, 125, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLabel).addComponent(this.jTargetColumnLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 258, Short.MAX_VALUE).addContainerGap()));
    }

    private static class AttrsTableModelEx
    extends GenericBaseTableModel {
        Map<String, Statistics> _statisticLookupMap;

        public int getRowCount() {
            return this._statisticLookupMap != null ? this._statisticLookupMap.size() : 0;
        }

        public AttrsTableModelEx() {
            this(null);
        }

        public AttrsTableModelEx(Map<String, Statistics> map) {
            this._statisticLookupMap = map;
            this.setColumnIdentifiers(_columnNamesEx);
        }

        public Class getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this._statisticLookupMap == null) {
                return "Loading...";
            }
            Object[] objectArray = this._statisticLookupMap.keySet().toArray();
            Object object = null;
            if (objectArray.length > 0) {
                Statistics statistics = this._statisticLookupMap.get(objectArray[n]);
                switch (n2) {
                    case 0: {
                        object = objectArray[n];
                        break;
                    }
                    case 1: {
                        object = statistics.getType();
                        break;
                    }
                    case 2: {
                        if (statistics == null) break;
                        object = statistics.getRank();
                        break;
                    }
                    case 3: {
                        if (statistics == null) break;
                        object = statistics.getImportance();
                        break;
                    }
                }
            }
            return object;
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        public LoadUI() {
            super(AIViewerPanel.this, AIViewerPanel.this.tablePanel.getTable());
        }

        private void loadResults(ColumnFilterNodeType columnFilterNodeType) throws SQLException {
            for (Object object : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
                AIViewerPanel.this._attrTypeLookupMap.put(object.getName(), object.getDataType());
            }
            ColumnFilterResultType columnFilterResultType = columnFilterNodeType.getColumnFilterResults();
            if (columnFilterResultType != null) {
                Object object;
                AIViewerPanel.this._statisticLookupMap.clear();
                object = new SQLHelper();
                AttributeType attributeType = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute();
                if (attributeType != null) {
                    try {
                        String string = columnFilterResultType.getAttrImportanceOutput();
                        String string2 = "SELECT ATTRIBUTE_NAME, IMPORTANCE_VALUE, RANK FROM " + string + " WHERE ATTRIBUTE_NAME != :1 ORDER BY RANK";
                        ((SQLHelper)object).conn = ConnectionFolder.getConnection(AIViewerPanel.this._context);
                        ((SQLHelper)object).pstmt = ((SQLHelper)object).conn.prepareStatement(string2);
                        ((SQLHelper)object).pstmt.setString(1, attributeType.getName());
                        ((SQLHelper)object).pstmt.setFetchSize(100);
                        ((SQLHelper)object).rs = ((SQLHelper)object).pstmt.executeQuery();
                        String string3 = null;
                        Integer n = null;
                        Double d = null;
                        while (((SQLHelper)object).rs.next()) {
                            string3 = ((SQLHelper)object).rs.getString("ATTRIBUTE_NAME");
                            n = ((SQLHelper)object).rs.getInt("RANK");
                            d = ((SQLHelper)object).rs.getDouble("IMPORTANCE_VALUE");
                            Statistics statistics = new Statistics();
                            statistics.setType((String)AIViewerPanel.this._attrTypeLookupMap.get(string3));
                            statistics.setRank(n);
                            statistics.setImportance(d);
                            AIViewerPanel.this._statisticLookupMap.put(string3, statistics);
                        }
                    }
                    catch (SQLException sQLException) {
                        throw sQLException;
                    }
                    finally {
                        ((SQLHelper)object).close();
                    }
                }
            }
        }

        @Override
        protected Void doInBackground() throws Exception {
            Node node = AIViewerPanel.this._context.getNode();
            if (node instanceof ColumnFilterNavNode) {
                ColumnFilterNavNode columnFilterNavNode = (ColumnFilterNavNode)node;
                ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNavNode.getRepositoryData();
                this.loadResults(columnFilterNodeType);
            }
            return null;
        }

        @Override
        protected void onSuccess(Void void_) {
            if (AIViewerPanel.this._statisticLookupMap.isEmpty()) {
                this.setTableMessage(DialogsLrb.get("AI_EDITOR_TABLE_FAILURE_MESG_TRY_RERUN"));
            } else {
                AIViewerPanel.this._models = new AttrsTableModelEx(AIViewerPanel.this._statisticLookupMap);
                AIViewerPanel.this.tablePanel.getTable().setModel((TableModel)((Object)AIViewerPanel.this._models));
                Node node = AIViewerPanel.this._context.getNode();
                if (node instanceof ColumnFilterNavNode) {
                    ColumnFilterNavNode columnFilterNavNode = (ColumnFilterNavNode)node;
                    ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNavNode.getRepositoryData();
                    AIViewerPanel.this.jTargetColumnLabel.setText(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute().getName());
                    AIViewerPanel.this.tablePanel.getTable().setSortColumn(2, true);
                }
            }
        }

        @Override
        protected void onFailure(Exception exception) {
            if (exception instanceof SQLException && ((SQLException)exception).getErrorCode() == 942) {
                this.setTableMessage(DialogsLrb.get("AI_EDITOR_TABLE_FAILURE_MESG_TRY_RERUN"));
                return;
            }
            super.onFailure(exception);
        }

        @Override
        protected void onFinally() {
            if (AIViewerPanel.this.overLayPanel != null) {
                AIViewerPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            }
        }
    }

    private static class Statistics {
        String _type;
        Integer _rank;
        Double _importance;

        public Statistics() {
            this(null, null, null);
        }

        public Statistics(String string, Integer n, Double d) {
            this._type = string;
            this._rank = n;
            this._importance = d;
        }

        public void setRank(Integer n) {
            this._rank = n;
        }

        public Integer getRank() {
            return this._rank;
        }

        public void setImportance(Double d) {
            this._importance = d;
        }

        public Double getImportance() {
            return this._importance;
        }

        public void setType(String string) {
            this._type = string;
        }

        public String getType() {
            return this._type;
        }
    }
}

