/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.FilterSetting;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.NBModelDetails;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OraclePreparedStatement;

public class NBModelDetailsImpl
implements NBModelDetails {
    private static final Logger LOGGER = Logger.getLogger(NBModelDetailsImpl.class.getName());
    private static final String _NB_MODEL_DETAILS_CAT_TARGET = "SELECT * FROM (\nSELECT * FROM (\nSELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"probability\" from (SELECT CASE WHEN C.attribute_subname IS NOT NULL THEN\n\t               C.attribute_name || '.' ||  C.attribute_subname\n\t          ELSE C.attribute_name\n\t     END \"attribute_name_subname\",\n\t     NVL(C.attribute_str_value, C.attribute_num_value) \"attribute_value\",\n\t     C.attribute_name \"attribute_name\",\n\t     C.conditional_probability \"probability\"\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param)) T,\n\t     TABLE(T.conditionals) C\nWHERE T.target_attribute_str_value = :target_value_param \nUNION\nSELECT '<PRIOR>' \"attribute_name_subname\",\n       '<PRIOR>' \"attribute_name\",\n\t    'NULL' \"attribute_value\",\n       T.prior_probability \"probability\"\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param)) T\nWHERE T.target_attribute_str_value = :target_value_param \n) \n) order by \"probability\" DESC NULLS LAST ,\"attribute_name_subname\" ASC ,\"attribute_value\" ASC \n) WHERE rownum <= :rownum_param \n";
    private static final String _NB_MODEL_DETAILS_CAT_TARGET_PARTITION = "SELECT * FROM (\nSELECT * FROM (\nSELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"probability\" from (SELECT CASE WHEN C.attribute_subname IS NOT NULL THEN\n\t               C.attribute_name || '.' ||  C.attribute_subname\n\t          ELSE C.attribute_name\n\t     END \"attribute_name_subname\",\n\t     NVL(C.attribute_str_value, C.attribute_num_value) \"attribute_value\",\n\t     C.attribute_name \"attribute_name\",\n\t     C.conditional_probability \"probability\"\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param, :partitionId)) T,\n\t     TABLE(T.conditionals) C\nWHERE T.target_attribute_str_value = :target_value_param \nUNION\nSELECT '<PRIOR>' \"attribute_name_subname\",\n       '<PRIOR>' \"attribute_name\",\n     'NULL' \"attribute_value\",\n       T.prior_probability \"probability\"\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param,:partitionId)) T\nWHERE T.target_attribute_str_value = :target_value_param \n) \n) order by \"probability\" DESC NULLS LAST ,\"attribute_name_subname\" ASC ,\"attribute_value\" ASC \n) WHERE rownum <= :rownum_param \n";
    private static final String _NB_MODEL_DETAILS_NUM_TARGET = "SELECT * FROM (\nSELECT * FROM (\nSELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"probability\" from (SELECT CASE WHEN C.attribute_subname IS NOT NULL THEN\n\t               C.attribute_name || '.' ||  C.attribute_subname\n\t          ELSE C.attribute_name\n\t     END \"attribute_name_subname\",\n\t     NVL(C.attribute_str_value, C.attribute_num_value) \"attribute_value\",\n\t     C.attribute_name \"attribute_name\",\n\t     C.conditional_probability \"probability\"\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param)) T,\n\t     TABLE(T.conditionals) C\nWHERE T.target_attribute_num_value = :target_value_param \nUNION\nSELECT '<PRIOR>' \"attribute_name_subname\",\n       '<PRIOR>' \"attribute_name\",\n       'NULL' \"attribute_value\",\n       T.prior_probability \"probability\"\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param)) T\nWHERE T.target_attribute_num_value = :target_value_param \n) \n) order by \"probability\" DESC NULLS LAST ,\"attribute_name_subname\" ASC ,\"attribute_value\" ASC \n) WHERE rownum <= :rownum_param \n";
    private static final String _NB_MODEL_DETAILS_NUM_TARGET_PARTITION = "SELECT * FROM (\nSELECT * FROM (\nSELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"probability\" from (SELECT CASE WHEN C.attribute_subname IS NOT NULL THEN\n\t               C.attribute_name || '.' ||  C.attribute_subname\n\t          ELSE C.attribute_name\n\t     END \"attribute_name_subname\",\n\t     NVL(C.attribute_str_value, C.attribute_num_value) \"attribute_value\",\n\t     C.attribute_name \"attribute_name\",\n\t     C.conditional_probability \"probability\"\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param, :partitionId)) T,\n\t     TABLE(T.conditionals) C\nWHERE T.target_attribute_num_value = :target_value_param \nUNION\nSELECT '<PRIOR>' \"attribute_name_subname\",\n       '<PRIOR>' \"attribute_name\",\n       'NULL' \"attribute_value\",\n       T.prior_probability \"probability\"\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param, :partitionId)) T\nWHERE T.target_attribute_num_value = :target_value_param \n) \n) order by \"probability\" DESC NULLS LAST ,\"attribute_name_subname\" ASC ,\"attribute_value\" ASC \n) WHERE rownum <= :rownum_param \n";
    private static final String _NB_MODEL_COMPARE_PROPENSITIES = "SELECT * FROM (\nSELECT * FROM (\nSELECT \"attribute_name_subname\", \"attribute_value\", \n\tCASE\n\t  WHEN V > 0 THEN V\n\t  ELSE null\n\tEND \"propensity_target_one\",\n\tCASE\n\t  WHEN V < 0 THEN abs(V)\n\t  ELSE null\n\tEND \"propensity_target_two\",\n\tabs(V) \"propensity_target\" \n\tFROM (\n\tSELECT \"attribute_name_subname\", \"attribute_value\", (nvl(c1, 0)-nvl(c2, 0))/(nvl(c1, 0)+nvl(c2, 0)) V FROM (\n\tSELECT * FROM (\n\t  SELECT target_attribute_value, \"attribute_name_subname\", \"attribute_value\", agg_attribute_value_prob\n\t   FROM (\n\t     SELECT /*+ NO_MERGE(P) */ target_attribute_value, \"attribute_name_subname\", \"attribute_value\",\n\t       (attribute_value_prob / SUM(attribute_value_prob) over(PARTITION BY \"attribute_name_subname\", \"attribute_value\")) agg_attribute_value_prob\n\t        FROM (\n\t          SELECT \n\t             nvl(to_char(target_attribute_num_value), target_attribute_str_value)  target_attribute_value,\n\t             prior_probability * s.conditional_probability                         attribute_value_prob,\n\t             NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) \"attribute_name_subname\",\n\t             nvl(to_char(s.attribute_num_value), s.attribute_str_value)            \"attribute_value\"\n\t          FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param)) t, TABLE(t.conditionals) s\n\t        ) P \n\t      ) \n\t   order by \"attribute_name_subname\", target_attribute_value \n\t  ) \n\t)\n\tPIVOT (max(agg_attribute_value_prob) for target_attribute_value IN (<target_value_param_1> c1, <target_value_param_2> c2 )\n\t) where c1 is not null or c2 is not null \n    ) )\t order by \"propensity_target\"  DESC NULLS LAST ,\"attribute_name_subname\"  ASC ,\"attribute_value\"  ASC \n\t  ) WHERE rownum <= :rownum_param \n";
    private static final String _NB_MODEL_COMPARE_PROPENSITIES_PARTITION = "SELECT * FROM (\nSELECT * FROM (\nSELECT \"attribute_name_subname\", \"attribute_value\", \n\tCASE\n\t  WHEN V > 0 THEN V\n\t  ELSE null\n\tEND \"propensity_target_one\",\n\tCASE\n\t  WHEN V < 0 THEN abs(V)\n\t  ELSE null\n\tEND \"propensity_target_two\",\n\tabs(V) \"propensity_target\" \n\tFROM (\n\tSELECT \"attribute_name_subname\", \"attribute_value\", (nvl(c1, 0)-nvl(c2, 0))/(nvl(c1, 0)+nvl(c2, 0)) V FROM (\n\tSELECT * FROM (\n\t  SELECT target_attribute_value, \"attribute_name_subname\", \"attribute_value\", agg_attribute_value_prob\n\t   FROM (\n\t     SELECT /*+ NO_MERGE(P) */ target_attribute_value, \"attribute_name_subname\", \"attribute_value\",\n\t       (attribute_value_prob / SUM(attribute_value_prob) over(PARTITION BY \"attribute_name_subname\", \"attribute_value\")) agg_attribute_value_prob\n\t        FROM (\n\t          SELECT \n\t             nvl(to_char(target_attribute_num_value), target_attribute_str_value)  target_attribute_value,\n\t             prior_probability * s.conditional_probability                         attribute_value_prob,\n\t             NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) \"attribute_name_subname\",\n\t             nvl(to_char(s.attribute_num_value), s.attribute_str_value)            \"attribute_value\"\n\t          FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param, :partitionId)) t, TABLE(t.conditionals) s\n\t        ) P \n\t      ) \n\t   order by \"attribute_name_subname\", target_attribute_value \n\t  ) \n\t)\n\tPIVOT (max(agg_attribute_value_prob) for target_attribute_value IN (<target_value_param_1> c1, <target_value_param_2> c2 )\n\t) where c1 is not null or c2 is not null \n    ) )\t order by \"propensity_target\"  DESC NULLS LAST ,\"attribute_name_subname\"  ASC ,\"attribute_value\"  ASC \n\t  ) WHERE rownum <= :rownum_param \n";
    private static final String _NB_MODEL_COMPARE_PROPENSITIES_TOTAL_COUNT = "SELECT COUNT(*) TOTAL_PROPENSITIES FROM (\nSELECT * FROM (\nSELECT \"attribute_name_subname\", \"attribute_value\", \n\tCASE\n\t  WHEN V > 0 THEN V\n\t  ELSE null\n\tEND \"propensity_target_one\",\n\tCASE\n\t  WHEN V < 0 THEN abs(V)\n\t  ELSE null\n\tEND \"propensity_target_two\",\n\tabs(V) \"propensity_target\" \n\tFROM (\n\tSELECT \"attribute_name_subname\", \"attribute_value\", (nvl(c1, 0)-nvl(c2, 0))/(nvl(c1, 0)+nvl(c2, 0)) V FROM (\n\tSELECT * FROM (\n\t  SELECT target_attribute_value, \"attribute_name_subname\", \"attribute_value\", agg_attribute_value_prob\n\t   FROM (\n\t     SELECT /*+ NO_MERGE(P) */ target_attribute_value, \"attribute_name_subname\", \"attribute_value\",\n\t       (attribute_value_prob / SUM(attribute_value_prob) over(PARTITION BY \"attribute_name_subname\", \"attribute_value\")) agg_attribute_value_prob\n\t        FROM (\n\t          SELECT \n\t             nvl(to_char(target_attribute_num_value), target_attribute_str_value)  target_attribute_value,\n\t             prior_probability * s.conditional_probability                         attribute_value_prob,\n\t             NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) \"attribute_name_subname\",\n\t             nvl(to_char(s.attribute_num_value), s.attribute_str_value)            \"attribute_value\"\n\t          FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param)) t, TABLE(t.conditionals) s\n\t        ) P \n\t      ) \n\t   order by \"attribute_name_subname\", target_attribute_value \n\t  ) \n\t)\n\tPIVOT (max(agg_attribute_value_prob) for target_attribute_value IN (<target_value_param_1> c1, <target_value_param_2> c2 )\n\t) where c1 is not null or c2 is not null \n    ) )\t order by \"propensity_target\"  DESC NULLS LAST ,\"attribute_name_subname\"  ASC ,\"attribute_value\"  ASC \n\t  ) \n";
    private static final String _NB_MODEL_COMPARE_PROPENSITIES_TOTAL_COUNT_PARTITION = "SELECT COUNT(*) TOTAL_PROPENSITIES FROM (\nSELECT * FROM (\nSELECT \"attribute_name_subname\", \"attribute_value\", \n\tCASE\n\t  WHEN V > 0 THEN V\n\t  ELSE null\n\tEND \"propensity_target_one\",\n\tCASE\n\t  WHEN V < 0 THEN abs(V)\n\t  ELSE null\n\tEND \"propensity_target_two\",\n\tabs(V) \"propensity_target\" \n\tFROM (\n\tSELECT \"attribute_name_subname\", \"attribute_value\", (nvl(c1, 0)-nvl(c2, 0))/(nvl(c1, 0)+nvl(c2, 0)) V FROM (\n\tSELECT * FROM (\n\t  SELECT target_attribute_value, \"attribute_name_subname\", \"attribute_value\", agg_attribute_value_prob\n\t   FROM (\n\t     SELECT /*+ NO_MERGE(P) */ target_attribute_value, \"attribute_name_subname\", \"attribute_value\",\n\t       (attribute_value_prob / SUM(attribute_value_prob) over(PARTITION BY \"attribute_name_subname\", \"attribute_value\")) agg_attribute_value_prob\n\t        FROM (\n\t          SELECT \n\t             nvl(to_char(target_attribute_num_value), target_attribute_str_value)  target_attribute_value,\n\t             prior_probability * s.conditional_probability                         attribute_value_prob,\n\t             NVL2(s.attribute_subname, s.attribute_name || '.' || s.attribute_subname, s.attribute_name) \"attribute_name_subname\",\n\t             nvl(to_char(s.attribute_num_value), s.attribute_str_value)            \"attribute_value\"\n\t          FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param, :partitionId)) t, TABLE(t.conditionals) s\n\t        ) P \n\t      ) \n\t   order by \"attribute_name_subname\", target_attribute_value \n\t  ) \n\t)\n\tPIVOT (max(agg_attribute_value_prob) for target_attribute_value IN (<target_value_param_1> c1, <target_value_param_2> c2 )\n\t) where c1 is not null or c2 is not null \n    ) )\t order by \"propensity_target\"  DESC NULLS LAST ,\"attribute_name_subname\"  ASC ,\"attribute_value\"  ASC \n\t  ) \n";
    private static final String _NB_MODEL_DETAILS_NUM_TARGET_TOTAL_COUNT_PROBS = "SELECT\n      count(*) TOTAL_PROBABILTIES \n       FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param)) T,\n      TABLE(T.conditionals) C\n      WHERE T.TARGET_ATTRIBUTE_NUM_VALUE IN(<target_values>) ";
    private static final String _NB_MODEL_DETAILS_NUM_TARGET_TOTAL_COUNT_PROBS_PARTITION = "SELECT\n      count(*) TOTAL_PROBABILTIES \n       FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param, :partitionId)) T,\n      TABLE(T.conditionals) C\n      WHERE T.TARGET_ATTRIBUTE_NUM_VALUE IN(<target_values>) ";
    private static final String _NB_MODEL_DETAILS_CAT_TARGET_TOTAL_COUNT_PROBS = "SELECT\n      count(*) TOTAL_PROBABILTIES \n       FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param)) T,\n      TABLE(T.conditionals) C\n      WHERE T.TARGET_ATTRIBUTE_STR_VALUE IN(<target_values>) ";
    private static final String _NB_MODEL_DETAILS_CAT_TARGET_TOTAL_COUNT_PROBS_PARTITION = "SELECT\n      count(*) TOTAL_PROBABILTIES \n       FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_NB(:model_param, :partitionId)) T,\n      TABLE(T.conditionals) C\n      WHERE T.TARGET_ATTRIBUTE_STR_VALUE IN(<target_values>) ";

    @Override
    public Vector<CoefficientRowData> getProbabilities(ConnectionManager connectionManager, String string, String string2, FilterSetting filterSetting, String string3) throws SQLException {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        String string4 = null;
        boolean bl = filterSetting.getTargetValue() instanceof Number;
        string4 = StringUtils.isNotEmpty(string3) ? (bl ? _NB_MODEL_DETAILS_NUM_TARGET_PARTITION : _NB_MODEL_DETAILS_CAT_TARGET_PARTITION) : (bl ? _NB_MODEL_DETAILS_NUM_TARGET : _NB_MODEL_DETAILS_CAT_TARGET);
        try (SQLHelper sQLHelper = new SQLHelper();){
            Object object;
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("model_param", Model.getCombinedUserNameModelName(string, string2, false));
            if (StringUtils.isNotEmpty(string3)) {
                sQLHelper.opstmt.setStringAtName("partitionId", string3);
            }
            if (bl) {
                object = (Number)filterSetting.getTargetValue();
                if (object instanceof Integer) {
                    sQLHelper.opstmt.setIntAtName("target_value_param", ((Number)object).intValue());
                } else if (object instanceof Float) {
                    sQLHelper.opstmt.setFloatAtName("target_value_param", ((Number)object).floatValue());
                } else if (object instanceof BigDecimal) {
                    sQLHelper.opstmt.setBigDecimalAtName("target_value_param", (BigDecimal)object);
                } else {
                    sQLHelper.opstmt.setDoubleAtName("target_value_param", ((Number)object).doubleValue());
                }
            } else {
                sQLHelper.opstmt.setStringAtName("target_value_param", StringUtils.escapeSingleQuotesForSQL(filterSetting.getTargetValue().toString()));
            }
            sQLHelper.opstmt.setIntAtName("rownum_param", Math.max(0, filterSetting.getFetchSize()));
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                object = sQLHelper.rs.getString("attribute_name_subname");
                String string5 = sQLHelper.rs.getString("attribute_value");
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("probability");
                CoefficientRowData coefficientRowData = new CoefficientRowData((String)object, string5, bigDecimal.doubleValue(), null);
                vector.add(coefficientRowData);
            }
        }
        return vector;
    }

    @Override
    public Vector<CoefficientRowData> getPropensities(ConnectionManager connectionManager, String string, String string2, FilterSetting filterSetting, String string3) throws SQLException {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        String string4 = null;
        boolean bl = filterSetting.getTargetValue() instanceof Number;
        string4 = StringUtils.isNotEmpty(string3) ? _NB_MODEL_COMPARE_PROPENSITIES_PARTITION : _NB_MODEL_COMPARE_PROPENSITIES;
        try (SQLHelper sQLHelper = new SQLHelper();){
            if (bl) {
                string4 = StringUtils.getReplacedString(string4, "<target_value_param_1>", filterSetting.getTargetValue().toString());
                string4 = StringUtils.getReplacedString(string4, "<target_value_param_2>", filterSetting.getSecondTargetValue().toString());
            } else {
                string4 = StringUtils.getReplacedString(string4, "<target_value_param_1>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getTargetValue().toString()) + "'");
                string4 = StringUtils.getReplacedString(string4, "<target_value_param_2>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getSecondTargetValue().toString()) + "'");
            }
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("model_param", Model.getCombinedUserNameModelName(string, string2, false));
            if (StringUtils.isNotEmpty(string3)) {
                sQLHelper.opstmt.setStringAtName("partitionId", string3);
            }
            sQLHelper.opstmt.setIntAtName("rownum_param", Math.max(0, filterSetting.getFetchSize()));
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string5 = sQLHelper.rs.getString("attribute_name_subname");
                String string6 = sQLHelper.rs.getString("attribute_value");
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("propensity_target_one");
                BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal("propensity_target_two");
                if (filterSetting.isBinaryClassModel()) {
                    if (bigDecimal == null && bigDecimal2 != null) {
                        bigDecimal = new BigDecimal(-1.0 * bigDecimal2.doubleValue());
                    } else if (bigDecimal2 == null && bigDecimal != null) {
                        bigDecimal2 = new BigDecimal(-1.0 * bigDecimal.doubleValue());
                    }
                }
                CoefficientRowData coefficientRowData = new CoefficientRowData(string5, string6, bigDecimal != null ? Double.valueOf(bigDecimal.doubleValue()) : null, bigDecimal2 != null ? Double.valueOf(bigDecimal2.doubleValue()) : null);
                vector.add(coefficientRowData);
            }
        }
        return vector;
    }

    @Override
    public Vector<CoefficientRowData> getAllProbabilities(ConnectionManager connectionManager, String string, String string2, FilterSetting filterSetting) throws SQLException {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        return vector;
    }

    private String prepareTotalCountProbabilitiesQuery(String string, String string2, List<Object> list, String string3) {
        boolean bl;
        boolean bl2 = bl = list.get(0) instanceof String;
        String string4 = StringUtils.isNotEmpty(string3) ? (bl ? _NB_MODEL_DETAILS_CAT_TARGET_TOTAL_COUNT_PROBS_PARTITION : _NB_MODEL_DETAILS_NUM_TARGET_TOTAL_COUNT_PROBS_PARTITION) : (bl ? _NB_MODEL_DETAILS_CAT_TARGET_TOTAL_COUNT_PROBS : _NB_MODEL_DETAILS_NUM_TARGET_TOTAL_COUNT_PROBS);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = true;
        for (Object object : list) {
            if (bl3) {
                bl3 = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("?");
        }
        string4 = StringUtils.getReplacedString(string4, "<target_values>", stringBuilder.toString());
        return string4;
    }

    @Override
    public Integer getTotalCountProbabilities(ConnectionManager connectionManager, String string, String string2, List<Object> list, String string3) throws SQLException {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        Integer n = null;
        String string4 = null;
        string4 = this.prepareTotalCountProbabilitiesQuery(string, string2, list, string3);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("model_param", Model.getCombinedUserNameModelName(string, string2, false));
            int n2 = 2;
            if (StringUtils.isNotEmpty(string3)) {
                sQLHelper.opstmt.setStringAtName("partitionId", string3);
                n2 = 3;
            }
            boolean bl = list.get(0) instanceof String;
            for (Object object : list) {
                if (bl) {
                    sQLHelper.opstmt.setString(n2++, StringUtils.escapeSingleQuotesForSQL(object.toString()));
                    continue;
                }
                Number number = (Number)list.get(0);
                if (number instanceof Integer) {
                    sQLHelper.opstmt.setInt(n2++, number.intValue());
                    continue;
                }
                if (number instanceof Float) {
                    sQLHelper.opstmt.setFloat(n2++, number.floatValue());
                    continue;
                }
                if (number instanceof BigDecimal) {
                    sQLHelper.opstmt.setBigDecimal(n2++, (BigDecimal)number);
                    continue;
                }
                sQLHelper.opstmt.setDouble(n2++, number.doubleValue());
            }
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                n = sQLHelper.rs.getInt("TOTAL_PROBABILTIES");
            }
        }
        return n;
    }

    public Integer getTotalCountPropensities(ConnectionManager connectionManager, String string, String string2, FilterSetting filterSetting, String string3) throws SQLException {
        String string4 = null;
        Integer n = null;
        boolean bl = filterSetting.getTargetValue() instanceof Number;
        string4 = StringUtils.isNotEmpty(string3) ? _NB_MODEL_COMPARE_PROPENSITIES_TOTAL_COUNT_PARTITION : _NB_MODEL_COMPARE_PROPENSITIES_TOTAL_COUNT;
        try (SQLHelper sQLHelper = new SQLHelper();){
            if (bl) {
                string4 = StringUtils.getReplacedString(string4, "<target_value_param_1>", filterSetting.getTargetValue().toString());
                string4 = StringUtils.getReplacedString(string4, "<target_value_param_2>", filterSetting.getSecondTargetValue().toString());
            } else {
                string4 = StringUtils.getReplacedString(string4, "<target_value_param_1>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getTargetValue().toString()) + "'");
                string4 = StringUtils.getReplacedString(string4, "<target_value_param_2>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getSecondTargetValue().toString()) + "'");
            }
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("model_param", Model.getCombinedUserNameModelName(string, string2, false));
            if (StringUtils.isNotEmpty(string3)) {
                sQLHelper.opstmt.setStringAtName("partitionId", string3);
            }
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                n = sQLHelper.rs.getInt("TOTAL_PROPENSITIES");
            }
        }
        return n;
    }
}

