/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.HashMap;
import java.util.Map;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingODMType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingsODM;

public final class MiningAlgorithms
extends Enum<MiningAlgorithms> {
    public static final /* enum */ MiningAlgorithms APRIORI = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_APRIORI_ASSOCIATION_RULES"));
    public static final /* enum */ MiningAlgorithms DECISION_TREE = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_DECISION_TREE"));
    public static final /* enum */ MiningAlgorithms EXPECTATION_MAXIMIZATION = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_EXPECTATION_MAXIMIZATION"));
    public static final /* enum */ MiningAlgorithms GENERALIZED_LINEAR_MODEL = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_GENERALIZED_LINEAR_MODEL"));
    public static final /* enum */ MiningAlgorithms KMEANS = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_KMEANS"));
    public static final /* enum */ MiningAlgorithms NAIVE_BAYES = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_NAIVE_BAYES"));
    public static final /* enum */ MiningAlgorithms NON_NEGATIVE_MATRIX_FACTORIZATION = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_NONNEGATIVE_MATRIX_FACTOR"));
    public static final /* enum */ MiningAlgorithms PRINCIPAL_COMPONENT_ANALYSIS = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_PRINCIPAL_COMPONENT_ANALYSIS"));
    public static final /* enum */ MiningAlgorithms SINGULAR_VALUE_DECOMP = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_SINGULAR_VALUE_DECOMP"));
    public static final /* enum */ MiningAlgorithms OCLUSTER = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_O_CLUSTER"));
    public static final /* enum */ MiningAlgorithms SUPPORT_VECTOR_MACHINE = new MiningAlgorithms(ServerConstantsLrb.get("ALGO_SUPPORT_VECTOR_MACHINE"));
    private final String translation;
    private static final Map<String, MiningAlgorithms> stringToEnum;
    private static final /* synthetic */ MiningAlgorithms[] $VALUES;

    public static MiningAlgorithms[] values() {
        return (MiningAlgorithms[])$VALUES.clone();
    }

    public static MiningAlgorithms valueOf(String string) {
        return Enum.valueOf(MiningAlgorithms.class, string);
    }

    private MiningAlgorithms(String string2) {
        this.translation = string2;
    }

    public static MiningAlgorithms fromString(String string) {
        return stringToEnum.get(string);
    }

    public String toString() {
        return this.translation;
    }

    public static String translateFromODMServerAlgorithm(String string, String string2) {
        ModelSettingsODM modelSettingsODM = null;
        if (string2 != null) {
            modelSettingsODM = new ModelSettingsODM();
            ModelSettingODMType modelSettingODMType = new ModelSettingODMType();
            modelSettingODMType.setName("SVDS_SCORING_MODE");
            modelSettingODMType.setValue(string2);
            modelSettingODMType.setType("Default");
            modelSettingsODM.getModelSettingODM().add(modelSettingODMType);
        }
        return MiningAlgorithms.translateFromODMServerAlgorithm(string, modelSettingsODM);
    }

    public static String translateFromODMServerAlgorithm(String string, ModelSettingsODM modelSettingsODM) {
        String string2 = "";
        if (string.compareTo("APRIORI_ASSOCIATION_RULES") == 0) {
            string2 = APRIORI.toString();
        } else if (string.compareTo("DECISION_TREE") == 0) {
            string2 = DECISION_TREE.toString();
        } else if (string.compareTo("EXPECTATION_MAXIMIZATION") == 0) {
            string2 = EXPECTATION_MAXIMIZATION.toString();
        } else if (string.compareTo("GENERALIZED_LINEAR_MODEL") == 0) {
            string2 = GENERALIZED_LINEAR_MODEL.toString();
        } else if (string.compareTo("KMEANS") == 0) {
            string2 = KMEANS.toString();
        } else if (string.compareTo("NAIVE_BAYES") == 0) {
            string2 = NAIVE_BAYES.toString();
        } else if (string.compareTo("O_CLUSTER") == 0) {
            string2 = OCLUSTER.toString();
        } else if (string.compareTo("SUPPORT_VECTOR_MACHINES") == 0) {
            string2 = SUPPORT_VECTOR_MACHINE.toString();
        } else if (string.compareTo("NONNEGATIVE_MATRIX_FACTOR") == 0) {
            string2 = NON_NEGATIVE_MATRIX_FACTORIZATION.toString();
        } else if (string.compareTo("SINGULAR_VALUE_DECOMP") == 0) {
            string2 = SINGULAR_VALUE_DECOMP.toString();
            if (modelSettingsODM != null) {
                for (ModelSettingODMType modelSettingODMType : modelSettingsODM.getModelSettingODM()) {
                    if (modelSettingODMType.getName().compareTo("SVDS_SCORING_MODE") != 0) continue;
                    string2 = modelSettingODMType.getValue().compareTo("SVDS_SCORING_SVD") == 0 ? SINGULAR_VALUE_DECOMP.toString() : PRINCIPAL_COMPONENT_ANALYSIS.toString();
                    break;
                }
            }
        } else {
            string2 = "UNKNOWN:" + string;
        }
        return string2;
    }

    public static MiningAlgorithmType translateToDataMinerServerMiningAlgorithm(MiningAlgorithms miningAlgorithms) {
        MiningAlgorithmType miningAlgorithmType = null;
        switch (miningAlgorithms) {
            case APRIORI: {
                miningAlgorithmType = MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
                break;
            }
            case DECISION_TREE: {
                miningAlgorithmType = MiningAlgorithmType.DECISION_TREE;
                break;
            }
            case EXPECTATION_MAXIMIZATION: {
                miningAlgorithmType = MiningAlgorithmType.EXPECTATION_MAXIMIZATION;
                break;
            }
            case GENERALIZED_LINEAR_MODEL: {
                miningAlgorithmType = MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
                break;
            }
            case KMEANS: {
                miningAlgorithmType = MiningAlgorithmType.KMEANS;
                break;
            }
            case NAIVE_BAYES: {
                miningAlgorithmType = MiningAlgorithmType.NAIVE_BAYES;
                break;
            }
            case NON_NEGATIVE_MATRIX_FACTORIZATION: {
                miningAlgorithmType = MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR;
                break;
            }
            case SINGULAR_VALUE_DECOMP: {
                miningAlgorithmType = MiningAlgorithmType.SINGULAR_VALUE_DECOMP;
                break;
            }
            case OCLUSTER: {
                miningAlgorithmType = MiningAlgorithmType.O_CLUSTER;
                break;
            }
            case SUPPORT_VECTOR_MACHINE: {
                miningAlgorithmType = MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
                break;
            }
            case PRINCIPAL_COMPONENT_ANALYSIS: {
                miningAlgorithmType = MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS;
                break;
            }
            default: {
                assert (false) : "Invalid Algorithm Type";
                break;
            }
        }
        return miningAlgorithmType;
    }

    public static MiningAlgorithms translateFromDataMinerServerMiningAlgorithm(MiningAlgorithmType miningAlgorithmType) {
        MiningAlgorithms miningAlgorithms = null;
        if (miningAlgorithmType == MiningAlgorithmType.APRIORI_ASSOCIATION_RULES) {
            miningAlgorithms = APRIORI;
        } else if (miningAlgorithmType == MiningAlgorithmType.DECISION_TREE) {
            miningAlgorithms = DECISION_TREE;
        } else if (miningAlgorithmType == MiningAlgorithmType.EXPECTATION_MAXIMIZATION) {
            miningAlgorithms = EXPECTATION_MAXIMIZATION;
        } else if (miningAlgorithmType == MiningAlgorithmType.GENERALIZED_LINEAR_MODEL) {
            miningAlgorithms = GENERALIZED_LINEAR_MODEL;
        } else if (miningAlgorithmType == MiningAlgorithmType.KMEANS) {
            miningAlgorithms = KMEANS;
        } else if (miningAlgorithmType == MiningAlgorithmType.NAIVE_BAYES) {
            miningAlgorithms = NAIVE_BAYES;
        } else if (miningAlgorithmType == MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR) {
            miningAlgorithms = NON_NEGATIVE_MATRIX_FACTORIZATION;
        } else if (miningAlgorithmType == MiningAlgorithmType.O_CLUSTER) {
            miningAlgorithms = OCLUSTER;
        } else if (miningAlgorithmType == MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS) {
            miningAlgorithms = PRINCIPAL_COMPONENT_ANALYSIS;
        } else if (miningAlgorithmType == MiningAlgorithmType.SINGULAR_VALUE_DECOMP) {
            miningAlgorithms = SINGULAR_VALUE_DECOMP;
        } else if (miningAlgorithmType == MiningAlgorithmType.SUPPORT_VECTOR_MACHINES) {
            miningAlgorithms = SUPPORT_VECTOR_MACHINE;
        }
        return miningAlgorithms;
    }

    static {
        $VALUES = new MiningAlgorithms[]{APRIORI, DECISION_TREE, EXPECTATION_MAXIMIZATION, GENERALIZED_LINEAR_MODEL, KMEANS, NAIVE_BAYES, NON_NEGATIVE_MATRIX_FACTORIZATION, PRINCIPAL_COMPONENT_ANALYSIS, SINGULAR_VALUE_DECOMP, OCLUSTER, SUPPORT_VECTOR_MACHINE};
        stringToEnum = new HashMap<String, MiningAlgorithms>();
        for (MiningAlgorithms miningAlgorithms : MiningAlgorithms.values()) {
            stringToEnum.put(miningAlgorithms.toString(), miningAlgorithms);
        }
    }
}

