/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OraclePreparedStatement;

public class GlobalDetails {
    private static String _get_model_details_global = "SELECT * FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_GLOBAL(:model_name))";
    private static String _get_model_details_global_partition = "SELECT * FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_GLOBAL(:model_name, :partitionID))";

    public static List<NameValuePair> getModelDetailsGlobal(ConnectionManager connectionManager, String string, String string2, String string3) throws SQLException {
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        String string4 = StringUtils.isNotEmpty(string3) ? _get_model_details_global_partition : _get_model_details_global;
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            if (StringUtils.isNotEmpty(string3)) {
                sQLHelper.opstmt.setStringAtName("partitionID", string3);
            }
            sQLHelper.opstmt.execute();
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string5 = sQLHelper.rs.getString("GLOBAL_DETAIL_NAME");
                Double d = sQLHelper.rs.getDouble("GLOBAL_DETAIL_VALUE");
                NameValuePair nameValuePair = new NameValuePair(string5, d);
                arrayList.add(nameValuePair);
            }
        }
        return arrayList;
    }

    public static interface GLOBAL_DETAIL_CONSTANTS {
        public static final String GLOBAL_DETAIL_NAME = "GLOBAL_DETAIL_NAME";
        public static final String GLOBAL_DETAIL_VALUE = "GLOBAL_DETAIL_VALUE";
    }
}

