/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.Component;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.repository.WorkflowJob;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.runner.RunManagerEvent;
import oracle.dmt.dataminer.runner.RunManagerListener;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;

public class RunItem {
    private static final Logger LOGGER = Logger.getLogger(RunItem.class.getName());
    private static final long POLL_INTERVAL_ACTIVE_VAL = 1500L;
    private static final long POLL_INTERVAL_IDLE_VAL = 30000L;
    private static final long POLL_INTERVAL_DELAYED_VAL = 60000L;
    private static final long FORCED_ACTIVE_DURATION_VAL = 120000L;
    private static final String POLL_INTERVAL_ACTIVE_NAME = "POLLING_ACTIVE_RATE";
    private static final String POLL_INTERVAL_IDLE_NAME = "POLLING_IDLE_RATE";
    private static final String POLLING_INTERVAL_DELAYED_NAME = "POLLING_INTERVAL_DELAYED";
    private static final String POLLING_COMPLETED_WINDOW_OVERRIDE_NAME = "POLLING_COMPLETED_WINDOW";
    private static final String FORCED_ACTIVE_DURATION_NAME = "FORCED_ACTIVE_DURATION";
    private String connectionName;
    private Connection connection;
    private HashMap<BigDecimal, WorkflowJob> jobs;
    private Map<RunManagerListener, ListenerDetail> listeners;
    private Map<RunManagerListener, Object> listenerTokens;
    private Object syncObj;
    private Timer refreshTimer;
    private MonitorMode mode = MonitorMode.ACTIVE;
    private boolean isInitialized;
    private boolean disconnected = false;
    private long forcedActiveTimeout;
    private Map<String, Long> monitorParams;
    private boolean monitorParamsOverriden;
    private boolean monitorParamsFetched;

    RunItem(String string) {
        this.connectionName = string;
        this.jobs = new HashMap();
        this.listeners = new HashMap<RunManagerListener, ListenerDetail>();
        this.listenerTokens = new HashMap<RunManagerListener, Object>();
        this.syncObj = new Object();
        this.init();
    }

    private void init() {
        this.mode = MonitorMode.STOPPED;
        this.connection = null;
        this.refreshTimer = null;
        this.isInitialized = false;
        this.forcedActiveTimeout = 0L;
        this.initMonitorParamsDefaults();
    }

    private void initMonitorParamsDefaults() {
        this.monitorParamsFetched = false;
        this.monitorParamsOverriden = false;
        this.monitorParams = new HashMap<String, Long>();
        this.monitorParams.put(POLL_INTERVAL_ACTIVE_NAME, 1500L);
        this.monitorParams.put(POLL_INTERVAL_IDLE_NAME, 30000L);
        this.monitorParams.put(POLLING_INTERVAL_DELAYED_NAME, 60000L);
        this.monitorParams.put(FORCED_ACTIVE_DURATION_NAME, 120000L);
    }

    public boolean isAdminOverride() {
        return this.monitorParamsOverriden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getListenerCount() {
        Object object = this.syncObj;
        synchronized (object) {
            return this.listeners.size();
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public boolean isAnyJobActive() {
        boolean bl = false;
        Collection<WorkflowJob> collection = this.jobs.values();
        for (WorkflowJob workflowJob : collection) {
            if (!workflowJob.isActive()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isJobRunning(BigDecimal bigDecimal) {
        WorkflowJob workflowJob = this.jobs.get(bigDecimal);
        if (workflowJob == null) {
            return false;
        }
        return !workflowJob.isJobFinished();
    }

    public WorkflowJob getJob(BigDecimal bigDecimal) {
        WorkflowJob workflowJob = this.jobs.get(bigDecimal);
        if (workflowJob == null) {
            return null;
        }
        return workflowJob;
    }

    public static boolean isJobRunning(String string, BigDecimal bigDecimal) throws Exception {
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        RunItem runItem = runManager.getRunItem(string);
        HashMap<BigDecimal, WorkflowJob> hashMap = WorkflowJob.getJobs(RunItem.getConnection(string), runItem.getPollingCompletedWindow());
        WorkflowJob workflowJob = hashMap.get(bigDecimal);
        return !workflowJob.isJobFinished();
    }

    public static WorkflowJob getJob(String string, BigDecimal bigDecimal) throws Exception {
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        RunItem runItem = runManager.getRunItem(string);
        HashMap<BigDecimal, WorkflowJob> hashMap = WorkflowJob.getJobs(RunItem.getConnection(string), runItem.getPollingCompletedWindow());
        WorkflowJob workflowJob = hashMap.get(bigDecimal);
        return workflowJob;
    }

    public boolean isRunning() {
        return !this.isMode(MonitorMode.STOPPED);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setInitialized(boolean bl) {
        this.isInitialized = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initListeners(HashMap<BigDecimal, WorkflowJob> hashMap) {
        Object object = this.syncObj;
        synchronized (object) {
            for (RunManagerListener runManagerListener : this.listeners.keySet()) {
                ListenerDetail listenerDetail = this.listeners.get(runManagerListener);
                if (listenerDetail.isListenerInitialized().booleanValue() || !this.isInitialized()) continue;
                this.initializeListener(listenerDetail, hashMap);
            }
        }
    }

    public void refresh() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        if (!this.monitorParamsFetched) {
            this.initFromRepositorySettings();
        }
        try {
            long l = this.getPollingCompletedWindow();
            HashMap<BigDecimal, WorkflowJob> hashMap = WorkflowJob.getJobs(this.getConnectionInstance(), l);
            this.refreshImpl(hashMap);
            if (!this.isInitialized()) {
                this.setInitialized(true);
            }
            this.initListeners(this.jobs);
        }
        catch (Exception exception) {
            this.disconnected = true;
            final Exception exception2 = exception;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunItem.this.fireConnectionLost(RunItem.this.listeners, exception2);
                }
            });
            throw exception;
        }
    }

    private void refreshImpl(HashMap<BigDecimal, WorkflowJob> hashMap) {
        WorkflowJob workflowJob;
        WorkflowJob workflowJob2;
        if (!this.isRunning()) {
            return;
        }
        if (this.disconnected) {
            this.disconnected = false;
            this.fireConnectionReestablished(this.listeners);
        }
        for (Map.Entry<BigDecimal, WorkflowJob> entry : hashMap.entrySet()) {
            workflowJob2 = entry.getValue();
            workflowJob = this.jobs.get(workflowJob2.getWorkflowId());
            if (workflowJob == null) {
                this.jobs.put(workflowJob2.getWorkflowId(), workflowJob2);
                if (ConfigUtils.isDebugBuild()) {
                    LOGGER.log(Level.FINEST, "RunItem: Added new job: " + workflowJob2.getWorkflowId());
                }
                this.fireJobAdded(workflowJob2, this.listeners);
                if (!workflowJob2.isJobFinished() || !this.isInitialized()) continue;
                if (ConfigUtils.isDebugBuild()) {
                    LOGGER.log(Level.FINEST, "RunItem: Job finished (new): " + workflowJob2.getWorkflowId());
                }
                this.fireJobFinished(workflowJob2, this.listeners);
                continue;
            }
            if (workflowJob.equalsStateOf(workflowJob2)) continue;
            this.jobs.remove(workflowJob.getWorkflowId());
            this.jobs.put(workflowJob2.getWorkflowId(), workflowJob2);
            if (workflowJob2.isJobFinished()) {
                if (ConfigUtils.isDebugBuild()) {
                    LOGGER.log(Level.INFO, "RunItem: Job finished: " + workflowJob2.getWorkflowId());
                }
                this.fireJobFinished(workflowJob2, this.listeners);
                continue;
            }
            if (ConfigUtils.isDebugBuild()) {
                LOGGER.log(Level.FINEST, "RunItem: Job changed: " + workflowJob2.getWorkflowId());
            }
            this.fireJobChanged(workflowJob2, this.listeners);
        }
        Iterator<Map.Entry<BigDecimal, WorkflowJob>> iterator = this.jobs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BigDecimal, WorkflowJob> entry;
            entry = iterator.next();
            workflowJob2 = entry.getValue();
            workflowJob = hashMap.get(workflowJob2.getWorkflowId());
            if (workflowJob != null) continue;
            iterator.remove();
            this.fireJobRemoved(workflowJob2, this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateListenerToken(ListenerDetail listenerDetail) {
        boolean bl = false;
        Object object = this.syncObj;
        synchronized (object) {
            Object object2 = this.listenerTokens.get(listenerDetail.getListener());
            if (object2 != null && object2 == listenerDetail.getListenerToken()) {
                bl = true;
            }
        }
        return bl;
    }

    private void fireConnectionLost(final Map<RunManagerListener, ListenerDetail> map, final Exception exception) {
        final RunManagerEvent runManagerEvent = new RunManagerEvent(this, null);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = RunItem.this.syncObj;
                synchronized (object) {
                    Iterator iterator = map.entrySet().iterator();
                    runManagerEvent.setExceptionInfo(exception);
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        ListenerDetail listenerDetail = (ListenerDetail)entry.getValue();
                        RunManagerListener runManagerListener = listenerDetail.getListener();
                        if (!RunItem.this.validateListenerToken(listenerDetail)) continue;
                        runManagerListener.connectionLost(runManagerEvent);
                    }
                }
            }
        });
    }

    private void fireConnectionReestablished(final Map<RunManagerListener, ListenerDetail> map) {
        final RunManagerEvent runManagerEvent = new RunManagerEvent(this, null);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = RunItem.this.syncObj;
                synchronized (object) {
                    for (Map.Entry entry : map.entrySet()) {
                        ListenerDetail listenerDetail = (ListenerDetail)entry.getValue();
                        RunManagerListener runManagerListener = listenerDetail.getListener();
                        if (!RunItem.this.validateListenerToken(listenerDetail)) continue;
                        runManagerListener.connectionReestablished(runManagerEvent);
                    }
                }
            }
        });
    }

    private void fireJobAdded(final WorkflowJob workflowJob, final Map<RunManagerListener, ListenerDetail> map) {
        final RunManagerEvent runManagerEvent = new RunManagerEvent(this, workflowJob);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = RunItem.this.syncObj;
                synchronized (object) {
                    HashMap hashMap = new HashMap(map);
                    Collection collection = hashMap.values();
                    for (ListenerDetail listenerDetail : collection) {
                        BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                        RunManagerListener runManagerListener = listenerDetail.getListener();
                        if (!RunItem.this.validateListenerToken(listenerDetail)) continue;
                        if (bigDecimal == null) {
                            runManagerListener.jobAdded(runManagerEvent);
                            continue;
                        }
                        if (!bigDecimal.equals(workflowJob.getWorkflowId())) continue;
                        runManagerListener.jobAdded(runManagerEvent);
                    }
                }
            }
        });
    }

    private void fireJobFinished(final WorkflowJob workflowJob, final Map<RunManagerListener, ListenerDetail> map) {
        try {
            this.updateWorkflowNodeRepositoryData(workflowJob);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            return;
        }
        final RunManagerEvent runManagerEvent = new RunManagerEvent(this, workflowJob);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = RunItem.this.syncObj;
                synchronized (object) {
                    HashMap hashMap = new HashMap(map);
                    ArrayList<ListenerDetail> arrayList = new ArrayList<ListenerDetail>();
                    Collection collection = hashMap.values();
                    for (ListenerDetail listenerDetail : collection) {
                        if (listenerDetail.getListener() instanceof WorkflowEditor) {
                            arrayList.add(0, listenerDetail);
                            continue;
                        }
                        arrayList.add(listenerDetail);
                    }
                    for (ListenerDetail listenerDetail : arrayList) {
                        BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                        RunManagerListener runManagerListener = listenerDetail.getListener();
                        if (!RunItem.this.validateListenerToken(listenerDetail) || bigDecimal != null && (bigDecimal == null || !bigDecimal.equals(workflowJob.getWorkflowId()))) continue;
                        runManagerListener.jobFinished(runManagerEvent);
                    }
                }
            }
        });
    }

    private void updateWorkflowNodeRepositoryData(WorkflowJob workflowJob) throws Exception {
        Object object2;
        HashMap<URL, WorkflowNode> hashMap = new HashMap<URL, WorkflowNode>();
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Object object2 : list) {
            URL uRL;
            WorkflowNode workflowNode;
            URL uRL2;
            String string;
            Node node = object2.getContext().getNode();
            if (!(node instanceof DataMinerNode) || !(string = DMURLFormatHelper.getConnectionName(uRL2 = node.getURL())).equals(this.connectionName) || (workflowNode = (WorkflowNode)NodeFactory.find((URL)(uRL = DMURLFormatHelper.getWorkflowURL(uRL2)))) == null) continue;
            Workflow workflow = (Workflow)workflowNode.getRepositoryData();
            if (!workflowJob.getWorkflowId().equals(workflow.getId())) continue;
            hashMap.put(uRL, workflowNode);
        }
        Collection collection = hashMap.values();
        if (collection.size() == 0) {
            return;
        }
        if (collection.size() > 1) {
            throw new RuntimeException("Unexpected state: update repository cache detected multiple workflows");
        }
        object2 = (WorkflowNode)collection.iterator().next();
        ((WorkflowNode)object2).reloadRepositoryData();
    }

    private void fireJobChanged(final WorkflowJob workflowJob, final Map<RunManagerListener, ListenerDetail> map) {
        final RunManagerEvent runManagerEvent = new RunManagerEvent(this, workflowJob);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = RunItem.this.syncObj;
                synchronized (object) {
                    HashMap hashMap = new HashMap(map);
                    for (Map.Entry entry : hashMap.entrySet()) {
                        ListenerDetail listenerDetail = (ListenerDetail)entry.getValue();
                        BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                        RunManagerListener runManagerListener = listenerDetail.getListener();
                        if (!RunItem.this.validateListenerToken(listenerDetail)) continue;
                        if (bigDecimal == null) {
                            runManagerListener.jobChanged(runManagerEvent);
                            continue;
                        }
                        if (!bigDecimal.equals(workflowJob.getWorkflowId())) continue;
                        runManagerListener.jobChanged(runManagerEvent);
                    }
                }
            }
        });
    }

    private void fireJobRemoved(final WorkflowJob workflowJob, final Map<RunManagerListener, ListenerDetail> map) {
        final RunManagerEvent runManagerEvent = new RunManagerEvent(this, workflowJob);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = RunItem.this.syncObj;
                synchronized (object) {
                    HashMap hashMap = new HashMap(map);
                    for (Map.Entry entry : hashMap.entrySet()) {
                        ListenerDetail listenerDetail = (ListenerDetail)entry.getValue();
                        BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                        RunManagerListener runManagerListener = listenerDetail.getListener();
                        if (!RunItem.this.validateListenerToken(listenerDetail)) continue;
                        if (bigDecimal == null) {
                            runManagerListener.jobRemoved(runManagerEvent);
                            continue;
                        }
                        if (!bigDecimal.equals(workflowJob.getWorkflowId())) continue;
                        runManagerListener.jobRemoved(runManagerEvent);
                    }
                }
            }
        });
    }

    private Connection getConnectionInstance() throws DBException, SQLException, RunManager.UnmonitorableConnectionException, ConnectionException {
        if (this.connection != null) {
            return this.connection;
        }
        this.connection = RunItem.getConnection(this.connectionName);
        return this.connection;
    }

    private static Connection getConnection(String string) throws SQLException, RunManager.UnmonitorableConnectionException, ConnectionException {
        Connection connection = null;
        if (!ConfigUtils.isValidUserConnection(string).booleanValue()) {
            throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_PRIVILEGED"));
        }
        Properties properties = DatabaseConnections.getInstance().getProperties(string);
        Properties properties2 = (Properties)properties.clone();
        DatabaseProvider databaseProvider = new DatabaseProvider(properties2);
        databaseProvider.setProperty("SQLDEV_PROMPT_KEY", "ODMR_PWD_PROMPT");
        Connection connection2 = null;
        boolean bl = false;
        while (!bl) {
            try {
                connection2 = databaseProvider.getConnection();
                break;
            }
            catch (ConnectionCanceledException connectionCanceledException) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_NOT_AUTH"));
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 1017) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RunManagerLrb.get("CONNECT_FAIL") + sQLException.getMessage()), (String)RunManagerLrb.get("CONNECT_FAIL_TITLE"), null);
                    if (properties2.getProperty("SavePassword").equalsIgnoreCase("true")) {
                        throw sQLException;
                    }
                } else {
                    if (sQLException.getErrorCode() == 28000) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RunManagerLrb.get("CONNECT_FAIL") + sQLException.getMessage()), (String)RunManagerLrb.get("CONNECT_FAIL_TITLE"), null);
                        throw sQLException;
                    }
                    throw sQLException;
                }
                Properties properties3 = (Properties)properties.clone();
                properties3.remove("password");
                databaseProvider = new DatabaseProvider(properties3);
                DatabaseProviderHelper.PasswordPrompter passwordPrompter = DatabaseProviderHelper.getPasswordPrompter();
                passwordPrompter.disconnect(properties3);
            }
        }
        try {
            if (!ConfigUtils.isValidUserConnection(string).booleanValue()) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_PRIVILEGED"));
            }
            if (!ConfigUtils.isODMRSYSLoaded(connection2)) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_LACKS_REPOS"));
            }
            if (!ConfigUtils.isODMPrivsPresent(connection2)) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_LACKS_PRIVS"));
            }
            connection = connection2;
        }
        catch (Exception exception) {
            SQLHelper.close(connection2);
            throw exception;
        }
        return connection;
    }

    public synchronized void close() {
        this.stopMonitor();
    }

    public boolean addListener(RunManagerListener runManagerListener) {
        return this.addListener(runManagerListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(RunManagerListener runManagerListener, BigDecimal bigDecimal) {
        Object object = this.syncObj;
        synchronized (object) {
            ListenerDetail listenerDetail = this.listeners.get(runManagerListener);
            if (listenerDetail != null && this.validateListenerToken(listenerDetail)) {
                return false;
            }
            if (this.listeners.size() == 0 || !this.isRunning()) {
                this.setMode(MonitorMode.ACTIVE);
            }
            ListenerDetail listenerDetail2 = new ListenerDetail(runManagerListener, bigDecimal);
            this.listenerTokens.put(runManagerListener, listenerDetail2.getListenerToken());
            this.listeners.put(runManagerListener, listenerDetail2);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(RunManagerListener runManagerListener) {
        Object object = this.syncObj;
        synchronized (object) {
            ListenerDetail listenerDetail = this.listeners.remove(runManagerListener);
            this.listenerTokens.remove(listenerDetail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunManagerListener getListener(RunManagerListener runManagerListener) {
        Object object = this.syncObj;
        synchronized (object) {
            ListenerDetail listenerDetail = this.listeners.get(runManagerListener);
            if (listenerDetail != null) {
                return listenerDetail.getListener();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeListener(final ListenerDetail listenerDetail, HashMap<BigDecimal, WorkflowJob> hashMap) {
        Object object = this.syncObj;
        synchronized (object) {
            if (!this.isRunning()) {
                return;
            }
            listenerDetail.setListenerInitialized();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    listenerDetail.getListener().jobsListenerInitialized();
                }
            });
            try {
                final HashMap<RunManagerListener, ListenerDetail> hashMap2 = new HashMap<RunManagerListener, ListenerDetail>();
                hashMap2.put(listenerDetail.getListener(), listenerDetail);
                for (Map.Entry<BigDecimal, WorkflowJob> entry : hashMap.entrySet()) {
                    final WorkflowJob workflowJob = entry.getValue();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RunItem.this.fireJobAdded(workflowJob, hashMap2);
                        }
                    });
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    private long getPollingInterval() {
        if (this.isMode(MonitorMode.ACTIVE)) {
            return this.monitorParams.get(POLL_INTERVAL_ACTIVE_NAME);
        }
        if (this.isMode(MonitorMode.IDLE)) {
            return this.monitorParams.get(POLL_INTERVAL_IDLE_NAME);
        }
        if (this.isMode(MonitorMode.DELAYED)) {
            return this.monitorParams.get(POLLING_INTERVAL_DELAYED_NAME);
        }
        throw new IllegalStateException("Invalid monitor mode, expected ACTIVE, IDLE, or DELAYED");
    }

    void scheduleMonitor() {
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
            this.refreshTimer = null;
        }
        this.refreshTimer = new Timer("RunManagerTimer:" + this.connectionName, true);
        this.refreshTimer.schedule((TimerTask)new RunTimerTask(), 0L, this.getPollingInterval());
        LOGGER.log(Level.FINEST, "workflowMonitor: scheduleMonitor() - polling mode: " + (Object)((Object)this.getMode()) + " delay: " + this.getPollingInterval());
    }

    public void forceActive() {
        LOGGER.log(Level.FINEST, "workflowMonitor: Forcing to ACTIVE");
        long l = this.monitorParams.get(FORCED_ACTIVE_DURATION_NAME);
        this.forcedActiveTimeout = Calendar.getInstance().getTimeInMillis() + l;
        this.setMode(MonitorMode.ACTIVE);
    }

    private boolean isForcedActiveExpired() {
        if (this.forcedActiveTimeout == 0L) {
            return true;
        }
        long l = Calendar.getInstance().getTimeInMillis();
        return this.forcedActiveTimeout < l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMonitor() {
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
        if (this.connection != null) {
            Connection connection = this.connection;
            synchronized (connection) {
                SQLHelper.close(this.connection);
            }
        }
        this.init();
        LOGGER.log(Level.FINEST, "workflowMonitor: stopMonitor()");
    }

    private void setMode(MonitorMode monitorMode) {
        if (this.mode == monitorMode) {
            return;
        }
        LOGGER.log(Level.FINEST, "workflowMonitor: setMode (" + (Object)((Object)monitorMode) + ")");
        if ((monitorMode == MonitorMode.IDLE || monitorMode == MonitorMode.DELAYED) && this.forcedActiveTimeout != 0L) {
            this.forcedActiveTimeout = 0L;
        }
        this.mode = monitorMode;
        if (monitorMode == MonitorMode.STOPPED) {
            this.stopMonitor();
            return;
        }
        this.scheduleMonitor();
    }

    private boolean isMode(MonitorMode monitorMode) {
        return this.getMode() == monitorMode;
    }

    private MonitorMode getMode() {
        return this.mode;
    }

    private void initFromRepositorySettings() {
        SQLHelper sQLHelper = new SQLHelper();
        String string = "SELECT PROPERTY_NAME, PROPERTY_NUM_VALUE FROM ODMR_REPOSITORY_PROPERTIES WHERE PROPERTY_NAME = 'POLLING_IDLE_RATE' or PROPERTY_NAME = 'POLLING_ACTIVE_RATE' or PROPERTY_NAME = 'POLLING_COMPLETED_WINDOW'";
        sQLHelper = new SQLHelper();
        try {
            String string2 = null;
            long l = 0L;
            sQLHelper.pstmt = this.getConnectionInstance().prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                string2 = sQLHelper.rs.getString("PROPERTY_NAME");
                l = sQLHelper.rs.getLong("PROPERTY_NUM_VALUE");
                if (l == 0L) continue;
                this.monitorParams.put(string2, l);
                if (!string2.equals(POLLING_COMPLETED_WINDOW_OVERRIDE_NAME)) continue;
                this.monitorParamsOverriden = true;
            }
            this.monitorParamsFetched = true;
            sQLHelper.close();
        }
        catch (Exception exception) {
            sQLHelper.close();
            LOGGER.log(Level.SEVERE, "RunItem: unable to read repository config table.", exception);
        }
    }

    public long getPollingCompletedWindow() {
        Long l = this.monitorParams.get(POLLING_COMPLETED_WINDOW_OVERRIDE_NAME);
        if (l != null) {
            return l;
        }
        return RunManager.getUserMaxJobAgePreference();
    }

    private static class ListenerDetail {
        private RunManagerListener listener;
        private BigDecimal workflowId;
        private Object listenerToken;
        private Boolean listenerInitialized;

        ListenerDetail(RunManagerListener runManagerListener, BigDecimal bigDecimal) {
            this.listener = runManagerListener;
            this.workflowId = bigDecimal;
            this.listenerToken = new Object();
            this.listenerInitialized = false;
        }

        public RunManagerListener getListener() {
            return this.listener;
        }

        public BigDecimal getWorkflowId() {
            return this.workflowId;
        }

        public Object getListenerToken() {
            return this.listenerToken;
        }

        public void setListenerInitialized() {
            this.listenerInitialized = true;
        }

        public Boolean isListenerInitialized() {
            return this.listenerInitialized;
        }
    }

    class RunTimerTask
    extends TimerTask {
        RunTimerTask() {
        }

        @Override
        public void run() {
            if (!RunItem.this.isRunning()) {
                return;
            }
            if (RunItem.this.listeners.size() != 0) {
                try {
                    RunItem.this.refresh();
                    if (RunItem.this.isMode(MonitorMode.ACTIVE) && !RunItem.this.isAnyJobActive()) {
                        if (RunItem.this.isForcedActiveExpired()) {
                            RunItem.this.setMode(MonitorMode.IDLE);
                        } else {
                            LOGGER.log(Level.FINEST, "workflowMonitor: Staying ACTIVE until timeout");
                        }
                    } else if (RunItem.this.isMode(MonitorMode.IDLE) && RunItem.this.isAnyJobActive()) {
                        RunItem.this.setMode(MonitorMode.ACTIVE);
                    } else if (RunItem.this.isMode(MonitorMode.DELAYED)) {
                        RunItem.this.setMode(MonitorMode.ACTIVE);
                    }
                    LOGGER.log(Level.FINEST, "workflowMonitor: Refreshed (mode: " + (Object)((Object)RunItem.this.getMode()) + " delay: " + RunItem.this.getPollingInterval());
                }
                catch (RunManager.UnmonitorableConnectionException unmonitorableConnectionException) {
                    RunItem.this.stopMonitor();
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 1035) {
                        LOGGER.log(Level.FINEST, "temporarily restricted connections due to repository installation", sQLException);
                        RunItem.this.stopMonitor();
                    } else if (sQLException.getErrorCode() == 1017) {
                        LOGGER.log(Level.FINEST, "logon denied", sQLException);
                        RunItem.this.stopMonitor();
                    } else if (sQLException.getErrorCode() == 28000) {
                        LOGGER.log(Level.FINEST, "account locked", sQLException);
                        RunItem.this.stopMonitor();
                    } else {
                        RunItem.this.stopMonitor();
                        RunItem.this.setMode(MonitorMode.DELAYED);
                    }
                }
                catch (Exception exception) {
                    RunItem.this.setMode(MonitorMode.DELAYED);
                }
            }
        }
    }

    private static enum MonitorMode {
        IDLE,
        ACTIVE,
        DELAYED,
        STOPPED;

    }
}

