/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import oracle.dmt.dataminer.partition.PartitionColumn;
import oracle.dmt.dataminer.partition.PartitionsLrb;

public class Rule {
    private PartitionColumn partitionKey;
    private OPERATORS operator;
    private String value;

    public Rule(PartitionColumn partitionColumn, OPERATORS oPERATORS, String string) {
        this.partitionKey = partitionColumn;
        this.operator = oPERATORS;
        this.value = string;
    }

    public void setPartitionKey(PartitionColumn partitionColumn) {
        this.partitionKey = partitionColumn;
    }

    public PartitionColumn getPartitionKey() {
        return this.partitionKey;
    }

    public void setOperator(OPERATORS oPERATORS) {
        this.operator = oPERATORS;
    }

    public OPERATORS getOperator() {
        return this.operator;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public static Rule createEmptyRule() {
        return new Rule(null, OPERATORS.EMPTY, "");
    }

    public boolean isComplete() {
        return this.partitionKey != null && this.operator != OPERATORS.EMPTY && this.value != null && !"".equals(this.value);
    }

    public boolean isEmpty() {
        return this.partitionKey == null && this.operator == OPERATORS.EMPTY && (this.value == null || "".equals(this.value));
    }

    public static void addOperatorSQL(StringBuilder stringBuilder, OPERATORS oPERATORS) {
        switch (oPERATORS) {
            case IS: {
                stringBuilder.append("= ?");
                break;
            }
            case GREATER_THAN: {
                stringBuilder.append("> ?");
                break;
            }
            case LESS_THAN: {
                stringBuilder.append("< ?");
                break;
            }
            case IS_NOT: {
                stringBuilder.append("!= ?");
                break;
            }
            case CONTAINS: 
            case STARTS: 
            case ENDS: {
                stringBuilder.append("LIKE ?");
                break;
            }
            case NOT_CONTAINS: 
            case NOT_START: 
            case NOT_END: {
                stringBuilder.append("NOT LIKE ?");
                break;
            }
            default: {
                assert (false) : "Not a valid operator";
                break;
            }
        }
    }

    public static enum OPERATORS {
        EMPTY("", true, true),
        IS(PartitionsLrb.get("FILTER_OPERATOR_IS"), true, true),
        GREATER_THAN(PartitionsLrb.get("FILTER_OPERATOR_GT"), false, true),
        LESS_THAN(PartitionsLrb.get("FILTER_OPERATOR_LT"), false, true),
        IS_NOT(PartitionsLrb.get("FILTER_OPERATOR_ISNOT"), true, false),
        CONTAINS(PartitionsLrb.get("FILTER_OPERATOR_CONTAINS"), true, false),
        NOT_CONTAINS(PartitionsLrb.get("FILTER_OPERATOR_NOT_CONTAINS"), true, false),
        STARTS(PartitionsLrb.get("FILTER_OPERATOR_STARTS"), true, false),
        NOT_START(PartitionsLrb.get("FILTER_OPERATOR_NOT_STARTS"), true, false),
        ENDS(PartitionsLrb.get("FILTER_OPERATOR_END"), true, false),
        NOT_END(PartitionsLrb.get("FILTER_OPERATOR_NOT_END"), true, false);

        private String label;
        private boolean stringOperator;
        private boolean numberOperator;

        private OPERATORS(String string2, boolean bl, boolean bl2) {
            this.label = string2;
            this.stringOperator = bl;
            this.numberOperator = bl2;
        }

        public String toString() {
            return this.label;
        }

        public boolean isStringOperator() {
            return this.stringOperator;
        }

        public boolean isNumberOperator() {
            return this.numberOperator;
        }
    }
}

