/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.partition.ModelPartitionChooserPanel;
import oracle.dmt.dataminer.partition.PartitionColumn;
import oracle.dmt.dataminer.partition.PartitionDetailsPanel;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.ui.HyperlinkButton;

public abstract class AbstractPartitionToolbar<T extends AbstractPartitionToolbar>
extends JPanel
implements DataminerGUIPanel {
    private static final int MAX_PARTITION_LINK_WIDTH = 400;
    private VirtualInstance<T> instance;
    protected BaseTreeNode node;
    protected Context context;
    protected HyperlinkButton partitionLink;
    protected int componentsWidth = -1;

    public AbstractPartitionToolbar() {
        this.instance = new VirtualInstance(null, null, null);
    }

    protected AbstractPartitionToolbar(VirtualInstance<T> virtualInstance) {
        this.instance = virtualInstance;
    }

    public void setEditor(Editor editor) {
        Node node = editor.getContext().getNode();
        assert (node instanceof BaseTreeNode);
        this.node = (BaseTreeNode)node;
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("EDITOR_STATE".equals(propertyChangeEvent.getPropertyName()) && "CLOSED".equals(propertyChangeEvent.getNewValue())) {
                    AbstractPartitionToolbar.this.getVirtualInstance().getRelatedToolbars().remove(AbstractPartitionToolbar.this);
                }
            }
        });
        this.context = editor.getContext();
    }

    public void updatePartitionHyperlink() {
        PartitionVO partitionVO = this.instance.getPartition();
        String string = partitionVO == null ? CommonLrb.get("COMMON_NONE") : partitionVO.getPartitionName();
        this.partitionLink.setEnabled(partitionVO != null);
        this.partitionLink.setText(string);
        this.partitionLink.setToolTipText(string);
        Font font = this.partitionLink.getFont();
        FontMetrics fontMetrics = this.partitionLink.getFontMetrics(font);
        int n = fontMetrics.stringWidth(string);
        Dimension dimension = this.partitionLink.getSize();
        dimension.width = n = Math.min(n, 400);
        dimension.height = 25;
        this.partitionLink.setPreferredSize(dimension);
        int n2 = 400 + this.getComponentsWidth();
        int n3 = n + this.getComponentsWidth() + 20;
        int n4 = Math.min(n3, n2);
        Dimension dimension2 = new Dimension(n4, 30);
        this.setPreferredSize(dimension2);
    }

    protected abstract int getComponentsWidth();

    public String getSelectedPartitionID() {
        PartitionVO partitionVO = this.instance.getPartition();
        return partitionVO == null ? null : partitionVO.getPartitionID();
    }

    public String getSelectedPartitionName() {
        PartitionVO partitionVO = this.instance.getPartition();
        return partitionVO == null ? null : partitionVO.getPartitionName();
    }

    public String getModelName() {
        return this.instance.models[0];
    }

    protected VirtualInstance<T> getVirtualInstance() {
        return this.instance;
    }

    protected void setVirtualInstance(VirtualInstance<T> virtualInstance) {
        this.instance = virtualInstance;
    }

    protected void displayPartitionDetails() {
        LoadPartitionDetails loadPartitionDetails = new LoadPartitionDetails();
        loadPartitionDetails.execute();
    }

    protected void displayPartitionFilterDialog(Context context, String[] stringArray) {
        PartitionVO partitionVO;
        ModelPartitionChooserPanel modelPartitionChooserPanel = new ModelPartitionChooserPanel(context, stringArray);
        if (modelPartitionChooserPanel.showAsDialog(this) && !(partitionVO = modelPartitionChooserPanel.getSelectedPartition()).equals(this.instance.getPartition())) {
            this.instance.setPartition(partitionVO);
        }
    }

    public class LoadPartitionDetails
    extends ODMrSwingWorker<PartitionVO, Void> {
        private static final String QUERY_PARTITION = "WITH model_partitions as\n   (SELECT DISTINCT mp.partition_name, mp.position, mp.column_name, ma.data_type,\n           NVL(column_value, '(null)') AS column_value\n           FROM all_mining_model_partitions mp, all_mining_model_attributes ma\n           WHERE mp.model_name = ? AND mp.partition_name = ?\n           AND mp.model_name  = ma.model_name\n           AND mp.column_name = ma.attribute_name)\nSELECT \n  partition_name,\n  LISTAGG(column_name , ',') WITHIN GROUP(ORDER BY partition_name, position) as part_cols,\n  LISTAGG(data_type   , ',') WITHIN GROUP(ORDER BY partition_name, position) as part_types,\n  LISTAGG(column_value, '_') WITHIN GROUP(ORDER BY partition_name, position) as part_values\nFROM model_partitions\nGROUP BY partition_name";

        private LoadPartitionDetails() {
            super(AbstractPartitionToolbar.this);
            AbstractPartitionToolbar.this.partitionLink.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected PartitionVO doInBackground() throws Exception {
            PartitionVO partitionVO = AbstractPartitionToolbar.this.instance.getPartition();
            if (partitionVO.getColumns().size() == 0) {
                try (SQLHelper sQLHelper = new SQLHelper();){
                    sQLHelper.conn = ConnectionFolder.getConnection(AbstractPartitionToolbar.this.context);
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement(QUERY_PARTITION);
                    sQLHelper.pstmt.setString(1, AbstractPartitionToolbar.this.getModelName());
                    sQLHelper.pstmt.setString(2, partitionVO.getPartitionID());
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    if (sQLHelper.rs.next()) {
                        String string = sQLHelper.rs.getString("PART_VALUES");
                        String[] stringArray = sQLHelper.rs.getString("PART_COLS").split(",");
                        String[] stringArray2 = sQLHelper.rs.getString("PART_TYPES").split(",");
                        ArrayList<PartitionColumn> arrayList = new ArrayList<PartitionColumn>();
                        String[] stringArray3 = string.split("_");
                        for (int i = 0; i < stringArray3.length; ++i) {
                            PartitionColumn partitionColumn = new PartitionColumn(stringArray[i], stringArray2[i], stringArray3[i]);
                            arrayList.add(partitionColumn);
                        }
                        partitionVO.setColumns(arrayList);
                    }
                }
            }
            return partitionVO;
        }

        @Override
        protected void onSuccess(PartitionVO partitionVO) throws Exception {
            PartitionDetailsPanel partitionDetailsPanel = new PartitionDetailsPanel(partitionVO);
            partitionDetailsPanel.showAsTooltipDialog((JComponent)AbstractPartitionToolbar.this.partitionLink);
        }

        @Override
        protected void onFinally() {
            AbstractPartitionToolbar.this.partitionLink.setEnabled(true);
        }
    }

    public class SearchPartitionActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractPartitionToolbar.this.displayPartitionFilterDialog(AbstractPartitionToolbar.this.context, AbstractPartitionToolbar.this.getVirtualInstance().getModels());
        }
    }

    public class PartitionDetailsActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            assert (actionEvent.getSource() instanceof HyperlinkButton);
            HyperlinkButton hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
            if (hyperlinkButton.isEnabled() && !CommonLrb.get("COMMON_NONE").equals(hyperlinkButton.getText())) {
                AbstractPartitionToolbar.this.displayPartitionDetails();
            }
        }
    }

    public static class VirtualInstance<T extends AbstractPartitionToolbar> {
        protected String[] models;
        protected PartitionVO partition;
        protected List<T> relatedToolbars;
        protected BaseTreeNode node;

        public VirtualInstance(String[] stringArray, PartitionVO partitionVO, BaseTreeNode baseTreeNode) {
            this.models = stringArray != null ? Arrays.copyOf(stringArray, stringArray.length) : null;
            this.partition = partitionVO;
            this.node = baseTreeNode;
            this.relatedToolbars = new LinkedList<T>();
        }

        public void setPartition(PartitionVO partitionVO) {
            if (this.partition == partitionVO) {
                return;
            }
            this.partition = partitionVO;
            for (AbstractPartitionToolbar abstractPartitionToolbar : this.getRelatedToolbars()) {
                abstractPartitionToolbar.updatePartitionHyperlink();
            }
            if (this.node != null) {
                UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, (Object)this.node);
                this.node.notifyObservers(this.node, updateMessage);
            }
        }

        public PartitionVO getPartition() {
            return this.partition;
        }

        public String getModelName() {
            return this.models[0];
        }

        public void setModelName(String string) {
            this.models = new String[1];
            this.models[0] = string;
        }

        public String[] getModels() {
            return Arrays.copyOf(this.models, this.models.length);
        }

        public void setModels(String[] stringArray) {
            this.models = Arrays.copyOf(stringArray, stringArray.length);
        }

        public BaseTreeNode getNode() {
            return this.node;
        }

        public void setNode(BaseTreeNode baseTreeNode) {
            this.node = baseTreeNode;
        }

        public List<T> getRelatedToolbars() {
            return this.relatedToolbars;
        }
    }
}

