/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.utils.ConnectionProperties;
import oracle.dmt.dataminer.wizard.project.ProjectModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Context;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class RenameNodePanel
extends DialogDisplayer<AbstractNode> {
    private boolean _isProject;
    private boolean _isWorkflow;
    private String _currentName;
    private Context _context;
    private JLabel _jRenameLabel;
    private JTextField _jRenameValue;

    public RenameNodePanel(Context context, boolean bl, boolean bl2, String string) {
        this._context = context;
        this._isProject = bl;
        this._isWorkflow = bl2;
        this._currentName = string;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jRenameLabel = new JLabel();
        this._jRenameValue = new JTextField();
        this._jRenameLabel.setText("Rename To:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jRenameLabel, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jRenameValue, -1, 291, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jRenameLabel).addComponent(this._jRenameValue, -2, -1, -2)).addContainerGap(33, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jRenameLabel, (Component)this._jRenameValue, (String)DataminerNavigatorLrb.get("RENAME_TO_LABEL"));
        this._jRenameLabel.getAccessibleContext().setAccessibleDescription(DataminerNavigatorLrb.get("RENAME_TO_LABEL_ADA"));
        if (this._isProject) {
            this._jRenameValue.setDocument(new TextFieldLimit(30));
        } else if (this._isWorkflow) {
            this._jRenameValue.setDocument(new TextFieldLimit(30));
        }
    }

    @Override
    public void initUI() {
        this._jRenameValue.setText(this._currentName);
    }

    @Override
    public boolean doWork() {
        boolean bl = false;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        try {
            if (this._isProject) {
                if (!this._currentName.equals(this._jRenameValue.getText())) {
                    String string = this._jRenameValue.getText();
                    if (!ProjectModel.validateProjectName(connectionFolder, string = string.trim())) {
                        bl = false;
                        return bl;
                    }
                    ProjectFolder projectFolder = (ProjectFolder)this._context.getNode();
                    WorkflowProject workflowProject = (WorkflowProject)projectFolder.getRepositoryData();
                    workflowProject.rename(connectionFolder, string);
                    BaseTreeNode baseTreeNode = (BaseTreeNode)projectFolder.getParent().getData();
                    String string2 = baseTreeNode.getURL().getPath() + "/" + string;
                    URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)string2);
                    projectFolder.rename(uRL);
                    bl = true;
                } else {
                    bl = false;
                    MessageDialog.error((Component)this.getParentWindow(), (Object)DataminerNavigatorLrb.get("RENAME_PROJECT_NAME_NOT_CHANGED"), (String)DataminerNavigatorLrb.get("RENAME_PROJECT_ERROR_NAME"), null);
                }
            } else if (this._isWorkflow) {
                if (!this._currentName.equals(this._jRenameValue.getText())) {
                    Object object;
                    String string = this._jRenameValue.getText();
                    if (!Workflow.validateWorkflowName(connectionFolder, string = string.trim(), this._context)) {
                        bl = false;
                        return bl;
                    }
                    WorkflowNode workflowNode = (WorkflowNode)this._context.getNode();
                    Workflow workflow = (Workflow)workflowNode.getRepositoryData();
                    if (workflowNode.getSessionConnection() == null) {
                        object = ConnectionFolder.getConnection(this._context, ConnectionProperties.UNIQUE);
                        workflowNode.setSessionConnection((Connection)object);
                    }
                    if (workflow.isReadOnly()) {
                        bl = false;
                        MessageDialog.error((Component)this.getParentWindow(), (Object)DataminerNavigatorLrb.get("RENAME_WORKFLOW_READ_ONLY"), (String)DataminerNavigatorLrb.get("RENAME_WORKFLOW_ERROR_NAME"), null);
                        return bl;
                    }
                    workflow.rename(workflowNode.getSessionConnection(), string, workflow.isLoaded() ? "W" : "R");
                    object = (BaseTreeNode)workflowNode.getParent().getData();
                    String string3 = object.getURL().getPath() + "/" + string;
                    URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)string3);
                    workflowNode.rename(uRL);
                    bl = true;
                } else {
                    bl = false;
                    MessageDialog.error((Component)this.getParentWindow(), (Object)DataminerNavigatorLrb.get("RENAME_WORKFLOW_NAME_NOT_CHANGED"), (String)DataminerNavigatorLrb.get("RENAME_WORKFLOW_ERROR_NAME"), null);
                }
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
            ExceptionDialog.showExceptionDialog((Component)this.getParentWindow(), (Throwable)exception, (String)DataminerNavigatorLrb.get("RENAME_WORKFLOW_ERROR_NAME"), (String)DataminerNavigatorLrb.get("RENAME_WORKFLOW_NAME_NOT_CHANGED"), null);
        }
        return bl;
    }

    @Override
    protected String getDialogTitle() {
        String string = DataminerNavigatorLrb.get("RENAME_NODE_TITLE");
        if (this._isProject) {
            string = string + " " + DataminerNavigatorLrb.get("RENAME_NODE_PROJECT") + ": ";
        } else if (this._isWorkflow) {
            string = string + " " + DataminerNavigatorLrb.get("RENAME_NODE_WORKFLOW") + ": ";
        }
        string = string + this._currentName;
        return string;
    }

    @Override
    protected String getHelpTopic() {
        return "renameNode.htm";
    }
}

