/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataminerNavigatorWindow;
import oracle.dmt.dataminer.navigator.NavigatorController;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.wflownodes.GraphNavNode;
import oracle.dmt.dataminer.workflow.WorkflowContextMenu;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorPath;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorWindow;

public final class NavigatorContextMenuListener
implements ContextMenuListener {
    private static final Logger LOGGER = Logger.getLogger(NavigatorContextMenuListener.class.getName());

    public void menuWillShow(ContextMenu contextMenu) {
        if (!(contextMenu.getContext().getView() instanceof DataminerNavigatorWindow)) {
            return;
        }
        contextMenu.addMenuFilter(new MenuFilter(){

            public boolean accept(Component component) {
                IdeAction ideAction;
                if (!(component instanceof JMenuItem)) {
                    return true;
                }
                JMenuItem jMenuItem = (JMenuItem)component;
                return jMenuItem.getAction() == null || !(jMenuItem.getAction() instanceof IdeAction) || (ideAction = (IdeAction)jMenuItem.getAction()).getCommandId() != Ide.findCmdID((String)"ObjectGalleryCommand").intValue();
            }
        });
        Context context = contextMenu.getContext();
        Node node = context.getNode();
        if (node instanceof ConnectionFolder) {
            this.menuWillShowHelper(contextMenu, IdeAction.find((int)NavigatorController.DISCONNECT_CONN_CMD_ID), true);
        }
        this.menuWillShowHelper(contextMenu, IdeAction.find((int)NavigatorController.NEW_CONNECTION_CMD_ID));
        this.menuWillShowHelper(contextMenu, IdeAction.find((int)NavigatorController.NEW_WORKFLOW_CMD_ID));
        this.menuWillShowHelper(contextMenu, IdeAction.find((int)NavigatorController.NEW_PROJECT_CMD_ID));
        this.menuWillShowHelper(contextMenu, IdeAction.find((int)NavigatorController.DELETE_NODE_CMD_ID));
        this.menuWillShowHelper(contextMenu, IdeAction.find((int)NavigatorController.DELETE_CONN_CMD_ID));
        this.menuWillShowHelper(contextMenu, IdeAction.find((int)NavigatorController.CONN_PROPERTIES_CMD_ID));
        this.menuWillShowHelper(contextMenu, IdeAction.find((int)NavigatorController.PROJECT_PROPERTIES_CMD_ID));
        this.menuWillShowHelper(contextMenu, IdeAction.find((int)NavigatorController.RENAME_NODE_CMD_ID));
        this.menuWillShowHelper(contextMenu, IdeAction.find((int)NavigatorController.WORKFLOW_IMPORT_CMD_ID));
        this.menuWillShowHelper(contextMenu, IdeAction.find((int)NavigatorController.WORKFLOW_EXPORT_CMD_ID));
    }

    private void menuWillShowHelper(ContextMenu contextMenu, IdeAction ideAction) {
        this.menuWillShowHelper(contextMenu, ideAction, false);
    }

    private void menuWillShowHelper(ContextMenu contextMenu, IdeAction ideAction, boolean bl) {
        ideAction.updateAction(contextMenu.getContext());
        if (ideAction.isEnabled() || bl) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction));
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        boolean bl = false;
        final Element element = context.getElement();
        EditorManager editorManager = EditorManager.getEditorManager();
        if (element instanceof GraphNavNode) {
            final WorkflowNode workflowNode = WorkflowNode.findParentWorkflowNode(context);
            if (workflowNode != null) {
                final Context context2 = Context.newIdeContext((Node)workflowNode);
                EditorPath editorPath = editorManager.searchEditor((Node)workflowNode);
                if (editorPath != null) {
                    this.openInGraphEditor((GraphNavNode)element, context2, workflowNode);
                } else {
                    WorkflowEditor workflowEditor = (WorkflowEditor)editorManager.openDefaultEditorInFrame(context2);
                    workflowEditor.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            NavigatorContextMenuListener.this.openInGraphEditor((GraphNavNode)element, context2, workflowNode);
                        }
                    });
                }
            }
            bl = true;
        } else if (editorManager.openDefaultEditorInFrame(context) != null) {
            bl = true;
        }
        return bl;
    }

    private void openInGraphEditor(GraphNavNode graphNavNode, Context context, WorkflowNode workflowNode) {
        WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
        boolean bl = false;
        if (workflowModel == null) {
            LOGGER.log(Level.SEVERE, "WorkflowModel instance is expected, but not available. Aborting Graph node edit.", new Exception());
        }
        String string = graphNavNode.getShortLabel();
        AbstractNode abstractNode = (AbstractNode)workflowModel.findNodeByName(string);
        try {
            bl = WorkflowContextMenu.openInGraphEditor(abstractNode, context);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        if (!bl) {
            LOGGER.log(Level.SEVERE, "Graph node editor could not be launched.", new Exception());
        }
    }

    protected boolean openNavigatorNode(NavigatorWindow navigatorWindow, Context context) {
        if (navigatorWindow == null || context == null) {
            return false;
        }
        TreeExplorer treeExplorer = navigatorWindow.getTreeExplorer();
        if (treeExplorer == null) {
            return false;
        }
        Node node = context.getNode();
        if (node == null) {
            return false;
        }
        TNode tNode = treeExplorer.getRoot();
        TNode tNode2 = treeExplorer.searchTNode((Element)node, tNode);
        if (tNode2 != null) {
            treeExplorer.setSelected(tNode2);
            navigatorWindow.show();
            DockStation.getDockStation().activateDockable((Dockable)navigatorWindow);
            return true;
        }
        return false;
    }
}

