/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.svd;

import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.svd.SVDLrb;
import oracle.dmt.dataminer.server.model.SVDCoefficientRowData;
import oracle.dmt.dataminer.utils.comparator.AbsoluteNumberComparator;
import oracle.dmt.dataminer.utils.comparator.LetterNumberComparator;
import oracle.dmt.dataminer.utils.comparator.NumberComparator;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class SingularValuesTableModel
extends GenericBaseTableModel {
    private static final String[] COLUMN_NAMES = new String[]{SVDLrb.get("FEATURE_ID_COLUMN"), SVDLrb.get("SINGULAR_VALUE_COLUMN")};
    public static final int FEATURE_ID_COLUMN = 0;
    public static final int SINGULAR_VALUE_COLUMN = 1;
    private boolean _absoluteSort = false;
    private Vector<SVDCoefficientRowData> _data = new Vector();

    public SingularValuesTableModel() {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this.setRowCount(0);
    }

    public SingularValuesTableModel(Vector<SVDCoefficientRowData> vector) {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this._data = vector;
        this.setRowCount(vector.size());
    }

    public int getRowCount() {
        return this._data == null ? 0 : this._data.size();
    }

    public void updateFeatureID(String string, String string2, int n) {
        for (SVDCoefficientRowData sVDCoefficientRowData : this._data) {
            if (!sVDCoefficientRowData.getAttributeName().equals(string2)) continue;
            sVDCoefficientRowData.setAttributeName(string);
            break;
        }
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public SVDCoefficientRowData getRow(int n) {
        return this._data.get(n);
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 1: {
                if (this._absoluteSort) {
                    return AbsoluteNumberComparator.getComparator();
                }
                return NumberComparator.getComparator();
            }
            case 0: {
                return LetterNumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        SVDCoefficientRowData sVDCoefficientRowData = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = sVDCoefficientRowData.getAttributeName();
                break;
            }
            case 1: {
                object = sVDCoefficientRowData.getSingularValue();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object == null ? "NULL" : object;
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public boolean getAbsoluteValueSort() {
        return this._absoluteSort;
    }

    public void addRow(SVDCoefficientRowData sVDCoefficientRowData) {
        this._data.add(sVDCoefficientRowData);
    }

    public Vector<SVDCoefficientRowData> getDataVector() {
        return this._data;
    }

    public void addRows(List<SVDCoefficientRowData> list) {
        for (SVDCoefficientRowData sVDCoefficientRowData : list) {
            this.getDataVector().add(sVDCoefficientRowData);
        }
    }
}

