/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerFeaturesTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerState;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerTextAttrsTableModel;

public class TextFeaturesPanel
extends JPanel {
    private SettingsViewerState state;
    private int _lastSelectedIindex = -1;
    private DataMinerTable _genericTableModelAttributes;
    private DataMinerTablePanel featuresPanel;
    private JPanel jAttributesPanel;
    private JScrollPane jScrollPane;
    private JSplitPane jSplitPane;

    public TextFeaturesPanel() {
        this.initComponents();
    }

    public void setupTextAttrsTable(final SettingsViewerState settingsViewerState) {
        this.state = settingsViewerState;
        SettingsViewerTextAttrsTableModel settingsViewerTextAttrsTableModel = settingsViewerState.getTextAttrsTableModel();
        this._genericTableModelAttributes.setModel((TableModel)((Object)settingsViewerTextAttrsTableModel));
        this._genericTableModelAttributes.setSorted(true);
        this._genericTableModelAttributes.setUpdateSelectionOnSort(true);
        this._genericTableModelAttributes.getTableHeader().setReorderingAllowed(false);
        this._genericTableModelAttributes.setSelectionMode(2);
        this._genericTableModelAttributes.setSortColumn(0, true);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = TextFeaturesPanel.this._genericTableModelAttributes.getSelectedRowsInModel();
                if (0 == nArray.length) {
                    TextFeaturesPanel.this._lastSelectedIindex = -1;
                    settingsViewerState.setLastSelectedTextAttribute(TextFeaturesPanel.this._lastSelectedIindex);
                    return;
                }
                if (nArray.length > 1) {
                    return;
                }
                int n = nArray[0];
                if (n >= 0 && TextFeaturesPanel.this._lastSelectedIindex != n) {
                    TextFeaturesPanel.this._lastSelectedIindex = n;
                    settingsViewerState.setLastSelectedTextAttribute(TextFeaturesPanel.this._lastSelectedIindex);
                    TextFeaturesPanel.this.loadFeatures();
                }
            }
        };
        this._genericTableModelAttributes.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.featuresPanel.getTable().setModel((TableModel)((Object)new SettingsViewerFeaturesTableModel()));
    }

    public void loadFeatures() {
        LoadFeatures loadFeatures = new LoadFeatures(this.state.getLastSelectedTextAttribute().getAttributeName());
        loadFeatures.execute();
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jAttributesPanel = new JPanel();
        this.jScrollPane = new JScrollPane();
        this._genericTableModelAttributes = new DataMinerTable();
        this.featuresPanel = new DataMinerTablePanel();
        this.jSplitPane.setDividerLocation(200);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setResizeWeight(0.5);
        this.jSplitPane.setContinuousLayout(true);
        this.jSplitPane.setOneTouchExpandable(true);
        this._genericTableModelAttributes.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Data Type", "Mining Type"}));
        this.jScrollPane.setViewportView((Component)((Object)this._genericTableModelAttributes));
        GroupLayout groupLayout = new GroupLayout(this.jAttributesPanel);
        this.jAttributesPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane, -1, 625, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane, -1, 168, Short.MAX_VALUE).addGap(20, 20, 20)));
        this.jSplitPane.setLeftComponent(this.jAttributesPanel);
        this.featuresPanel.setModelExample(new DefaultTableModel(new Object[0][], new String[]{"Feature", "Type", "Document Frecuency"}));
        this.jSplitPane.setRightComponent(this.featuresPanel);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING, -1, 461, Short.MAX_VALUE));
    }

    private class LoadFeatures
    extends SwingWorker {
        Exception _ex = null;
        String _attribute;
        boolean _success = false;

        public LoadFeatures(String string) {
            this._attribute = string;
            SettingsViewerFeaturesTableModel settingsViewerFeaturesTableModel = (SettingsViewerFeaturesTableModel)((Object)TextFeaturesPanel.this.featuresPanel.getTable().getModel());
            settingsViewerFeaturesTableModel.loadStatus(SettingsLrb.get("SETTINGS_LOADING"));
        }

        protected Object doInBackground() throws Exception {
            try {
                TextFeaturesPanel.this.state.loadTextFeatures(this._attribute);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return TextFeaturesPanel.this.state;
        }

        @Override
        protected void done() {
            super.done();
            if (this._success && this._ex == null) {
                SettingsViewerFeaturesTableModel settingsViewerFeaturesTableModel = TextFeaturesPanel.this.state.getFeaturesTableModel();
                if (settingsViewerFeaturesTableModel == null) {
                    settingsViewerFeaturesTableModel = new SettingsViewerFeaturesTableModel();
                }
                TextFeaturesPanel.this.featuresPanel.setup((TableModel)((Object)settingsViewerFeaturesTableModel), MessageFormat.format(SettingsLrb.get("FEATURE_ROW_COUNT"), 0), 0);
                TextFeaturesPanel.this.featuresPanel.getTable().setUpdateSelectionOnSort(true);
                TextFeaturesPanel.this.featuresPanel.getTable().getTableHeader().setReorderingAllowed(false);
                TextFeaturesPanel.this.featuresPanel.getTable().setSelectionMode(2);
                String string = MessageFormat.format(SettingsLrb.get("FEATURE_ROW_COUNT"), settingsViewerFeaturesTableModel.getRowCount());
                TextFeaturesPanel.this.featuresPanel.setTitle(string);
            }
        }
    }
}

