/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.glmdetails;

import java.text.NumberFormat;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.glmdetails.GLMDetailsLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.server.model.GLMModelDetailsRowData;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelC;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelR;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class GLMDetailsTableModel
extends GenericBaseTableModel {
    private GeneralizedLinearModelC _modelGLMClassification = null;
    private GeneralizedLinearModelR _modelGLMRegression = null;
    private Context _context;
    private Vector<GLMModelDetailsRowData> _data = new Vector(30, 10);
    private Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._prefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private NumberFormat _nf_wprecision = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);
    private String[] _columnNames = new String[]{GLMDetailsLrb.get("NAME_COLUMN"), GLMDetailsLrb.get("VALUE_COLUMN")};
    private static final int COLUMN_COUNT = 2;
    public static final int NAME = 0;
    public static final int VALUE = 1;

    public GLMDetailsTableModel(Context context) {
        this._context = context;
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(0);
        this.setColumnCount(2);
        this.setPercentageFormating();
    }

    public GLMDetailsTableModel(Context context, Vector<GLMModelDetailsRowData> vector) {
        this._context = context;
        this.setColumnIdentifiers(this._columnNames);
        this._data = vector;
        this.setRowCount(vector.size());
        this.setColumnCount(2);
        this.setPercentageFormating();
    }

    private void setPercentageFormating() {
        this._percentageFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
        this._percentageFormat.setMinimumIntegerDigits(1);
    }

    public void load(ModelViewerState1 modelViewerState1) throws Exception {
        Vector<GLMModelDetailsRowData> vector;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        Model model = null;
        if (modelViewerState1.getOdmModel().getModelGeneralDescription().isClassificationModel() && modelViewerState1.getOdmModel().getModelGeneralDescription().isGeneralizedLinearModelAlgorithm()) {
            this._modelGLMClassification = model = new GeneralizedLinearModelC();
            vector = this._modelGLMClassification.getGlobalDetails(connectionFolder, modelViewerState1.getUserName(), modelViewerState1.getModelName());
        } else if (modelViewerState1.getOdmModel().getModelGeneralDescription().isRegressionModel() && modelViewerState1.getOdmModel().getModelGeneralDescription().isGeneralizedLinearModelAlgorithm()) {
            model = new GeneralizedLinearModelR();
            this._modelGLMRegression = (GeneralizedLinearModelR)model;
            vector = this._modelGLMRegression.getGlobalDetails(connectionFolder, modelViewerState1.getUserName(), modelViewerState1.getModelName());
        } else {
            throw new Exception(GLMDetailsLrb.get("DETAILS_VIEWER_UNRECOGNIZED_MODEL_TYPE"));
        }
        this._data = vector;
        this.fireTableDataChanged();
    }

    public void addRows(Vector<GLMModelDetailsRowData> vector) {
        for (GLMModelDetailsRowData gLMModelDetailsRowData : vector) {
            this.getDataVector().add(gLMModelDetailsRowData);
        }
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public GLMModelDetailsRowData getRow(int n) {
        return this._data.get(n);
    }

    public Vector<GLMModelDetailsRowData> getDataVector() {
        return this._data;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        GLMModelDetailsRowData gLMModelDetailsRowData = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = GLMModelDetailsRowData.translateGLOBAL_DETAIL_NAMES(gLMModelDetailsRowData.getName());
                break;
            }
            case 1: {
                object = gLMModelDetailsRowData.getValue();
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    if (bl) {
                        object = GLMDetailsLrb.get("YES");
                        break;
                    }
                    object = GLMDetailsLrb.get("NO");
                    break;
                }
                if (gLMModelDetailsRowData.getName().equals("TERMINATION")) {
                    if (!(object instanceof Double)) break;
                    int n3 = ((Double)object).intValue();
                    if (n3 == 0) {
                        object = GLMDetailsLrb.get("TERMINATION_NORMAL");
                        break;
                    }
                    if (n3 == 1) {
                        object = GLMDetailsLrb.get("TERMINATION_EARY");
                        break;
                    }
                    if (n3 != 2) break;
                    object = GLMDetailsLrb.get("TERMINATION_SKIP_CATEGORICALS");
                    break;
                }
                if (!(object instanceof Double)) break;
                if (gLMModelDetailsRowData.getName().equals("PCT_CORRECT") || gLMModelDetailsRowData.getName().equals("PCT_INCORRECT") || gLMModelDetailsRowData.getName().equals("PCT_TIED")) {
                    object = this._percentageFormat.format(100.0 * (Double)object) + "%";
                    break;
                }
                object = this._nf_wprecision.format((Double)object);
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing global details";
                break;
            }
        }
        if (object == null) {
            return "NULL";
        }
        return object;
    }

    public void addRow(GLMModelDetailsRowData gLMModelDetailsRowData) {
        this._data.add(gLMModelDetailsRowData);
    }
}

