/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.util.Comparator;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.utils.comparator.AbsoluteNumberComparator;
import oracle.dmt.dataminer.utils.comparator.NumberComparator;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class NBProbabilitiesTableModel
extends GenericBaseTableModel {
    private Vector<CoefficientRowData> _data = new Vector();
    public static final int ATTRIBUTE = 0;
    public static final int VALUE = 1;
    public static final int PROBABILITY = 2;
    private boolean _absoluteSort = false;
    private static final String[] COLUMN_NAMES = new String[]{CoefficientsLrb.get("PRIORS_ATTRIBUTE_NAME"), CoefficientsLrb.get("PRIORS_ATTRIBUTE_VALUE"), CoefficientsLrb.get("PRIORS_ATTRIBUTE_PROBABILITY")};

    public NBProbabilitiesTableModel() {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this.setRowCount(0);
    }

    public NBProbabilitiesTableModel(Vector<CoefficientRowData> vector) {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this._data = vector;
        this.setRowCount(vector.size());
    }

    public void updateColumnIdentifiers(String string) {
        Object[] objectArray = new String[COLUMN_NAMES.length];
        System.arraycopy(COLUMN_NAMES, 0, objectArray, 0, COLUMN_NAMES.length);
        objectArray[2] = objectArray[2] + string;
        this.setColumnIdentifiers(objectArray);
    }

    public int getRowCount() {
        return this._data == null ? 0 : this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public CoefficientRowData getRow(int n) {
        return this._data.get(n);
    }

    public Vector<CoefficientRowData> getDataVector() {
        return this._data;
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator<Object> comparator = null;
        comparator = n == 2 ? (this._absoluteSort ? AbsoluteNumberComparator.getComparator() : NumberComparator.getComparator()) : super.getColumnSortComparator(n);
        return comparator;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        CoefficientRowData coefficientRowData = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = coefficientRowData.getAttributeFullName();
                break;
            }
            case 1: {
                object = coefficientRowData.getValue();
                break;
            }
            case 2: {
                if (coefficientRowData.getCoefficient1() != null) {
                    object = coefficientRowData.getCoefficient1() * 100.0;
                    break;
                }
                object = coefficientRowData.getCoefficient1();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object == null ? " " : object;
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public boolean getAbsoluteValueSort() {
        return this._absoluteSort;
    }

    public void addRow(CoefficientRowData coefficientRowData) {
        this._data.add(coefficientRowData);
    }

    public void addRows(Vector<CoefficientRowData> vector) {
        for (CoefficientRowData coefficientRowData : vector) {
            this._data.add(coefficientRowData);
        }
    }
}

