/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.filter.FilterEvent;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GLMCoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoeffViewer;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.NBProbabilitiesTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.PCACoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.PCACoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.SVDCoefViewerTableModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractModelNode;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.GLMCoefficientRowData;
import oracle.dmt.dataminer.server.model.SVDCoefficientRowData;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class CoefViewer
extends JPanel
implements GeneralCoeffViewer {
    CoefViewerState _state;
    Context _context;
    CoefViewerMainPanel _mainPanel;
    public static final String COEFFICIENT_VIEWER_ID = "COEFFICIENT_VIEWER_ID";
    private static final int GLM_FROZEN_COLUMNS = 2;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private static String _LOADING_SVM = CoefficientsLrb.get("COEFFICIENT_LOADING");
    private static String _LOADING_GLM = CoefficientsLrb.get("STATISTICS_LOADING");
    private static String _LOADING_NB = CoefficientsLrb.get("PROBABILITIES_LOADING");
    private static String _LOADING_NMF = CoefficientsLrb.get("COEFFICIENT_LOADING");
    private NumberFormat _labelNumericalFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel(), 0, 0);
    private NumberFormat _labelPercentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private HistogramBarRenderer _barRenderer = null;
    private boolean _loadedFilterSetting = false;
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel dataMinerTablePanel;

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public CoefViewer(CoefViewerMainPanel coefViewerMainPanel, Context context, CoefViewerState coefViewerState) {
        this._mainPanel = coefViewerMainPanel;
        this._context = context;
        this._state = coefViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 504, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 257, Short.MAX_VALUE));
    }

    @Override
    public JPanel getUIComponent() {
        return this;
    }

    @Override
    public void initRes() {
        this.loadRowsOutOfTotalLabel(0, 0);
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setShowGrid(true);
        this.initializeControls();
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = "";
        if (this._state.isSVM() || this._state.isAnomaly() || this._state.isNMF() || this._state.isSVD() || this._state.isPCA()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        } else if (this._state.isNB()) {
            string = CoefficientsLrb.get("PROBABILTIES_ROWS_OUT_OF_TOTAL");
        } else if (this._state.isGLM()) {
            string = CoefficientsLrb.get("COEFFICIENTS_ROWS_OUT_OF_TOTAL");
        }
        int n3 = 1;
        if (n == 0 && n2 == 0) {
            n3 = 0;
        }
        if (this._state.isSVM() || this._state.isGLM() || this._state.isAnomaly() || this._state.isNMF() || this._state.isSVD() || this._state.isPCA()) {
            n3 = 0;
        }
        Integer n4 = n2 + n3;
        String string2 = NumericFormat.format(n);
        String string3 = NumericFormat.format(n4);
        String string4 = MessageFormat.format(string, string2, string3);
        this.dataMinerTablePanel.setTitle(string4);
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
    }

    private void setLoaded(boolean bl) {
        if (!this._loadedFilterSetting) {
            this._mainPanel.setFilterPanelInitialState(this._state.getFilterSetting());
            this._loadedFilterSetting = true;
        }
        this._mainPanel.updateLoaded(bl);
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    @Override
    public void setFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this._state.setFilterSetting(coefficientFilterSetting);
        this.prepareReload();
    }

    public void setFilterState(FilterEvent filterEvent) {
    }

    public CoefficientFilterSetting getFilterState() {
        return this._state.getFilterSetting();
    }

    @Override
    public CoefficientFilterSetting getCachedFilterState() {
        return this._state.getCachedFilterSetting();
    }

    @Override
    public void setCachedFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        this._state.setCachedFilterSetting(coefficientFilterSetting);
    }

    @Override
    public void prepareReload() {
        this.setLoading(true);
        this.prepareForNewQuery();
        LoadUI loadUI = new LoadUI(true);
        loadUI.execute();
    }

    private void enableControls(boolean bl) {
        this.dataMinerTablePanel.getSearchField().setEnabled(bl);
    }

    void prepareForNewQuery() {
        this._state.clearRows();
        if (this._state.isSVM() || this._state.isNB() || this._state.isAnomaly()) {
            CoefficientRowData coefficientRowData = new CoefficientRowData(this._state.isSVM() || this._state.isAnomaly() ? _LOADING_SVM : _LOADING_NB);
            this._state.addRow(coefficientRowData);
            this.dataMinerTablePanel.getTable().setModel((TableModel)this._state.getTableModel());
        } else if (this._state.isGLM()) {
            GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(_LOADING_GLM);
            this._state.addRow(gLMCoefficientRowData);
            this.dataMinerTablePanel.getTable().setModel((TableModel)this._state.getTableModel());
        } else if (this._state.isNMF()) {
            CoefficientRowData coefficientRowData = new CoefficientRowData(_LOADING_NMF);
            this._state.addRow(coefficientRowData);
            this.dataMinerTablePanel.getTable().setModel((TableModel)this._state.getTableModel());
        } else if (this._state.isSVD()) {
            SVDCoefficientRowData sVDCoefficientRowData = new SVDCoefficientRowData(_LOADING_NMF);
            this._state.addSVDRow(sVDCoefficientRowData);
            this.dataMinerTablePanel.getTable().setModel((TableModel)this._state.getTableModel());
        } else if (this._state.isPCA()) {
            SVDCoefficientRowData sVDCoefficientRowData = new SVDCoefficientRowData(_LOADING_NMF);
            this._state.addPCARow(sVDCoefficientRowData);
            this.dataMinerTablePanel.getTable().setModel((TableModel)this._state.getTableModel());
        }
        this.enableControls(false);
    }

    private void initializeControls() {
        this.setupLoadingTable();
        this.enableControls(false);
    }

    private void setupSVMTable(CoefViewerTableModel coefViewerTableModel) {
        coefViewerTableModel.setAbsoluteValueSort(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        this.dataMinerTablePanel.setup((TableModel)((Object)coefViewerTableModel), null, 0, true);
        this.dataMinerTablePanel.getTable().setSorted(true);
        this._barRenderer = new HistogramBarRenderer(1L, true, this._labelNumericalFormat);
        this.dataMinerTablePanel.getTable().getFullColumnModel().getColumn(2).setCellRenderer(this._barRenderer);
        this._barRenderer.setMaximumValue(this._state.getMaximumABSCoefficient().longValue());
        if (this._state.isAnomaly()) {
            this.dataMinerTablePanel.getTable().setSortColumn(2, false);
        }
        this.dataMinerTablePanel.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    private void setupSVDTable(SVDCoefViewerTableModel sVDCoefViewerTableModel) {
        sVDCoefViewerTableModel.setAbsoluteValueSort(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        this.dataMinerTablePanel.setup((TableModel)((Object)sVDCoefViewerTableModel), null, 0, true);
        this.dataMinerTablePanel.getTable().setSorted(true);
        this._barRenderer = new HistogramBarRenderer(1L, true, this._labelPercentageFormat);
        this.dataMinerTablePanel.getTable().getFullColumnModel().getColumn(1).setCellRenderer(this._barRenderer);
        this._barRenderer.setMaximumValue(this._state.getMaximumABSCoefficient().longValue());
        this.dataMinerTablePanel.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    private void setupPCATable(PCACoefViewerTableModel pCACoefViewerTableModel) {
        pCACoefViewerTableModel.setAbsoluteValueSort(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        this.dataMinerTablePanel.setup((TableModel)((Object)pCACoefViewerTableModel), null, 0, true);
        this.dataMinerTablePanel.getTable().setSorted(true);
        this._barRenderer = new HistogramBarRenderer(1L, true, this._labelPercentageFormat);
        this.dataMinerTablePanel.getTable().getFullColumnModel().getColumn(1).setCellRenderer(this._barRenderer);
        this._barRenderer.setMaximumValue(this._state.getMaximumABSCoefficient().longValue());
        this.dataMinerTablePanel.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    private void setupNBTable(NBProbabilitiesTableModel nBProbabilitiesTableModel) {
        nBProbabilitiesTableModel.updateColumnIdentifiers(this._state.getSelectedTargetClass().toString());
        nBProbabilitiesTableModel.setAbsoluteValueSort(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        this.dataMinerTablePanel.setup((TableModel)((Object)nBProbabilitiesTableModel), null, 0, true);
        this.dataMinerTablePanel.getTable().setSorted(true);
        this._barRenderer = new HistogramBarRenderer(1L, true, this._labelNumericalFormat);
        this.dataMinerTablePanel.getTable().getFullColumnModel().getColumn(2).setCellRenderer(this._barRenderer);
        this._barRenderer.setMaximumValue(100L);
        this.dataMinerTablePanel.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    private void setupGLMTable(GLMCoefViewerTableModel gLMCoefViewerTableModel) {
        this.dataMinerTablePanel.getTable().setFixedColumns(2, 175, 175);
        gLMCoefViewerTableModel.setAbsoluteValueSort(this._state.getFilterSetting().getFilterAndSortByAbsolute());
        this.dataMinerTablePanel.getTable().setSorted(true);
        this.dataMinerTablePanel.getTable().setAutoCreateRowSorter(true);
        this.dataMinerTablePanel.setup((TableModel)((Object)gLMCoefViewerTableModel), null, 0, true);
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setSorted(true);
        int n = this.dataMinerTablePanel.getTable().getColumnModel().getTotalColumnWidth();
        Dimension dimension = this.dataMinerTablePanel.getTable().getPreferredSize();
        if ((double)n < dimension.getWidth()) {
            this.dataMinerTablePanel.getTable().setAutoResizeMode(3);
        } else {
            this.dataMinerTablePanel.getTable().setAutoResizeMode(0);
        }
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getFullColumnModel();
        tableColumnModel.getColumn(2).setPreferredWidth(130);
        tableColumnModel.getColumn(3).setPreferredWidth(150);
        tableColumnModel.getColumn(gLMCoefViewerTableModel.getColumn_Exp_Cofficient_Column_Number()).setPreferredWidth(100);
        this._barRenderer = new HistogramBarRenderer(1L, true, this._labelNumericalFormat);
        tableColumnModel.getColumn(2).setCellRenderer(this._barRenderer);
        if (this._state.isCovarianceIndicator()) {
            tableColumnModel.getColumn(10).setPreferredWidth(150);
            tableColumnModel.getColumn(11).setPreferredWidth(150);
            tableColumnModel.getColumn(7).setPreferredWidth(130);
            tableColumnModel.getColumn(6).setPreferredWidth(100);
            tableColumnModel.getColumn(4).setPreferredWidth(130);
            tableColumnModel.getColumn(5).setPreferredWidth(100);
            tableColumnModel.getColumn(8).setPreferredWidth(130);
            tableColumnModel.getColumn(11).setCellRenderer(new NumberCellRenderer(NumberCellRenderer.FormatType.SCIENTIFIC));
            tableColumnModel.getColumn(7).setCellRenderer(new NumberCellRenderer());
            tableColumnModel.getColumn(10).setCellRenderer(new NumberCellRenderer());
            tableColumnModel.getColumn(6).setCellRenderer(new NumberCellRenderer());
            tableColumnModel.getColumn(4).setCellRenderer(new NumberCellRenderer());
            tableColumnModel.getColumn(5).setCellRenderer(new NumberCellRenderer());
            tableColumnModel.getColumn(8).setCellRenderer(new NumberCellRenderer());
        }
        tableColumnModel.getColumn(gLMCoefViewerTableModel.getColumn_Exp_Cofficient_Column_Number()).setCellRenderer(new NumberCellRenderer());
        this._barRenderer.setMaximumValue(this._state.getMaximumABSCoefficient().longValue());
        this.dataMinerTablePanel.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CoefViewer.this.repaint();
                        }
                    });
                }
            }
        });
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private void setupLoadingTable() {
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)new LoadingTableModel()));
    }

    class LoadingTableModel
    extends GenericBaseTableModel {
        private String[] columnNames = new String[]{CoefficientsLrb.get("PRIORS_ATTRIBUTE_NAME")};

        LoadingTableModel() {
            this.setColumnIdentifiers(this.columnNames);
            this.setRowCount(1);
            this.setColumnCount(this.columnNames.length);
        }

        public Object getValueAt(int n, int n2) {
            if (CoefViewer.this._state.isSVM() || CoefViewer.this._state.isAnomaly()) {
                return _LOADING_SVM;
            }
            if (CoefViewer.this._state.isGLM()) {
                return _LOADING_GLM;
            }
            if (CoefViewer.this._state.isNB()) {
                return _LOADING_NB;
            }
            if (CoefViewer.this._state.isNMF()) {
                return _LOADING_NMF;
            }
            if (CoefViewer.this._state.isSVD()) {
                return _LOADING_NMF;
            }
            if (CoefViewer.this._state.isPCA()) {
                return _LOADING_NMF;
            }
            return "unknown details";
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        protected Object doInBackground() throws Exception {
            try {
                Node node = CoefViewer.this._mainPanel.getEditor().getContext().getNode();
                AbstractModelNode abstractModelNode = (AbstractModelNode)node;
                String string = abstractModelNode.getOdmModel().getUserName();
                String string2 = abstractModelNode.getOdmModel().getModelName();
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(CoefViewer.this._mainPanel.getEditor().getContext());
                String string3 = "";
                PartitionVO partitionVO = new PartitionVO("", "");
                GeneralCoefficientFilterPanel generalCoefficientFilterPanel = CoefViewer.this._mainPanel.getViewerFilterPanel();
                if (generalCoefficientFilterPanel instanceof CoefficientFilterPanel) {
                    CoefficientFilterPanel coefficientFilterPanel = (CoefficientFilterPanel)generalCoefficientFilterPanel;
                    boolean bl = DatabaseMetadataUtils.isModelPartitioned(connectionFolder, string, string2, partitionVO);
                    if (bl) {
                        string3 = partitionVO.getPartitionID();
                    }
                    CoefViewer.this._mainPanel.setPartitionVO(partitionVO);
                    CoefViewer.this._mainPanel.setModelPartitioned(bl);
                    coefficientFilterPanel.resizePartitionToolbar();
                } else if (generalCoefficientFilterPanel instanceof PCACoefficientFilterPanel) {
                    PCACoefficientFilterPanel pCACoefficientFilterPanel = (PCACoefficientFilterPanel)generalCoefficientFilterPanel;
                }
                if (this._reload) {
                    CoefViewer.this._state.reloadCoefficients(string3);
                } else if (CoefViewer.this._mainPanel.isModelParitioned()) {
                    CoefViewer.this._state.load(partitionVO);
                } else {
                    CoefViewer.this._state.load(new PartitionVO("", ""));
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return CoefViewer.this._state;
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    if (this._reload) {
                        // empty if block
                    }
                    if (CoefViewer.this._state.isSVM() || CoefViewer.this._state.isAnomaly() || CoefViewer.this._state.isNMF()) {
                        if (CoefViewer.this._state.isAnomaly()) {
                            CoefViewer.this._state.setSortByAbsoluteValue(CoefViewer.this._state.getFilterSetting().getFilterAndSortByAbsolute());
                        }
                        CoefViewer.this.setupSVMTable((CoefViewerTableModel)CoefViewer.this._state.getTableModel());
                    } else if (CoefViewer.this._state.isSVD()) {
                        CoefViewer.this._state.setSortByAbsoluteValue(CoefViewer.this._state.getFilterSetting().getFilterAndSortByAbsolute());
                        CoefViewer.this.setupSVDTable((SVDCoefViewerTableModel)CoefViewer.this._state.getTableModel());
                    } else if (CoefViewer.this._state.isPCA()) {
                        CoefViewer.this._state.setSortByAbsoluteValue(CoefViewer.this._state.getFilterSetting().getFilterAndSortByAbsolute());
                        CoefViewer.this.setupPCATable((PCACoefViewerTableModel)CoefViewer.this._state.getTableModel());
                    } else if (CoefViewer.this._state.isGLM()) {
                        CoefViewer.this.setupGLMTable((GLMCoefViewerTableModel)CoefViewer.this._state.getTableModel());
                    } else if (CoefViewer.this._state.isNB()) {
                        CoefViewer.this.setupNBTable((NBProbabilitiesTableModel)CoefViewer.this._state.getTableModel());
                    }
                    CoefViewer.this.dataMinerTablePanel.trySearch();
                    CoefViewer.this._mainPanel.updateTarget();
                    CoefViewer.this.loadRowsOutOfTotalLabel(CoefViewer.this._state.getTableModel().getRowCount(), CoefViewer.this._state.getTotalDetailCount());
                    CoefViewer.this.enableControls(true);
                    CoefViewer.this._labelNumericalFormat.setMaximumFractionDigits(CoefViewer.this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
                    CoefViewer.this._labelNumericalFormat.setMinimumFractionDigits(CoefViewer.this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
                    CoefViewer.this._labelNumericalFormat.setMinimumIntegerDigits(1);
                    CoefViewer.this._labelPercentageFormat.setMaximumFractionDigits(CoefViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    CoefViewer.this._labelPercentageFormat.setMinimumFractionDigits(CoefViewer.this._modelViewerPrefenceSettings.getPercentagePrecisionLevel());
                    CoefViewer.this._labelPercentageFormat.setMinimumIntegerDigits(1);
                    if (CoefViewer.this.dataMinerTablePanel.getTable().getRowCount() > 0) {
                        CoefViewer.this.dataMinerTablePanel.getTable().setSelectedRowsInModel(new int[]{0});
                    }
                    CoefViewer.this.setLoaded(true);
                } else if (CoefViewer.this._state.getTableModel() != null) {
                    CoefViewer.this._state.clearRows();
                    if (CoefViewer.this._state.isSVM() || CoefViewer.this._state.isAnomaly() || CoefViewer.this._state.isNMF()) {
                        CoefficientRowData coefficientRowData = new CoefficientRowData(CoefficientsLrb.get("COEFFICIENT_FAILURE"));
                        CoefViewer.this._state.addRow(coefficientRowData);
                        CoefViewer.this.setupSVMTable((CoefViewerTableModel)CoefViewer.this._state.getTableModel());
                    } else if (CoefViewer.this._state.isSVD()) {
                        SVDCoefficientRowData sVDCoefficientRowData = new SVDCoefficientRowData(CoefficientsLrb.get("COEFFICIENT_FAILURE"));
                        CoefViewer.this._state.addSVDRow(sVDCoefficientRowData);
                        CoefViewer.this.setupSVDTable((SVDCoefViewerTableModel)CoefViewer.this._state.getTableModel());
                    } else if (CoefViewer.this._state.isPCA()) {
                        SVDCoefficientRowData sVDCoefficientRowData = new SVDCoefficientRowData(CoefficientsLrb.get("COEFFICIENT_FAILURE"));
                        CoefViewer.this._state.addPCARow(sVDCoefficientRowData);
                        CoefViewer.this.setupPCATable((PCACoefViewerTableModel)CoefViewer.this._state.getTableModel());
                    } else if (CoefViewer.this._state.isGLM()) {
                        GLMCoefficientRowData gLMCoefficientRowData = new GLMCoefficientRowData(CoefficientsLrb.get("STATISTICS_FAILURE"));
                        CoefViewer.this._state.addRow(gLMCoefficientRowData);
                        CoefViewer.this.setupGLMTable((GLMCoefViewerTableModel)CoefViewer.this._state.getTableModel());
                    } else if (CoefViewer.this._state.isNB()) {
                        CoefficientRowData coefficientRowData = new CoefficientRowData(CoefficientsLrb.get("PROBABILITIES_FAILURE"));
                        CoefViewer.this._state.addRow(coefficientRowData);
                        CoefViewer.this.setupNBTable((NBProbabilitiesTableModel)CoefViewer.this._state.getTableModel());
                    }
                    CoefViewer.this.loadRowsOutOfTotalLabel(CoefViewer.this._state.getTableModel().getRowCount(), CoefViewer.this._state.getTotalDetailCount());
                }
            }
            catch (Exception exception) {
                this._ex = exception;
            }
            finally {
                if (this._ex != null) {
                    DataMinerEditor.handleEditorException(CoefViewer.this._mainPanel.getEditor().getContext(), this._ex, CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), CoefficientsLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"));
                }
                CoefViewer.this.setLoading(false);
                if (CoefViewer.this.overLayPanel != null) {
                    CoefViewer.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

