/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.ClusteringDetailRow;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Context;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OraclePreparedStatement;

public class RenameClusterDialog
extends DialogDisplayer<AbstractNode> {
    private ClusTreeNode _treeNode;
    private Context _context;
    private JTextField clusterNameEdit;
    private JLabel clusterNameLabel;
    private boolean _dirty = false;

    public RenameClusterDialog(Context context, ClusTreeNode clusTreeNode) {
        this._treeNode = clusTreeNode;
        this._context = context;
        this.initComponents();
        this.initUI();
        this.initRes();
    }

    private void initComponents() {
        this.clusterNameLabel = new JLabel();
        this.clusterNameEdit = new JTextField();
        this.clusterNameLabel.setLabelFor(this.clusterNameEdit);
        this.clusterNameLabel.setText("Cluster Name:");
        this.clusterNameEdit.setText("Cluster Name");
        this.clusterNameEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RenameClusterDialog.this.clusterNameEditActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.clusterNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clusterNameEdit, -2, 159, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clusterNameLabel).addComponent(this.clusterNameEdit, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void clusterNameEditActionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.clusterNameLabel, (Component)this.clusterNameEdit, (String)ClusteringTreeEditorLrb.get("CLUSTER_NAME"));
    }

    @Override
    public void initUI() {
        this.clusterNameEdit.setText(this._treeNode.getData().getCluster_id());
    }

    @Override
    protected boolean doWork() {
        String string;
        String string2 = this._treeNode.getData().getCluster_id();
        if (string2.equals(string = this.clusterNameEdit.getText())) {
            return true;
        }
        if (string.trim().length() == 0) {
            MessageDialog.error((Component)this.getParentWindow(), (Object)CompareClustersLrb.get("COMPARE_CLUSTERS_NAME_EMPTY"), (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_TITLE"), null);
            return false;
        }
        ClusteringDetailRow clusteringDetailRow = null;
        try {
            clusteringDetailRow = this.renameClusterLabel(string, string2);
        }
        catch (ClusterIdNotUniqueException clusterIdNotUniqueException) {
            MessageDialog.error((Component)this.getParentWindow(), (Object)ClusteringTreeEditorLrb.get("CLUSTER_NAME_INUSE"), (String)ClusteringTreeEditorLrb.get("CLUSTER_NAME_INUSE_TITLE"), null);
            return false;
        }
        catch (Exception exception) {
            if (exception.getMessage().equals(CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_NO_PRIVILEGE_MESG"))) {
                MessageDialog.error((Component)this.getParentWindow(), (Object)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_NO_PRIVILEGE_MESG"), (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_TITLE"), null);
            }
            ExceptionDialog.showExceptionDialog((Component)this.getParentWindow(), (Throwable)exception, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_TITLE"), (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_MESG"), null);
        }
        if (!clusteringDetailRow.getCluster_id().equals(string)) {
            return false;
        }
        this._treeNode.getModel().fireDataChanged(this._treeNode);
        UpdateMessage.firePropertiesChanged((Subject)this._context.getNode(), null, (Object)clusteringDetailRow);
        return true;
    }

    public ClusteringDetailRow renameClusterLabel(String string, String string2) throws Exception {
        Object object;
        Object object2;
        HashMap<String, ClusteringDetailRow> hashMap = null;
        Vector<ClusteringDetailRow> vector = new Vector<ClusteringDetailRow>();
        ClusterTreeSDMModel clusterTreeSDMModel = this._treeNode.getModel();
        Enumeration<IlvSDMNode> enumeration = clusterTreeSDMModel.getObjects();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            if (!(object2 instanceof ClusTreeNode)) continue;
            object = (ClusTreeNode)object2;
            if (string.equals(((ClusTreeNode)object).getData().getCluster_id())) {
                throw new ClusterIdNotUniqueException();
            }
            vector.add(((ClusTreeNode)object).getData());
        }
        hashMap = ClusteringDetailRow.createMappedClusterLabelToID(vector, false);
        object2 = (ClusteringDetailRow)hashMap.get(string2);
        object = (ClusteringModelNode)this._context.getNode();
        String string3 = ((ClusteringModelNode)object).getModelLoader().getModelName();
        StringBuilder stringBuilder = new StringBuilder("case ");
        for (ClusteringDetailRow clusteringDetailRow : vector) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string4 = StringUtils.getReplacedString("when value = [CLUSTER_ID] then ", "[CLUSTER_ID]", clusteringDetailRow.getId().toString());
            stringBuilder2.append(string4);
            if (((ClusteringDetailRow)object2).getId().equals(clusteringDetailRow.getId())) {
                clusteringDetailRow.setCluster_id(string);
                string4 = StringUtils.getReplacedString("'[NEW_NAME]'\n", "[NEW_NAME]", string);
            } else {
                string4 = StringUtils.getReplacedString("'[OLD_NAME]'\n", "[OLD_NAME]", clusteringDetailRow.getCluster_id());
            }
            stringBuilder2.append(string4);
            stringBuilder.append(stringBuilder2.toString());
        }
        stringBuilder.append("                else TO_CHAR(value) end");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(this._context);
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement("BEGIN\n  dbms_data_mining.alter_reverse_expression(\n :MODEL_NAME, :CASE_STATEMENT);\nEND;\n");
            sQLHelper.opstmt.setStringAtName("MODEL_NAME", Model.getCombinedUserNameModelName(((ClusteringModelNode)object).getModelLoader().getUserName(), string3, true));
            sQLHelper.opstmt.setStringAtName("CASE_STATEMENT", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            ((ClusteringDetailRow)object2).setCluster_id(string);
        }
        return object2;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    protected String getDialogTitle() {
        return ClusteringTreeEditorLrb.get("RENAME_CLUSTER_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "renameCluster.htm";
    }

    private static class ClusterIdNotUniqueException
    extends Exception {
        private ClusterIdNotUniqueException() {
        }
    }
}

