/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.jdbc.OraclePreparedStatement;

public class ClusterComponentPane
extends JPanel
implements DataminerGUIPanel {
    private ClusTreeNode treeNode;
    private static List<RowSorter.SortKey> sortKeys = null;
    private RowSorterListener sorterListener;
    private List<String> components;
    private boolean hasBeenShown = false;
    private JScrollPane scrollPane;
    private DataMinerTable valuesTable;
    private static final int COMPONENT_ID = 0;
    private static final int COLUMN_COUNT = 1;

    public ClusterComponentPane(ClusTreeNode clusTreeNode) {
        this.treeNode = clusTreeNode;
        this.components = new ArrayList<String>();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.valuesTable = new DataMinerTable();
        this.valuesTable.setModel(new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}}, new String[]{"Component ID"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class};
                this.canEdit = new boolean[]{false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.scrollPane.setViewportView((Component)((Object)this.valuesTable));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 475, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -1, 132, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this.valuesTable.setSortColumn(0, true);
        this.valuesTable.setColumnSelectorAvailable(false);
        this.valuesTable.setAutoResizeMode(3);
        this.initTable(true);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (!ClusterComponentPane.this.hasBeenShown) {
                    ClusterComponentPane.this.hasBeenShown = true;
                    ClusterComponentPane.this.loadClusterComponents();
                }
            }
        });
    }

    private synchronized void initTable(boolean bl) {
        String[] stringArray = new String[]{ClusteringTreeEditorLrb.get("COMPONENT_ID_COLUMN")};
        this.valuesTable.setModel(new ValuesTableModel(this.components, stringArray));
        this.valuesTable.setRolloverHighlightingEnabled(false);
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(this.valuesTable.getModel());
        if (sortKeys == null) {
            sortKeys = new ArrayList<RowSorter.SortKey>();
            sortKeys.add(new RowSorter.SortKey(0, SortOrder.DESCENDING));
        }
        tableRowSorter.setSortKeys(sortKeys);
        this.valuesTable.setRowSorter(tableRowSorter);
        if (this.sorterListener == null) {
            this.sorterListener = new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent rowSorterEvent) {
                    Object object = rowSorterEvent.getSource();
                    sortKeys = ((RowSorter)object).getSortKeys();
                }
            };
            this.valuesTable.getRowSorter().addRowSorterListener(this.sorterListener);
        }
        this.valuesTable.setDragEnabled(true);
        if (bl) {
            this.valuesTable.setNoEntryInstructionText(ClusteringTreeEditorLrb.get("LOADING_COMPONENTS"));
        } else {
            this.valuesTable.setNoEntryInstructionText(ClusteringTreeEditorLrb.get("NO_COMPONENTS_FOUND"));
        }
    }

    private void loadClusterComponents() {
        SwingWorker<List<String>, Void> swingWorker = new SwingWorker<List<String>, Void>(){

            @Override
            public List<String> doInBackground() throws Exception {
                List list = null;
                try {
                    list = ClusterComponentPane.this.getComponents(ClusterComponentPane.this.treeNode);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
                    throw sQLException;
                }
                return list;
            }

            @Override
            public void done() {
                try {
                    if (this.isCancelled()) {
                        ClusterComponentPane.this.components = new ArrayList();
                        ClusterComponentPane.this.components.add(ClusteringTreeEditorLrb.get("INTERRUPTED"));
                        ClusterComponentPane.this.initTable(false);
                        return;
                    }
                    ClusterComponentPane.this.components = (List)this.get();
                    ClusterComponentPane.this.initTable(false);
                }
                catch (ExecutionException executionException) {
                    ClusterComponentPane.this.components = new ArrayList();
                    ClusterComponentPane.this.components.add(ClusteringTreeEditorLrb.get("ERROR"));
                    ClusterComponentPane.this.initTable(false);
                }
                catch (InterruptedException interruptedException) {
                    ClusterComponentPane.this.components = new ArrayList();
                    ClusterComponentPane.this.components.add(ClusteringTreeEditorLrb.get("INTERRUPTED"));
                    ClusterComponentPane.this.initTable(false);
                }
            }
        };
        swingWorker.execute();
    }

    private List<String> getComponents(ClusTreeNode clusTreeNode) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Context context = clusTreeNode.getModel().getContext();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        String string = connectionFolder.getUserAccountName() + "." + context.getNode().getShortLabel();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clusTreeNode.getData().getId());
        List<ClusTreeNode> list = clusTreeNode.findAllChildNodes();
        for (ClusTreeNode object2 : list) {
            stringBuilder.append(", ");
            stringBuilder.append(object2.getData().getId());
        }
        String string2 = "SELECT * FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name)) WHERE INFO_TYPE = 'Cluster' AND CLUSTER_ID IN   (SELECT regexp_substr(:cluster_ids, '[^,]+', 1, LEVEL) token   FROM dual     CONNECT BY LEVEL <= LENGTH(:cluster_ids) - LENGTH(REPLACE(:cluster_ids, ',', '')) + 1   ) ";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = connectionFolder.getConnection();
            sQLHelper.opstmt = (OraclePreparedStatement)sQLHelper.conn.prepareStatement(string2);
            sQLHelper.opstmt.setStringAtName("model_name", string);
            sQLHelper.opstmt.setStringAtName("cluster_ids", stringBuilder.toString());
            sQLHelper.opstmt.execute();
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                Integer sQLException = sQLHelper.rs.getInt("COMPONENT_ID");
                arrayList.add(sQLException.toString());
            }
        }
        return arrayList;
    }

    private static class ValuesTableModel
    extends DefaultTableModel
    implements GenericTableModel {
        private List<String> data;

        public ValuesTableModel(List<String> list, String[] stringArray) {
            this.data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this.data.size());
            this.setColumnCount(1);
        }

        public int getColumnAlignment(int n) {
            return 2;
        }

        public boolean canHide(int n) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            return String.class;
        }

        public void reload(List<String> list) {
            this.data = list;
            this.setRowCount(this.data.size());
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            String string = null;
            switch (n2) {
                case 0: {
                    string = this.data.get(n);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        public Collection<String> getDataList() {
            return this.data;
        }
    }
}

