/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.details;

import java.util.concurrent.ExecutionException;
import javax.swing.GroupLayout;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.clustering.details.DetailsLrb;
import oracle.dmt.dataminer.mviewer.clustering.details.DetailsViewerState;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.partition.PartitionVO;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.BlockingComponent;

public class DetailsViewer
extends DataMinerViewGUI {
    private DetailsViewerState _state;
    private BlockingComponent overLayPanel = null;
    private boolean isModelPartitioned;
    private DataMinerTablePanel attributesTablePanel;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;

    public DetailsViewer(Editor editor, Context context, DetailsViewerState detailsViewerState) {
        super(editor, context);
        this._state = detailsViewerState;
        PartitionVO partitionVO = new PartitionVO("", "");
        ModelNode modelNode = (ModelNode)this.getContext().getNode();
        String string = modelNode.getOdmModel().getUserName();
        String string2 = modelNode.getOdmModel().getModelName();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        this.isModelPartitioned = DatabaseMetadataUtils.isModelPartitioned(connectionFolder, string, string2, partitionVO);
        this.initComponents();
        this.initRes();
        if (this.isModelPartitioned) {
            this.modelViewerPartitionToolbar1.setEditor(this.getEditor(), partitionVO);
        } else {
            this.modelViewerPartitionToolbar1.setVisible(false);
        }
        this.initUI();
    }

    public DetailsViewer(Editor editor, Context context, DetailsViewerState detailsViewerState, BlockingComponent blockingComponent) {
        super(editor, context);
        this.overLayPanel = blockingComponent;
        this._context = context;
        this._state = detailsViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private void initComponents() {
        this.attributesTablePanel = new DataMinerTablePanel();
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this.attributesTablePanel.setModelExample(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attributesTablePanel, -1, 400, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attributesTablePanel, -1, 284, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        DataMinerTable dataMinerTable = this.attributesTablePanel.getTable();
        dataMinerTable.setTooltipEnable(true);
        dataMinerTable.setAutoResizeMode(4);
        this.attributesTablePanel.setup((TableModel)((Object)this._state.getTableModel()), DetailsLrb.get("DETAILS_VIEWER_GRID_TITLE"), 0);
        dataMinerTable.setSortColumn(0, true);
        this._state.loadStatus(DetailsLrb.get("DETAILS_LOADING_DATA_MESSAGE"));
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private class LoadUI
    extends SwingWorker<Boolean, Void> {
        private LoadUI() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            if (DetailsViewer.this.isModelPartitioned) {
                DetailsViewer.this._state.load(DetailsViewer.this.modelViewerPartitionToolbar1.getSelectedPartitionID());
            } else {
                DetailsViewer.this._state.load("");
            }
            return Boolean.TRUE;
        }

        @Override
        protected void done() {
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    DetailsViewer.this._state.loadTableModel();
                    DetailsViewer.this.setLoaded(true);
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                DetailsViewer.this._state.loadStatus(DetailsLrb.get("DETAILS_LOADING_ERROR"));
                DataMinerEditor.handleEditorException(DetailsViewer.this.getEditor().getContext(), exception, DetailsLrb.get("DETAILS_VIEWER_FAILURE_TITLE"), DetailsLrb.get("DETAILS_VIEWER_FAILURE_MESG"));
            }
            finally {
                DetailsViewer.this.setLoading(false);
                if (DetailsViewer.this.overLayPanel != null) {
                    DetailsViewer.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

