/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.arrules.ARGlobalMetrics;
import oracle.dmt.dataminer.mviewer.arrules.ARItemSetsTableModel;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.server.model.AssociationRules;
import oracle.dmt.dataminer.server.model.ItemSet;
import oracle.dmt.dataminer.server.model.ItemSetsFilterSetting;
import oracle.dmt.dataminer.server.model.RuleContentOption;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;

public class ARItemSetsViewerState
extends BaseViewerState {
    private static final Logger theLogger = Logger.getLogger(ARItemSetsViewerState.class.getName());
    private boolean _loaded;
    private ARItemSetsTableModel _tableModel;
    private AssociationRules _model = null;
    private String _modelName;
    private String _userName;
    private ARGlobalMetrics _globalMetrics;
    private ItemSetsFilterSetting _filterSetting;
    private ItemSetsFilterSetting _cachedFilterSetting;
    private RuleContentOption _itemsetContentOption;

    public ARItemSetsViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
    }

    public ARItemSetsViewerState reloadItemSets(String string) throws SQLException {
        this.loadItemSets(string);
        return this;
    }

    public ARItemSetsViewerState load(String string) throws Exception {
        this._modelViewerState1 = new ModelViewerState1(this._context);
        this._modelViewerState1.load();
        if (!this._modelViewerState1.getOdmModel().getModelGeneralDescription().isAssociationRulesModel()) {
            throw new Exception(ARRulesLrb.get("RULE_VIEWER_UNRECOGNIZED_MODEL_TYPE"));
        }
        this._model = new AssociationRules(this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
        this._modelName = this._modelViewerState1.getModelName();
        this._userName = this._modelViewerState1.getUserName();
        this._filterSetting = new ItemSetsFilterSetting(this);
        this._cachedFilterSetting = new ItemSetsFilterSetting(this);
        Vector<ItemSet> vector = new Vector<ItemSet>();
        this._tableModel = new ARItemSetsTableModel(vector);
        this._globalMetrics = new ARGlobalMetrics(this._context, this._model, this._userName, this._modelName);
        LoadGlobalMetrics loadGlobalMetrics = new LoadGlobalMetrics(string);
        loadGlobalMetrics.run();
        this.loadItemSets(string);
        if (loadGlobalMetrics.getException() != null) {
            throw loadGlobalMetrics.getException();
        }
        this._loaded = true;
        return this;
    }

    public ARItemSetsTableModel getFilteredItemSets(String string, int n) throws Exception {
        return this._tableModel.getFilteredItemSets(string, n);
    }

    private void loadItemSets(String string) throws SQLException {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        Vector<ItemSet> vector = this._model.getItemSets((ConnectionManager)connectionFolder, this._userName, this._modelName, this._filterSetting, string);
        this._tableModel.clearRows();
        this._tableModel.addRows(vector);
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "ar_itemsets_help";
        return new HelpInfo(string);
    }

    public void setFilterSetting(ItemSetsFilterSetting itemSetsFilterSetting) {
        this._filterSetting = itemSetsFilterSetting;
    }

    public ItemSetsFilterSetting getFilterSetting() {
        return this._filterSetting;
    }

    public ARItemSetsTableModel getTableModel() {
        return this._tableModel;
    }

    public void clearRows() {
        this._tableModel.clearRows();
    }

    public void addRow(ItemSet itemSet) {
        this._tableModel.addRow(itemSet);
    }

    public void setCachedFilterSetting(ItemSetsFilterSetting itemSetsFilterSetting) {
        this._cachedFilterSetting = itemSetsFilterSetting;
    }

    public ItemSetsFilterSetting getCachedFilterSetting() {
        return this._cachedFilterSetting;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void setModel(AssociationRules associationRules) {
        this._model = associationRules;
    }

    public AssociationRules getModel() {
        return this._model;
    }

    public Integer getTotalItemSetsCount() {
        return this._globalMetrics.getTotal_itemset_count();
    }

    public Double getMaximumSupport() {
        return this._globalMetrics.getMaximum_lift_value();
    }

    public void setItemsetContentOption(RuleContentOption ruleContentOption) {
        this._itemsetContentOption = ruleContentOption;
        this._tableModel.setItemsetContentOption(ruleContentOption);
    }

    public RuleContentOption getItemsetContentOption() {
        return this._itemsetContentOption;
    }

    public boolean isOnlyOneColumnNameInModelItems() {
        return this._globalMetrics.isOnlyOneColumnNameInModelItems();
    }

    public boolean isOnlyOneConstantValueInModelItems() {
        return this._globalMetrics.isOnlyOneConstantValueInModelItems();
    }

    public boolean isNoSubNameColumnsInModelItems() {
        return this._globalMetrics.isNoSubNameColumnsInModelItems();
    }

    public Integer getTotalNumberOfSingleOccuringItems() {
        return this._globalMetrics.getTotalNumberOfSingleOccuringItems();
    }

    public boolean isOnlyOneSubColumnNameInModelItems() {
        return this._globalMetrics.isOnlyOneSubColumnNameInModelItems();
    }

    private class LoadGlobalMetrics {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;
        String _partitionId;

        public LoadGlobalMetrics(String string) {
            this._partitionId = string;
        }

        public void run() {
            try {
                ARItemSetsViewerState.this._globalMetrics.loadGlobalMetrics(this._partitionId);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
        }

        public Exception getException() {
            return this._ex;
        }
    }
}

