/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.dmt.dataminer.filter.Filter;
import oracle.dmt.dataminer.filter.FilterConsumer;
import oracle.dmt.dataminer.filter.FilterDockableFactory;
import oracle.dmt.dataminer.filter.FilterWindow;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.javaxide.Util;
import oracle.ide.layout.ViewId;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.jndi.Names;

public class FilterManager
implements Controller,
Addin {
    private static Icon _icon;
    protected static final String FILTER_MANAGER_NAME = "dataminer/filter-manager";
    public static final int VIEW_FILTER_ID;
    Filter filter = Filter.getInstance();
    FilterWindow filterWindow;
    private ArrayList<MetaClass> metaConsumers;

    public Filter getFilter() {
        return this.filter;
    }

    public static FilterManager getFilterManager() {
        FilterManager filterManager = (FilterManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)FILTER_MANAGER_NAME);
        return filterManager;
    }

    public FilterWindow getFilterWindow() {
        if (this.filterWindow == null) {
            this.filterWindow = FilterWindow.getInstance();
        }
        return this.filterWindow;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == VIEW_FILTER_ID) {
            DockStation dockStation = DockStation.getDockStation();
            ViewId viewId = new ViewId("DATAMININGFILTERFACTORY", "FILTER");
            Dockable dockable = dockStation.findDockable(viewId);
            dockStation.activateDockable(dockable);
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    public void initialize() {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)FILTER_MANAGER_NAME, (Object)this);
        this.createActions();
        DockStation dockStation = DockStation.getDockStation();
        dockStation.registerDockableFactory("DATAMININGFILTERFACTORY", (DockableFactory)FilterDockableFactory.getInstance());
    }

    private void createActions() {
        IdeAction ideAction = IdeAction.get((int)VIEW_FILTER_ID, (String)null, (String)"Filter", (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)null, (Icon)OracleIcons.getIcon((String)"filter.png"), null, (boolean)true);
        ideAction.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction);
        MenuManager.getJMenu((String)"View").add(jMenuItem);
    }

    public void addFilterConsumerClass(MetaClass metaClass) {
        if (this.metaConsumers == null) {
            this.metaConsumers = new ArrayList();
        }
        this.metaConsumers.add(metaClass);
    }

    public void removeFilterConsumerClass(MetaClass metaClass) {
        this.metaConsumers.remove(metaClass);
    }

    protected List<FilterConsumer> getFilterConsumers() {
        if (this.metaConsumers != null) {
            ArrayList<FilterConsumer> arrayList = new ArrayList<FilterConsumer>();
            for (MetaClass metaClass : this.metaConsumers) {
                FilterConsumer filterConsumer;
                try {
                    filterConsumer = (FilterConsumer)Util.createInstance((MetaClass)metaClass, FilterConsumer.class);
                }
                catch (Exception exception) {
                    filterConsumer = null;
                }
                if (filterConsumer == null) continue;
                arrayList.add(filterConsumer);
            }
            return Collections.unmodifiableList(arrayList);
        }
        return null;
    }

    static {
        VIEW_FILTER_ID = Ide.createCmdID((String)"dataminer.filterViewFilter");
    }
}

