/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.expressionbuilder2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dmt.dataminer.expressionbuilder2.DialogsLrb;
import oracle.dmt.dataminer.expressionbuilder2.RScriptViewerPanel;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.expressionbuilder2.SQLExpressionBuilderPanel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.preferences.RInterfaceFunctionSettings;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class RScriptsPanel
extends AbstractPanel<AbstractNode>
implements SearchListener {
    private JButton _refreshButton = new JButton();
    private JButton _viewButton = new JButton();
    private JTable _RScriptTable;
    private RScriptTableModel _RScriptTableModel;
    private transient FunctionDetails _functionDetails;
    private SearchField _searchField;
    private String _searchText;
    private transient SearchCategory _searchCategory;
    private transient RowFilter<RScriptTableModel, Integer> _RScriptFilter;
    private SQLExpressionBuilderPanel _parent;
    private transient SQLContext _context;
    private RInterfaceFunctionSettings _RInterfaceFunctionPref;
    private static final String LOADING = DialogsLrb.get("SQLQUERY_LOADING");
    private static final String NO_FUNCTION = DialogsLrb.get("SQLQUERY_RSCRIPT_NO_FUNCTION");
    private static final String RQEVAL = "rqEval";
    private static final String RQEVAL_PROTOCOL = "rqEval(\n  cursor(select * from <table-1>), -- Param Cursor \n  'select <column list> from <table-2>', -- Output Definition \n  '<RScript>' -- R Script \n) \n";
    private static final String RQTABLEEVAL = "rqTableEval";
    private static final String RQTABLEEVAL_PROTOCOL = "rqTableEval(\n  cursor(select * from <table-1>), -- Input Cursor \n  cursor(select * from <table-2>), -- Param Cursor \n  'select <column list> from <table-3>', -- Output Definition \n  '<RScript>' -- R Script \n) \n";
    private static final String RQROWEVAL = "rqRowEval";
    private static final String RQROWEVAL_PROTOCOL = "rqRowEval(\n  cursor(select * from <table-1>), -- Input Cursor \n  cursor(select * from <table-2>), -- Param Cursor \n  'select <column list> from <table-3>', -- Output Definition \n  '<num rows>', -- Number of rows \n  '<RScript>' -- R Script \n) \n";
    private static final String RQGROUPEVAL = "rqGroupEval";
    private static final String RQGROUPEVAL_PROTOCOL = "rqGroupEval(\n  cursor(select * from <table-1>), -- Input Cursor \n  cursor(select * from <table-2>), -- Param Cursor \n  'select <column list> from <table-3>', -- Output Definition \n  '<grouping column name>', -- Group name \n  '<RScript>' -- R Script \n) \n";
    private JLabel jRFunctionLabel;
    private JCheckBox jRInterfaceFuncCheckBox;
    private JComboBox jRInterfaceFuncComboBox;
    private JPanel jRQPanel;
    private JPanel jRScriptPanel;
    private JToolBar jToolBar;
    private static String[] _functionColumnNames = new String[]{DialogsLrb.get("SQLQUERY_RSCRIPT_TABLE_NAME")};
    private static final int RSCRIPT_NAME = 0;
    private static final int RSCRIPT_COLUMN_COUNT = 1;

    public RScriptsPanel(SQLExpressionBuilderPanel sQLExpressionBuilderPanel, SQLContext sQLContext) {
        super(sQLContext.getContext(), sQLContext.getNode());
        this._parent = sQLExpressionBuilderPanel;
        this._context = sQLContext;
        Preferences preferences = Preferences.getPreferences();
        this._RInterfaceFunctionPref = RInterfaceFunctionSettings.getInstance((PropertyStorage)preferences);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jRFunctionLabel, (Component)this.jRInterfaceFuncComboBox, (String)DialogsLrb.get("SQLQUERY_RSCRIPT_R_INTERFACE_FUNC"));
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("SQLQUERY_RSCRIPT_WARP_R_INTERFACE"), this.jRInterfaceFuncCheckBox);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        this.installRScriptsFilterActions(this.jToolBar);
        this._RScriptTable = new JTable(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                Container container = this.getParent();
                if (container instanceof JViewport) {
                    return container.getHeight() > this.getPreferredSize().height;
                }
                return false;
            }
        };
        this._RScriptTableModel = new RScriptTableModel(null);
        JScrollPane jScrollPane = new JScrollPane(this._RScriptTable);
        this.jRScriptPanel.add((Component)jScrollPane, "Center");
        this._RScriptTable.setModel((TableModel)((Object)this._RScriptTableModel));
        this._RScriptTable.setAutoResizeMode(4);
        this._RScriptTable.setSelectionMode(0);
        this._RScriptTable.setShowGrid(false);
        this._RScriptTable.setUpdateSelectionOnSort(true);
        this._RScriptTable.setRowSelectionAllowed(true);
        this._RScriptTable.setTransferHandler(new FromTransferHandler());
        this._RScriptTable.setDragEnabled(true);
        this._RScriptFilter = new RowFilter<RScriptTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends RScriptTableModel, ? extends Integer> entry) {
                String string;
                boolean bl = true;
                boolean bl2 = RScriptsPanel.this._searchText != null && RScriptsPanel.this._searchCategory != null;
                Integer n = entry.getIdentifier();
                RScriptTableModel rScriptTableModel = entry.getModel();
                String string2 = string = RScriptsPanel.this._searchText != null ? RScriptsPanel.this._searchText.toLowerCase() : null;
                if (bl2 && RScriptsPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("SQLQUERY_RSCRIPT_TABLE_NAME"))) {
                    String string3 = (String)rScriptTableModel.getValueAt(n, 0);
                    bl = string3.toLowerCase().contains(string);
                }
                return bl;
            }
        };
        this.configureSorting();
        this._RScriptTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                RScriptsPanel.this.enableControls();
            }
        });
        this._RScriptTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JTable jTable = (JTable)mouseEvent.getSource();
                    int n = jTable.getSelectedRow();
                    n = jTable.convertRowIndexToModel(n);
                    String string = RScriptsPanel.this._functionDetails.get(n).toSQLString();
                    if (RScriptsPanel.this.jRInterfaceFuncCheckBox.isSelected()) {
                        FunctionDetail functionDetail = (FunctionDetail)RScriptsPanel.this.jRInterfaceFuncComboBox.getSelectedItem();
                        string = functionDetail.getScript().replace("<RScript>", string);
                    }
                    RScriptsPanel.this._parent.insertSQLExpression(string);
                }
            }
        });
        this.jRInterfaceFuncCheckBox.setSelected(this._RInterfaceFunctionPref.isRInterfaceEnable());
        FunctionDetail functionDetail = new FunctionDetail(RQEVAL, RQEVAL_PROTOCOL);
        FunctionDetail functionDetail2 = new FunctionDetail(RQTABLEEVAL, RQTABLEEVAL_PROTOCOL);
        FunctionDetail functionDetail3 = new FunctionDetail(RQGROUPEVAL, RQGROUPEVAL_PROTOCOL);
        FunctionDetail functionDetail4 = new FunctionDetail(RQROWEVAL, RQROWEVAL_PROTOCOL);
        FunctionDetail[] functionDetailArray = new FunctionDetail[]{functionDetail, functionDetail2, functionDetail3, functionDetail4};
        this.jRInterfaceFuncComboBox.setModel(new DefaultComboBoxModel<FunctionDetail>(functionDetailArray));
        for (FunctionDetail functionDetail5 : functionDetailArray) {
            if (!this._RInterfaceFunctionPref.getRInterface().equals(functionDetail5.getName())) continue;
            this.jRInterfaceFuncComboBox.setSelectedItem(functionDetail5);
            break;
        }
        LoadFunctions loadFunctions = new LoadFunctions();
        loadFunctions.execute();
        this.enableControls();
    }

    public String[] getRQFunctions() {
        return new String[]{RQEVAL, RQTABLEEVAL, RQGROUPEVAL, RQROWEVAL};
    }

    private void installRScriptsFilterActions(JToolBar jToolBar) {
        SearchCategory[] searchCategoryArray;
        this._refreshButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        this._refreshButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_RSCRIPT_REFRESH_ADA"));
        this._refreshButton.setToolTipText(DialogsLrb.get("SQLQUERY_RSCRIPT_REFRESH_ADA"));
        this._refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RScriptsPanel.this._functionDetails = null;
                LoadFunctions loadFunctions = new LoadFunctions();
                loadFunctions.execute();
            }
        });
        jToolBar.add(this._refreshButton);
        this._viewButton.setIcon(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_ENA));
        this._viewButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_RSCRIPT_VIEW_ADA"));
        this._viewButton.setToolTipText(DialogsLrb.get("SQLQUERY_RSCRIPT_VIEW_ADA"));
        this._viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = RScriptsPanel.this._RScriptTable.getSelectedRow();
                n = RScriptsPanel.this._RScriptTable.convertRowIndexToModel(n);
                if (n >= 0) {
                    String string = RScriptsPanel.this._functionDetails.get(n).getScript();
                    RScriptViewerPanel rScriptViewerPanel = new RScriptViewerPanel(string);
                    rScriptViewerPanel.showAsDialog(RScriptsPanel.this);
                }
            }
        });
        jToolBar.add(this._viewButton);
        jToolBar.addSeparator();
        this._searchField = new SearchField(SearchField.Style.FILTER);
        this._searchField.setPreferredSize(new Dimension(100, 10));
        for (SearchCategory searchCategory : searchCategoryArray = new SearchCategory[]{new SearchCategory(DialogsLrb.get("SQLQUERY_RSCRIPT_TABLE_NAME"))}) {
            this._searchField.addCategory(searchCategory);
        }
        jToolBar.add((Component)this._searchField);
        this._searchField.addSearchListener((SearchListener)this);
    }

    private void resetRScriptTableModel(RScriptTableModel rScriptTableModel) {
        rScriptTableModel.fireTableDataChanged();
        this._RScriptTable.clearSelection();
        this._RScriptTable.updateUI();
        this.configureSorting();
    }

    private void enableControls() {
        this._viewButton.setEnabled(this._RScriptTable.getSelectedRowCount() > 0);
    }

    public void configureSorting() {
        TableRowSorter<RScriptTableModel> tableRowSorter = (TableRowSorter<RScriptTableModel>)this._RScriptTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<RScriptTableModel>(this._RScriptTableModel);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this._RScriptFilter);
        this._RScriptTable.setRowSorter(tableRowSorter);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
    }

    private void initComponents() {
        this.jRScriptPanel = new JPanel();
        this.jToolBar = new JToolBar();
        this.jRQPanel = new JPanel();
        this.jRInterfaceFuncCheckBox = new JCheckBox();
        this.jRFunctionLabel = new JLabel();
        this.jRInterfaceFuncComboBox = new JComboBox();
        this.jRScriptPanel.setLayout(new BorderLayout());
        this.jToolBar.setRollover(true);
        this.jRScriptPanel.add((Component)this.jToolBar, "North");
        this.jRInterfaceFuncCheckBox.setText("Use R Interface Function");
        this.jRInterfaceFuncCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RScriptsPanel.this.jRInterfaceFuncCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jRFunctionLabel.setLabelFor(this.jRInterfaceFuncComboBox);
        this.jRFunctionLabel.setText("Function:");
        this.jRInterfaceFuncComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{RQEVAL, RQTABLEEVAL, RQROWEVAL, RQGROUPEVAL}));
        this.jRInterfaceFuncComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RScriptsPanel.this.jRInterfaceFuncComboBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jRQPanel);
        this.jRQPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jRInterfaceFuncCheckBox, -2, 170, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jRFunctionLabel, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRInterfaceFuncComboBox, -2, -1, -2))).addContainerGap(140, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jRInterfaceFuncCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRFunctionLabel).addComponent(this.jRInterfaceFuncComboBox, -2, -1, -2)).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRScriptPanel, -1, 322, Short.MAX_VALUE).addComponent(this.jRQPanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jRScriptPanel, -1, 385, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRQPanel, -2, -1, -2)));
    }

    private void jRInterfaceFuncCheckBoxActionPerformed(ActionEvent actionEvent) {
        this._RInterfaceFunctionPref.setRInterfaceEnable(this.jRInterfaceFuncCheckBox.isSelected());
    }

    private void jRInterfaceFuncComboBoxActionPerformed(ActionEvent actionEvent) {
        FunctionDetail functionDetail = (FunctionDetail)this.jRInterfaceFuncComboBox.getSelectedItem();
        this._RInterfaceFunctionPref.setRInterface(functionDetail.getName());
    }

    class FromTransferHandler
    extends TransferHandler {
        FromTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        public Transferable createTransferable(JComponent jComponent) {
            int n = RScriptsPanel.this._RScriptTable.getSelectedRow();
            n = RScriptsPanel.this._RScriptTable.convertRowIndexToModel(n);
            if (n >= 0) {
                String string = RScriptsPanel.this._functionDetails.get(n).toSQLString();
                if (RScriptsPanel.this.jRInterfaceFuncCheckBox.isSelected()) {
                    FunctionDetail functionDetail = (FunctionDetail)RScriptsPanel.this.jRInterfaceFuncComboBox.getSelectedItem();
                    string = functionDetail.getScript().replace("<RScript>", string);
                }
                return new StringSelection(string);
            }
            return null;
        }

        @Override
        public void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n != 2) {
                return;
            }
        }
    }

    private class LoadFunctions
    extends SwingWorker<Void, Void> {
        public LoadFunctions() {
            RScriptsPanel.this._RScriptTableModel.resetModel(null);
            RScriptsPanel.this.resetRScriptTableModel(RScriptsPanel.this._RScriptTableModel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() throws Exception {
            if (RScriptsPanel.this._functionDetails == null) {
                RScriptsPanel.this._functionDetails = new FunctionDetails();
                try (SQLHelper sQLHelper = new SQLHelper();){
                    String string = "select NAME, SCRIPT from sys.rq_scripts";
                    sQLHelper.conn = ConnectionFolder.getConnection(RScriptsPanel.this._context.getContext());
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                    sQLHelper.pstmt.setFetchSize(10);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        String string2 = sQLHelper.rs.getString(1);
                        String string3 = sQLHelper.rs.getString(2);
                        FunctionDetail functionDetail = new FunctionDetail(string2, string3);
                        RScriptsPanel.this._functionDetails.add(functionDetail);
                    }
                }
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get();
                RScriptsPanel.this._RScriptTableModel.resetModel(RScriptsPanel.this._functionDetails);
                RScriptsPanel.this.resetRScriptTableModel(RScriptsPanel.this._RScriptTableModel);
            }
            catch (InterruptedException | ExecutionException exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
            }
            finally {
                RScriptsPanel.this.enableControls();
            }
        }
    }

    private static class RScriptTableModel
    extends GenericBaseTableModel {
        private transient FunctionDetails _functions;

        public RScriptTableModel(FunctionDetails functionDetails) {
            this._functions = functionDetails;
            this.setColumnIdentifiers(_functionColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(1);
        }

        public void resetModel(FunctionDetails functionDetails) {
            this._functions = functionDetails;
        }

        public int getRowCount() {
            if (this._functions == null || this._functions.size() == 0) {
                return 1;
            }
            return this._functions.size();
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._functions == null) {
                return LOADING;
            }
            if (this._functions.size() == 0) {
                return NO_FUNCTION;
            }
            FunctionDetail functionDetail = this._functions.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = functionDetail.toString();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }
    }

    private static class FunctionDetails {
        Vector<FunctionDetail> _data = new Vector();

        FunctionDetails() {
        }

        Integer size() {
            return this._data.size();
        }

        void add(FunctionDetail functionDetail) {
            this._data.add(functionDetail);
        }

        FunctionDetail get(int n) {
            return this._data.get(n);
        }
    }

    private static class FunctionDetail {
        String _name;
        String _script;

        FunctionDetail(String string, String string2) {
            this._name = string;
            this._script = string2;
        }

        public String toString() {
            return this._name;
        }

        public String toSQLString() {
            return this._name;
        }

        public String getName() {
            return this._name;
        }

        public String getScript() {
            return this._script;
        }
    }
}

