/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.dprofiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.renderers.MiniHistogramCellRenderer;
import oracle.dmt.dataminer.dprofiler.DataProfilePanelSettings;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsModel;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsState;
import oracle.dmt.dataminer.dprofiler.MessagePanel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.dss.graph.Graph;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTablePersistentSettings;

public class DataProfileViewPanel2
extends DataMinerViewGUI {
    private static final Logger theLogger = Logger.getLogger(DataProfileViewPanel2.class.getName());
    private BlockingComponent overLayPanel = null;
    private static final String _verylongseparator = "                                ";
    private static final String _longseparator = "                ";
    private static final String _shortseparator = "    ";
    private ComponentWithTitlebar<JComponent> _jComponentWithToolbar;
    private JTable _table;
    private JCheckBox jCheckBox1;
    private JLabel jFilterLabel;
    private JScrollPane jFilterScrollPane;
    private JPanel jGraphPanel;
    private JLabel jLblGroupby;
    private JLabel jLblGroupbyValue;
    private JScrollPane jStatisticsScrollPane;
    private JSplitPane jStatsSplitPane;
    private int FIXED_COLUMNS = 2;
    private JPanel jGraphMainPanel;
    private GraphPanel[] graphPanel;
    private DataProfileStatisticsState state;
    private SearchField jFilterCtl = new SearchField();
    private SearchCategory defaultSearchCategory = new SearchCategory(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_NAME"));
    private int[] lastSelectedRowsRowsInModel;
    private boolean loadingDetailedGraph = false;
    private boolean restoringPersistance = false;
    private DataProfilePanelSettings dataProfilePanelSettings = DataProfilePanelSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private GraphicalPreferencesSettings graphPanelSettings = GraphicalPreferencesSettings.getInstance((PropertyStorage)Preferences.getPreferences());

    public DataProfileViewPanel2(Editor editor, Context context) throws Exception {
        super(editor, context);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this._jComponentWithToolbar = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jComponentWithToolbar, -1, 534, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this._jComponentWithToolbar, -1, 341, Short.MAX_VALUE).addContainerGap()));
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private CustomNiceTable getTable() {
        return (CustomNiceTable)((Object)this._table);
    }

    public void clear() {
        if (this.state != null) {
            this.state.clear();
        }
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jFilterLabel, (Component)this.jFilterCtl, (String)DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FILTER_LABEL"));
        this.jFilterLabel.getAccessibleContext().setAccessibleName(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FILTER_LABEL"));
        this.jFilterLabel.getAccessibleContext().setAccessibleDescription(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FILTER_LABEL_ADA"));
        this.jCheckBox1.setText(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_SHOW_NULLS_LABEL"));
        this.jCheckBox1.getAccessibleContext().setAccessibleName(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_SHOW_NULLS_LABEL"));
        this.jCheckBox1.getAccessibleContext().setAccessibleDescription(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_SHOW_NULLS_LABEL_ADA"));
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    @Override
    public void initUI() {
        this.jFilterLabel = new JLabel();
        this.jFilterScrollPane = new JScrollPane();
        Dimension dimension = this.jFilterScrollPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 200);
        Dimension dimension3 = this.derive(dimension, 120);
        this.jFilterScrollPane.setPreferredSize(dimension2);
        this.jFilterScrollPane.setMaximumSize(dimension2);
        this.jFilterScrollPane.setMinimumSize(dimension3);
        this.jStatsSplitPane = new JSplitPane();
        this.jStatisticsScrollPane = new JScrollPane();
        this._table = new CustomNiceTable();
        this.jGraphPanel = new JPanel();
        this.jGraphPanel.setMinimumSize(new Dimension(100, 100));
        this.jGraphPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.jGraphPanel);
        this.jGraphMainPanel = new JPanel();
        this.jGraphMainPanel.setLayout(new BorderLayout());
        this.jGraphMainPanel.setPreferredSize(new Dimension(300, 300));
        this.jGraphMainPanel.add((Component)jScrollPane, "Center");
        this.jLblGroupby = new JLabel();
        this.jLblGroupbyValue = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jFilterScrollPane.setBorder(null);
        this.jStatsSplitPane.setDividerLocation(152);
        this.initRes();
        this.jStatsSplitPane.setOrientation(0);
        this._table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jStatisticsScrollPane.setViewportView(this._table);
        this.jStatsSplitPane.setTopComponent(this.jStatisticsScrollPane);
        this.jStatsSplitPane.setRightComponent(this.jGraphMainPanel);
        this.state = new DataProfileStatisticsState(this._context, this.graphPanelSettings, this.dataProfilePanelSettings.isShowNulls());
        this._jComponentWithToolbar.setComponent((JComponent)this.jStatsSplitPane);
        int n = this.state.getNumberOfSelectedStats();
        String string = StringUtils.getReplacedString(DataProfileStatisticsLrb.get("DATA_PROFILE_TITLE_NEW"), "<cols>", String.valueOf(n));
        String string2 = NumericFormat.statsFormatter.format(this.state.getRowCount());
        string = StringUtils.getReplacedString(string, "<rows>", string2);
        string = this.state.isSampledData() ? StringUtils.getReplacedString(string, "<sampled>", DataProfileStatisticsLrb.get("DATA_PROFILE_TITLE_SAMPLED_DATA")) : StringUtils.getReplacedString(string, "<sampled>", DataProfileStatisticsLrb.get("DATA_PROFILE_TITLE_ALL_DATA"));
        this._jComponentWithToolbar.setLabel(new JLabel(string));
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this.jLblGroupby);
        controlBar.add((Component)new JLabel(_shortseparator));
        controlBar.add((Component)this.jLblGroupbyValue);
        controlBar.add((Component)new JLabel(_verylongseparator));
        controlBar.add((Component)this.jCheckBox1);
        controlBar.add((Component)new JLabel(_longseparator));
        controlBar.add((Component)this.jFilterLabel);
        controlBar.add((Component)new JLabel(_shortseparator));
        controlBar.add((Component)this.jFilterScrollPane);
        this._jComponentWithToolbar.setControlBar(controlBar);
        if (this.state.isGroupingBy()) {
            this.jLblGroupby.setText(DataProfileStatisticsLrb.get("GROUP_BY_LABEL"));
            this.jLblGroupbyValue.setText(StringUtils.trimDoubleQuotes(this.state.getGroupingAttributName()));
        }
        this.jCheckBox1.setSelected(this.dataProfilePanelSettings.isShowNulls());
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DataProfileViewPanel2.this.overLayPanel != null) {
                    DataProfileViewPanel2.this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
                }
                DataProfileViewPanel2.this.reload();
            }
        });
        this.jLblGroupby.setVisible(this.state.isGroupingBy());
        this.jLblGroupbyValue.setVisible(this.state.isGroupingBy());
        this.jStatsSplitPane.setOneTouchExpandable(true);
        if (this.state.isHistogramAvalable()) {
            this.jStatsSplitPane.setDividerLocation(300);
        } else {
            this.jStatsSplitPane.setDividerLocation(5000);
        }
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DataProfileViewPanel2.this.handleSelectionChanged(DataProfileViewPanel2.this.getTable().getSelectionModel());
            }
        });
        this.setLoading(true);
        this.initializeControls();
        this.graphPanelSettings.addStructureChangeListener(new CustomStructureChangeListener());
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public void reload() {
        int n = 0;
        int[] nArray = this.getTable().getSelectedRowsInModel();
        if (nArray != null && nArray.length == 1) {
            n = nArray[0];
        }
        boolean bl = this.jCheckBox1.isSelected();
        this.dataProfilePanelSettings.setShowNulls(bl);
        this.state = new DataProfileStatisticsState(this._context, this.graphPanelSettings, this.dataProfilePanelSettings.isShowNulls());
        this.setLoading(true);
        this.state.clear();
        if (this.state.isHistogramAvalable()) {
            this.jStatsSplitPane.setDividerLocation(300);
        } else {
            this.jStatsSplitPane.setDividerLocation(5000);
        }
        LoadUI loadUI = new LoadUI(n);
        loadUI.execute();
    }

    private void initializeControls() {
        this.getTable().setNoEntryInstructionText(CommonLrb.get("COMMON_LOADING"));
        this.jFilterCtl.setStyle(SearchField.Style.FILTER);
        this.jFilterCtl.addCategory(this.defaultSearchCategory);
        this.jFilterCtl.addCategory(new SearchCategory(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE")));
        this.jFilterCtl.addCategory(new SearchCategory(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_COLUMN_MODE")));
        this.jFilterCtl.setSelectedCategory(this.defaultSearchCategory);
        this.jFilterScrollPane.setViewportView((Component)this.jFilterCtl);
    }

    private void setupTable(DataProfileStatisticsModel dataProfileStatisticsModel) {
        this.getTable().setFixedColumns(this.FIXED_COLUMNS, 210);
        this.getTable().setModel((TableModel)((Object)dataProfileStatisticsModel));
        this.getTable().setRowHeight((int)MiniHistogramCellRenderer._DEFAULT_PREFFERRED_WIDTH.getHeight());
        this.getTable().setSelectionMode(2);
        this.getTable().setColumnSelectorAvailable(true);
        this.getTable().setSorted(true);
        TableColumnModel tableColumnModel = this.getTable().getFullColumnModel();
        if (null != dataProfileStatisticsModel.getColumnColumnName()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnColumnName()).setCellRenderer(new CustomRenderer());
        }
        if (null != dataProfileStatisticsModel.getColumnHistogram()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnHistogram()).setCellRenderer(new MiniHistogramCellRenderer(this.state));
        }
        if (null != dataProfileStatisticsModel.getColumnDataType()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnDataType()).setCellRenderer(new CustomRenderer());
        }
        if (null != dataProfileStatisticsModel.getColumnPercentNull()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnPercentNull()).setCellRenderer(new CustomRenderer(FormatType.PERCENTAGE));
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnPercentNull()).setPreferredWidth(100);
        }
        if (null != dataProfileStatisticsModel.getColumnDistinct()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnDistinct()).setCellRenderer(new CustomRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnDistinct()).setPreferredWidth(100);
        }
        if (null != dataProfileStatisticsModel.getColumnPercentDistinct()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnPercentDistinct()).setCellRenderer(new CustomRenderer(FormatType.PERCENTAGE));
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnPercentDistinct()).setPreferredWidth(100);
        }
        if (null != dataProfileStatisticsModel.getColumnMode()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMode()).setCellRenderer(new CustomRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMode()).setPreferredWidth(150);
        }
        if (null != dataProfileStatisticsModel.getColumnMin()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMin()).setCellRenderer(new CustomRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMin()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnMax()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMax()).setCellRenderer(new CustomRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMax()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnAvg()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnAvg()).setCellRenderer(new CustomRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnAvg()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnMedian()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMedian()).setCellRenderer(new CustomRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnMedian()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnStd()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnStd()).setCellRenderer(new CustomRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnStd()).setPreferredWidth(115);
        }
        if (null != dataProfileStatisticsModel.getColumnVar()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnVar()).setCellRenderer(new CustomRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnVar()).setPreferredWidth(100);
        }
        if (null != dataProfileStatisticsModel.getColumnSkewness()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnSkewness()).setCellRenderer(new CustomRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnSkewness()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnKurtosis()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnKurtosis()).setCellRenderer(new CustomRenderer());
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnKurtosis()).setPreferredWidth(90);
        }
        if (null != dataProfileStatisticsModel.getColumnDataType()) {
            tableColumnModel.getColumn(dataProfileStatisticsModel.getColumnDataType()).setPreferredWidth(100);
        }
        this.getTable().setAutoResizeMode(3);
        this.getTable().getTableHeader().setReorderingAllowed(false);
        this.restoringPersistance = true;
        int[] nArray = this.dataProfilePanelSettings.getHiddenColumns();
        if (nArray != null && nArray.length > 0) {
            this.getTable().setHiddenColumns(nArray);
        }
        this.restoringPersistance = false;
    }

    private void setupMessageOnlyTable(String string) {
        this.getTable().setNoEntryInstructionText(string);
    }

    private void addListeners() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        DataProfileStatisticsModel dataProfileStatisticsModel = this.state.getTableModel();
        hashMap.put(DataProfileStatisticsModel.TABLE_SUMMARY_EDITOR_COLUMN_NAME, dataProfileStatisticsModel.getColumnColumnName());
        hashMap.put(DataProfileStatisticsModel.TABLE_SUMMARY_EDITOR_COLUMN_DATA_TYPE, dataProfileStatisticsModel.getColumnDataType());
        hashMap.put(DataProfileStatisticsModel.TABLE_SUMMARY_EDITOR_COLUMN_MODE, dataProfileStatisticsModel.getColumnMode());
        SimpleSearchListener simpleSearchListener = new SimpleSearchListener((GenericTable)this.getTable(), hashMap);
        this.jFilterCtl.addSearchListener((SearchListener)simpleSearchListener);
    }

    private void handleSelectionChanged(ListSelectionModel listSelectionModel) {
        if (listSelectionModel.getValueIsAdjusting()) {
            return;
        }
        if (!this.state.isHistogramAvalable()) {
            this.createGraphPanelWithoutHistograms();
            return;
        }
        boolean bl = false;
        boolean bl2 = listSelectionModel.isSelectionEmpty();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (!bl2 && n == n2) {
            bl = true;
        }
        int[] nArray = this.getTable().getSelectedRowsInModel();
        if (!this.state.isLoaded()) {
            this.lastSelectedRowsRowsInModel = nArray;
            return;
        }
        if (this.isLoadingDetailedGraph()) {
            return;
        }
        this.setLoadingDetailedGraph(true);
        LoadGraphPanel loadGraphPanel = new LoadGraphPanel(nArray);
        loadGraphPanel.execute();
    }

    private void createGraphPanelWithoutHistograms() {
        this.jGraphPanel.removeAll();
        String string = DataProfileStatisticsLrb.get("DETAIL_NO_HISTOGRAM_PANEL_LINE_1");
        String string2 = DataProfileStatisticsLrb.get("DETAIL_NO_HISTOGRAM_PANEL_LINE_2");
        MessagePanel messagePanel = new MessagePanel(string, string2);
        this.jGraphPanel.add((Component)messagePanel, "Center");
        this.jGraphPanel.updateUI();
    }

    private void updateDetailsGraph() {
        int[] nArray = this.getTable().getSelectedRowsInModel();
        if (!this.state.isLoaded()) {
            this.lastSelectedRowsRowsInModel = nArray;
            return;
        }
        if (this.isLoadingDetailedGraph()) {
            return;
        }
        this.setLoadingDetailedGraph(true);
        LoadGraphPanel loadGraphPanel = new LoadGraphPanel(nArray);
        loadGraphPanel.execute();
    }

    private void setDepthRadius(int n) {
        this.state.setDepthRadius(n);
        this.updateDetailsGraph();
        this.validate();
        this.repaint();
    }

    private void changeStyle(String string) {
        this.state.setStyleSelection(string);
        this.getTable().updateUI();
        this.updateDetailsGraph();
        this.validate();
        this.repaint();
    }

    boolean isHistogramVisible() {
        int[] nArray = this.getTable().getSelectedRowsInModel();
        return nArray != null && nArray.length != 0;
    }

    public void close() {
        this.state.close();
    }

    public void setLoadingDetailedGraph(boolean bl) {
        this.loadingDetailedGraph = bl;
    }

    public boolean isLoadingDetailedGraph() {
        return this.loadingDetailedGraph;
    }

    private String formatCellValue(Object object, FormatType formatType) {
        String string = "";
        string = object == null ? null : (object instanceof Double ? (formatType == FormatType.PERCENTAGE ? NumericFormat.format((Double)object, true, this.dataProfilePanelSettings.getPercentagePrecisionLevel()) + "" : NumericFormat.format((Double)object, true, this.dataProfilePanelSettings.getNumericalPrecisionLevel()) + "") : object.toString());
        return string;
    }

    static /* synthetic */ GraphPanel[] access$1802(DataProfileViewPanel2 dataProfileViewPanel2, GraphPanel[] graphPanelArray) {
        dataProfileViewPanel2.graphPanel = graphPanelArray;
        return graphPanelArray;
    }

    private class LoadGraphPanel
    extends SwingWorker {
        Exception ex = null;
        boolean success = false;
        GraphDataModel[] localGraphModel = null;
        int[] selectedRowsInModel;

        public LoadGraphPanel(int[] nArray) {
            this.selectedRowsInModel = nArray;
            this.localGraphModel = new GraphDataModel[nArray.length];
        }

        protected Object doInBackground() throws Exception {
            try {
                DataProfileStatisticsModel dataProfileStatisticsModel = (DataProfileStatisticsModel)((Object)DataProfileViewPanel2.this.getTable().getModel());
                Vector<DataProfileStatisticsData> vector = dataProfileStatisticsModel.getDataVector();
                for (int i = 0; i < this.selectedRowsInModel.length; ++i) {
                    DataProfileStatisticsData dataProfileStatisticsData = (DataProfileStatisticsData)vector.get(this.selectedRowsInModel[i]);
                    String string = dataProfileStatisticsData.getName();
                    this.localGraphModel[i] = DataProfileViewPanel2.this.state.createDetailedGraphModel(string);
                }
                this.success = true;
            }
            catch (Exception exception) {
                this.ex = exception;
                this.success = false;
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return DataProfileViewPanel2.this.state;
        }

        @Override
        protected void done() {
            super.done();
            if (this.success && this.ex == null) {
                int n;
                DataProfileStatisticsModel dataProfileStatisticsModel = (DataProfileStatisticsModel)((Object)DataProfileViewPanel2.this.getTable().getModel());
                Vector<DataProfileStatisticsData> vector = dataProfileStatisticsModel.getDataVector();
                int n2 = this.selectedRowsInModel.length;
                DataProfileViewPanel2.access$1802(DataProfileViewPanel2.this, new GraphPanel[n2]);
                for (n = 0; n < n2; ++n) {
                    ((DataProfileViewPanel2)DataProfileViewPanel2.this).graphPanel[n] = new GraphPanel(this.localGraphModel[n]);
                    this.localGraphModel[n].setDepthRadius(DataProfileViewPanel2.this.state.getDepthRadius());
                    DataProfileViewPanel2.this.graphPanel[n].initGraph();
                    this.localGraphModel[n].setStyleSelection(DataProfileViewPanel2.this.state.getStyleSelection());
                    DataProfileViewPanel2.this.graphPanel[n].updateGraphStyle();
                    Graph graph = DataProfileViewPanel2.this.graphPanel[n].getGraph();
                    DataProfileStatisticsData dataProfileStatisticsData = (DataProfileStatisticsData)vector.get(this.selectedRowsInModel[n]);
                    String string = dataProfileStatisticsData.getDataType();
                    if (!DatabaseMetadataUtils.isTimestampDerived(string) && !string.equals("DATE") || null == dataProfileStatisticsData.getGraphDataModel() || dataProfileStatisticsData.getGraphDataModel().getColumnLabels().length <= 3) continue;
                    graph.doAutoLayout(2);
                    graph.getO1TickLabel().setTextRotation(90);
                }
                DataProfileViewPanel2.this.jGraphPanel.removeAll();
                if (n2 == 1) {
                    DataProfileViewPanel2.this.jGraphPanel.setLayout(new BorderLayout());
                    DataProfileViewPanel2.this.jGraphPanel.add((Component)DataProfileViewPanel2.this.graphPanel[0], "Center");
                } else if (n2 % 3 == 0) {
                    DataProfileViewPanel2.this.jGraphPanel.setLayout(new GridLayout(0, 3));
                } else {
                    DataProfileViewPanel2.this.jGraphPanel.setLayout(new GridLayout(0, 2));
                }
                for (n = 0; n < n2; ++n) {
                    DataProfileViewPanel2.this.jGraphPanel.add(DataProfileViewPanel2.this.graphPanel[n]);
                }
                DataProfileViewPanel2.this.jGraphPanel.updateUI();
            }
            DataProfileViewPanel2.this.jGraphMainPanel.updateUI();
            DataProfileViewPanel2.this.setLoadingDetailedGraph(false);
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception ex = null;
        boolean success = false;
        int previousSelection = 0;

        public LoadUI(int n) {
            this.previousSelection = n;
        }

        public LoadUI() {
        }

        protected Object doInBackground() throws Exception {
            try {
                DataProfileViewPanel2.this.state.load();
                this.success = DataProfileViewPanel2.this.state.isLoaded();
            }
            catch (Exception exception) {
                this.ex = exception;
                this.success = false;
            }
            return DataProfileViewPanel2.this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this.success && this.ex == null) {
                    DataProfileViewPanel2.this.setupTable(DataProfileViewPanel2.this.state.getTableModel());
                    if (DataProfileViewPanel2.this.jFilterCtl.getText().trim().length() > 0) {
                        DataProfileViewPanel2.this.jFilterCtl.doSearch(DataProfileViewPanel2.this.jFilterCtl.getSelectedCategory(), DataProfileViewPanel2.this.jFilterCtl.getText(), SearchEvent.Direction.FORWARD);
                    }
                    DataProfileStatisticsModel dataProfileStatisticsModel = (DataProfileStatisticsModel)((Object)DataProfileViewPanel2.this.getTable().getModel());
                    Vector<DataProfileStatisticsData> vector = dataProfileStatisticsModel.getDataVector();
                    ArrayList<String> arrayList = new ArrayList<String>(vector.size());
                    arrayList.add(DataProfileStatisticsState._NONE_ATTRIBUTE);
                    for (DataProfileStatisticsData dataProfileStatisticsData : vector) {
                        String string = dataProfileStatisticsData.getName();
                        arrayList.add(string);
                    }
                    if (DataProfileViewPanel2.this.getTable().getRowCount() > 0) {
                        DataProfileViewPanel2.this.getTable().setSelectedRowsInModel(new int[]{this.previousSelection});
                    }
                    if (DataProfileViewPanel2.this.state.isGroupingBy()) {
                        DataProfileViewPanel2.this.jLblGroupby.setText(DataProfileStatisticsLrb.get("GROUP_BY_LABEL"));
                        DataProfileViewPanel2.this.jLblGroupbyValue.setText(StringUtils.trimDoubleQuotes(DataProfileViewPanel2.this.state.getGroupingAttributName()));
                    }
                    DataProfileViewPanel2.this.jLblGroupby.setVisible(DataProfileViewPanel2.this.state.isGroupingBy());
                    DataProfileViewPanel2.this.jLblGroupbyValue.setVisible(DataProfileViewPanel2.this.state.isGroupingBy());
                    DataProfileViewPanel2.this.addListeners();
                    DataProfileViewPanel2.this.setLoaded(true);
                } else {
                    DataProfileViewPanel2.this.setupMessageOnlyTable(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_MESG_TRY_RERUN"));
                    if (DataProfileViewPanel2.this.state.getTableModel() != null) {
                        DataProfileViewPanel2.this.state.getTableModel().setFailedStatus();
                    }
                }
            }
            catch (Exception exception) {
                this.ex = exception;
            }
            finally {
                if (this.ex != null) {
                    DataMinerEditor.handleEditorException(DataProfileViewPanel2.this.getEditor().getContext(), this.ex, DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_TITLE"), DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_MESG"));
                }
                DataProfileViewPanel2.this.setLoading(false);
                if (DataProfileViewPanel2.this.overLayPanel != null) {
                    DataProfileViewPanel2.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }

    private class CustomRenderer
    extends DefaultTableCellRenderer {
        FormatType formatType;

        public CustomRenderer(FormatType formatType) {
            this.formatType = formatType;
        }

        public CustomRenderer() {
            this.formatType = FormatType.NUMERICAL;
        }

        @Override
        public void setValue(Object object) {
            if (object != null) {
                String string = null;
                if (object instanceof Double) {
                    string = this.formatType == FormatType.PERCENTAGE ? NumericFormat.format((Double)object, true, DataProfileViewPanel2.this.dataProfilePanelSettings.getPercentagePrecisionLevel()) + "" : NumericFormat.format((Double)object, true, DataProfileViewPanel2.this.dataProfilePanelSettings.getNumericalPrecisionLevel()) + "";
                } else if (object instanceof Integer) {
                    string = NumericFormat.format((Integer)object, true, 8) + "";
                } else if (object instanceof String) {
                    String string2 = (String)object;
                    try {
                        Double d = Double.valueOf(string2.trim());
                        string = NumericFormat.format(d, true, DataProfileViewPanel2.this.dataProfilePanelSettings.getNumericalPrecisionLevel()) + "";
                    }
                    catch (NumberFormatException numberFormatException) {
                        string = string2;
                    }
                }
                super.setValue(string);
            }
        }
    }

    private static enum FormatType {
        PERCENTAGE,
        NUMERICAL;

    }

    class CustomNiceTable
    extends DataMinerTable {
        CustomNiceTable() {
        }

        protected void setColumnVisible(TableColumn tableColumn, int n, boolean bl) {
            GenericTablePersistentSettings genericTablePersistentSettings;
            super.setColumnVisible(tableColumn, n, bl);
            if (!DataProfileViewPanel2.this.restoringPersistance && (genericTablePersistentSettings = this.getPersistentSettings()) != null) {
                DataProfileViewPanel2.this.dataProfilePanelSettings.setHiddenColumns(genericTablePersistentSettings.getHiddenColumns());
            }
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof DefaultGraphDataModel) {
                String string = ((DefaultGraphDataModel)object).getComment();
                return string;
            }
            if (object instanceof Double) {
                FormatType formatType = null;
                DataProfileStatisticsModel dataProfileStatisticsModel = DataProfileViewPanel2.this.state.getTableModel();
                formatType = n2 == dataProfileStatisticsModel.getColumnPercentNull() || n2 == dataProfileStatisticsModel.getColumnPercentDistinct() ? FormatType.PERCENTAGE : FormatType.NUMERICAL;
                return DataProfileViewPanel2.this.formatCellValue(object, formatType);
            }
            return super.convertValueToText(object, bl, bl2, n, n2);
        }
    }

    class CustomStructureChangeListener
    extends StructureChangeListener {
        CustomStructureChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
            if (changeInfoArray == null || changeInfoArray.length == 0) {
                return;
            }
            for (int i = 0; i < changeInfoArray.length; ++i) {
                String string = changeInfoArray[i].getPropertyName();
                if (string.equals("histogram_graph_style")) {
                    DataProfileViewPanel2.this.changeStyle(changeInfoArray[i].getNewValueAsString());
                    continue;
                }
                if (!string.equals("radius_depth")) continue;
                DataProfileViewPanel2.this.setDepthRadius(changeInfoArray[i].getNewValueAsInt());
            }
        }
    }
}

