/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.renderers;

import java.awt.Component;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class FormatterCellRenderer
extends DefaultTableCellRenderer {
    private Format formatter;
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance();

    public FormatterCellRenderer() {
    }

    public FormatterCellRenderer(Format format) {
        this.formatter = format;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object != null) {
            this.setValue(object);
        } else {
            this.setText("");
        }
        return component;
    }

    @Override
    protected void setValue(Object object) {
        if (this.formatter != null) {
            this.setText(this.formatter.format(object));
        } else if (object instanceof Double || object instanceof Float || object instanceof BigDecimal) {
            this.setText(numberFormat.format(((Number)object).doubleValue()));
        } else if (object instanceof Date) {
            this.setText(dateFormat.format((Date)object));
        } else {
            this.setText(object.toString());
        }
    }
}

