/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.models;

import java.math.BigDecimal;
import oracle.dmt.dataminer.repository.RepositoryLrb;

public class Duration
implements Comparable {
    private int days;
    private int hours;
    private int minutes;
    private int seconds;

    public Duration(int n, int n2, int n3, int n4) {
        this.days = n;
        this.hours = n2;
        this.minutes = n3;
        this.seconds = n4;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int compareTo(Object object) {
        assert (object instanceof Duration);
        Duration duration = (Duration)object;
        int n = this.days - duration.getDays();
        if (n != 0) {
            return n;
        }
        int n2 = this.hours - duration.getHours();
        if (n2 != 0) {
            return n2;
        }
        int n3 = this.minutes - duration.getMinutes();
        if (n3 != 0) {
            return n3;
        }
        return this.seconds - duration.getSeconds();
    }

    public String toString() {
        String string = RepositoryLrb.get("DAYS") + ":" + this.days + " " + RepositoryLrb.get("HOURS") + ":" + this.hours + " " + RepositoryLrb.get("MINUTES") + ":" + this.minutes + " " + RepositoryLrb.get("SECONDS") + ":" + this.seconds;
        return string;
    }

    public static Duration newInstance(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4) {
        if (bigDecimal == null && bigDecimal2 == null && bigDecimal3 == null && bigDecimal4 == null) {
            return null;
        }
        return new Duration(bigDecimal.intValue(), bigDecimal2.intValue(), bigDecimal3.intValue(), bigDecimal4.intValue());
    }
}

