/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.common.vo.TableVO;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.TableChooserPreferenceSettings;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class TableChooserModel
extends ODMrTableModel<TableVO> {
    private static final String[] COLUMN_NAMES = new String[]{ControlsLrb.get("TABLE_CHOOSER_TABLES_LIST_NAME"), ControlsLrb.get("TABLE_CHOOSER_TABLES_LIST_TYPE")};
    static final int SCHEMA_TABLE_NAME = 0;
    static final int TYPE = 1;
    static final int SCHEMA = 2;
    static final int TABLE_NAME = 3;
    private String _ownerSchema = null;
    private Context _context = null;
    private boolean tablesOnly = false;
    private boolean _ownerOnly = true;
    private String _connectionName = null;
    private TableChooserPreferenceSettings _tableChooserPrefenceSettings = TableChooserPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());

    public TableChooserModel(String string, Context context) {
        super(COLUMN_NAMES);
        assert (string != null) : "Can not pass a null ownerSchema in to the constructor";
        assert (context != null) : "Can not pass a null context in to the constructor";
        this._context = context;
        this._ownerSchema = string;
        this._connectionName = ConnectionFolder.getConnectionName(this._context);
    }

    public int selectRow(String string, String string2) {
        int n = -1;
        for (int i = 0; i < this.srcData.size(); ++i) {
            TableVO tableVO = (TableVO)this.srcData.get(i);
            if (!tableVO.getSchema().equals(string) || !tableVO.getName().equals(string2)) continue;
            n = i;
            break;
        }
        return n;
    }

    public TableVO getRow(int n) {
        return (TableVO)this.srcData.get(n);
    }

    public List<TableVO> load(ConnectionManager connectionManager) throws SQLException {
        List<TableVO> list = null;
        list = this._ownerOnly ? this.loadOwnerTablesAndViews(connectionManager) : this.loadAccessableTablesAndViews(connectionManager);
        return list;
    }

    private List<TableVO> loadAccessableTablesAndViews(ConnectionManager connectionManager) throws SQLException {
        ArrayList<TableVO> arrayList = new ArrayList<TableVO>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            StringBuilder stringBuilder = new StringBuilder("with \n");
            stringBuilder.append("T_ALL as \n");
            stringBuilder.append("(select OWNER, TABLE_NAME, TYPE, T_OWNER, T_NAME \n");
            stringBuilder.append(" from \n");
            stringBuilder.append("  (select OWNER, TABLE_NAME, '");
            stringBuilder.append(CommonLrb.get("COMMON_TABLE_UP"));
            stringBuilder.append("' as TYPE, OWNER as T_OWNER, TABLE_NAME as T_NAME \n");
            stringBuilder.append("   from ALL_TABLES where <LIST_OF_SCHEMAS> AND \n   ");
            stringBuilder.append("TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' ");
            this.tablesOnly = false;
            if (this.tablesOnly) {
                stringBuilder.append(")");
            } else {
                stringBuilder.append("\n   union all \n");
                stringBuilder.append("   select OWNER, VIEW_NAME as TABLE_NAME, '");
                stringBuilder.append(CommonLrb.get("COMMON_VIEW_UP"));
                stringBuilder.append("' as TYPE, OWNER AS T_OWNER, VIEW_NAME AS T_NAME \n");
                stringBuilder.append("   from ALL_VIEWS where <LIST_OF_SCHEMAS> AND \n   ");
                stringBuilder.append("VIEW_NAME NOT LIKE 'DM$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'DR$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND VIEW_NAME NOT LIKE 'DM4J$%'  ESCAPE '@' ");
                stringBuilder.append(")\n), \n");
                stringBuilder.append("LIST_SYNONYMS as \n");
                stringBuilder.append("(select * from ALL_SYNONYMS where <LIST_OF_SCHEMAS> \n");
                stringBuilder.append(" and (TABLE_OWNER, TABLE_NAME) not in (select T_OWNER, T_NAME from T_ALL)), \n");
                stringBuilder.append("SYNONYMS as \n");
                stringBuilder.append("(select S.OWNER, SYNONYM_NAME as TABLE_NAME, '");
                stringBuilder.append(CommonLrb.get("COMMON_SYNONYM_UP"));
                stringBuilder.append("' as TYPE, TABLE_OWNER as T_OWNER, TABLE_NAME as T_NAME \n");
                stringBuilder.append(" from LIST_SYNONYMS S inner join ALL_OBJECTS A \n");
                stringBuilder.append(" on S.TABLE_NAME = A.OBJECT_NAME AND S.TABLE_OWNER = a.OWNER");
                stringBuilder.append(" where OBJECT_TYPE = 'TABLE' or OBJECT_TYPE = 'VIEW' ");
            }
            stringBuilder.append("\n) \n");
            stringBuilder.append("select * from \n");
            if (this.tablesOnly) {
                stringBuilder.append(" (");
            } else {
                stringBuilder.append(" (select * from SYNONYMS \n");
                stringBuilder.append("  union all \n  ");
            }
            stringBuilder.append("select * from T_ALL) \n");
            stringBuilder.append("order by OWNER, TABLE_NAME");
            ListStructure listStructure = this._tableChooserPrefenceSettings.getIncludedSchemaList(this._connectionName);
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = listStructure.iterator();
            String string = "";
            boolean bl = false;
            int n = 0;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                stringBuffer.append("'" + StringUtils.escapeSingleQuotesForSQL(string) + "'");
                ++n;
                if (iterator.hasNext()) {
                    stringBuffer.append(",");
                }
                if (string.compareTo(this._ownerSchema) != 0) continue;
                bl = true;
            }
            if (!bl) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("'" + StringUtils.escapeSingleQuotesForSQL(this._ownerSchema) + "'");
                ++n;
            }
            String string2 = " ";
            if (n > 0) {
                string2 = " OWNER IN ( " + stringBuffer.toString() + " ) ";
            }
            String string3 = StringUtils.getReplacedString(stringBuilder.toString(), "<LIST_OF_SCHEMAS>", string2);
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            TableVO tableVO = null;
            while (sQLHelper.rs.next()) {
                tableVO = new TableVO(sQLHelper.rs.getString("OWNER"), sQLHelper.rs.getString("TABLE_NAME"), sQLHelper.rs.getString("TYPE"));
                tableVO.setSynonymSchema(sQLHelper.rs.getString("T_OWNER"));
                tableVO.setSynonymName(sQLHelper.rs.getString("T_NAME"));
                arrayList.add(tableVO);
            }
        }
        return arrayList;
    }

    private List<TableVO> loadOwnerTablesAndViews(ConnectionManager connectionManager) throws SQLException {
        ArrayList<TableVO> arrayList = new ArrayList<TableVO>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            StringBuilder stringBuilder = new StringBuilder("with\n");
            stringBuilder.append("T_ALL as");
            stringBuilder.append("(select TABLE_NAME, TYPE, T_OWNER, T_NAME \n");
            stringBuilder.append(" from \n");
            stringBuilder.append(" (select TABLE_NAME, '");
            stringBuilder.append(CommonLrb.get("COMMON_TABLE_UP"));
            stringBuilder.append("' as TYPE, '");
            stringBuilder.append(StringUtils.escapeSingleQuotesForSQL(this._ownerSchema));
            stringBuilder.append("' AS T_OWNER, TABLE_NAME AS T_NAME \n");
            stringBuilder.append("  from USER_TABLES where \n  ");
            stringBuilder.append("TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' ");
            if (this.tablesOnly) {
                stringBuilder.append(")");
            } else {
                stringBuilder.append("\n  union all  \n");
                stringBuilder.append("  select VIEW_NAME as TABLE_NAME, '");
                stringBuilder.append(CommonLrb.get("COMMON_VIEW_UP"));
                stringBuilder.append("' as TYPE, '");
                stringBuilder.append(StringUtils.escapeSingleQuotesForSQL(this._ownerSchema));
                stringBuilder.append("' AS T_OWNER, VIEW_NAME AS T_NAME \n");
                stringBuilder.append("  from USER_VIEWS where \n  ");
                stringBuilder.append("VIEW_NAME NOT LIKE 'DM$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'DR$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND VIEW_NAME NOT LIKE 'DM4J$%'  ESCAPE '@' ");
                stringBuilder.append(")\n), \n");
                stringBuilder.append("LIST_SYNONYMS as \n");
                stringBuilder.append("(select * from USER_SYNONYMS \n");
                stringBuilder.append(" where (TABLE_OWNER, TABLE_NAME) not in (select T_OWNER, T_NAME from T_ALL)), \n ");
                stringBuilder.append("SYNONYMS as \n");
                stringBuilder.append("(select SYNONYM_NAME as TABLE_NAME, '");
                stringBuilder.append(CommonLrb.get("COMMON_SYNONYM_UP"));
                stringBuilder.append("' as TYPE, TABLE_OWNER as T_OWNER, TABLE_NAME AS T_NAME\n");
                stringBuilder.append(" from LIST_SYNONYMS s inner join ALL_OBJECTS a \n");
                stringBuilder.append(" on s.TABLE_NAME = a.OBJECT_NAME AND s.TABLE_OWNER = a.OWNER\n");
                stringBuilder.append(" where OBJECT_TYPE = 'TABLE' or OBJECT_TYPE = 'VIEW'");
            }
            stringBuilder.append("\n) \n");
            stringBuilder.append("select * from \n");
            if (this.tablesOnly) {
                stringBuilder.append(" (");
            } else {
                stringBuilder.append(" (select * from SYNONYMS \n");
                stringBuilder.append("  union all \n  ");
            }
            stringBuilder.append("select * from T_ALL) \n");
            stringBuilder.append("order by TABLE_NAME");
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(stringBuilder.toString());
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            TableVO tableVO = null;
            while (sQLHelper.rs.next()) {
                tableVO = new TableVO(this._ownerSchema, sQLHelper.rs.getString("TABLE_NAME"), sQLHelper.rs.getString("TYPE"));
                tableVO.setSynonymSchema(sQLHelper.rs.getString("T_OWNER"));
                tableVO.setSynonymName(sQLHelper.rs.getString("T_NAME"));
                arrayList.add(tableVO);
            }
        }
        return arrayList;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!" + n + " of " + this.getRowCount();
        TableVO tableVO = (TableVO)this.srcData.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                if (this.isOwnerOnly()) {
                    if (this._ownerSchema != null) {
                        if (this._ownerSchema.equals(tableVO.getSchema())) {
                            string = tableVO.getName();
                            break;
                        }
                        string = tableVO.getFullName();
                        break;
                    }
                    string = tableVO.getName();
                    break;
                }
                string = tableVO.getFullName();
                break;
            }
            case 2: {
                string = tableVO.getSchema();
                break;
            }
            case 1: {
                string = tableVO.getType();
                break;
            }
            case 3: {
                string = tableVO.getName();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing list of tables";
                break;
            }
        }
        return string;
    }

    public void setOwnerOnly(boolean bl) {
        this._ownerOnly = bl;
    }

    public boolean isOwnerOnly() {
        return this._ownerOnly;
    }

    public String getOwnerSchema() {
        return this._ownerSchema;
    }

    public void setTablesOnly(boolean bl) {
        this.tablesOnly = bl;
    }

    public boolean isTablesOnly() {
        return this.tablesOnly;
    }
}

